/* -----------------------------------------------------------------------------
 * spnego.c defines RFC 2478 SPNEGO GSS-API mechanism APIs.
 *
 * Author: Frank Balluffi
 *
 * Copyright (C) 2002-2005 Frank Balluffi. All rights reserved.
 * -----------------------------------------------------------------------------
 */

#include "../../include/spnego.h"

#include <openssl/asn1t.h>

ASN1_SEQUENCE (SPNEGO_NEG_TOKEN_INIT) = {
    ASN1_EXP_SEQUENCE_OF_OPT (SPNEGO_NEG_TOKEN_INIT, mechTypes,   ASN1_OBJECT,       0),
    ASN1_EXP_OPT             (SPNEGO_NEG_TOKEN_INIT, reqFlags,    ASN1_BIT_STRING,   1),
    ASN1_EXP_OPT             (SPNEGO_NEG_TOKEN_INIT, mechToken,   ASN1_OCTET_STRING, 2),
    ASN1_EXP_OPT             (SPNEGO_NEG_TOKEN_INIT, mechListMIC, ASN1_OCTET_STRING, 3)
} ASN1_SEQUENCE_END (SPNEGO_NEG_TOKEN_INIT)

IMPLEMENT_ASN1_FUNCTIONS (SPNEGO_NEG_TOKEN_INIT)

ASN1_SEQUENCE (SPNEGO_NEG_TOKEN_TARG) = {
    ASN1_EXP_OPT (SPNEGO_NEG_TOKEN_TARG, negResult,     ASN1_ENUMERATED,   0),
    ASN1_EXP_OPT (SPNEGO_NEG_TOKEN_TARG, supportedMech, ASN1_OBJECT,       1),
    ASN1_EXP_OPT (SPNEGO_NEG_TOKEN_TARG, responseToken, ASN1_OCTET_STRING, 2),
    ASN1_EXP_OPT (SPNEGO_NEG_TOKEN_TARG, mechListMIC,   ASN1_OCTET_STRING, 3)
} ASN1_SEQUENCE_END (SPNEGO_NEG_TOKEN_TARG)

IMPLEMENT_ASN1_FUNCTIONS (SPNEGO_NEG_TOKEN_TARG)

ASN1_CHOICE (SPNEGO_NEGOTIATION_TOKEN) = {
    ASN1_EXP (SPNEGO_NEGOTIATION_TOKEN, value.negTokenInit, SPNEGO_NEG_TOKEN_INIT, 0),
    ASN1_EXP (SPNEGO_NEGOTIATION_TOKEN, value.negTokenTarg, SPNEGO_NEG_TOKEN_TARG, 1)
} ASN1_CHOICE_END (SPNEGO_NEGOTIATION_TOKEN)

IMPLEMENT_ASN1_FUNCTIONS (SPNEGO_NEGOTIATION_TOKEN)
