/* -----------------------------------------------------------------------------
 * asn1help.c defines ASN.1 helper APIs.
 *
 * Author: Frank Balluffi
 *
 * Copyright (C) 2002-2005 Frank Balluffi. All rights reserved.
 * -----------------------------------------------------------------------------
 */

#include "../../include/asn1help.h"

#include <string.h>

int ASN1_OBJECT_cmp (const ASN1_OBJECT * object1,
                     const ASN1_OBJECT * object2)
{
    if (object1->length != object2->length)
        return 1;

    return memcmp (object1->data, object2->data, object1->length);
}

ASN1_OBJECT * ASN1_OBJECT_dup (const ASN1_OBJECT * object)
{
    return (ASN1_OBJECT *) ASN1_dup (i2d_ASN1_OBJECT,
                                     (char * (*) ()) d2i_ASN1_OBJECT,
                                     (char *) object);
}
