/* -----------------------------------------------------------------------------
 * gssapi.h declares RFC 2743 GSS-API APIs.
 *
 * Author: Frank Balluffi
 *
 * Copyright (C) 2002-2005 Frank Balluffi. All rights reserved.
 * -----------------------------------------------------------------------------
 */

#ifndef GSSAPI_H
#define GSSAPI_H

#ifdef __cplusplus
extern "C" {
#endif

#include <openssl/asn1.h>

/* Structure declarations and constant definitions. */

/*
GSSAPI_INITIAL_CONTEXT_TOKEN_BODY and GSSAPI_INITIAL_CONTEXT_TOKEN are modeled
after OpenSSL's KRB5_APREQBODY and KRB5_APREQ.
*/

typedef struct GSSAPI_INITIAL_CONTEXT_TOKEN_BODY_st {
    ASN1_OBJECT * thisMech;
    ASN1_TYPE *   innerContextToken;
} GSSAPI_INITIAL_CONTEXT_TOKEN_BODY;

typedef STACK_OF (GSSAPI_INITIAL_CONTEXT_TOKEN_BODY) GSSAPI_INITIAL_CONTEXT_TOKEN;

/* The following statement does not appear to be necessary. */

/* DECLARE_STACK_OF (GSSAPI_INITIAL_CONTEXT_TOKEN_BODY) */

/* _new, _free, d2i_ and _i2d function declarations. */

DECLARE_ASN1_FUNCTIONS (GSSAPI_INITIAL_CONTEXT_TOKEN_BODY)
DECLARE_ASN1_FUNCTIONS (GSSAPI_INITIAL_CONTEXT_TOKEN)

#ifdef __cplusplus
}
#endif

#endif /* GSSAPI_H */
