/* -----------------------------------------------------------------------------
 * asn1help.c declares ASN.1 helper APIs.
 *
 * Author: Frank Balluffi
 *
 * Copyright (C) 2002-2005 Frank Balluffi. All rights reserved.
 * -----------------------------------------------------------------------------
 */

#ifndef ASN1HELP_H
#define ASN1HELP_H

#ifdef __cplusplus
extern "C" {
#endif

#include <openssl/asn1.h>

/* -----------------------------------------------------------------------------
 * ASN1_OBJECT_cmp compares two OBJECT IDENTIFIERs.
 *
 * Returns 0 if the OBJECT IDENTIFIERs are the same, non-zero otherwise.
 * -----------------------------------------------------------------------------
 */

int ASN1_OBJECT_cmp (const ASN1_OBJECT * object1,
                     const ASN1_OBJECT * object2);

/* -----------------------------------------------------------------------------
 * ASN1_OBJECT_dup duplicates an ASN.1 OBJECT IDENTIFIER.
 *
 * If ASN1_OBJECT_dup is successful, call ASN1_OBJECT_free to free the returned
 * structure.
 *
 * Returns a pointer to an ASN1_OBJECT if successful, NULL otherwise.
 * -----------------------------------------------------------------------------
 */

ASN1_OBJECT * ASN1_OBJECT_dup (const ASN1_OBJECT * object);

#ifdef __cplusplus
}
#endif

#endif /* ASN1HELP_H */
