/*
 * Decompiled with CFR 0.152.
 */
package javacli;

public class Rectangle {
    public int x0;
    public int y0;
    public int x1;
    public int y1;
    static Class TYPE;

    public int hashCode() {
        return this.x0 ^ this.x1 ^ this.y0 ^ this.y1;
    }

    public String toString() {
        return "(" + this.x0 + ", " + this.y0 + ")-(" + this.x1 + ", " + this.y1 + ")";
    }

    public static int distance(Rectangle r, Rectangle q) {
        if (r.overlaps(q)) {
            return 0;
        }
        int d = 0;
        if (r.x0 > q.x1) {
            d += (r.x0 - q.x1) * (r.x0 - q.x1);
        } else if (q.x0 > r.x1) {
            d += (q.x0 - r.x1) * (q.x0 - r.x1);
        }
        if (r.y0 > q.y1) {
            d += (r.y0 - q.y1) * (r.y0 - q.y1);
        } else if (q.y0 > r.y1) {
            d += (q.y0 - r.y1) * (q.y0 - r.y1);
        }
        return (int)Math.sqrt(d);
    }

    public int area() {
        return (this.y1 - this.y0) * (this.x1 - this.x0);
    }

    public static Rectangle join(Rectangle p, Rectangle q) {
        Rectangle res = new Rectangle(p);
        res.join(q);
        return res;
    }

    public void join(Rectangle r) {
        if (this.x0 > r.x0) {
            this.x0 = r.x0;
        }
        if (this.y0 > r.y0) {
            this.y0 = r.y0;
        }
        if (this.x1 < r.x1) {
            this.x1 = r.x1;
        }
        if (this.y1 < r.y1) {
            this.y1 = r.y1;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof Rectangle) {
            return false;
        }
        Rectangle r = (Rectangle)obj;
        return this.x0 == r.x0 && this.x1 == r.x1 && this.y0 == r.y0 && this.y1 == r.y1;
    }

    public boolean overlaps(Rectangle r) {
        return this.x0 <= r.x1 && this.y0 <= r.y1 && r.x0 <= this.x1 && r.y0 <= this.y1;
    }

    public boolean contains(Rectangle r) {
        return this.x0 <= r.x0 && this.y0 <= r.y0 && this.x1 >= r.x1 && this.y1 >= r.y1;
    }

    public Rectangle(int x0, int y0, int x1, int y1) {
        this.x0 = x0;
        this.x1 = x1;
        this.y0 = y0;
        this.y1 = y1;
    }

    public Rectangle(Rectangle r) {
        this.x0 = r.x0;
        this.x1 = r.x1;
        this.y0 = r.y0;
        this.y1 = r.y1;
    }

    public Rectangle() {
    }

    static {
        try {
            TYPE = Class.forName("javacli.Rectangle");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

