/*
 * Decompiled with CFR 0.152.
 */
package fanx.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileUtil {
    public static final File[] none = new File[0];

    public static File[] list(File file) {
        String[] stringArray = file.list();
        if (stringArray == null || stringArray.length == 0) {
            return none;
        }
        File[] fileArray = new File[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            fileArray[i] = new File(file, stringArray[i]);
        }
        return fileArray;
    }

    public static File parent(File file) {
        return new File(file.getParent());
    }

    public static void mkdir(File file) throws IOException {
        if (file.exists() && file.isDirectory()) {
            return;
        }
        if (!file.mkdirs()) {
            throw new IOException("Cannot mkdir: " + file);
        }
    }

    public static void delete(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] fileArray = FileUtil.list(file);
            for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
                FileUtil.delete(fileArray[i]);
            }
        }
        if (!file.delete()) {
            throw new IOException("Cannot delete: " + file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(File file, File file2) throws IOException {
        FileUtil.mkdir(FileUtil.parent(file2));
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));
        try {
            File[] fileArray = FileUtil.list(file);
            for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
                FileUtil.zip(fileArray[i], "", zipOutputStream);
            }
        }
        finally {
            zipOutputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zip(File file, String string, ZipOutputStream zipOutputStream) throws IOException {
        String string2;
        String string3 = file.getName();
        String string4 = string2 = string == "" ? string3 : string + "/" + string3;
        if (file.isDirectory()) {
            File[] fileArray = FileUtil.list(file);
            for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
                FileUtil.zip(fileArray[i], string2, zipOutputStream);
            }
        } else {
            zipOutputStream.putNextEntry(new ZipEntry(string2));
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            try {
                FileUtil.pipe(bufferedInputStream, zipOutputStream);
            }
            finally {
                try {
                    ((InputStream)bufferedInputStream).close();
                }
                catch (Exception exception) {}
            }
            zipOutputStream.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File file, File file2) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            try {
                FileUtil.pipe(bufferedInputStream, bufferedOutputStream);
            }
            finally {
                try {
                    ((OutputStream)bufferedOutputStream).close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                ((InputStream)bufferedInputStream).close();
            }
            catch (Exception exception) {}
        }
    }

    public static void pipe(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray, 0, byArray.length)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] read(File file) throws IOException {
        char[] cArray = new char[(int)file.length()];
        int n = 0;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            int n2;
            int n3 = -1;
            while ((n2 = ((InputStream)bufferedInputStream).read()) >= 0) {
                if ((n2 & 0x80) != 0) {
                    n2 = FileUtil.readUtf8(n2, bufferedInputStream);
                }
                if (n2 == 13) {
                    cArray[n++] = 10;
                } else {
                    if (n3 == 13 && n2 == 10) continue;
                    cArray[n++] = (char)n2;
                }
                n3 = n2;
            }
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
        if (n == cArray.length) {
            return cArray;
        }
        char[] cArray2 = new char[n];
        System.arraycopy(cArray, 0, cArray2, 0, n);
        return cArray2;
    }

    private static int readUtf8(int n, InputStream inputStream) throws IOException {
        switch (n >> 4) {
            case 12: 
            case 13: {
                int n2 = inputStream.read();
                if ((n2 & 0xC0) != 128) {
                    throw new UTFDataFormatException(Integer.toHexString(n));
                }
                return (n & 0x1F) << 6 | (n2 & 0x3F) << 0;
            }
            case 14: {
                int n3 = inputStream.read();
                int n4 = inputStream.read();
                if ((n3 & 0xC0) != 128 || (n4 & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                return (n & 0xF) << 12 | (n3 & 0x3F) << 6 | (n4 & 0x3F) << 0;
            }
            case 15: {
                throw new UTFDataFormatException(Integer.toHexString(n));
            }
        }
        throw new UTFDataFormatException(Integer.toHexString(n));
    }
}

