/*
 * Decompiled with CFR 0.152.
 */
package fanx.util;

import fan.sys.DateTime;
import fan.sys.Err;
import fan.sys.FanObj;
import fan.sys.File;
import fan.sys.List;
import fan.sys.Map;
import fan.sys.Method;
import fan.sys.Pod;
import fan.sys.Slot;
import fan.sys.Type;
import fanx.util.OpUtil;
import java.util.HashMap;

public class EnvScripts {
    HashMap cache = new HashMap(300);
    Object counterLock = new Object();
    int counter = 0;

    public Type compile(File file, Map map) {
        FanObj fanObj;
        Object object;
        file = file.normalize();
        if (!EnvScripts.getOption(map, "force", false) && (object = this.getCache(file)) != null && (fanObj = Type.find(((CachedScript)object).typeName, false)) != null) {
            return fanObj;
        }
        object = this.generatePodName(file);
        fanObj = this.compile((String)object, file, map);
        List list = ((Pod)fanObj).types();
        Type type = null;
        for (int i = 0; i < list.sz() && !(type = (Type)list.get(i)).isPublic(); ++i) {
        }
        if (type == null) {
            throw Err.make("Script file defines no public classes: " + file);
        }
        this.putCache(file, type);
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generatePodName(File file) {
        String string = file.basename();
        StringBuilder stringBuilder = new StringBuilder(string.length() + 6);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ('a' <= c && c <= 'z') {
                stringBuilder.append(c);
                continue;
            }
            if ('A' <= c && c <= 'Z') {
                stringBuilder.append(c);
                continue;
            }
            if (i <= 0 || '0' > c || c > '9') continue;
            stringBuilder.append(c);
        }
        Object object = this.counterLock;
        synchronized (object) {
            stringBuilder.append('_').append(this.counter++);
        }
        return stringBuilder.toString();
    }

    private Pod compile(String string, File file, Map map) {
        Method method = Slot.findMethod("compiler::Main.compileScript", true);
        return (Pod)method.call(string, file, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CachedScript getCache(File file) {
        HashMap hashMap = this.cache;
        synchronized (hashMap) {
            String string = this.cacheKey(file);
            CachedScript cachedScript = (CachedScript)this.cache.get(string);
            if (cachedScript == null) {
                return null;
            }
            if (OpUtil.compareEQ((Object)cachedScript.modified, (Object)file.modified()) && OpUtil.compareEQ(cachedScript.size, (Object)file.size())) {
                return cachedScript;
            }
            this.cache.remove(string);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putCache(File file, Type type) {
        CachedScript cachedScript = new CachedScript();
        cachedScript.modified = file.modified();
        cachedScript.size = file.size();
        cachedScript.typeName = type.qname();
        HashMap hashMap = this.cache;
        synchronized (hashMap) {
            this.cache.put(this.cacheKey(file), cachedScript);
        }
    }

    String cacheKey(File file) {
        return file.toStr();
    }

    static boolean getOption(Map map, String string, boolean bl) {
        if (map == null) {
            return bl;
        }
        Boolean bl2 = (Boolean)map.get(string);
        if (bl2 == null) {
            return bl;
        }
        return bl2;
    }

    static class CachedScript {
        DateTime modified;
        long size;
        String typeName;

        CachedScript() {
        }
    }
}

