/*
 * Decompiled with CFR 0.152.
 */
package fanx.util;

public class Box {
    public byte[] buf;
    public int len;

    public Box() {
        this.buf = new byte[256];
        this.len = 0;
    }

    public Box(byte[] byArray) {
        this.buf = byArray;
        this.len = byArray.length;
    }

    public Box(byte[] byArray, int n) {
        this.buf = byArray;
        this.len = n;
    }

    public final void u1(int n) {
        if (this.len + 1 >= this.buf.length) {
            this.grow();
        }
        this.buf[this.len++] = (byte)(n >>> 0);
    }

    public final void u2(int n) {
        if (this.len + 2 >= this.buf.length) {
            this.grow();
        }
        this.buf[this.len++] = (byte)(n >>> 8);
        this.buf[this.len++] = (byte)(n >>> 0);
    }

    public final void u2(int n, int n2) {
        this.buf[n + 0] = (byte)(n2 >>> 8);
        this.buf[n + 1] = (byte)(n2 >>> 0);
    }

    public final void u4(int n) {
        if (this.len + 4 >= this.buf.length) {
            this.grow();
        }
        this.buf[this.len++] = (byte)(n >>> 24);
        this.buf[this.len++] = (byte)(n >>> 16);
        this.buf[this.len++] = (byte)(n >>> 8);
        this.buf[this.len++] = (byte)(n >>> 0);
    }

    public final void u4(int n, int n2) {
        this.buf[n + 0] = (byte)(n2 >>> 24);
        this.buf[n + 1] = (byte)(n2 >>> 16);
        this.buf[n + 2] = (byte)(n2 >>> 8);
        this.buf[n + 3] = (byte)(n2 >>> 0);
    }

    public final void u8(long l) {
        if (this.len + 8 >= this.buf.length) {
            this.grow();
        }
        this.buf[this.len++] = (byte)(l >>> 56);
        this.buf[this.len++] = (byte)(l >>> 48);
        this.buf[this.len++] = (byte)(l >>> 40);
        this.buf[this.len++] = (byte)(l >>> 32);
        this.buf[this.len++] = (byte)(l >>> 24);
        this.buf[this.len++] = (byte)(l >>> 16);
        this.buf[this.len++] = (byte)(l >>> 8);
        this.buf[this.len++] = (byte)(l >>> 0);
    }

    public final void f4(float f) {
        this.u4(Float.floatToIntBits(f));
    }

    public final void f8(double d) {
        this.u8(Double.doubleToLongBits(d));
    }

    public final void append(Box box) {
        this.append(box.buf, box.len);
    }

    public final void append(byte[] byArray, int n) {
        while (this.len + n >= this.buf.length) {
            this.grow();
        }
        System.arraycopy(byArray, 0, this.buf, this.len, n);
        this.len += n;
    }

    public final void skip(int n) {
        while (this.len + n >= this.buf.length) {
            this.grow();
        }
        this.len += n;
    }

    public final void utf(String string) {
        char c;
        int n;
        int n2 = string.length();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            c = string.charAt(n);
            if (c <= '\u007f') {
                if (c == '\u0000') {
                    n3 += 2;
                    continue;
                }
                ++n3;
                continue;
            }
            if (c > '\u07ff') {
                n3 += 3;
                continue;
            }
            n3 += 2;
        }
        if (n3 > 65536) {
            throw new RuntimeException("string too big");
        }
        while (this.len + 2 + n3 >= this.buf.length) {
            this.grow();
        }
        this.buf[this.len++] = (byte)(n3 >>> 8 & 0xFF);
        this.buf[this.len++] = (byte)(n3 >>> 0 & 0xFF);
        for (n = 0; n < n2; ++n) {
            c = string.charAt(n);
            if (c <= '\u007f') {
                if (c == '\u0000') {
                    this.buf[this.len++] = -64;
                    this.buf[this.len++] = -128;
                    continue;
                }
                this.buf[this.len++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                this.buf[this.len++] = (byte)(0xE0 | c >> 12 & 0xF);
                this.buf[this.len++] = (byte)(0x80 | c >> 6 & 0x3F);
                this.buf[this.len++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            this.buf[this.len++] = (byte)(0xC0 | c >> 6 & 0x1F);
            this.buf[this.len++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
    }

    public final void grow() {
        this.grow(this.buf.length * 2);
    }

    public final void grow(int n) {
        if (n > this.buf.length) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.buf, 0, byArray, 0, this.buf.length);
            this.buf = byArray;
        }
    }

    public void dump() {
        for (int i = 0; i < this.len; ++i) {
            System.out.println("  [" + i + "] 0x" + Integer.toHexString(this.buf[i] & 0xFF));
        }
    }
}

