/*
 * Decompiled with CFR 0.152.
 */
package fanx.test;

import fanx.emit.CodeEmit;
import fanx.emit.EmitConst;
import fanx.emit.Emitter;
import fanx.test.Test;
import fanx.util.Box;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class EmitTest
extends Test
implements EmitConst {
    ClassLoader loader = new Loader();
    Emitter toLoad;

    public void run() throws Exception {
        this.verifyConstantPool();
        this.verifyBasics();
    }

    void verifyConstantPool() throws Exception {
        Emitter emitter = new Emitter("Foo", "java/lang/Object", new String[0], 1);
        int n = emitter.utf("foo");
        int n2 = emitter.utf("bar");
        int n3 = emitter.utf("ray");
        this.verify(emitter.utf("foo") == n);
        this.verify(emitter.utf("foo") == n);
        this.verify(emitter.utf("bar") == n2);
        this.verify(emitter.utf("foo") == n);
        int n4 = emitter.strConst("hello");
        this.verify(emitter.strConst("hello") == n4);
        this.verify(emitter.strConst("hello") == n4);
        int n5 = emitter.intConst(77);
        this.verify(emitter.intConst(77) == n5);
        int n6 = emitter.longConst(Long.MIN_VALUE);
        this.verify(emitter.longConst(Long.MIN_VALUE) == n6);
        int n7 = emitter.longConst(0L);
        this.verify(n7 == n6 + 2);
        int n8 = emitter.floatConst(Float.valueOf(2.3f));
        this.verify(emitter.floatConst(Float.valueOf(2.3f)) == n8);
        int n9 = emitter.floatConst(Float.valueOf(Float.NaN));
        this.verify(emitter.floatConst(Float.valueOf(Float.NaN)) == n9);
        this.verify(emitter.floatConst(Float.valueOf(Float.NaN)) == n9);
        int n10 = emitter.floatConst(Float.valueOf(Float.POSITIVE_INFINITY));
        this.verify(emitter.floatConst(Float.valueOf(Float.POSITIVE_INFINITY)) == n10);
        int n11 = emitter.doubleConst((Double)Double.MAX_VALUE);
        this.verify(emitter.doubleConst((Double)Double.MAX_VALUE) == n11);
        int n12 = emitter.doubleConst(0.0);
        this.verify(n12 == n11 + 2);
        int n13 = emitter.doubleConst(Double.NaN);
        this.verify(emitter.doubleConst(Double.NaN) == n13);
        this.verify(emitter.doubleConst(Double.NaN) == n13);
        int n14 = emitter.doubleConst(Double.POSITIVE_INFINITY);
        this.verify(emitter.doubleConst(Double.POSITIVE_INFINITY) == n14);
        int n15 = emitter.cls("bad");
        int n16 = emitter.cls("foo");
        this.verify(emitter.cls("bad") == n15);
        int n17 = emitter.method("foo.funcx()I");
        this.verify(emitter.method("foo.funcx()I") == n17);
        this.verify(emitter.method("foo.funcx()I") == n17);
        int n18 = emitter.field("foo.kick:Z");
        this.verify(emitter.field("foo.kick:Z") == n18);
    }

    void verifyBasics() throws Exception {
        Emitter emitter = new Emitter("Foo", "java/lang/Object", new String[0], 1);
        int n = emitter.emitField("s", "Ljava/lang/String;", 1).ref();
        int n2 = emitter.emitField("i", "I", 1).ref();
        int n3 = emitter.emitField("l", "J", 1).ref();
        int n4 = emitter.emitField("f", "F", 1).ref();
        int n5 = emitter.emitField("d", "D", 1).ref();
        int n6 = emitter.emitField("z", "Z", 1).ref();
        CodeEmit codeEmit = emitter.emitMethod("<init>", "()V", 1).emitCode();
        codeEmit.maxLocals = 10;
        codeEmit.maxStack = 10;
        codeEmit.op(42);
        codeEmit.op2(183, emitter.method("java/lang/Object.<init>()V"));
        codeEmit.op(177);
        codeEmit = emitter.emitMethod("add", "(II)I", 1).emitCode();
        codeEmit.maxLocals = 10;
        codeEmit.maxStack = 10;
        codeEmit.op(27);
        codeEmit.op(28);
        codeEmit.op(96);
        codeEmit.op(172);
        codeEmit = emitter.emitMethod("sets", "()V", 1).emitCode();
        codeEmit.maxLocals = 10;
        codeEmit.maxStack = 10;
        codeEmit.op(42);
        codeEmit.op2(19, emitter.strConst("set it!"));
        codeEmit.op2(181, n);
        codeEmit.op(42);
        codeEmit.op2(19, emitter.intConst(123));
        codeEmit.op2(181, n2);
        codeEmit.op(42);
        codeEmit.op2(20, emitter.longConst(11806310404660L));
        codeEmit.op2(181, n3);
        codeEmit.op(42);
        codeEmit.op2(19, emitter.floatConst(Float.valueOf(6.9f)));
        codeEmit.op2(181, n4);
        codeEmit.op(42);
        codeEmit.op2(20, emitter.doubleConst(700.007));
        codeEmit.op2(181, n5);
        codeEmit.op(177);
        Class clazz = this.load(emitter);
        this.verify(clazz.getName().equals("Foo"));
        this.verify(clazz.getSuperclass() == Object.class);
        this.verify(clazz.getInterfaces().length == 0);
        this.verify(Modifier.isPublic(clazz.getModifiers()));
        Object t = clazz.newInstance();
        Field field = clazz.getField("s");
        Field field2 = clazz.getField("i");
        Field field3 = clazz.getField("l");
        Field field4 = clazz.getField("f");
        Field field5 = clazz.getField("d");
        this.verify(field.getType() == String.class);
        this.verify(field.get(t) == null);
        field.set(t, "hello");
        this.verify(field.get(t) == "hello");
        Method method = clazz.getMethod("add", Integer.TYPE, Integer.TYPE);
        this.verify(method.getReturnType() == Integer.TYPE);
        Integer n7 = (Integer)method.invoke(t, new Integer(3), new Integer(5));
        this.verify(n7 == 8);
        Method method2 = clazz.getMethod("sets", new Class[0]);
        method2.invoke(t, new Object[0]);
        this.verify(field.get(t).equals("set it!"));
        this.verify(field2.getInt(t) == 123);
        this.verify(field3.getLong(t) == 11806310404660L);
        this.verify(field4.getFloat(t) == 6.9f);
        this.verify(field5.getDouble(t) == 700.007);
    }

    Class load(Emitter emitter) throws Exception {
        this.toLoad = emitter;
        return this.loader.loadClass(emitter.className);
    }

    void dumpToFile(String string, Box box) {
        try {
            File file = new File(string + ".class");
            System.out.println("Dump: " + file);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(box.buf, 0, box.len);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    class Loader
    extends ClassLoader {
        Loader() {
        }

        protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
            if (EmitTest.this.toLoad != null && EmitTest.this.toLoad.className.equals(string)) {
                Box box = EmitTest.this.toLoad.pack();
                Class<?> clazz = this.defineClass(string, box.buf, 0, box.len);
                EmitTest.this.toLoad = null;
                if (bl) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
            return this.findSystemClass(string);
        }
    }
}

