/*
 * Decompiled with CFR 0.152.
 */
package fanx.fcode;

import fanx.fcode.FBuf;
import fanx.fcode.FConst;
import fanx.fcode.FPod;
import fanx.util.StrUtil;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;

public class FCodePrinter
extends PrintWriter
implements FConst {
    static final int None = -1;
    static final int Int = 0;
    static final int Float = 1;
    static final int Str = 2;
    static final int Dur = 3;
    static final int Uri = 4;
    static final int Reg = 5;
    static final int Type = 6;
    static final int Field = 7;
    static final int Method = 8;
    static final int Jmp = 9;
    static final Op[] ops = new Op[OpNames.length];
    public final FPod pod;
    public boolean showIndex;
    private FBuf code;
    private DataInputStream in;
    private int n;

    public FCodePrinter(FPod fPod, OutputStream outputStream) {
        super(outputStream);
        this.pod = fPod;
    }

    public FCodePrinter(FPod fPod, Writer writer) {
        super(writer);
        this.pod = fPod;
    }

    public FCodePrinter(FPod fPod) {
        this(fPod, System.out);
    }

    public void code(FBuf fBuf) {
        try {
            int n;
            this.code = fBuf;
            this.in = new DataInputStream(new ByteArrayInputStream(fBuf.buf, 0, fBuf.len));
            while ((n = this.in.read()) >= 0) {
                ++this.n;
                this.op(n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.flush();
        this.code = null;
        this.in = null;
    }

    private void op(int n) throws IOException {
        if (n >= ops.length) {
            throw new IllegalStateException("Unknown opcode: " + n);
        }
        Op op = ops[n];
        this.print("    " + StrUtil.padl("" + (this.n - 1), 3) + ": " + StrUtil.padr(op.name, 16) + " ");
        if (n == 47) {
            this.printSwitch();
        } else {
            switch (op.arg) {
                case -1: {
                    break;
                }
                case 0: {
                    this.print(this.integer());
                    break;
                }
                case 1: {
                    this.print(this.floatpt());
                    break;
                }
                case 2: {
                    this.print(this.str());
                    break;
                }
                case 3: {
                    this.print(this.duration());
                    break;
                }
                case 4: {
                    this.print(this.uri());
                    break;
                }
                case 5: {
                    this.print(this.u2());
                    break;
                }
                case 6: {
                    this.print(this.type());
                    break;
                }
                case 7: {
                    this.print(this.field());
                    break;
                }
                case 8: {
                    this.print(this.method());
                    break;
                }
                case 9: {
                    this.print(this.jmp());
                    break;
                }
                default: {
                    throw new IllegalStateException(op.sig);
                }
            }
        }
        this.println();
    }

    private void printSwitch() throws IOException {
        int n = this.u2();
        for (int i = 0; i < n; ++i) {
            this.println();
            this.print("          " + i + " -> " + this.u2());
        }
    }

    static int parseArg(String string) {
        if (string.equals("()")) {
            return -1;
        }
        if (string.equals("(int)")) {
            return 0;
        }
        if (string.equals("(float)")) {
            return 1;
        }
        if (string.equals("(str)")) {
            return 2;
        }
        if (string.equals("(dur)")) {
            return 3;
        }
        if (string.equals("(uri)")) {
            return 4;
        }
        if (string.equals("(reg)")) {
            return 5;
        }
        if (string.equals("(type)")) {
            return 6;
        }
        if (string.equals("(field)")) {
            return 7;
        }
        if (string.equals("(method)")) {
            return 8;
        }
        if (string.equals("(jmp)")) {
            return 9;
        }
        throw new IllegalStateException(string);
    }

    private int u1() throws IOException {
        ++this.n;
        return this.in.readByte();
    }

    private int u2() throws IOException {
        this.n += 2;
        return this.in.readUnsignedShort();
    }

    private int u4() throws IOException {
        this.n += 4;
        return this.in.readInt();
    }

    private String integer() throws IOException {
        int n = this.u2();
        try {
            return this.pod.literals.integer(n).toString() + this.showIndex(n);
        }
        catch (Exception exception) {
            return "Error [" + n + "]";
        }
    }

    private String floatpt() throws IOException {
        int n = this.u2();
        try {
            return this.pod.literals.floats(n).toString() + this.showIndex(n);
        }
        catch (Exception exception) {
            return "Error [" + n + "]";
        }
    }

    private String str() throws IOException {
        int n = this.u2();
        try {
            return this.pod.literals.str(n).toString() + this.showIndex(n);
        }
        catch (Exception exception) {
            return "Error [" + n + "]";
        }
    }

    private String duration() throws IOException {
        int n = this.u2();
        try {
            return this.pod.literals.duration(n).toString() + this.showIndex(n);
        }
        catch (Exception exception) {
            return "Error [" + n + "]";
        }
    }

    private String uri() throws IOException {
        int n = this.u2();
        try {
            return this.pod.literals.uri(n).toString() + this.showIndex(n);
        }
        catch (Exception exception) {
            return "Error [" + n + "]";
        }
    }

    private String type() throws IOException {
        int n = this.u2();
        try {
            return this.pod.typeRefs.toString(n) + this.showIndex(n);
        }
        catch (Exception exception) {
            return "Error [" + n + "]";
        }
    }

    private String field() throws IOException {
        int n = this.u2();
        try {
            return this.pod.fieldRefs.toString(n) + this.showIndex(n);
        }
        catch (Exception exception) {
            return "Error [" + n + "]";
        }
    }

    private String method() throws IOException {
        int n = this.u2();
        try {
            return this.pod.methodRefs.toString(n) + this.showIndex(n);
        }
        catch (Exception exception) {
            return "Error [" + n + "]";
        }
    }

    private String jmp() throws IOException {
        int n = this.u2();
        return "" + n;
    }

    private String showIndex(int n) {
        if (this.showIndex) {
            return "[" + n + "]";
        }
        return "";
    }

    static {
        for (int i = 0; i < ops.length; ++i) {
            FCodePrinter.ops[i] = new Op(i);
        }
    }

    static class Op {
        int id;
        String name;
        String sig;
        int arg;

        Op(int n) {
            this.id = n;
            this.name = FConst.OpNames[n];
            this.sig = FConst.OpSigs[n];
            this.arg = FCodePrinter.parseArg(this.sig);
        }
    }
}

