/*
 * Decompiled with CFR 0.152.
 */
package fanx.emit;

import fan.sys.FuncType;
import fan.sys.List;
import fan.sys.Method;
import fan.sys.Type;
import fanx.emit.AttrEmit;
import fanx.emit.CodeEmit;
import fanx.emit.Emitter;
import fanx.emit.FClassEmit;
import fanx.emit.FCodeEmit;
import fanx.emit.FFacetEmit;
import fanx.emit.FMethodEmit;
import fanx.emit.FMixinBodyEmit;
import fanx.emit.FMixinInterfaceEmit;
import fanx.emit.FieldEmit;
import fanx.emit.MethodEmit;
import fanx.fcode.FAttrs;
import fanx.fcode.FConst;
import fanx.fcode.FField;
import fanx.fcode.FMethod;
import fanx.fcode.FPod;
import fanx.fcode.FType;
import fanx.util.Box;
import java.util.HashMap;

public abstract class FTypeEmit
extends Emitter
implements FConst {
    private int typeFind;
    int BoolBox;
    int BoolUnbox;
    int IntBox;
    int IntUnbox;
    int FloatBox;
    int FloatUnbox;
    int IsViaType;
    int ErrMake;
    int TypeToNullable;
    int NullErrMakeCoerce;
    public Box classFile;
    Type parent;
    FPod pod;
    FType type;
    String selfName;
    FieldEmit typeField;
    FieldEmit peerField;
    boolean hasInstanceInit;
    boolean hasStaticInit;
    FuncType funcType;
    HashMap typeLiteralFields;
    boolean isNative = false;
    int lineNum;

    public static FTypeEmit[] emit(Type type, FType fType) throws Exception {
        if ((fType.flags & 0x100) != 0) {
            FMixinInterfaceEmit fMixinInterfaceEmit = new FMixinInterfaceEmit(type, fType);
            fMixinInterfaceEmit.emit();
            FMixinBodyEmit fMixinBodyEmit = new FMixinBodyEmit(type, fType);
            fMixinBodyEmit.emit();
            return new FTypeEmit[]{fMixinInterfaceEmit, fMixinBodyEmit};
        }
        FClassEmit fClassEmit = new FClassEmit(type, fType);
        fClassEmit.emit();
        return new FTypeEmit[]{fClassEmit};
    }

    protected FTypeEmit(Type type, FType fType) {
        this.parent = type;
        this.pod = fType.pod;
        this.type = fType;
        this.lineNum = fType.attrs.lineNum;
    }

    public Box emit() {
        int n;
        this.init(this.jname(this.type.self), this.base(), this.mixins(), FTypeEmit.jflags(this.type.flags) | 0x20);
        this.selfName = this.className;
        this.preview();
        this.emitType();
        for (n = 0; n < this.type.fields.length; ++n) {
            this.emit(this.type.fields[n]);
        }
        for (n = 0; n < this.type.methods.length; ++n) {
            this.emit(this.type.methods[n]);
        }
        this.emitAttributes(this.type.attrs);
        this.emitMixinRouters();
        if (!this.hasInstanceInit) {
            this.emitInstanceInit(null);
        }
        if (!this.hasStaticInit) {
            this.emitStaticInit(null);
        }
        this.emitTypeConstFields();
        this.classFile = this.pack();
        return this.classFile;
    }

    abstract String base();

    String[] mixins() {
        String[] stringArray = new String[this.type.mixins.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.jname(this.type.mixins[i]);
        }
        return stringArray;
    }

    private void preview() {
        boolean bl = this.isNative = (this.type.flags & 0x200) != 0;
        if (!this.isNative) {
            for (int i = 0; i < this.type.methods.length; ++i) {
                if ((this.type.methods[i].flags & 0x200) == 0) continue;
                this.isNative = true;
                break;
            }
        }
    }

    private void emitType() {
        this.typeField = this.emitField("$Type", "Lfan/sys/Type;", 25);
        MethodEmit methodEmit = this.emitMethod("typeof", "()Lfan/sys/Type;", 1);
        CodeEmit codeEmit = methodEmit.emitCode();
        codeEmit.maxLocals = 1;
        codeEmit.maxStack = 2;
        codeEmit.op2(178, this.typeField.ref());
        codeEmit.op(176);
        codeEmit.emitLineNumber(this.lineNum);
        if (this.isNative) {
            this.peerField = this.emitField("peer", "L" + this.className + "Peer;", 1);
        }
    }

    protected void emitAttributes(FAttrs fAttrs) {
        if (fAttrs.sourceFile != null) {
            AttrEmit attrEmit = this.emitAttr("SourceFile");
            attrEmit.info.u2(this.utf(fAttrs.sourceFile));
        }
        FFacetEmit.emitType(this, this.pod, fAttrs);
    }

    protected void emit(FField fField) {
        if ((fField.flags & 0x10000) != 0) {
            FieldEmit fieldEmit = this.emitField(fField.name, this.pod.typeRef(fField.type).jsig(), FTypeEmit.jflags(fField.flags));
            FFacetEmit.emitField(fieldEmit, this.pod, fField.attrs);
        }
    }

    private void emit(FMethod fMethod) {
        boolean bl;
        String string = fMethod.name;
        boolean bl2 = (fMethod.flags & 0x200) != 0;
        boolean bl3 = bl = (fMethod.flags & 4) != 0;
        if (string.equals("static$init")) {
            this.emitStaticInit(fMethod);
            return;
        }
        if (string.equals("instance$init")) {
            this.emitInstanceInit(fMethod);
            return;
        }
        MethodEmit methodEmit = null;
        methodEmit = bl2 ? new FMethodEmit(this, fMethod).emitNative() : (bl ? (this.parent.base().isJava() ? new FMethodEmit(this, fMethod).emitCtorWithJavaSuper() : new FMethodEmit(this, fMethod).emitCtor()) : new FMethodEmit(this, fMethod).emitStandard());
        FFacetEmit.emitMethod(methodEmit, this.pod, fMethod.attrs);
        if (this.funcType != null && string.equals("doCall")) {
            this.emitFuncParamNames(fMethod);
        }
    }

    protected void emitInstanceInit(FMethod fMethod) {
        if (this.parent.base().isJava()) {
            return;
        }
        this.hasInstanceInit = true;
        MethodEmit methodEmit = this.emitMethod("<init>", "()V", 1);
        CodeEmit codeEmit = methodEmit.emitCode();
        codeEmit.maxLocals = 1;
        codeEmit.maxStack = 3;
        codeEmit.op(42);
        if (this.funcType != null) {
            codeEmit.op2(178, this.typeField.ref());
            codeEmit.op2(192, this.cls("fan/sys/FuncType"));
            codeEmit.op2(183, this.method(this.superClassName + ".<init>(Lfan/sys/FuncType;)V"));
        } else {
            codeEmit.op2(183, this.method(this.superClassName + ".<init>()V"));
        }
        if (this.isNative) {
            codeEmit.op(42);
            codeEmit.op(89);
            codeEmit.op2(184, this.method(this.selfName + "Peer.make(L" + this.className + ";)L" + this.className + "Peer;"));
            codeEmit.op2(181, this.peerField.ref());
        }
        if (fMethod == null) {
            codeEmit.op(177);
            codeEmit.emitLineNumber(this.lineNum);
        } else {
            new FCodeEmit(this, fMethod, codeEmit).emit();
        }
    }

    void emitStaticInit(FMethod fMethod) {
        this.hasStaticInit = true;
        MethodEmit methodEmit = this.emitMethod("<clinit>", "()V", 9);
        CodeEmit codeEmit = methodEmit.emitCode();
        codeEmit.maxLocals = 0;
        codeEmit.maxStack = 1;
        if (!this.parent.isMixin()) {
            Type type = this.parent;
            if (this.parent.base() instanceof FuncType) {
                type = this.parent.base();
            }
            codeEmit.op2(19, this.strConst(type.signature()));
            codeEmit.op2(184, this.method("fan/sys/Type.find(Ljava/lang/String;)Lfan/sys/Type;"));
            codeEmit.op2(179, this.typeField.ref());
        }
        if (fMethod == null) {
            codeEmit.op(177);
            codeEmit.emitLineNumber(this.lineNum);
        } else {
            new FCodeEmit(this, fMethod, codeEmit).emit();
        }
    }

    void emitTypeConstFields() {
        if (this.typeLiteralFields == null) {
            return;
        }
        for (String string : this.typeLiteralFields.values()) {
            this.emitField(string, "Lfan/sys/Type;", 10);
        }
    }

    void emitFuncParamNames(FMethod fMethod) {
        StringBuilder stringBuilder = new StringBuilder(fMethod.paramCount * 16);
        for (int i = 0; i < fMethod.paramCount; ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(fMethod.vars[i].name);
        }
        MethodEmit methodEmit = this.emitMethod("paramNames", "()Ljava/lang/String;", 1);
        CodeEmit codeEmit = methodEmit.emitCode();
        codeEmit.maxLocals = 1;
        codeEmit.maxStack = 1;
        codeEmit.op2(19, this.strConst(stringBuilder.toString()));
        codeEmit.op(176);
    }

    private void emitMixinRouters() {
        if (this.parent.mixins().isEmpty()) {
            return;
        }
        HashMap hashMap = new HashMap();
        this.findMixins(this.parent, hashMap);
        for (Type type : hashMap.values()) {
            this.emitMixinRouters(type);
        }
    }

    private void findMixins(Type type, HashMap hashMap) {
        String string = type.qname();
        if (type.isMixin() && hashMap.get(string) == null) {
            hashMap.put(string, type);
        }
        for (int i = 0; i < type.mixins().sz(); ++i) {
            this.findMixins((Type)type.mixins().get(i), hashMap);
        }
    }

    private void emitMixinRouters(Type type) {
        List list = type.methods();
        for (int i = 0; i < list.sz(); ++i) {
            String string;
            Method method = (Method)list.get(i);
            if (method.isStatic() || method.isAbstract() || this.parent.slot(string = method.name(), true).parent() != type) continue;
            new FMethodEmit(this).emitMixinRouter(method);
        }
    }

    static int jflags(int n) {
        int n2 = 0;
        if ((n & 0x800) != 0) {
            // empty if block
        }
        if ((n & 0x1000) != 0) {
            n2 |= 1;
        }
        if ((n & 0x2000) != 0) {
            n2 |= 1;
        }
        if ((n & 0x80) != 0) {
            n2 |= 1;
        }
        if ((n & 1) != 0) {
            n2 |= 0x400;
        }
        if ((n & 0x8000) != 0) {
            n2 |= 8;
        }
        if ((n & 0x100) != 0) {
            n2 |= 0x200;
        }
        return n2;
    }

    String jname(int n) {
        return this.pod.typeRef(n).jname();
    }

    String name(int n) {
        return this.pod.name(n);
    }

    int typeFind() {
        if (this.typeFind == 0) {
            this.typeFind = this.method("fan/sys/Type.find(Ljava/lang/String;Z)Lfan/sys/Type;");
        }
        return this.typeFind;
    }
}

