/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.Buf;
import fan.sys.IOErr;
import fan.sys.MemBuf;
import fan.sys.OutStream;
import fan.sys.Sys;
import fan.sys.Type;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class SysOutStream
extends OutStream {
    OutputStream out;

    public static SysOutStream make(OutputStream outputStream, Long l) {
        return new SysOutStream(SysOutStream.toBuffered(outputStream, l));
    }

    public static OutputStream toBuffered(OutputStream outputStream, Long l) {
        if (l == null || l == 0L) {
            return outputStream;
        }
        return new BufferedOutputStream(outputStream, l.intValue());
    }

    public SysOutStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    public Type typeof() {
        return Sys.SysOutStreamType;
    }

    public final OutStream write(long l) {
        return this.w((int)l);
    }

    public OutStream w(int n) {
        try {
            this.out.write(n);
            return this;
        }
        catch (IOException iOException) {
            throw IOErr.make(iOException);
        }
    }

    public final OutStream writeBuf(Buf buf) {
        return this.writeBuf(buf, buf.remaining());
    }

    public OutStream writeBuf(Buf buf, long l) {
        try {
            buf.pipeTo(this.out, l);
            return this;
        }
        catch (IOException iOException) {
            throw IOErr.make(iOException);
        }
    }

    public OutStream writeChar(long l) {
        return this.writeChar((char)l);
    }

    public OutStream writeChar(char c) {
        this.charsetEncoder.encode(c, this);
        return this;
    }

    public OutStream flush() {
        try {
            this.out.flush();
            return this;
        }
        catch (IOException iOException) {
            throw IOErr.make(iOException);
        }
    }

    public boolean close() {
        try {
            if (this.out != null) {
                this.out.close();
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static OutputStream java(OutStream outStream) {
        if (outStream instanceof SysOutStream) {
            return ((SysOutStream)outStream).out;
        }
        return new JavaOutputStream(outStream);
    }

    static class JavaOutputStream
    extends OutputStream {
        OutStream out;
        MemBuf buf = new MemBuf(null, 0);

        JavaOutputStream(OutStream outStream) {
            this.out = outStream;
        }

        public void write(int n) {
            this.out.write(n);
        }

        public void write(byte[] byArray, int n, int n2) {
            this.buf.buf = byArray;
            this.buf.pos = n;
            this.buf.size = byArray.length;
            this.out.writeBuf(this.buf, n2);
            this.buf.buf = null;
        }

        public void close() {
            this.out.close();
        }
    }
}

