/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.Buf;
import fan.sys.FanInt;
import fan.sys.IOErr;
import fan.sys.InStream;
import fan.sys.MemBuf;
import fan.sys.Sys;
import fan.sys.Type;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class SysInStream
extends InStream {
    InputStream in;

    public static SysInStream make(InputStream inputStream, Long l) {
        if (l == null || l == 0L) {
            return new SysInStream(inputStream);
        }
        return new SysInStream(new BufferedInputStream(inputStream, l.intValue()));
    }

    public SysInStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public Type typeof() {
        return Sys.SysInStreamType;
    }

    public Long read() {
        int n = this.r();
        return n < 0 ? null : FanInt.pos[n];
    }

    public int r() {
        try {
            return this.in.read();
        }
        catch (IOException iOException) {
            throw IOErr.make(iOException);
        }
    }

    public Long readBuf(Buf buf, long l) {
        try {
            long l2 = buf.pipeFrom(this.in, l);
            if (l2 < 0L) {
                return null;
            }
            return l2;
        }
        catch (IOException iOException) {
            throw IOErr.make(iOException);
        }
    }

    public InStream unread(long l) {
        return this.unread((int)l);
    }

    public InStream unread(int n) {
        try {
            if (!(this.in instanceof PushbackInputStream)) {
                this.in = new PushbackInputStream(this.in, 128);
            }
            ((PushbackInputStream)this.in).unread(n);
            return this;
        }
        catch (IOException iOException) {
            throw IOErr.make(iOException);
        }
    }

    public long skip(long l) {
        try {
            long l2 = this.in.skip(l);
            if (l2 < 0L) {
                return 0L;
            }
            return l2;
        }
        catch (IOException iOException) {
            throw IOErr.make(iOException);
        }
    }

    public boolean close() {
        try {
            if (this.in != null) {
                this.in.close();
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static InputStream java(InStream inStream) {
        if (inStream instanceof SysInStream) {
            return ((SysInStream)inStream).in;
        }
        return new JavaInputStream(inStream);
    }

    static class JavaInputStream
    extends InputStream {
        InStream in;
        MemBuf buf = new MemBuf(null, 0);

        JavaInputStream(InStream inStream) {
            this.in = inStream;
        }

        public int read() {
            return this.in.r();
        }

        public int read(byte[] byArray, int n, int n2) {
            this.buf.buf = byArray;
            this.buf.pos = n;
            this.buf.size = byArray.length;
            Long l = this.in.readBuf(this.buf, n2);
            this.buf.buf = null;
            if (l == null) {
                return -1;
            }
            return l.intValue();
        }

        public void close() {
            this.in.close();
        }
    }
}

