/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.ArgErr;
import fan.sys.Buf;
import fan.sys.DateTime;
import fan.sys.File;
import fan.sys.FileBuf;
import fan.sys.IOErr;
import fan.sys.InStream;
import fan.sys.List;
import fan.sys.MmapBuf;
import fan.sys.OutStream;
import fan.sys.Sys;
import fan.sys.SysInStream;
import fan.sys.SysOutStream;
import fan.sys.Type;
import fan.sys.Uri;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;

public class LocalFile
extends File {
    final java.io.File file;

    public static Uri fileToUri(java.io.File file, boolean bl, String string) {
        String string2 = file.getPath();
        int n = string2.length();
        StringBuilder stringBuilder = new StringBuilder(string2.length() + 2);
        if (string != null) {
            stringBuilder.append(string).append(':');
        }
        if (n > 2 && string2.charAt(1) == ':' && string2.charAt(0) != '/') {
            stringBuilder.append('/');
        }
        block4: for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            switch (c) {
                case '#': 
                case '?': {
                    stringBuilder.append('\\').append(c);
                    continue block4;
                }
                case '\\': {
                    stringBuilder.append('/');
                    continue block4;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        if (bl && (stringBuilder.length() == 0 || stringBuilder.charAt(stringBuilder.length() - 1) != '/')) {
            stringBuilder.append('/');
        }
        return Uri.fromStr(stringBuilder.toString());
    }

    public static java.io.File uriToFile(Uri uri) {
        if (uri.scheme() != null && !uri.scheme().equals("file")) {
            throw ArgErr.make("Invalid Uri scheme for local file: " + uri);
        }
        return new java.io.File(LocalFile.uriToPath(uri));
    }

    public static String uriToPath(Uri uri) {
        String string = uri.pathStr();
        int n = string.length();
        StringBuilder stringBuilder = null;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                if (stringBuilder != null) continue;
                stringBuilder = new StringBuilder();
                stringBuilder.append(string, 0, i);
                continue;
            }
            if (stringBuilder == null) continue;
            stringBuilder.append(c);
        }
        return stringBuilder == null ? string : stringBuilder.toString();
    }

    public static String fileNameToUriName(String string) {
        int n = string.length();
        StringBuilder stringBuilder = null;
        block3: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '#': 
                case '?': {
                    if (stringBuilder == null) {
                        stringBuilder = new StringBuilder();
                        stringBuilder.append(string, 0, i);
                    }
                    stringBuilder.append('\\').append(c);
                    continue block3;
                }
                default: {
                    if (stringBuilder == null) continue block3;
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder == null ? string : stringBuilder.toString();
    }

    public LocalFile(java.io.File file) {
        this(file, file.isDirectory());
    }

    public LocalFile(java.io.File file, boolean bl) {
        this(LocalFile.fileToUri(file, bl, null), file);
    }

    public LocalFile(Uri uri, java.io.File file) {
        super(uri);
        this.file = file;
        if (file.exists()) {
            if (file.isDirectory()) {
                if (!uri.isDir()) {
                    throw IOErr.make("Must use trailing slash for dir: " + uri);
                }
            } else if (uri.isDir()) {
                throw IOErr.make("Cannot use trailing slash for file: " + uri);
            }
        }
    }

    public Type typeof() {
        return Sys.LocalFileType;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public Long size() {
        if (this.file.isDirectory()) {
            return null;
        }
        return this.file.length();
    }

    public DateTime modified() {
        return DateTime.fromJava(this.file.lastModified());
    }

    public void modified(DateTime dateTime) {
        this.file.setLastModified(dateTime.toJava());
    }

    public String osPath() {
        return this.file.getPath();
    }

    public File parent() {
        Uri uri = this.uri.parent();
        if (uri == null) {
            return null;
        }
        return new LocalFile(uri, LocalFile.uriToFile(uri));
    }

    public List list() {
        java.io.File[] fileArray = this.file.listFiles();
        int n = fileArray == null ? 0 : fileArray.length;
        List list = new List(Sys.FileType, n);
        for (int i = 0; i < n; ++i) {
            java.io.File file = fileArray[i];
            String string = LocalFile.fileNameToUriName(file.getName());
            list.add(new LocalFile(this.uri.plusName(string, file.isDirectory()), file));
        }
        return list;
    }

    public File normalize() {
        try {
            java.io.File file = this.file.getCanonicalFile();
            boolean bl = file.exists() ? file.isDirectory() : this.uri.isDir();
            Uri uri = LocalFile.fileToUri(file, bl, "file");
            return new LocalFile(uri, file);
        }
        catch (IOException iOException) {
            throw IOErr.make(iOException);
        }
    }

    public File plus(Uri uri, boolean bl) {
        return LocalFile.make(this.uri.plus(uri), bl);
    }

    public File create() {
        if (this.isDir()) {
            this.createDir();
        } else {
            this.createFile();
        }
        return this;
    }

    private void createFile() {
        if (this.file.exists() && this.file.isDirectory()) {
            throw IOErr.make("Already exists as dir: " + this.file);
        }
        java.io.File file = this.file.getParentFile();
        if (file != null && !file.exists() && !file.mkdirs()) {
            throw IOErr.make("Cannot create dir: " + file);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.file);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            throw IOErr.make(iOException);
        }
    }

    private void createDir() {
        if (this.file.exists()) {
            if (!this.file.isDirectory()) {
                throw IOErr.make("Already exists as file: " + this.file);
            }
        } else if (!this.file.mkdirs()) {
            throw IOErr.make("Cannot create dir: " + this.file);
        }
    }

    public File moveTo(File file) {
        File file2;
        if (this.isDir() != file.isDir()) {
            if (this.isDir()) {
                throw ArgErr.make("moveTo must be dir `" + file + "`");
            }
            throw ArgErr.make("moveTo must not be dir `" + file + "`");
        }
        if (!(file instanceof LocalFile)) {
            throw IOErr.make("Cannot move LocalFile to " + file.typeof());
        }
        LocalFile localFile = (LocalFile)file;
        if (localFile.exists()) {
            throw IOErr.make("moveTo already exists: " + file);
        }
        if (!this.file.isDirectory() && (file2 = localFile.parent()) != null && !file2.exists()) {
            file2.create();
        }
        if (!this.file.renameTo(localFile.file)) {
            throw IOErr.make("moveTo failed: " + file);
        }
        return file;
    }

    public void delete() {
        if (!this.exists()) {
            return;
        }
        if (this.file.isDirectory()) {
            List list = this.list();
            for (int i = 0; i < list.sz(); ++i) {
                ((File)list.get(i)).delete();
            }
        }
        if (!this.file.delete()) {
            throw IOErr.make("Cannot delete: " + this.file);
        }
    }

    public File deleteOnExit() {
        this.file.deleteOnExit();
        return this;
    }

    public Buf open(String string) {
        try {
            return new FileBuf(this, new RandomAccessFile(this.file, string));
        }
        catch (IOException iOException) {
            throw IOErr.make(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Buf mmap(String string, long l, Long l2) {
        MmapBuf mmapBuf;
        RandomAccessFile randomAccessFile;
        block15: {
            FileChannel.MapMode mapMode;
            String string2;
            if (string.equals("r")) {
                string2 = "r";
                mapMode = FileChannel.MapMode.READ_ONLY;
            } else if (string.equals("rw")) {
                string2 = "rw";
                mapMode = FileChannel.MapMode.READ_WRITE;
            } else if (string.equals("p")) {
                string2 = "rw";
                mapMode = FileChannel.MapMode.PRIVATE;
            } else {
                throw ArgErr.make("Invalid mode: " + string);
            }
            if (l2 == null) {
                l2 = this.size();
            }
            randomAccessFile = null;
            AbstractInterruptibleChannel abstractInterruptibleChannel = null;
            try {
                randomAccessFile = new RandomAccessFile(this.file, string2);
                abstractInterruptibleChannel = randomAccessFile.getChannel();
                mmapBuf = new MmapBuf(this, ((FileChannel)abstractInterruptibleChannel).map(mapMode, l, l2));
                if (abstractInterruptibleChannel == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (abstractInterruptibleChannel != null) {
                        abstractInterruptibleChannel.close();
                    }
                    if (randomAccessFile != null) {
                        randomAccessFile.close();
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw IOErr.make(iOException);
                }
            }
            abstractInterruptibleChannel.close();
        }
        if (randomAccessFile != null) {
            randomAccessFile.close();
        }
        return mmapBuf;
    }

    public InStream in(Long l) {
        try {
            return SysInStream.make(new FileInputStream(this.file), l);
        }
        catch (IOException iOException) {
            throw IOErr.make(iOException);
        }
    }

    public OutStream out(boolean bl, Long l) {
        try {
            java.io.File file = this.file.getParentFile();
            if (file != null && !file.exists()) {
                file.mkdirs();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(this.file, bl);
            OutputStream outputStream = SysOutStream.toBuffered(fileOutputStream, l);
            return new LocalFileOutStream(outputStream, fileOutputStream.getFD());
        }
        catch (IOException iOException) {
            throw IOErr.make(iOException);
        }
    }

    public java.io.File toJava() {
        return this.file;
    }

    static class LocalFileOutStream
    extends SysOutStream {
        FileDescriptor fd;

        LocalFileOutStream(OutputStream outputStream, FileDescriptor fileDescriptor) {
            super(outputStream);
            this.fd = fileDescriptor;
        }

        public OutStream sync() {
            try {
                this.flush();
                this.fd.sync();
                return this;
            }
            catch (IOException iOException) {
                throw IOErr.make(iOException);
            }
        }
    }
}

