! Copyright (C) 2014 John Benediktsson
! See http://factorcode.org/license.txt for BSD license

USING: assocs combinators.short-circuit kernel locals make math
math.order math.parser math.ranges regexp sequences splitting
strings ;

IN: html.entities

: html-escape ( str -- newstr )
    {
        { "&" "&amp;" }
        { "<" "&lt;" }
        { ">" "&gt;" }
        { "\"" "&quot;" }
        { "'" "&#39;" }
    } [ replace ] assoc-each ;

<PRIVATE

! see http://www.w3.org/TR/html5/syntax.html#tokenizing-character-references

CONSTANT: invalid-charrefs H{
    { 0x00 "\u00fffd" }  ! REPLACEMENT CHARACTER
    { 0x0d "\r"       }  ! CARRIAGE RETURN
    { 0x80 "\u0020ac" }  ! EURO SIGN
    { 0x81 "\x81"     }  ! <control>
    { 0x82 "\u00201a" }  ! SINGLE LOW-9 QUOTATION MARK
    { 0x83 "\u000192" }  ! LATIN SMALL LETTER F WITH HOOK
    { 0x84 "\u00201e" }  ! DOUBLE LOW-9 QUOTATION MARK
    { 0x85 "\u002026" }  ! HORIZONTAL ELLIPSIS
    { 0x86 "\u002020" }  ! DAGGER
    { 0x87 "\u002021" }  ! DOUBLE DAGGER
    { 0x88 "\u0002c6" }  ! MODIFIER LETTER CIRCUMFLEX ACCENT
    { 0x89 "\u002030" }  ! PER MILLE SIGN
    { 0x8a "\u000160" }  ! LATIN CAPITAL LETTER S WITH CARON
    { 0x8b "\u002039" }  ! SINGLE LEFT-POINTING ANGLE QUOTATION MARK
    { 0x8c "\u000152" }  ! LATIN CAPITAL LIGATURE OE
    { 0x8d "\x8d"     }  ! <control>
    { 0x8e "\u00017d" }  ! LATIN CAPITAL LETTER Z WITH CARON
    { 0x8f "\x8f"     }  ! <control>
    { 0x90 "\x90"     }  ! <control>
    { 0x91 "\u002018" }  ! LEFT SINGLE QUOTATION MARK
    { 0x92 "\u002019" }  ! RIGHT SINGLE QUOTATION MARK
    { 0x93 "\u00201c" }  ! LEFT DOUBLE QUOTATION MARK
    { 0x94 "\u00201d" }  ! RIGHT DOUBLE QUOTATION MARK
    { 0x95 "\u002022" }  ! BULLET
    { 0x96 "\u002013" }  ! EN DASH
    { 0x97 "\u002014" }  ! EM DASH
    { 0x98 "\u0002dc" }  ! SMALL TILDE
    { 0x99 "\u002122" }  ! TRADE MARK SIGN
    { 0x9a "\u000161" }  ! LATIN SMALL LETTER S WITH CARON
    { 0x9b "\u00203a" }  ! SINGLE RIGHT-POINTING ANGLE QUOTATION MARK
    { 0x9c "\u000153" }  ! LATIN SMALL LIGATURE OE
    { 0x9d "\x9d"     }  ! <control>
    { 0x9e "\u00017e" }  ! LATIN SMALL LETTER Z WITH CARON
    { 0x9f "\u000178" }  ! LATIN CAPITAL LETTER Y WITH DIAERESIS
}

CONSTANT: invalid-codepoints {
    ! 0x0001 to 0x0008
    0x1 0x2 0x3 0x4 0x5 0x6 0x7 0x8
    ! 0x000E to 0x001F
    0xe 0xf 0x10 0x11 0x12 0x13 0x14 0x15 0x16 0x17 0x18 0x19
    0x1a 0x1b 0x1c 0x1d 0x1e 0x1f
    ! 0x007F to 0x009F
    0x7f 0x80 0x81 0x82 0x83 0x84 0x85 0x86 0x87 0x88 0x89 0x8a
    0x8b 0x8c 0x8d 0x8e 0x8f 0x90 0x91 0x92 0x93 0x94 0x95 0x96
    0x97 0x98 0x99 0x9a 0x9b 0x9c 0x9d 0x9e 0x9f
    ! 0xFDD0 to 0xFDEF
    0xfdd0 0xfdd1 0xfdd2 0xfdd3 0xfdd4 0xfdd5 0xfdd6 0xfdd7 0xfdd8
    0xfdd9 0xfdda 0xfddb 0xfddc 0xfddd 0xfdde 0xfddf 0xfde0 0xfde1
    0xfde2 0xfde3 0xfde4 0xfde5 0xfde6 0xfde7 0xfde8 0xfde9 0xfdea
    0xfdeb 0xfdec 0xfded 0xfdee 0xfdef
    ! others
    0xb 0xfffe 0xffff 0x1fffe 0x1ffff 0x2fffe 0x2ffff 0x3fffe 0x3ffff
    0x4fffe 0x4ffff 0x5fffe 0x5ffff 0x6fffe 0x6ffff 0x7fffe 0x7ffff
    0x8fffe 0x8ffff 0x9fffe 0x9ffff 0xafffe 0xaffff 0xbfffe 0xbffff
    0xcfffe 0xcffff 0xdfffe 0xdffff 0xefffe 0xeffff 0xffffe 0xfffff
    0x10fffe 0x10ffff
}

! see http://www.w3.org/TR/html5/syntax.html#named-character-references

CONSTANT: html5 H{
    { "Aacute" "\xc1" }
    { "aacute" "\xe1" }
    { "Aacute;" "\xc1" }
    { "aacute;" "\xe1" }
    { "Abreve;" "\u000102" }
    { "abreve;" "\u000103" }
    { "ac;" "\u00223e" }
    { "acd;" "\u00223f" }
    { "acE;" "\u00223e\u000333" }
    { "Acirc" "\xc2" }
    { "acirc" "\xe2" }
    { "Acirc;" "\xc2" }
    { "acirc;" "\xe2" }
    { "acute" "\xb4" }
    { "acute;" "\xb4" }
    { "Acy;" "\u000410" }
    { "acy;" "\u000430" }
    { "AElig" "\xc6" }
    { "aelig" "\xe6" }
    { "AElig;" "\xc6" }
    { "aelig;" "\xe6" }
    { "af;" "\u002061" }
    { "Afr;" "\u01d504" }
    { "afr;" "\u01d51e" }
    { "Agrave" "\xc0" }
    { "agrave" "\xe0" }
    { "Agrave;" "\xc0" }
    { "agrave;" "\xe0" }
    { "alefsym;" "\u002135" }
    { "aleph;" "\u002135" }
    { "Alpha;" "\u000391" }
    { "alpha;" "\u0003b1" }
    { "Amacr;" "\u000100" }
    { "amacr;" "\u000101" }
    { "amalg;" "\u002a3f" }
    { "AMP" "&" }
    { "amp" "&" }
    { "AMP;" "&" }
    { "amp;" "&" }
    { "And;" "\u002a53" }
    { "and;" "\u002227" }
    { "andand;" "\u002a55" }
    { "andd;" "\u002a5c" }
    { "andslope;" "\u002a58" }
    { "andv;" "\u002a5a" }
    { "ang;" "\u002220" }
    { "ange;" "\u0029a4" }
    { "angle;" "\u002220" }
    { "angmsd;" "\u002221" }
    { "angmsdaa;" "\u0029a8" }
    { "angmsdab;" "\u0029a9" }
    { "angmsdac;" "\u0029aa" }
    { "angmsdad;" "\u0029ab" }
    { "angmsdae;" "\u0029ac" }
    { "angmsdaf;" "\u0029ad" }
    { "angmsdag;" "\u0029ae" }
    { "angmsdah;" "\u0029af" }
    { "angrt;" "\u00221f" }
    { "angrtvb;" "\u0022be" }
    { "angrtvbd;" "\u00299d" }
    { "angsph;" "\u002222" }
    { "angst;" "\xc5" }
    { "angzarr;" "\u00237c" }
    { "Aogon;" "\u000104" }
    { "aogon;" "\u000105" }
    { "Aopf;" "\u01d538" }
    { "aopf;" "\u01d552" }
    { "ap;" "\u002248" }
    { "apacir;" "\u002a6f" }
    { "apE;" "\u002a70" }
    { "ape;" "\u00224a" }
    { "apid;" "\u00224b" }
    { "apos;" "'" }
    { "ApplyFunction;" "\u002061" }
    { "approx;" "\u002248" }
    { "approxeq;" "\u00224a" }
    { "Aring" "\xc5" }
    { "aring" "\xe5" }
    { "Aring;" "\xc5" }
    { "aring;" "\xe5" }
    { "Ascr;" "\u01d49c" }
    { "ascr;" "\u01d4b6" }
    { "Assign;" "\u002254" }
    { "ast;" "*" }
    { "asymp;" "\u002248" }
    { "asympeq;" "\u00224d" }
    { "Atilde" "\xc3" }
    { "atilde" "\xe3" }
    { "Atilde;" "\xc3" }
    { "atilde;" "\xe3" }
    { "Auml" "\xc4" }
    { "auml" "\xe4" }
    { "Auml;" "\xc4" }
    { "auml;" "\xe4" }
    { "awconint;" "\u002233" }
    { "awint;" "\u002a11" }
    { "backcong;" "\u00224c" }
    { "backepsilon;" "\u0003f6" }
    { "backprime;" "\u002035" }
    { "backsim;" "\u00223d" }
    { "backsimeq;" "\u0022cd" }
    { "Backslash;" "\u002216" }
    { "Barv;" "\u002ae7" }
    { "barvee;" "\u0022bd" }
    { "Barwed;" "\u002306" }
    { "barwed;" "\u002305" }
    { "barwedge;" "\u002305" }
    { "bbrk;" "\u0023b5" }
    { "bbrktbrk;" "\u0023b6" }
    { "bcong;" "\u00224c" }
    { "Bcy;" "\u000411" }
    { "bcy;" "\u000431" }
    { "bdquo;" "\u00201e" }
    { "becaus;" "\u002235" }
    { "Because;" "\u002235" }
    { "because;" "\u002235" }
    { "bemptyv;" "\u0029b0" }
    { "bepsi;" "\u0003f6" }
    { "bernou;" "\u00212c" }
    { "Bernoullis;" "\u00212c" }
    { "Beta;" "\u000392" }
    { "beta;" "\u0003b2" }
    { "beth;" "\u002136" }
    { "between;" "\u00226c" }
    { "Bfr;" "\u01d505" }
    { "bfr;" "\u01d51f" }
    { "bigcap;" "\u0022c2" }
    { "bigcirc;" "\u0025ef" }
    { "bigcup;" "\u0022c3" }
    { "bigodot;" "\u002a00" }
    { "bigoplus;" "\u002a01" }
    { "bigotimes;" "\u002a02" }
    { "bigsqcup;" "\u002a06" }
    { "bigstar;" "\u002605" }
    { "bigtriangledown;" "\u0025bd" }
    { "bigtriangleup;" "\u0025b3" }
    { "biguplus;" "\u002a04" }
    { "bigvee;" "\u0022c1" }
    { "bigwedge;" "\u0022c0" }
    { "bkarow;" "\u00290d" }
    { "blacklozenge;" "\u0029eb" }
    { "blacksquare;" "\u0025aa" }
    { "blacktriangle;" "\u0025b4" }
    { "blacktriangledown;" "\u0025be" }
    { "blacktriangleleft;" "\u0025c2" }
    { "blacktriangleright;" "\u0025b8" }
    { "blank;" "\u002423" }
    { "blk12;" "\u002592" }
    { "blk14;" "\u002591" }
    { "blk34;" "\u002593" }
    { "block;" "\u002588" }
    { "bne;" "=\u0020e5" }
    { "bnequiv;" "\u002261\u0020e5" }
    { "bNot;" "\u002aed" }
    { "bnot;" "\u002310" }
    { "Bopf;" "\u01d539" }
    { "bopf;" "\u01d553" }
    { "bot;" "\u0022a5" }
    { "bottom;" "\u0022a5" }
    { "bowtie;" "\u0022c8" }
    { "boxbox;" "\u0029c9" }
    { "boxDL;" "\u002557" }
    { "boxDl;" "\u002556" }
    { "boxdL;" "\u002555" }
    { "boxdl;" "\u002510" }
    { "boxDR;" "\u002554" }
    { "boxDr;" "\u002553" }
    { "boxdR;" "\u002552" }
    { "boxdr;" "\u00250c" }
    { "boxH;" "\u002550" }
    { "boxh;" "\u002500" }
    { "boxHD;" "\u002566" }
    { "boxHd;" "\u002564" }
    { "boxhD;" "\u002565" }
    { "boxhd;" "\u00252c" }
    { "boxHU;" "\u002569" }
    { "boxHu;" "\u002567" }
    { "boxhU;" "\u002568" }
    { "boxhu;" "\u002534" }
    { "boxminus;" "\u00229f" }
    { "boxplus;" "\u00229e" }
    { "boxtimes;" "\u0022a0" }
    { "boxUL;" "\u00255d" }
    { "boxUl;" "\u00255c" }
    { "boxuL;" "\u00255b" }
    { "boxul;" "\u002518" }
    { "boxUR;" "\u00255a" }
    { "boxUr;" "\u002559" }
    { "boxuR;" "\u002558" }
    { "boxur;" "\u002514" }
    { "boxV;" "\u002551" }
    { "boxv;" "\u002502" }
    { "boxVH;" "\u00256c" }
    { "boxVh;" "\u00256b" }
    { "boxvH;" "\u00256a" }
    { "boxvh;" "\u00253c" }
    { "boxVL;" "\u002563" }
    { "boxVl;" "\u002562" }
    { "boxvL;" "\u002561" }
    { "boxvl;" "\u002524" }
    { "boxVR;" "\u002560" }
    { "boxVr;" "\u00255f" }
    { "boxvR;" "\u00255e" }
    { "boxvr;" "\u00251c" }
    { "bprime;" "\u002035" }
    { "Breve;" "\u0002d8" }
    { "breve;" "\u0002d8" }
    { "brvbar" "\xa6" }
    { "brvbar;" "\xa6" }
    { "Bscr;" "\u00212c" }
    { "bscr;" "\u01d4b7" }
    { "bsemi;" "\u00204f" }
    { "bsim;" "\u00223d" }
    { "bsime;" "\u0022cd" }
    { "bsol;" "\\" }
    { "bsolb;" "\u0029c5" }
    { "bsolhsub;" "\u0027c8" }
    { "bull;" "\u002022" }
    { "bullet;" "\u002022" }
    { "bump;" "\u00224e" }
    { "bumpE;" "\u002aae" }
    { "bumpe;" "\u00224f" }
    { "Bumpeq;" "\u00224e" }
    { "bumpeq;" "\u00224f" }
    { "Cacute;" "\u000106" }
    { "cacute;" "\u000107" }
    { "Cap;" "\u0022d2" }
    { "cap;" "\u002229" }
    { "capand;" "\u002a44" }
    { "capbrcup;" "\u002a49" }
    { "capcap;" "\u002a4b" }
    { "capcup;" "\u002a47" }
    { "capdot;" "\u002a40" }
    { "CapitalDifferentialD;" "\u002145" }
    { "caps;" "\u002229\u00fe00" }
    { "caret;" "\u002041" }
    { "caron;" "\u0002c7" }
    { "Cayleys;" "\u00212d" }
    { "ccaps;" "\u002a4d" }
    { "Ccaron;" "\u00010c" }
    { "ccaron;" "\u00010d" }
    { "Ccedil" "\xc7" }
    { "ccedil" "\xe7" }
    { "Ccedil;" "\xc7" }
    { "ccedil;" "\xe7" }
    { "Ccirc;" "\u000108" }
    { "ccirc;" "\u000109" }
    { "Cconint;" "\u002230" }
    { "ccups;" "\u002a4c" }
    { "ccupssm;" "\u002a50" }
    { "Cdot;" "\u00010a" }
    { "cdot;" "\u00010b" }
    { "cedil" "\xb8" }
    { "cedil;" "\xb8" }
    { "Cedilla;" "\xb8" }
    { "cemptyv;" "\u0029b2" }
    { "cent" "\xa2" }
    { "cent;" "\xa2" }
    { "CenterDot;" "\xb7" }
    { "centerdot;" "\xb7" }
    { "Cfr;" "\u00212d" }
    { "cfr;" "\u01d520" }
    { "CHcy;" "\u000427" }
    { "chcy;" "\u000447" }
    { "check;" "\u002713" }
    { "checkmark;" "\u002713" }
    { "Chi;" "\u0003a7" }
    { "chi;" "\u0003c7" }
    { "cir;" "\u0025cb" }
    { "circ;" "\u0002c6" }
    { "circeq;" "\u002257" }
    { "circlearrowleft;" "\u0021ba" }
    { "circlearrowright;" "\u0021bb" }
    { "circledast;" "\u00229b" }
    { "circledcirc;" "\u00229a" }
    { "circleddash;" "\u00229d" }
    { "CircleDot;" "\u002299" }
    { "circledR;" "\xae" }
    { "circledS;" "\u0024c8" }
    { "CircleMinus;" "\u002296" }
    { "CirclePlus;" "\u002295" }
    { "CircleTimes;" "\u002297" }
    { "cirE;" "\u0029c3" }
    { "cire;" "\u002257" }
    { "cirfnint;" "\u002a10" }
    { "cirmid;" "\u002aef" }
    { "cirscir;" "\u0029c2" }
    { "ClockwiseContourIntegral;" "\u002232" }
    { "CloseCurlyDoubleQuote;" "\u00201d" }
    { "CloseCurlyQuote;" "\u002019" }
    { "clubs;" "\u002663" }
    { "clubsuit;" "\u002663" }
    { "Colon;" "\u002237" }
    { "colon;" ":" }
    { "Colone;" "\u002a74" }
    { "colone;" "\u002254" }
    { "coloneq;" "\u002254" }
    { "comma;" " }" }
    { "commat;" "@" }
    { "comp;" "\u002201" }
    { "compfn;" "\u002218" }
    { "complement;" "\u002201" }
    { "complexes;" "\u002102" }
    { "cong;" "\u002245" }
    { "congdot;" "\u002a6d" }
    { "Congruent;" "\u002261" }
    { "Conint;" "\u00222f" }
    { "conint;" "\u00222e" }
    { "ContourIntegral;" "\u00222e" }
    { "Copf;" "\u002102" }
    { "copf;" "\u01d554" }
    { "coprod;" "\u002210" }
    { "Coproduct;" "\u002210" }
    { "COPY" "\xa9" }
    { "copy" "\xa9" }
    { "COPY;" "\xa9" }
    { "copy;" "\xa9" }
    { "copysr;" "\u002117" }
    { "CounterClockwiseContourIntegral;" "\u002233" }
    { "crarr;" "\u0021b5" }
    { "Cross;" "\u002a2f" }
    { "cross;" "\u002717" }
    { "Cscr;" "\u01d49e" }
    { "cscr;" "\u01d4b8" }
    { "csub;" "\u002acf" }
    { "csube;" "\u002ad1" }
    { "csup;" "\u002ad0" }
    { "csupe;" "\u002ad2" }
    { "ctdot;" "\u0022ef" }
    { "cudarrl;" "\u002938" }
    { "cudarrr;" "\u002935" }
    { "cuepr;" "\u0022de" }
    { "cuesc;" "\u0022df" }
    { "cularr;" "\u0021b6" }
    { "cularrp;" "\u00293d" }
    { "Cup;" "\u0022d3" }
    { "cup;" "\u00222a" }
    { "cupbrcap;" "\u002a48" }
    { "CupCap;" "\u00224d" }
    { "cupcap;" "\u002a46" }
    { "cupcup;" "\u002a4a" }
    { "cupdot;" "\u00228d" }
    { "cupor;" "\u002a45" }
    { "cups;" "\u00222a\u00fe00" }
    { "curarr;" "\u0021b7" }
    { "curarrm;" "\u00293c" }
    { "curlyeqprec;" "\u0022de" }
    { "curlyeqsucc;" "\u0022df" }
    { "curlyvee;" "\u0022ce" }
    { "curlywedge;" "\u0022cf" }
    { "curren" "\xa4" }
    { "curren;" "\xa4" }
    { "curvearrowleft;" "\u0021b6" }
    { "curvearrowright;" "\u0021b7" }
    { "cuvee;" "\u0022ce" }
    { "cuwed;" "\u0022cf" }
    { "cwconint;" "\u002232" }
    { "cwint;" "\u002231" }
    { "cylcty;" "\u00232d" }
    { "Dagger;" "\u002021" }
    { "dagger;" "\u002020" }
    { "daleth;" "\u002138" }
    { "Darr;" "\u0021a1" }
    { "dArr;" "\u0021d3" }
    { "darr;" "\u002193" }
    { "dash;" "\u002010" }
    { "Dashv;" "\u002ae4" }
    { "dashv;" "\u0022a3" }
    { "dbkarow;" "\u00290f" }
    { "dblac;" "\u0002dd" }
    { "Dcaron;" "\u00010e" }
    { "dcaron;" "\u00010f" }
    { "Dcy;" "\u000414" }
    { "dcy;" "\u000434" }
    { "DD;" "\u002145" }
    { "dd;" "\u002146" }
    { "ddagger;" "\u002021" }
    { "ddarr;" "\u0021ca" }
    { "DDotrahd;" "\u002911" }
    { "ddotseq;" "\u002a77" }
    { "deg" "\xb0" }
    { "deg;" "\xb0" }
    { "Del;" "\u002207" }
    { "Delta;" "\u000394" }
    { "delta;" "\u0003b4" }
    { "demptyv;" "\u0029b1" }
    { "dfisht;" "\u00297f" }
    { "Dfr;" "\u01d507" }
    { "dfr;" "\u01d521" }
    { "dHar;" "\u002965" }
    { "dharl;" "\u0021c3" }
    { "dharr;" "\u0021c2" }
    { "DiacriticalAcute;" "\xb4" }
    { "DiacriticalDot;" "\u0002d9" }
    { "DiacriticalDoubleAcute;" "\u0002dd" }
    { "DiacriticalGrave;" "`" }
    { "DiacriticalTilde;" "\u0002dc" }
    { "diam;" "\u0022c4" }
    { "Diamond;" "\u0022c4" }
    { "diamond;" "\u0022c4" }
    { "diamondsuit;" "\u002666" }
    { "diams;" "\u002666" }
    { "die;" "\xa8" }
    { "DifferentialD;" "\u002146" }
    { "digamma;" "\u0003dd" }
    { "disin;" "\u0022f2" }
    { "div;" "\xf7" }
    { "divide" "\xf7" }
    { "divide;" "\xf7" }
    { "divideontimes;" "\u0022c7" }
    { "divonx;" "\u0022c7" }
    { "DJcy;" "\u000402" }
    { "djcy;" "\u000452" }
    { "dlcorn;" "\u00231e" }
    { "dlcrop;" "\u00230d" }
    { "dollar;" "$" }
    { "Dopf;" "\u01d53b" }
    { "dopf;" "\u01d555" }
    { "Dot;" "\xa8" }
    { "dot;" "\u0002d9" }
    { "DotDot;" "\u0020dc" }
    { "doteq;" "\u002250" }
    { "doteqdot;" "\u002251" }
    { "DotEqual;" "\u002250" }
    { "dotminus;" "\u002238" }
    { "dotplus;" "\u002214" }
    { "dotsquare;" "\u0022a1" }
    { "doublebarwedge;" "\u002306" }
    { "DoubleContourIntegral;" "\u00222f" }
    { "DoubleDot;" "\xa8" }
    { "DoubleDownArrow;" "\u0021d3" }
    { "DoubleLeftArrow;" "\u0021d0" }
    { "DoubleLeftRightArrow;" "\u0021d4" }
    { "DoubleLeftTee;" "\u002ae4" }
    { "DoubleLongLeftArrow;" "\u0027f8" }
    { "DoubleLongLeftRightArrow;" "\u0027fa" }
    { "DoubleLongRightArrow;" "\u0027f9" }
    { "DoubleRightArrow;" "\u0021d2" }
    { "DoubleRightTee;" "\u0022a8" }
    { "DoubleUpArrow;" "\u0021d1" }
    { "DoubleUpDownArrow;" "\u0021d5" }
    { "DoubleVerticalBar;" "\u002225" }
    { "DownArrow;" "\u002193" }
    { "Downarrow;" "\u0021d3" }
    { "downarrow;" "\u002193" }
    { "DownArrowBar;" "\u002913" }
    { "DownArrowUpArrow;" "\u0021f5" }
    { "DownBreve;" "\u000311" }
    { "downdownarrows;" "\u0021ca" }
    { "downharpoonleft;" "\u0021c3" }
    { "downharpoonright;" "\u0021c2" }
    { "DownLeftRightVector;" "\u002950" }
    { "DownLeftTeeVector;" "\u00295e" }
    { "DownLeftVector;" "\u0021bd" }
    { "DownLeftVectorBar;" "\u002956" }
    { "DownRightTeeVector;" "\u00295f" }
    { "DownRightVector;" "\u0021c1" }
    { "DownRightVectorBar;" "\u002957" }
    { "DownTee;" "\u0022a4" }
    { "DownTeeArrow;" "\u0021a7" }
    { "drbkarow;" "\u002910" }
    { "drcorn;" "\u00231f" }
    { "drcrop;" "\u00230c" }
    { "Dscr;" "\u01d49f" }
    { "dscr;" "\u01d4b9" }
    { "DScy;" "\u000405" }
    { "dscy;" "\u000455" }
    { "dsol;" "\u0029f6" }
    { "Dstrok;" "\u000110" }
    { "dstrok;" "\u000111" }
    { "dtdot;" "\u0022f1" }
    { "dtri;" "\u0025bf" }
    { "dtrif;" "\u0025be" }
    { "duarr;" "\u0021f5" }
    { "duhar;" "\u00296f" }
    { "dwangle;" "\u0029a6" }
    { "DZcy;" "\u00040f" }
    { "dzcy;" "\u00045f" }
    { "dzigrarr;" "\u0027ff" }
    { "Eacute" "\xc9" }
    { "eacute" "\xe9" }
    { "Eacute;" "\xc9" }
    { "eacute;" "\xe9" }
    { "easter;" "\u002a6e" }
    { "Ecaron;" "\u00011a" }
    { "ecaron;" "\u00011b" }
    { "ecir;" "\u002256" }
    { "Ecirc" "\xca" }
    { "ecirc" "\xea" }
    { "Ecirc;" "\xca" }
    { "ecirc;" "\xea" }
    { "ecolon;" "\u002255" }
    { "Ecy;" "\u00042d" }
    { "ecy;" "\u00044d" }
    { "eDDot;" "\u002a77" }
    { "Edot;" "\u000116" }
    { "eDot;" "\u002251" }
    { "edot;" "\u000117" }
    { "ee;" "\u002147" }
    { "efDot;" "\u002252" }
    { "Efr;" "\u01d508" }
    { "efr;" "\u01d522" }
    { "eg;" "\u002a9a" }
    { "Egrave" "\xc8" }
    { "egrave" "\xe8" }
    { "Egrave;" "\xc8" }
    { "egrave;" "\xe8" }
    { "egs;" "\u002a96" }
    { "egsdot;" "\u002a98" }
    { "el;" "\u002a99" }
    { "Element;" "\u002208" }
    { "elinters;" "\u0023e7" }
    { "ell;" "\u002113" }
    { "els;" "\u002a95" }
    { "elsdot;" "\u002a97" }
    { "Emacr;" "\u000112" }
    { "emacr;" "\u000113" }
    { "empty;" "\u002205" }
    { "emptyset;" "\u002205" }
    { "EmptySmallSquare;" "\u0025fb" }
    { "emptyv;" "\u002205" }
    { "EmptyVerySmallSquare;" "\u0025ab" }
    { "emsp13;" "\u002004" }
    { "emsp14;" "\u002005" }
    { "emsp;" "\u002003" }
    { "ENG;" "\u00014a" }
    { "eng;" "\u00014b" }
    { "ensp;" "\u002002" }
    { "Eogon;" "\u000118" }
    { "eogon;" "\u000119" }
    { "Eopf;" "\u01d53c" }
    { "eopf;" "\u01d556" }
    { "epar;" "\u0022d5" }
    { "eparsl;" "\u0029e3" }
    { "eplus;" "\u002a71" }
    { "epsi;" "\u0003b5" }
    { "Epsilon;" "\u000395" }
    { "epsilon;" "\u0003b5" }
    { "epsiv;" "\u0003f5" }
    { "eqcirc;" "\u002256" }
    { "eqcolon;" "\u002255" }
    { "eqsim;" "\u002242" }
    { "eqslantgtr;" "\u002a96" }
    { "eqslantless;" "\u002a95" }
    { "Equal;" "\u002a75" }
    { "equals;" "=" }
    { "EqualTilde;" "\u002242" }
    { "equest;" "\u00225f" }
    { "Equilibrium;" "\u0021cc" }
    { "equiv;" "\u002261" }
    { "equivDD;" "\u002a78" }
    { "eqvparsl;" "\u0029e5" }
    { "erarr;" "\u002971" }
    { "erDot;" "\u002253" }
    { "Escr;" "\u002130" }
    { "escr;" "\u00212f" }
    { "esdot;" "\u002250" }
    { "Esim;" "\u002a73" }
    { "esim;" "\u002242" }
    { "Eta;" "\u000397" }
    { "eta;" "\u0003b7" }
    { "ETH" "\xd0" }
    { "eth" "\xf0" }
    { "ETH;" "\xd0" }
    { "eth;" "\xf0" }
    { "Euml" "\xcb" }
    { "euml" "\xeb" }
    { "Euml;" "\xcb" }
    { "euml;" "\xeb" }
    { "euro;" "\u0020ac" }
    { "excl;" "!" }
    { "exist;" "\u002203" }
    { "Exists;" "\u002203" }
    { "expectation;" "\u002130" }
    { "ExponentialE;" "\u002147" }
    { "exponentiale;" "\u002147" }
    { "fallingdotseq;" "\u002252" }
    { "Fcy;" "\u000424" }
    { "fcy;" "\u000444" }
    { "female;" "\u002640" }
    { "ffilig;" "\u00fb03" }
    { "fflig;" "\u00fb00" }
    { "ffllig;" "\u00fb04" }
    { "Ffr;" "\u01d509" }
    { "ffr;" "\u01d523" }
    { "filig;" "\u00fb01" }
    { "FilledSmallSquare;" "\u0025fc" }
    { "FilledVerySmallSquare;" "\u0025aa" }
    { "fjlig;" "fj" }
    { "flat;" "\u00266d" }
    { "fllig;" "\u00fb02" }
    { "fltns;" "\u0025b1" }
    { "fnof;" "\u000192" }
    { "Fopf;" "\u01d53d" }
    { "fopf;" "\u01d557" }
    { "ForAll;" "\u002200" }
    { "forall;" "\u002200" }
    { "fork;" "\u0022d4" }
    { "forkv;" "\u002ad9" }
    { "Fouriertrf;" "\u002131" }
    { "fpartint;" "\u002a0d" }
    { "frac12" "\xbd" }
    { "frac12;" "\xbd" }
    { "frac13;" "\u002153" }
    { "frac14" "\xbc" }
    { "frac14;" "\xbc" }
    { "frac15;" "\u002155" }
    { "frac16;" "\u002159" }
    { "frac18;" "\u00215b" }
    { "frac23;" "\u002154" }
    { "frac25;" "\u002156" }
    { "frac34" "\xbe" }
    { "frac34;" "\xbe" }
    { "frac35;" "\u002157" }
    { "frac38;" "\u00215c" }
    { "frac45;" "\u002158" }
    { "frac56;" "\u00215a" }
    { "frac58;" "\u00215d" }
    { "frac78;" "\u00215e" }
    { "frasl;" "\u002044" }
    { "frown;" "\u002322" }
    { "Fscr;" "\u002131" }
    { "fscr;" "\u01d4bb" }
    { "gacute;" "\u0001f5" }
    { "Gamma;" "\u000393" }
    { "gamma;" "\u0003b3" }
    { "Gammad;" "\u0003dc" }
    { "gammad;" "\u0003dd" }
    { "gap;" "\u002a86" }
    { "Gbreve;" "\u00011e" }
    { "gbreve;" "\u00011f" }
    { "Gcedil;" "\u000122" }
    { "Gcirc;" "\u00011c" }
    { "gcirc;" "\u00011d" }
    { "Gcy;" "\u000413" }
    { "gcy;" "\u000433" }
    { "Gdot;" "\u000120" }
    { "gdot;" "\u000121" }
    { "gE;" "\u002267" }
    { "ge;" "\u002265" }
    { "gEl;" "\u002a8c" }
    { "gel;" "\u0022db" }
    { "geq;" "\u002265" }
    { "geqq;" "\u002267" }
    { "geqslant;" "\u002a7e" }
    { "ges;" "\u002a7e" }
    { "gescc;" "\u002aa9" }
    { "gesdot;" "\u002a80" }
    { "gesdoto;" "\u002a82" }
    { "gesdotol;" "\u002a84" }
    { "gesl;" "\u0022db\u00fe00" }
    { "gesles;" "\u002a94" }
    { "Gfr;" "\u01d50a" }
    { "gfr;" "\u01d524" }
    { "Gg;" "\u0022d9" }
    { "gg;" "\u00226b" }
    { "ggg;" "\u0022d9" }
    { "gimel;" "\u002137" }
    { "GJcy;" "\u000403" }
    { "gjcy;" "\u000453" }
    { "gl;" "\u002277" }
    { "gla;" "\u002aa5" }
    { "glE;" "\u002a92" }
    { "glj;" "\u002aa4" }
    { "gnap;" "\u002a8a" }
    { "gnapprox;" "\u002a8a" }
    { "gnE;" "\u002269" }
    { "gne;" "\u002a88" }
    { "gneq;" "\u002a88" }
    { "gneqq;" "\u002269" }
    { "gnsim;" "\u0022e7" }
    { "Gopf;" "\u01d53e" }
    { "gopf;" "\u01d558" }
    { "grave;" "`" }
    { "GreaterEqual;" "\u002265" }
    { "GreaterEqualLess;" "\u0022db" }
    { "GreaterFullEqual;" "\u002267" }
    { "GreaterGreater;" "\u002aa2" }
    { "GreaterLess;" "\u002277" }
    { "GreaterSlantEqual;" "\u002a7e" }
    { "GreaterTilde;" "\u002273" }
    { "Gscr;" "\u01d4a2" }
    { "gscr;" "\u00210a" }
    { "gsim;" "\u002273" }
    { "gsime;" "\u002a8e" }
    { "gsiml;" "\u002a90" }
    { "GT" ">" }
    { "gt" ">" }
    { "GT;" ">" }
    { "Gt;" "\u00226b" }
    { "gt;" ">" }
    { "gtcc;" "\u002aa7" }
    { "gtcir;" "\u002a7a" }
    { "gtdot;" "\u0022d7" }
    { "gtlPar;" "\u002995" }
    { "gtquest;" "\u002a7c" }
    { "gtrapprox;" "\u002a86" }
    { "gtrarr;" "\u002978" }
    { "gtrdot;" "\u0022d7" }
    { "gtreqless;" "\u0022db" }
    { "gtreqqless;" "\u002a8c" }
    { "gtrless;" "\u002277" }
    { "gtrsim;" "\u002273" }
    { "gvertneqq;" "\u002269\u00fe00" }
    { "gvnE;" "\u002269\u00fe00" }
    { "Hacek;" "\u0002c7" }
    { "hairsp;" "\u00200a" }
    { "half;" "\xbd" }
    { "hamilt;" "\u00210b" }
    { "HARDcy;" "\u00042a" }
    { "hardcy;" "\u00044a" }
    { "hArr;" "\u0021d4" }
    { "harr;" "\u002194" }
    { "harrcir;" "\u002948" }
    { "harrw;" "\u0021ad" }
    { "Hat;" "^" }
    { "hbar;" "\u00210f" }
    { "Hcirc;" "\u000124" }
    { "hcirc;" "\u000125" }
    { "hearts;" "\u002665" }
    { "heartsuit;" "\u002665" }
    { "hellip;" "\u002026" }
    { "hercon;" "\u0022b9" }
    { "Hfr;" "\u00210c" }
    { "hfr;" "\u01d525" }
    { "HilbertSpace;" "\u00210b" }
    { "hksearow;" "\u002925" }
    { "hkswarow;" "\u002926" }
    { "hoarr;" "\u0021ff" }
    { "homtht;" "\u00223b" }
    { "hookleftarrow;" "\u0021a9" }
    { "hookrightarrow;" "\u0021aa" }
    { "Hopf;" "\u00210d" }
    { "hopf;" "\u01d559" }
    { "horbar;" "\u002015" }
    { "HorizontalLine;" "\u002500" }
    { "Hscr;" "\u00210b" }
    { "hscr;" "\u01d4bd" }
    { "hslash;" "\u00210f" }
    { "Hstrok;" "\u000126" }
    { "hstrok;" "\u000127" }
    { "HumpDownHump;" "\u00224e" }
    { "HumpEqual;" "\u00224f" }
    { "hybull;" "\u002043" }
    { "hyphen;" "\u002010" }
    { "Iacute" "\xcd" }
    { "iacute" "\xed" }
    { "Iacute;" "\xcd" }
    { "iacute;" "\xed" }
    { "ic;" "\u002063" }
    { "Icirc" "\xce" }
    { "icirc" "\xee" }
    { "Icirc;" "\xce" }
    { "icirc;" "\xee" }
    { "Icy;" "\u000418" }
    { "icy;" "\u000438" }
    { "Idot;" "\u000130" }
    { "IEcy;" "\u000415" }
    { "iecy;" "\u000435" }
    { "iexcl" "\xa1" }
    { "iexcl;" "\xa1" }
    { "iff;" "\u0021d4" }
    { "Ifr;" "\u002111" }
    { "ifr;" "\u01d526" }
    { "Igrave" "\xcc" }
    { "igrave" "\xec" }
    { "Igrave;" "\xcc" }
    { "igrave;" "\xec" }
    { "ii;" "\u002148" }
    { "iiiint;" "\u002a0c" }
    { "iiint;" "\u00222d" }
    { "iinfin;" "\u0029dc" }
    { "iiota;" "\u002129" }
    { "IJlig;" "\u000132" }
    { "ijlig;" "\u000133" }
    { "Im;" "\u002111" }
    { "Imacr;" "\u00012a" }
    { "imacr;" "\u00012b" }
    { "image;" "\u002111" }
    { "ImaginaryI;" "\u002148" }
    { "imagline;" "\u002110" }
    { "imagpart;" "\u002111" }
    { "imath;" "\u000131" }
    { "imof;" "\u0022b7" }
    { "imped;" "\u0001b5" }
    { "Implies;" "\u0021d2" }
    { "in;" "\u002208" }
    { "incare;" "\u002105" }
    { "infin;" "\u00221e" }
    { "infintie;" "\u0029dd" }
    { "inodot;" "\u000131" }
    { "Int;" "\u00222c" }
    { "int;" "\u00222b" }
    { "intcal;" "\u0022ba" }
    { "integers;" "\u002124" }
    { "Integral;" "\u00222b" }
    { "intercal;" "\u0022ba" }
    { "Intersection;" "\u0022c2" }
    { "intlarhk;" "\u002a17" }
    { "intprod;" "\u002a3c" }
    { "InvisibleComma;" "\u002063" }
    { "InvisibleTimes;" "\u002062" }
    { "IOcy;" "\u000401" }
    { "iocy;" "\u000451" }
    { "Iogon;" "\u00012e" }
    { "iogon;" "\u00012f" }
    { "Iopf;" "\u01d540" }
    { "iopf;" "\u01d55a" }
    { "Iota;" "\u000399" }
    { "iota;" "\u0003b9" }
    { "iprod;" "\u002a3c" }
    { "iquest" "\xbf" }
    { "iquest;" "\xbf" }
    { "Iscr;" "\u002110" }
    { "iscr;" "\u01d4be" }
    { "isin;" "\u002208" }
    { "isindot;" "\u0022f5" }
    { "isinE;" "\u0022f9" }
    { "isins;" "\u0022f4" }
    { "isinsv;" "\u0022f3" }
    { "isinv;" "\u002208" }
    { "it;" "\u002062" }
    { "Itilde;" "\u000128" }
    { "itilde;" "\u000129" }
    { "Iukcy;" "\u000406" }
    { "iukcy;" "\u000456" }
    { "Iuml" "\xcf" }
    { "iuml" "\xef" }
    { "Iuml;" "\xcf" }
    { "iuml;" "\xef" }
    { "Jcirc;" "\u000134" }
    { "jcirc;" "\u000135" }
    { "Jcy;" "\u000419" }
    { "jcy;" "\u000439" }
    { "Jfr;" "\u01d50d" }
    { "jfr;" "\u01d527" }
    { "jmath;" "\u000237" }
    { "Jopf;" "\u01d541" }
    { "jopf;" "\u01d55b" }
    { "Jscr;" "\u01d4a5" }
    { "jscr;" "\u01d4bf" }
    { "Jsercy;" "\u000408" }
    { "jsercy;" "\u000458" }
    { "Jukcy;" "\u000404" }
    { "jukcy;" "\u000454" }
    { "Kappa;" "\u00039a" }
    { "kappa;" "\u0003ba" }
    { "kappav;" "\u0003f0" }
    { "Kcedil;" "\u000136" }
    { "kcedil;" "\u000137" }
    { "Kcy;" "\u00041a" }
    { "kcy;" "\u00043a" }
    { "Kfr;" "\u01d50e" }
    { "kfr;" "\u01d528" }
    { "kgreen;" "\u000138" }
    { "KHcy;" "\u000425" }
    { "khcy;" "\u000445" }
    { "KJcy;" "\u00040c" }
    { "kjcy;" "\u00045c" }
    { "Kopf;" "\u01d542" }
    { "kopf;" "\u01d55c" }
    { "Kscr;" "\u01d4a6" }
    { "kscr;" "\u01d4c0" }
    { "lAarr;" "\u0021da" }
    { "Lacute;" "\u000139" }
    { "lacute;" "\u00013a" }
    { "laemptyv;" "\u0029b4" }
    { "lagran;" "\u002112" }
    { "Lambda;" "\u00039b" }
    { "lambda;" "\u0003bb" }
    { "Lang;" "\u0027ea" }
    { "lang;" "\u0027e8" }
    { "langd;" "\u002991" }
    { "langle;" "\u0027e8" }
    { "lap;" "\u002a85" }
    { "Laplacetrf;" "\u002112" }
    { "laquo" "\xab" }
    { "laquo;" "\xab" }
    { "Larr;" "\u00219e" }
    { "lArr;" "\u0021d0" }
    { "larr;" "\u002190" }
    { "larrb;" "\u0021e4" }
    { "larrbfs;" "\u00291f" }
    { "larrfs;" "\u00291d" }
    { "larrhk;" "\u0021a9" }
    { "larrlp;" "\u0021ab" }
    { "larrpl;" "\u002939" }
    { "larrsim;" "\u002973" }
    { "larrtl;" "\u0021a2" }
    { "lat;" "\u002aab" }
    { "lAtail;" "\u00291b" }
    { "latail;" "\u002919" }
    { "late;" "\u002aad" }
    { "lates;" "\u002aad\u00fe00" }
    { "lBarr;" "\u00290e" }
    { "lbarr;" "\u00290c" }
    { "lbbrk;" "\u002772" }
    { "lbrace;" "{" }
    { "lbrack;" "[" }
    { "lbrke;" "\u00298b" }
    { "lbrksld;" "\u00298f" }
    { "lbrkslu;" "\u00298d" }
    { "Lcaron;" "\u00013d" }
    { "lcaron;" "\u00013e" }
    { "Lcedil;" "\u00013b" }
    { "lcedil;" "\u00013c" }
    { "lceil;" "\u002308" }
    { "lcub;" "{" }
    { "Lcy;" "\u00041b" }
    { "lcy;" "\u00043b" }
    { "ldca;" "\u002936" }
    { "ldquo;" "\u00201c" }
    { "ldquor;" "\u00201e" }
    { "ldrdhar;" "\u002967" }
    { "ldrushar;" "\u00294b" }
    { "ldsh;" "\u0021b2" }
    { "lE;" "\u002266" }
    { "le;" "\u002264" }
    { "LeftAngleBracket;" "\u0027e8" }
    { "LeftArrow;" "\u002190" }
    { "Leftarrow;" "\u0021d0" }
    { "leftarrow;" "\u002190" }
    { "LeftArrowBar;" "\u0021e4" }
    { "LeftArrowRightArrow;" "\u0021c6" }
    { "leftarrowtail;" "\u0021a2" }
    { "LeftCeiling;" "\u002308" }
    { "LeftDoubleBracket;" "\u0027e6" }
    { "LeftDownTeeVector;" "\u002961" }
    { "LeftDownVector;" "\u0021c3" }
    { "LeftDownVectorBar;" "\u002959" }
    { "LeftFloor;" "\u00230a" }
    { "leftharpoondown;" "\u0021bd" }
    { "leftharpoonup;" "\u0021bc" }
    { "leftleftarrows;" "\u0021c7" }
    { "LeftRightArrow;" "\u002194" }
    { "Leftrightarrow;" "\u0021d4" }
    { "leftrightarrow;" "\u002194" }
    { "leftrightarrows;" "\u0021c6" }
    { "leftrightharpoons;" "\u0021cb" }
    { "leftrightsquigarrow;" "\u0021ad" }
    { "LeftRightVector;" "\u00294e" }
    { "LeftTee;" "\u0022a3" }
    { "LeftTeeArrow;" "\u0021a4" }
    { "LeftTeeVector;" "\u00295a" }
    { "leftthreetimes;" "\u0022cb" }
    { "LeftTriangle;" "\u0022b2" }
    { "LeftTriangleBar;" "\u0029cf" }
    { "LeftTriangleEqual;" "\u0022b4" }
    { "LeftUpDownVector;" "\u002951" }
    { "LeftUpTeeVector;" "\u002960" }
    { "LeftUpVector;" "\u0021bf" }
    { "LeftUpVectorBar;" "\u002958" }
    { "LeftVector;" "\u0021bc" }
    { "LeftVectorBar;" "\u002952" }
    { "lEg;" "\u002a8b" }
    { "leg;" "\u0022da" }
    { "leq;" "\u002264" }
    { "leqq;" "\u002266" }
    { "leqslant;" "\u002a7d" }
    { "les;" "\u002a7d" }
    { "lescc;" "\u002aa8" }
    { "lesdot;" "\u002a7f" }
    { "lesdoto;" "\u002a81" }
    { "lesdotor;" "\u002a83" }
    { "lesg;" "\u0022da\u00fe00" }
    { "lesges;" "\u002a93" }
    { "lessapprox;" "\u002a85" }
    { "lessdot;" "\u0022d6" }
    { "lesseqgtr;" "\u0022da" }
    { "lesseqqgtr;" "\u002a8b" }
    { "LessEqualGreater;" "\u0022da" }
    { "LessFullEqual;" "\u002266" }
    { "LessGreater;" "\u002276" }
    { "lessgtr;" "\u002276" }
    { "LessLess;" "\u002aa1" }
    { "lesssim;" "\u002272" }
    { "LessSlantEqual;" "\u002a7d" }
    { "LessTilde;" "\u002272" }
    { "lfisht;" "\u00297c" }
    { "lfloor;" "\u00230a" }
    { "Lfr;" "\u01d50f" }
    { "lfr;" "\u01d529" }
    { "lg;" "\u002276" }
    { "lgE;" "\u002a91" }
    { "lHar;" "\u002962" }
    { "lhard;" "\u0021bd" }
    { "lharu;" "\u0021bc" }
    { "lharul;" "\u00296a" }
    { "lhblk;" "\u002584" }
    { "LJcy;" "\u000409" }
    { "ljcy;" "\u000459" }
    { "Ll;" "\u0022d8" }
    { "ll;" "\u00226a" }
    { "llarr;" "\u0021c7" }
    { "llcorner;" "\u00231e" }
    { "Lleftarrow;" "\u0021da" }
    { "llhard;" "\u00296b" }
    { "lltri;" "\u0025fa" }
    { "Lmidot;" "\u00013f" }
    { "lmidot;" "\u000140" }
    { "lmoust;" "\u0023b0" }
    { "lmoustache;" "\u0023b0" }
    { "lnap;" "\u002a89" }
    { "lnapprox;" "\u002a89" }
    { "lnE;" "\u002268" }
    { "lne;" "\u002a87" }
    { "lneq;" "\u002a87" }
    { "lneqq;" "\u002268" }
    { "lnsim;" "\u0022e6" }
    { "loang;" "\u0027ec" }
    { "loarr;" "\u0021fd" }
    { "lobrk;" "\u0027e6" }
    { "LongLeftArrow;" "\u0027f5" }
    { "Longleftarrow;" "\u0027f8" }
    { "longleftarrow;" "\u0027f5" }
    { "LongLeftRightArrow;" "\u0027f7" }
    { "Longleftrightarrow;" "\u0027fa" }
    { "longleftrightarrow;" "\u0027f7" }
    { "longmapsto;" "\u0027fc" }
    { "LongRightArrow;" "\u0027f6" }
    { "Longrightarrow;" "\u0027f9" }
    { "longrightarrow;" "\u0027f6" }
    { "looparrowleft;" "\u0021ab" }
    { "looparrowright;" "\u0021ac" }
    { "lopar;" "\u002985" }
    { "Lopf;" "\u01d543" }
    { "lopf;" "\u01d55d" }
    { "loplus;" "\u002a2d" }
    { "lotimes;" "\u002a34" }
    { "lowast;" "\u002217" }
    { "lowbar;" "_" }
    { "LowerLeftArrow;" "\u002199" }
    { "LowerRightArrow;" "\u002198" }
    { "loz;" "\u0025ca" }
    { "lozenge;" "\u0025ca" }
    { "lozf;" "\u0029eb" }
    { "lpar;" "(" }
    { "lparlt;" "\u002993" }
    { "lrarr;" "\u0021c6" }
    { "lrcorner;" "\u00231f" }
    { "lrhar;" "\u0021cb" }
    { "lrhard;" "\u00296d" }
    { "lrm;" "\u00200e" }
    { "lrtri;" "\u0022bf" }
    { "lsaquo;" "\u002039" }
    { "Lscr;" "\u002112" }
    { "lscr;" "\u01d4c1" }
    { "Lsh;" "\u0021b0" }
    { "lsh;" "\u0021b0" }
    { "lsim;" "\u002272" }
    { "lsime;" "\u002a8d" }
    { "lsimg;" "\u002a8f" }
    { "lsqb;" "[" }
    { "lsquo;" "\u002018" }
    { "lsquor;" "\u00201a" }
    { "Lstrok;" "\u000141" }
    { "lstrok;" "\u000142" }
    { "LT" "<" }
    { "lt" "<" }
    { "LT;" "<" }
    { "Lt;" "\u00226a" }
    { "lt;" "<" }
    { "ltcc;" "\u002aa6" }
    { "ltcir;" "\u002a79" }
    { "ltdot;" "\u0022d6" }
    { "lthree;" "\u0022cb" }
    { "ltimes;" "\u0022c9" }
    { "ltlarr;" "\u002976" }
    { "ltquest;" "\u002a7b" }
    { "ltri;" "\u0025c3" }
    { "ltrie;" "\u0022b4" }
    { "ltrif;" "\u0025c2" }
    { "ltrPar;" "\u002996" }
    { "lurdshar;" "\u00294a" }
    { "luruhar;" "\u002966" }
    { "lvertneqq;" "\u002268\u00fe00" }
    { "lvnE;" "\u002268\u00fe00" }
    { "macr" "\xaf" }
    { "macr;" "\xaf" }
    { "male;" "\u002642" }
    { "malt;" "\u002720" }
    { "maltese;" "\u002720" }
    { "Map;" "\u002905" }
    { "map;" "\u0021a6" }
    { "mapsto;" "\u0021a6" }
    { "mapstodown;" "\u0021a7" }
    { "mapstoleft;" "\u0021a4" }
    { "mapstoup;" "\u0021a5" }
    { "marker;" "\u0025ae" }
    { "mcomma;" "\u002a29" }
    { "Mcy;" "\u00041c" }
    { "mcy;" "\u00043c" }
    { "mdash;" "\u002014" }
    { "mDDot;" "\u00223a" }
    { "measuredangle;" "\u002221" }
    { "MediumSpace;" "\u00205f" }
    { "Mellintrf;" "\u002133" }
    { "Mfr;" "\u01d510" }
    { "mfr;" "\u01d52a" }
    { "mho;" "\u002127" }
    { "micro" "\xb5" }
    { "micro;" "\xb5" }
    { "mid;" "\u002223" }
    { "midast;" "*" }
    { "midcir;" "\u002af0" }
    { "middot" "\xb7" }
    { "middot;" "\xb7" }
    { "minus;" "\u002212" }
    { "minusb;" "\u00229f" }
    { "minusd;" "\u002238" }
    { "minusdu;" "\u002a2a" }
    { "MinusPlus;" "\u002213" }
    { "mlcp;" "\u002adb" }
    { "mldr;" "\u002026" }
    { "mnplus;" "\u002213" }
    { "models;" "\u0022a7" }
    { "Mopf;" "\u01d544" }
    { "mopf;" "\u01d55e" }
    { "mp;" "\u002213" }
    { "Mscr;" "\u002133" }
    { "mscr;" "\u01d4c2" }
    { "mstpos;" "\u00223e" }
    { "Mu;" "\u00039c" }
    { "mu;" "\u0003bc" }
    { "multimap;" "\u0022b8" }
    { "mumap;" "\u0022b8" }
    { "nabla;" "\u002207" }
    { "Nacute;" "\u000143" }
    { "nacute;" "\u000144" }
    { "nang;" "\u002220\u0020d2" }
    { "nap;" "\u002249" }
    { "napE;" "\u002a70\u000338" }
    { "napid;" "\u00224b\u000338" }
    { "napos;" "\u000149" }
    { "napprox;" "\u002249" }
    { "natur;" "\u00266e" }
    { "natural;" "\u00266e" }
    { "naturals;" "\u002115" }
    { "nbsp" "\xa0" }
    { "nbsp;" "\xa0" }
    { "nbump;" "\u00224e\u000338" }
    { "nbumpe;" "\u00224f\u000338" }
    { "ncap;" "\u002a43" }
    { "Ncaron;" "\u000147" }
    { "ncaron;" "\u000148" }
    { "Ncedil;" "\u000145" }
    { "ncedil;" "\u000146" }
    { "ncong;" "\u002247" }
    { "ncongdot;" "\u002a6d\u000338" }
    { "ncup;" "\u002a42" }
    { "Ncy;" "\u00041d" }
    { "ncy;" "\u00043d" }
    { "ndash;" "\u002013" }
    { "ne;" "\u002260" }
    { "nearhk;" "\u002924" }
    { "neArr;" "\u0021d7" }
    { "nearr;" "\u002197" }
    { "nearrow;" "\u002197" }
    { "nedot;" "\u002250\u000338" }
    { "NegativeMediumSpace;" "\u00200b" }
    { "NegativeThickSpace;" "\u00200b" }
    { "NegativeThinSpace;" "\u00200b" }
    { "NegativeVeryThinSpace;" "\u00200b" }
    { "nequiv;" "\u002262" }
    { "nesear;" "\u002928" }
    { "nesim;" "\u002242\u000338" }
    { "NestedGreaterGreater;" "\u00226b" }
    { "NestedLessLess;" "\u00226a" }
    { "NewLine;" "\n" }
    { "nexist;" "\u002204" }
    { "nexists;" "\u002204" }
    { "Nfr;" "\u01d511" }
    { "nfr;" "\u01d52b" }
    { "ngE;" "\u002267\u000338" }
    { "nge;" "\u002271" }
    { "ngeq;" "\u002271" }
    { "ngeqq;" "\u002267\u000338" }
    { "ngeqslant;" "\u002a7e\u000338" }
    { "nges;" "\u002a7e\u000338" }
    { "nGg;" "\u0022d9\u000338" }
    { "ngsim;" "\u002275" }
    { "nGt;" "\u00226b\u0020d2" }
    { "ngt;" "\u00226f" }
    { "ngtr;" "\u00226f" }
    { "nGtv;" "\u00226b\u000338" }
    { "nhArr;" "\u0021ce" }
    { "nharr;" "\u0021ae" }
    { "nhpar;" "\u002af2" }
    { "ni;" "\u00220b" }
    { "nis;" "\u0022fc" }
    { "nisd;" "\u0022fa" }
    { "niv;" "\u00220b" }
    { "NJcy;" "\u00040a" }
    { "njcy;" "\u00045a" }
    { "nlArr;" "\u0021cd" }
    { "nlarr;" "\u00219a" }
    { "nldr;" "\u002025" }
    { "nlE;" "\u002266\u000338" }
    { "nle;" "\u002270" }
    { "nLeftarrow;" "\u0021cd" }
    { "nleftarrow;" "\u00219a" }
    { "nLeftrightarrow;" "\u0021ce" }
    { "nleftrightarrow;" "\u0021ae" }
    { "nleq;" "\u002270" }
    { "nleqq;" "\u002266\u000338" }
    { "nleqslant;" "\u002a7d\u000338" }
    { "nles;" "\u002a7d\u000338" }
    { "nless;" "\u00226e" }
    { "nLl;" "\u0022d8\u000338" }
    { "nlsim;" "\u002274" }
    { "nLt;" "\u00226a\u0020d2" }
    { "nlt;" "\u00226e" }
    { "nltri;" "\u0022ea" }
    { "nltrie;" "\u0022ec" }
    { "nLtv;" "\u00226a\u000338" }
    { "nmid;" "\u002224" }
    { "NoBreak;" "\u002060" }
    { "NonBreakingSpace;" "\xa0" }
    { "Nopf;" "\u002115" }
    { "nopf;" "\u01d55f" }
    { "not" "\xac" }
    { "Not;" "\u002aec" }
    { "not;" "\xac" }
    { "NotCongruent;" "\u002262" }
    { "NotCupCap;" "\u00226d" }
    { "NotDoubleVerticalBar;" "\u002226" }
    { "NotElement;" "\u002209" }
    { "NotEqual;" "\u002260" }
    { "NotEqualTilde;" "\u002242\u000338" }
    { "NotExists;" "\u002204" }
    { "NotGreater;" "\u00226f" }
    { "NotGreaterEqual;" "\u002271" }
    { "NotGreaterFullEqual;" "\u002267\u000338" }
    { "NotGreaterGreater;" "\u00226b\u000338" }
    { "NotGreaterLess;" "\u002279" }
    { "NotGreaterSlantEqual;" "\u002a7e\u000338" }
    { "NotGreaterTilde;" "\u002275" }
    { "NotHumpDownHump;" "\u00224e\u000338" }
    { "NotHumpEqual;" "\u00224f\u000338" }
    { "notin;" "\u002209" }
    { "notindot;" "\u0022f5\u000338" }
    { "notinE;" "\u0022f9\u000338" }
    { "notinva;" "\u002209" }
    { "notinvb;" "\u0022f7" }
    { "notinvc;" "\u0022f6" }
    { "NotLeftTriangle;" "\u0022ea" }
    { "NotLeftTriangleBar;" "\u0029cf\u000338" }
    { "NotLeftTriangleEqual;" "\u0022ec" }
    { "NotLess;" "\u00226e" }
    { "NotLessEqual;" "\u002270" }
    { "NotLessGreater;" "\u002278" }
    { "NotLessLess;" "\u00226a\u000338" }
    { "NotLessSlantEqual;" "\u002a7d\u000338" }
    { "NotLessTilde;" "\u002274" }
    { "NotNestedGreaterGreater;" "\u002aa2\u000338" }
    { "NotNestedLessLess;" "\u002aa1\u000338" }
    { "notni;" "\u00220c" }
    { "notniva;" "\u00220c" }
    { "notnivb;" "\u0022fe" }
    { "notnivc;" "\u0022fd" }
    { "NotPrecedes;" "\u002280" }
    { "NotPrecedesEqual;" "\u002aaf\u000338" }
    { "NotPrecedesSlantEqual;" "\u0022e0" }
    { "NotReverseElement;" "\u00220c" }
    { "NotRightTriangle;" "\u0022eb" }
    { "NotRightTriangleBar;" "\u0029d0\u000338" }
    { "NotRightTriangleEqual;" "\u0022ed" }
    { "NotSquareSubset;" "\u00228f\u000338" }
    { "NotSquareSubsetEqual;" "\u0022e2" }
    { "NotSquareSuperset;" "\u002290\u000338" }
    { "NotSquareSupersetEqual;" "\u0022e3" }
    { "NotSubset;" "\u002282\u0020d2" }
    { "NotSubsetEqual;" "\u002288" }
    { "NotSucceeds;" "\u002281" }
    { "NotSucceedsEqual;" "\u002ab0\u000338" }
    { "NotSucceedsSlantEqual;" "\u0022e1" }
    { "NotSucceedsTilde;" "\u00227f\u000338" }
    { "NotSuperset;" "\u002283\u0020d2" }
    { "NotSupersetEqual;" "\u002289" }
    { "NotTilde;" "\u002241" }
    { "NotTildeEqual;" "\u002244" }
    { "NotTildeFullEqual;" "\u002247" }
    { "NotTildeTilde;" "\u002249" }
    { "NotVerticalBar;" "\u002224" }
    { "npar;" "\u002226" }
    { "nparallel;" "\u002226" }
    { "nparsl;" "\u002afd\u0020e5" }
    { "npart;" "\u002202\u000338" }
    { "npolint;" "\u002a14" }
    { "npr;" "\u002280" }
    { "nprcue;" "\u0022e0" }
    { "npre;" "\u002aaf\u000338" }
    { "nprec;" "\u002280" }
    { "npreceq;" "\u002aaf\u000338" }
    { "nrArr;" "\u0021cf" }
    { "nrarr;" "\u00219b" }
    { "nrarrc;" "\u002933\u000338" }
    { "nrarrw;" "\u00219d\u000338" }
    { "nRightarrow;" "\u0021cf" }
    { "nrightarrow;" "\u00219b" }
    { "nrtri;" "\u0022eb" }
    { "nrtrie;" "\u0022ed" }
    { "nsc;" "\u002281" }
    { "nsccue;" "\u0022e1" }
    { "nsce;" "\u002ab0\u000338" }
    { "Nscr;" "\u01d4a9" }
    { "nscr;" "\u01d4c3" }
    { "nshortmid;" "\u002224" }
    { "nshortparallel;" "\u002226" }
    { "nsim;" "\u002241" }
    { "nsime;" "\u002244" }
    { "nsimeq;" "\u002244" }
    { "nsmid;" "\u002224" }
    { "nspar;" "\u002226" }
    { "nsqsube;" "\u0022e2" }
    { "nsqsupe;" "\u0022e3" }
    { "nsub;" "\u002284" }
    { "nsubE;" "\u002ac5\u000338" }
    { "nsube;" "\u002288" }
    { "nsubset;" "\u002282\u0020d2" }
    { "nsubseteq;" "\u002288" }
    { "nsubseteqq;" "\u002ac5\u000338" }
    { "nsucc;" "\u002281" }
    { "nsucceq;" "\u002ab0\u000338" }
    { "nsup;" "\u002285" }
    { "nsupE;" "\u002ac6\u000338" }
    { "nsupe;" "\u002289" }
    { "nsupset;" "\u002283\u0020d2" }
    { "nsupseteq;" "\u002289" }
    { "nsupseteqq;" "\u002ac6\u000338" }
    { "ntgl;" "\u002279" }
    { "Ntilde" "\xd1" }
    { "ntilde" "\xf1" }
    { "Ntilde;" "\xd1" }
    { "ntilde;" "\xf1" }
    { "ntlg;" "\u002278" }
    { "ntriangleleft;" "\u0022ea" }
    { "ntrianglelefteq;" "\u0022ec" }
    { "ntriangleright;" "\u0022eb" }
    { "ntrianglerighteq;" "\u0022ed" }
    { "Nu;" "\u00039d" }
    { "nu;" "\u0003bd" }
    { "num;" "#" }
    { "numero;" "\u002116" }
    { "numsp;" "\u002007" }
    { "nvap;" "\u00224d\u0020d2" }
    { "nVDash;" "\u0022af" }
    { "nVdash;" "\u0022ae" }
    { "nvDash;" "\u0022ad" }
    { "nvdash;" "\u0022ac" }
    { "nvge;" "\u002265\u0020d2" }
    { "nvgt;" ">\u0020d2" }
    { "nvHarr;" "\u002904" }
    { "nvinfin;" "\u0029de" }
    { "nvlArr;" "\u002902" }
    { "nvle;" "\u002264\u0020d2" }
    { "nvlt;" "<\u0020d2" }
    { "nvltrie;" "\u0022b4\u0020d2" }
    { "nvrArr;" "\u002903" }
    { "nvrtrie;" "\u0022b5\u0020d2" }
    { "nvsim;" "\u00223c\u0020d2" }
    { "nwarhk;" "\u002923" }
    { "nwArr;" "\u0021d6" }
    { "nwarr;" "\u002196" }
    { "nwarrow;" "\u002196" }
    { "nwnear;" "\u002927" }
    { "Oacute" "\xd3" }
    { "oacute" "\xf3" }
    { "Oacute;" "\xd3" }
    { "oacute;" "\xf3" }
    { "oast;" "\u00229b" }
    { "ocir;" "\u00229a" }
    { "Ocirc" "\xd4" }
    { "ocirc" "\xf4" }
    { "Ocirc;" "\xd4" }
    { "ocirc;" "\xf4" }
    { "Ocy;" "\u00041e" }
    { "ocy;" "\u00043e" }
    { "odash;" "\u00229d" }
    { "Odblac;" "\u000150" }
    { "odblac;" "\u000151" }
    { "odiv;" "\u002a38" }
    { "odot;" "\u002299" }
    { "odsold;" "\u0029bc" }
    { "OElig;" "\u000152" }
    { "oelig;" "\u000153" }
    { "ofcir;" "\u0029bf" }
    { "Ofr;" "\u01d512" }
    { "ofr;" "\u01d52c" }
    { "ogon;" "\u0002db" }
    { "Ograve" "\xd2" }
    { "ograve" "\xf2" }
    { "Ograve;" "\xd2" }
    { "ograve;" "\xf2" }
    { "ogt;" "\u0029c1" }
    { "ohbar;" "\u0029b5" }
    { "ohm;" "\u0003a9" }
    { "oint;" "\u00222e" }
    { "olarr;" "\u0021ba" }
    { "olcir;" "\u0029be" }
    { "olcross;" "\u0029bb" }
    { "oline;" "\u00203e" }
    { "olt;" "\u0029c0" }
    { "Omacr;" "\u00014c" }
    { "omacr;" "\u00014d" }
    { "Omega;" "\u0003a9" }
    { "omega;" "\u0003c9" }
    { "Omicron;" "\u00039f" }
    { "omicron;" "\u0003bf" }
    { "omid;" "\u0029b6" }
    { "ominus;" "\u002296" }
    { "Oopf;" "\u01d546" }
    { "oopf;" "\u01d560" }
    { "opar;" "\u0029b7" }
    { "OpenCurlyDoubleQuote;" "\u00201c" }
    { "OpenCurlyQuote;" "\u002018" }
    { "operp;" "\u0029b9" }
    { "oplus;" "\u002295" }
    { "Or;" "\u002a54" }
    { "or;" "\u002228" }
    { "orarr;" "\u0021bb" }
    { "ord;" "\u002a5d" }
    { "order;" "\u002134" }
    { "orderof;" "\u002134" }
    { "ordf" "\xaa" }
    { "ordf;" "\xaa" }
    { "ordm" "\xba" }
    { "ordm;" "\xba" }
    { "origof;" "\u0022b6" }
    { "oror;" "\u002a56" }
    { "orslope;" "\u002a57" }
    { "orv;" "\u002a5b" }
    { "oS;" "\u0024c8" }
    { "Oscr;" "\u01d4aa" }
    { "oscr;" "\u002134" }
    { "Oslash" "\xd8" }
    { "oslash" "\xf8" }
    { "Oslash;" "\xd8" }
    { "oslash;" "\xf8" }
    { "osol;" "\u002298" }
    { "Otilde" "\xd5" }
    { "otilde" "\xf5" }
    { "Otilde;" "\xd5" }
    { "otilde;" "\xf5" }
    { "Otimes;" "\u002a37" }
    { "otimes;" "\u002297" }
    { "otimesas;" "\u002a36" }
    { "Ouml" "\xd6" }
    { "ouml" "\xf6" }
    { "Ouml;" "\xd6" }
    { "ouml;" "\xf6" }
    { "ovbar;" "\u00233d" }
    { "OverBar;" "\u00203e" }
    { "OverBrace;" "\u0023de" }
    { "OverBracket;" "\u0023b4" }
    { "OverParenthesis;" "\u0023dc" }
    { "par;" "\u002225" }
    { "para" "\xb6" }
    { "para;" "\xb6" }
    { "parallel;" "\u002225" }
    { "parsim;" "\u002af3" }
    { "parsl;" "\u002afd" }
    { "part;" "\u002202" }
    { "PartialD;" "\u002202" }
    { "Pcy;" "\u00041f" }
    { "pcy;" "\u00043f" }
    { "percnt;" "%" }
    { "period;" "." }
    { "permil;" "\u002030" }
    { "perp;" "\u0022a5" }
    { "pertenk;" "\u002031" }
    { "Pfr;" "\u01d513" }
    { "pfr;" "\u01d52d" }
    { "Phi;" "\u0003a6" }
    { "phi;" "\u0003c6" }
    { "phiv;" "\u0003d5" }
    { "phmmat;" "\u002133" }
    { "phone;" "\u00260e" }
    { "Pi;" "\u0003a0" }
    { "pi;" "\u0003c0" }
    { "pitchfork;" "\u0022d4" }
    { "piv;" "\u0003d6" }
    { "planck;" "\u00210f" }
    { "planckh;" "\u00210e" }
    { "plankv;" "\u00210f" }
    { "plus;" "+" }
    { "plusacir;" "\u002a23" }
    { "plusb;" "\u00229e" }
    { "pluscir;" "\u002a22" }
    { "plusdo;" "\u002214" }
    { "plusdu;" "\u002a25" }
    { "pluse;" "\u002a72" }
    { "PlusMinus;" "\xb1" }
    { "plusmn" "\xb1" }
    { "plusmn;" "\xb1" }
    { "plussim;" "\u002a26" }
    { "plustwo;" "\u002a27" }
    { "pm;" "\xb1" }
    { "Poincareplane;" "\u00210c" }
    { "pointint;" "\u002a15" }
    { "Popf;" "\u002119" }
    { "popf;" "\u01d561" }
    { "pound" "\xa3" }
    { "pound;" "\xa3" }
    { "Pr;" "\u002abb" }
    { "pr;" "\u00227a" }
    { "prap;" "\u002ab7" }
    { "prcue;" "\u00227c" }
    { "prE;" "\u002ab3" }
    { "pre;" "\u002aaf" }
    { "prec;" "\u00227a" }
    { "precapprox;" "\u002ab7" }
    { "preccurlyeq;" "\u00227c" }
    { "Precedes;" "\u00227a" }
    { "PrecedesEqual;" "\u002aaf" }
    { "PrecedesSlantEqual;" "\u00227c" }
    { "PrecedesTilde;" "\u00227e" }
    { "preceq;" "\u002aaf" }
    { "precnapprox;" "\u002ab9" }
    { "precneqq;" "\u002ab5" }
    { "precnsim;" "\u0022e8" }
    { "precsim;" "\u00227e" }
    { "Prime;" "\u002033" }
    { "prime;" "\u002032" }
    { "primes;" "\u002119" }
    { "prnap;" "\u002ab9" }
    { "prnE;" "\u002ab5" }
    { "prnsim;" "\u0022e8" }
    { "prod;" "\u00220f" }
    { "Product;" "\u00220f" }
    { "profalar;" "\u00232e" }
    { "profline;" "\u002312" }
    { "profsurf;" "\u002313" }
    { "prop;" "\u00221d" }
    { "Proportion;" "\u002237" }
    { "Proportional;" "\u00221d" }
    { "propto;" "\u00221d" }
    { "prsim;" "\u00227e" }
    { "prurel;" "\u0022b0" }
    { "Pscr;" "\u01d4ab" }
    { "pscr;" "\u01d4c5" }
    { "Psi;" "\u0003a8" }
    { "psi;" "\u0003c8" }
    { "puncsp;" "\u002008" }
    { "Qfr;" "\u01d514" }
    { "qfr;" "\u01d52e" }
    { "qint;" "\u002a0c" }
    { "Qopf;" "\u00211a" }
    { "qopf;" "\u01d562" }
    { "qprime;" "\u002057" }
    { "Qscr;" "\u01d4ac" }
    { "qscr;" "\u01d4c6" }
    { "quaternions;" "\u00210d" }
    { "quatint;" "\u002a16" }
    { "quest;" "?" }
    { "questeq;" "\u00225f" }
    { "QUOT" """ }
    { "quot" """ }
    { "QUOT;" """ }
    { "quot;" """ }
    { "rAarr;" "\u0021db" }
    { "race;" "\u00223d\u000331" }
    { "Racute;" "\u000154" }
    { "racute;" "\u000155" }
    { "radic;" "\u00221a" }
    { "raemptyv;" "\u0029b3" }
    { "Rang;" "\u0027eb" }
    { "rang;" "\u0027e9" }
    { "rangd;" "\u002992" }
    { "range;" "\u0029a5" }
    { "rangle;" "\u0027e9" }
    { "raquo" "\xbb" }
    { "raquo;" "\xbb" }
    { "Rarr;" "\u0021a0" }
    { "rArr;" "\u0021d2" }
    { "rarr;" "\u002192" }
    { "rarrap;" "\u002975" }
    { "rarrb;" "\u0021e5" }
    { "rarrbfs;" "\u002920" }
    { "rarrc;" "\u002933" }
    { "rarrfs;" "\u00291e" }
    { "rarrhk;" "\u0021aa" }
    { "rarrlp;" "\u0021ac" }
    { "rarrpl;" "\u002945" }
    { "rarrsim;" "\u002974" }
    { "Rarrtl;" "\u002916" }
    { "rarrtl;" "\u0021a3" }
    { "rarrw;" "\u00219d" }
    { "rAtail;" "\u00291c" }
    { "ratail;" "\u00291a" }
    { "ratio;" "\u002236" }
    { "rationals;" "\u00211a" }
    { "RBarr;" "\u002910" }
    { "rBarr;" "\u00290f" }
    { "rbarr;" "\u00290d" }
    { "rbbrk;" "\u002773" }
    { "rbrace;" "}" }
    { "rbrack;" "]" }
    { "rbrke;" "\u00298c" }
    { "rbrksld;" "\u00298e" }
    { "rbrkslu;" "\u002990" }
    { "Rcaron;" "\u000158" }
    { "rcaron;" "\u000159" }
    { "Rcedil;" "\u000156" }
    { "rcedil;" "\u000157" }
    { "rceil;" "\u002309" }
    { "rcub;" "}" }
    { "Rcy;" "\u000420" }
    { "rcy;" "\u000440" }
    { "rdca;" "\u002937" }
    { "rdldhar;" "\u002969" }
    { "rdquo;" "\u00201d" }
    { "rdquor;" "\u00201d" }
    { "rdsh;" "\u0021b3" }
    { "Re;" "\u00211c" }
    { "real;" "\u00211c" }
    { "realine;" "\u00211b" }
    { "realpart;" "\u00211c" }
    { "reals;" "\u00211d" }
    { "rect;" "\u0025ad" }
    { "REG" "\xae" }
    { "reg" "\xae" }
    { "REG;" "\xae" }
    { "reg;" "\xae" }
    { "ReverseElement;" "\u00220b" }
    { "ReverseEquilibrium;" "\u0021cb" }
    { "ReverseUpEquilibrium;" "\u00296f" }
    { "rfisht;" "\u00297d" }
    { "rfloor;" "\u00230b" }
    { "Rfr;" "\u00211c" }
    { "rfr;" "\u01d52f" }
    { "rHar;" "\u002964" }
    { "rhard;" "\u0021c1" }
    { "rharu;" "\u0021c0" }
    { "rharul;" "\u00296c" }
    { "Rho;" "\u0003a1" }
    { "rho;" "\u0003c1" }
    { "rhov;" "\u0003f1" }
    { "RightAngleBracket;" "\u0027e9" }
    { "RightArrow;" "\u002192" }
    { "Rightarrow;" "\u0021d2" }
    { "rightarrow;" "\u002192" }
    { "RightArrowBar;" "\u0021e5" }
    { "RightArrowLeftArrow;" "\u0021c4" }
    { "rightarrowtail;" "\u0021a3" }
    { "RightCeiling;" "\u002309" }
    { "RightDoubleBracket;" "\u0027e7" }
    { "RightDownTeeVector;" "\u00295d" }
    { "RightDownVector;" "\u0021c2" }
    { "RightDownVectorBar;" "\u002955" }
    { "RightFloor;" "\u00230b" }
    { "rightharpoondown;" "\u0021c1" }
    { "rightharpoonup;" "\u0021c0" }
    { "rightleftarrows;" "\u0021c4" }
    { "rightleftharpoons;" "\u0021cc" }
    { "rightrightarrows;" "\u0021c9" }
    { "rightsquigarrow;" "\u00219d" }
    { "RightTee;" "\u0022a2" }
    { "RightTeeArrow;" "\u0021a6" }
    { "RightTeeVector;" "\u00295b" }
    { "rightthreetimes;" "\u0022cc" }
    { "RightTriangle;" "\u0022b3" }
    { "RightTriangleBar;" "\u0029d0" }
    { "RightTriangleEqual;" "\u0022b5" }
    { "RightUpDownVector;" "\u00294f" }
    { "RightUpTeeVector;" "\u00295c" }
    { "RightUpVector;" "\u0021be" }
    { "RightUpVectorBar;" "\u002954" }
    { "RightVector;" "\u0021c0" }
    { "RightVectorBar;" "\u002953" }
    { "ring;" "\u0002da" }
    { "risingdotseq;" "\u002253" }
    { "rlarr;" "\u0021c4" }
    { "rlhar;" "\u0021cc" }
    { "rlm;" "\u00200f" }
    { "rmoust;" "\u0023b1" }
    { "rmoustache;" "\u0023b1" }
    { "rnmid;" "\u002aee" }
    { "roang;" "\u0027ed" }
    { "roarr;" "\u0021fe" }
    { "robrk;" "\u0027e7" }
    { "ropar;" "\u002986" }
    { "Ropf;" "\u00211d" }
    { "ropf;" "\u01d563" }
    { "roplus;" "\u002a2e" }
    { "rotimes;" "\u002a35" }
    { "RoundImplies;" "\u002970" }
    { "rpar;" ")" }
    { "rpargt;" "\u002994" }
    { "rppolint;" "\u002a12" }
    { "rrarr;" "\u0021c9" }
    { "Rrightarrow;" "\u0021db" }
    { "rsaquo;" "\u00203a" }
    { "Rscr;" "\u00211b" }
    { "rscr;" "\u01d4c7" }
    { "Rsh;" "\u0021b1" }
    { "rsh;" "\u0021b1" }
    { "rsqb;" "]" }
    { "rsquo;" "\u002019" }
    { "rsquor;" "\u002019" }
    { "rthree;" "\u0022cc" }
    { "rtimes;" "\u0022ca" }
    { "rtri;" "\u0025b9" }
    { "rtrie;" "\u0022b5" }
    { "rtrif;" "\u0025b8" }
    { "rtriltri;" "\u0029ce" }
    { "RuleDelayed;" "\u0029f4" }
    { "ruluhar;" "\u002968" }
    { "rx;" "\u00211e" }
    { "Sacute;" "\u00015a" }
    { "sacute;" "\u00015b" }
    { "sbquo;" "\u00201a" }
    { "Sc;" "\u002abc" }
    { "sc;" "\u00227b" }
    { "scap;" "\u002ab8" }
    { "Scaron;" "\u000160" }
    { "scaron;" "\u000161" }
    { "sccue;" "\u00227d" }
    { "scE;" "\u002ab4" }
    { "sce;" "\u002ab0" }
    { "Scedil;" "\u00015e" }
    { "scedil;" "\u00015f" }
    { "Scirc;" "\u00015c" }
    { "scirc;" "\u00015d" }
    { "scnap;" "\u002aba" }
    { "scnE;" "\u002ab6" }
    { "scnsim;" "\u0022e9" }
    { "scpolint;" "\u002a13" }
    { "scsim;" "\u00227f" }
    { "Scy;" "\u000421" }
    { "scy;" "\u000441" }
    { "sdot;" "\u0022c5" }
    { "sdotb;" "\u0022a1" }
    { "sdote;" "\u002a66" }
    { "searhk;" "\u002925" }
    { "seArr;" "\u0021d8" }
    { "searr;" "\u002198" }
    { "searrow;" "\u002198" }
    { "sect" "\xa7" }
    { "sect;" "\xa7" }
    { "semi;" ";" }
    { "seswar;" "\u002929" }
    { "setminus;" "\u002216" }
    { "setmn;" "\u002216" }
    { "sext;" "\u002736" }
    { "Sfr;" "\u01d516" }
    { "sfr;" "\u01d530" }
    { "sfrown;" "\u002322" }
    { "sharp;" "\u00266f" }
    { "SHCHcy;" "\u000429" }
    { "shchcy;" "\u000449" }
    { "SHcy;" "\u000428" }
    { "shcy;" "\u000448" }
    { "ShortDownArrow;" "\u002193" }
    { "ShortLeftArrow;" "\u002190" }
    { "shortmid;" "\u002223" }
    { "shortparallel;" "\u002225" }
    { "ShortRightArrow;" "\u002192" }
    { "ShortUpArrow;" "\u002191" }
    { "shy" "\xad" }
    { "shy;" "\xad" }
    { "Sigma;" "\u0003a3" }
    { "sigma;" "\u0003c3" }
    { "sigmaf;" "\u0003c2" }
    { "sigmav;" "\u0003c2" }
    { "sim;" "\u00223c" }
    { "simdot;" "\u002a6a" }
    { "sime;" "\u002243" }
    { "simeq;" "\u002243" }
    { "simg;" "\u002a9e" }
    { "simgE;" "\u002aa0" }
    { "siml;" "\u002a9d" }
    { "simlE;" "\u002a9f" }
    { "simne;" "\u002246" }
    { "simplus;" "\u002a24" }
    { "simrarr;" "\u002972" }
    { "slarr;" "\u002190" }
    { "SmallCircle;" "\u002218" }
    { "smallsetminus;" "\u002216" }
    { "smashp;" "\u002a33" }
    { "smeparsl;" "\u0029e4" }
    { "smid;" "\u002223" }
    { "smile;" "\u002323" }
    { "smt;" "\u002aaa" }
    { "smte;" "\u002aac" }
    { "smtes;" "\u002aac\u00fe00" }
    { "SOFTcy;" "\u00042c" }
    { "softcy;" "\u00044c" }
    { "sol;" "/" }
    { "solb;" "\u0029c4" }
    { "solbar;" "\u00233f" }
    { "Sopf;" "\u01d54a" }
    { "sopf;" "\u01d564" }
    { "spades;" "\u002660" }
    { "spadesuit;" "\u002660" }
    { "spar;" "\u002225" }
    { "sqcap;" "\u002293" }
    { "sqcaps;" "\u002293\u00fe00" }
    { "sqcup;" "\u002294" }
    { "sqcups;" "\u002294\u00fe00" }
    { "Sqrt;" "\u00221a" }
    { "sqsub;" "\u00228f" }
    { "sqsube;" "\u002291" }
    { "sqsubset;" "\u00228f" }
    { "sqsubseteq;" "\u002291" }
    { "sqsup;" "\u002290" }
    { "sqsupe;" "\u002292" }
    { "sqsupset;" "\u002290" }
    { "sqsupseteq;" "\u002292" }
    { "squ;" "\u0025a1" }
    { "Square;" "\u0025a1" }
    { "square;" "\u0025a1" }
    { "SquareIntersection;" "\u002293" }
    { "SquareSubset;" "\u00228f" }
    { "SquareSubsetEqual;" "\u002291" }
    { "SquareSuperset;" "\u002290" }
    { "SquareSupersetEqual;" "\u002292" }
    { "SquareUnion;" "\u002294" }
    { "squarf;" "\u0025aa" }
    { "squf;" "\u0025aa" }
    { "srarr;" "\u002192" }
    { "Sscr;" "\u01d4ae" }
    { "sscr;" "\u01d4c8" }
    { "ssetmn;" "\u002216" }
    { "ssmile;" "\u002323" }
    { "sstarf;" "\u0022c6" }
    { "Star;" "\u0022c6" }
    { "star;" "\u002606" }
    { "starf;" "\u002605" }
    { "straightepsilon;" "\u0003f5" }
    { "straightphi;" "\u0003d5" }
    { "strns;" "\xaf" }
    { "Sub;" "\u0022d0" }
    { "sub;" "\u002282" }
    { "subdot;" "\u002abd" }
    { "subE;" "\u002ac5" }
    { "sube;" "\u002286" }
    { "subedot;" "\u002ac3" }
    { "submult;" "\u002ac1" }
    { "subnE;" "\u002acb" }
    { "subne;" "\u00228a" }
    { "subplus;" "\u002abf" }
    { "subrarr;" "\u002979" }
    { "Subset;" "\u0022d0" }
    { "subset;" "\u002282" }
    { "subseteq;" "\u002286" }
    { "subseteqq;" "\u002ac5" }
    { "SubsetEqual;" "\u002286" }
    { "subsetneq;" "\u00228a" }
    { "subsetneqq;" "\u002acb" }
    { "subsim;" "\u002ac7" }
    { "subsub;" "\u002ad5" }
    { "subsup;" "\u002ad3" }
    { "succ;" "\u00227b" }
    { "succapprox;" "\u002ab8" }
    { "succcurlyeq;" "\u00227d" }
    { "Succeeds;" "\u00227b" }
    { "SucceedsEqual;" "\u002ab0" }
    { "SucceedsSlantEqual;" "\u00227d" }
    { "SucceedsTilde;" "\u00227f" }
    { "succeq;" "\u002ab0" }
    { "succnapprox;" "\u002aba" }
    { "succneqq;" "\u002ab6" }
    { "succnsim;" "\u0022e9" }
    { "succsim;" "\u00227f" }
    { "SuchThat;" "\u00220b" }
    { "Sum;" "\u002211" }
    { "sum;" "\u002211" }
    { "sung;" "\u00266a" }
    { "sup1" "\xb9" }
    { "sup1;" "\xb9" }
    { "sup2" "\xb2" }
    { "sup2;" "\xb2" }
    { "sup3" "\xb3" }
    { "sup3;" "\xb3" }
    { "Sup;" "\u0022d1" }
    { "sup;" "\u002283" }
    { "supdot;" "\u002abe" }
    { "supdsub;" "\u002ad8" }
    { "supE;" "\u002ac6" }
    { "supe;" "\u002287" }
    { "supedot;" "\u002ac4" }
    { "Superset;" "\u002283" }
    { "SupersetEqual;" "\u002287" }
    { "suphsol;" "\u0027c9" }
    { "suphsub;" "\u002ad7" }
    { "suplarr;" "\u00297b" }
    { "supmult;" "\u002ac2" }
    { "supnE;" "\u002acc" }
    { "supne;" "\u00228b" }
    { "supplus;" "\u002ac0" }
    { "Supset;" "\u0022d1" }
    { "supset;" "\u002283" }
    { "supseteq;" "\u002287" }
    { "supseteqq;" "\u002ac6" }
    { "supsetneq;" "\u00228b" }
    { "supsetneqq;" "\u002acc" }
    { "supsim;" "\u002ac8" }
    { "supsub;" "\u002ad4" }
    { "supsup;" "\u002ad6" }
    { "swarhk;" "\u002926" }
    { "swArr;" "\u0021d9" }
    { "swarr;" "\u002199" }
    { "swarrow;" "\u002199" }
    { "swnwar;" "\u00292a" }
    { "szlig" "\xdf" }
    { "szlig;" "\xdf" }
    { "Tab;" "\t" }
    { "target;" "\u002316" }
    { "Tau;" "\u0003a4" }
    { "tau;" "\u0003c4" }
    { "tbrk;" "\u0023b4" }
    { "Tcaron;" "\u000164" }
    { "tcaron;" "\u000165" }
    { "Tcedil;" "\u000162" }
    { "tcedil;" "\u000163" }
    { "Tcy;" "\u000422" }
    { "tcy;" "\u000442" }
    { "tdot;" "\u0020db" }
    { "telrec;" "\u002315" }
    { "Tfr;" "\u01d517" }
    { "tfr;" "\u01d531" }
    { "there4;" "\u002234" }
    { "Therefore;" "\u002234" }
    { "therefore;" "\u002234" }
    { "Theta;" "\u000398" }
    { "theta;" "\u0003b8" }
    { "thetasym;" "\u0003d1" }
    { "thetav;" "\u0003d1" }
    { "thickapprox;" "\u002248" }
    { "thicksim;" "\u00223c" }
    { "ThickSpace;" "\u00205f\u00200a" }
    { "thinsp;" "\u002009" }
    { "ThinSpace;" "\u002009" }
    { "thkap;" "\u002248" }
    { "thksim;" "\u00223c" }
    { "THORN" "\xde" }
    { "thorn" "\xfe" }
    { "THORN;" "\xde" }
    { "thorn;" "\xfe" }
    { "Tilde;" "\u00223c" }
    { "tilde;" "\u0002dc" }
    { "TildeEqual;" "\u002243" }
    { "TildeFullEqual;" "\u002245" }
    { "TildeTilde;" "\u002248" }
    { "times" "\xd7" }
    { "times;" "\xd7" }
    { "timesb;" "\u0022a0" }
    { "timesbar;" "\u002a31" }
    { "timesd;" "\u002a30" }
    { "tint;" "\u00222d" }
    { "toea;" "\u002928" }
    { "top;" "\u0022a4" }
    { "topbot;" "\u002336" }
    { "topcir;" "\u002af1" }
    { "Topf;" "\u01d54b" }
    { "topf;" "\u01d565" }
    { "topfork;" "\u002ada" }
    { "tosa;" "\u002929" }
    { "tprime;" "\u002034" }
    { "TRADE;" "\u002122" }
    { "trade;" "\u002122" }
    { "triangle;" "\u0025b5" }
    { "triangledown;" "\u0025bf" }
    { "triangleleft;" "\u0025c3" }
    { "trianglelefteq;" "\u0022b4" }
    { "triangleq;" "\u00225c" }
    { "triangleright;" "\u0025b9" }
    { "trianglerighteq;" "\u0022b5" }
    { "tridot;" "\u0025ec" }
    { "trie;" "\u00225c" }
    { "triminus;" "\u002a3a" }
    { "TripleDot;" "\u0020db" }
    { "triplus;" "\u002a39" }
    { "trisb;" "\u0029cd" }
    { "tritime;" "\u002a3b" }
    { "trpezium;" "\u0023e2" }
    { "Tscr;" "\u01d4af" }
    { "tscr;" "\u01d4c9" }
    { "TScy;" "\u000426" }
    { "tscy;" "\u000446" }
    { "TSHcy;" "\u00040b" }
    { "tshcy;" "\u00045b" }
    { "Tstrok;" "\u000166" }
    { "tstrok;" "\u000167" }
    { "twixt;" "\u00226c" }
    { "twoheadleftarrow;" "\u00219e" }
    { "twoheadrightarrow;" "\u0021a0" }
    { "Uacute" "\xda" }
    { "uacute" "\xfa" }
    { "Uacute;" "\xda" }
    { "uacute;" "\xfa" }
    { "Uarr;" "\u00219f" }
    { "uArr;" "\u0021d1" }
    { "uarr;" "\u002191" }
    { "Uarrocir;" "\u002949" }
    { "Ubrcy;" "\u00040e" }
    { "ubrcy;" "\u00045e" }
    { "Ubreve;" "\u00016c" }
    { "ubreve;" "\u00016d" }
    { "Ucirc" "\xdb" }
    { "ucirc" "\xfb" }
    { "Ucirc;" "\xdb" }
    { "ucirc;" "\xfb" }
    { "Ucy;" "\u000423" }
    { "ucy;" "\u000443" }
    { "udarr;" "\u0021c5" }
    { "Udblac;" "\u000170" }
    { "udblac;" "\u000171" }
    { "udhar;" "\u00296e" }
    { "ufisht;" "\u00297e" }
    { "Ufr;" "\u01d518" }
    { "ufr;" "\u01d532" }
    { "Ugrave" "\xd9" }
    { "ugrave" "\xf9" }
    { "Ugrave;" "\xd9" }
    { "ugrave;" "\xf9" }
    { "uHar;" "\u002963" }
    { "uharl;" "\u0021bf" }
    { "uharr;" "\u0021be" }
    { "uhblk;" "\u002580" }
    { "ulcorn;" "\u00231c" }
    { "ulcorner;" "\u00231c" }
    { "ulcrop;" "\u00230f" }
    { "ultri;" "\u0025f8" }
    { "Umacr;" "\u00016a" }
    { "umacr;" "\u00016b" }
    { "uml" "\xa8" }
    { "uml;" "\xa8" }
    { "UnderBar;" "_" }
    { "UnderBrace;" "\u0023df" }
    { "UnderBracket;" "\u0023b5" }
    { "UnderParenthesis;" "\u0023dd" }
    { "Union;" "\u0022c3" }
    { "UnionPlus;" "\u00228e" }
    { "Uogon;" "\u000172" }
    { "uogon;" "\u000173" }
    { "Uopf;" "\u01d54c" }
    { "uopf;" "\u01d566" }
    { "UpArrow;" "\u002191" }
    { "Uparrow;" "\u0021d1" }
    { "uparrow;" "\u002191" }
    { "UpArrowBar;" "\u002912" }
    { "UpArrowDownArrow;" "\u0021c5" }
    { "UpDownArrow;" "\u002195" }
    { "Updownarrow;" "\u0021d5" }
    { "updownarrow;" "\u002195" }
    { "UpEquilibrium;" "\u00296e" }
    { "upharpoonleft;" "\u0021bf" }
    { "upharpoonright;" "\u0021be" }
    { "uplus;" "\u00228e" }
    { "UpperLeftArrow;" "\u002196" }
    { "UpperRightArrow;" "\u002197" }
    { "Upsi;" "\u0003d2" }
    { "upsi;" "\u0003c5" }
    { "upsih;" "\u0003d2" }
    { "Upsilon;" "\u0003a5" }
    { "upsilon;" "\u0003c5" }
    { "UpTee;" "\u0022a5" }
    { "UpTeeArrow;" "\u0021a5" }
    { "upuparrows;" "\u0021c8" }
    { "urcorn;" "\u00231d" }
    { "urcorner;" "\u00231d" }
    { "urcrop;" "\u00230e" }
    { "Uring;" "\u00016e" }
    { "uring;" "\u00016f" }
    { "urtri;" "\u0025f9" }
    { "Uscr;" "\u01d4b0" }
    { "uscr;" "\u01d4ca" }
    { "utdot;" "\u0022f0" }
    { "Utilde;" "\u000168" }
    { "utilde;" "\u000169" }
    { "utri;" "\u0025b5" }
    { "utrif;" "\u0025b4" }
    { "uuarr;" "\u0021c8" }
    { "Uuml" "\xdc" }
    { "uuml" "\xfc" }
    { "Uuml;" "\xdc" }
    { "uuml;" "\xfc" }
    { "uwangle;" "\u0029a7" }
    { "vangrt;" "\u00299c" }
    { "varepsilon;" "\u0003f5" }
    { "varkappa;" "\u0003f0" }
    { "varnothing;" "\u002205" }
    { "varphi;" "\u0003d5" }
    { "varpi;" "\u0003d6" }
    { "varpropto;" "\u00221d" }
    { "vArr;" "\u0021d5" }
    { "varr;" "\u002195" }
    { "varrho;" "\u0003f1" }
    { "varsigma;" "\u0003c2" }
    { "varsubsetneq;" "\u00228a\u00fe00" }
    { "varsubsetneqq;" "\u002acb\u00fe00" }
    { "varsupsetneq;" "\u00228b\u00fe00" }
    { "varsupsetneqq;" "\u002acc\u00fe00" }
    { "vartheta;" "\u0003d1" }
    { "vartriangleleft;" "\u0022b2" }
    { "vartriangleright;" "\u0022b3" }
    { "Vbar;" "\u002aeb" }
    { "vBar;" "\u002ae8" }
    { "vBarv;" "\u002ae9" }
    { "Vcy;" "\u000412" }
    { "vcy;" "\u000432" }
    { "VDash;" "\u0022ab" }
    { "Vdash;" "\u0022a9" }
    { "vDash;" "\u0022a8" }
    { "vdash;" "\u0022a2" }
    { "Vdashl;" "\u002ae6" }
    { "Vee;" "\u0022c1" }
    { "vee;" "\u002228" }
    { "veebar;" "\u0022bb" }
    { "veeeq;" "\u00225a" }
    { "vellip;" "\u0022ee" }
    { "Verbar;" "\u002016" }
    { "verbar;" "|" }
    { "Vert;" "\u002016" }
    { "vert;" "|" }
    { "VerticalBar;" "\u002223" }
    { "VerticalLine;" "|" }
    { "VerticalSeparator;" "\u002758" }
    { "VerticalTilde;" "\u002240" }
    { "VeryThinSpace;" "\u00200a" }
    { "Vfr;" "\u01d519" }
    { "vfr;" "\u01d533" }
    { "vltri;" "\u0022b2" }
    { "vnsub;" "\u002282\u0020d2" }
    { "vnsup;" "\u002283\u0020d2" }
    { "Vopf;" "\u01d54d" }
    { "vopf;" "\u01d567" }
    { "vprop;" "\u00221d" }
    { "vrtri;" "\u0022b3" }
    { "Vscr;" "\u01d4b1" }
    { "vscr;" "\u01d4cb" }
    { "vsubnE;" "\u002acb\u00fe00" }
    { "vsubne;" "\u00228a\u00fe00" }
    { "vsupnE;" "\u002acc\u00fe00" }
    { "vsupne;" "\u00228b\u00fe00" }
    { "Vvdash;" "\u0022aa" }
    { "vzigzag;" "\u00299a" }
    { "Wcirc;" "\u000174" }
    { "wcirc;" "\u000175" }
    { "wedbar;" "\u002a5f" }
    { "Wedge;" "\u0022c0" }
    { "wedge;" "\u002227" }
    { "wedgeq;" "\u002259" }
    { "weierp;" "\u002118" }
    { "Wfr;" "\u01d51a" }
    { "wfr;" "\u01d534" }
    { "Wopf;" "\u01d54e" }
    { "wopf;" "\u01d568" }
    { "wp;" "\u002118" }
    { "wr;" "\u002240" }
    { "wreath;" "\u002240" }
    { "Wscr;" "\u01d4b2" }
    { "wscr;" "\u01d4cc" }
    { "xcap;" "\u0022c2" }
    { "xcirc;" "\u0025ef" }
    { "xcup;" "\u0022c3" }
    { "xdtri;" "\u0025bd" }
    { "Xfr;" "\u01d51b" }
    { "xfr;" "\u01d535" }
    { "xhArr;" "\u0027fa" }
    { "xharr;" "\u0027f7" }
    { "Xi;" "\u00039e" }
    { "xi;" "\u0003be" }
    { "xlArr;" "\u0027f8" }
    { "xlarr;" "\u0027f5" }
    { "xmap;" "\u0027fc" }
    { "xnis;" "\u0022fb" }
    { "xodot;" "\u002a00" }
    { "Xopf;" "\u01d54f" }
    { "xopf;" "\u01d569" }
    { "xoplus;" "\u002a01" }
    { "xotime;" "\u002a02" }
    { "xrArr;" "\u0027f9" }
    { "xrarr;" "\u0027f6" }
    { "Xscr;" "\u01d4b3" }
    { "xscr;" "\u01d4cd" }
    { "xsqcup;" "\u002a06" }
    { "xuplus;" "\u002a04" }
    { "xutri;" "\u0025b3" }
    { "xvee;" "\u0022c1" }
    { "xwedge;" "\u0022c0" }
    { "Yacute" "\xdd" }
    { "yacute" "\xfd" }
    { "Yacute;" "\xdd" }
    { "yacute;" "\xfd" }
    { "YAcy;" "\u00042f" }
    { "yacy;" "\u00044f" }
    { "Ycirc;" "\u000176" }
    { "ycirc;" "\u000177" }
    { "Ycy;" "\u00042b" }
    { "ycy;" "\u00044b" }
    { "yen" "\xa5" }
    { "yen;" "\xa5" }
    { "Yfr;" "\u01d51c" }
    { "yfr;" "\u01d536" }
    { "YIcy;" "\u000407" }
    { "yicy;" "\u000457" }
    { "Yopf;" "\u01d550" }
    { "yopf;" "\u01d56a" }
    { "Yscr;" "\u01d4b4" }
    { "yscr;" "\u01d4ce" }
    { "YUcy;" "\u00042e" }
    { "yucy;" "\u00044e" }
    { "yuml" "\xff" }
    { "Yuml;" "\u000178" }
    { "yuml;" "\xff" }
    { "Zacute;" "\u000179" }
    { "zacute;" "\u00017a" }
    { "Zcaron;" "\u00017d" }
    { "zcaron;" "\u00017e" }
    { "Zcy;" "\u000417" }
    { "zcy;" "\u000437" }
    { "Zdot;" "\u00017b" }
    { "zdot;" "\u00017c" }
    { "zeetrf;" "\u002128" }
    { "ZeroWidthSpace;" "\u00200b" }
    { "Zeta;" "\u000396" }
    { "zeta;" "\u0003b6" }
    { "Zfr;" "\u002128" }
    { "zfr;" "\u01d537" }
    { "ZHcy;" "\u000416" }
    { "zhcy;" "\u000436" }
    { "zigrarr;" "\u0021dd" }
    { "Zopf;" "\u002124" }
    { "zopf;" "\u01d56b" }
    { "Zscr;" "\u01d4b5" }
    { "zscr;" "\u01d4cf" }
    { "zwj;" "\u00200d" }
    { "zwnj;" "\u00200c" }
}

: numeric-charref ( str -- newstr )
    ";" ?tail drop dup first "xX" member?
    [ rest hex> ] [ dec> ] if invalid-charrefs ?at [
        dup { [ 0xD800 0xDFFF between? ] [ 0x10FFFF > ] } 1||
        [ drop "\u0FFFFD" ] [
            dup invalid-codepoints member?
            [ drop "" ] [ 1string ] if
        ] if
    ] unless ;

: named-charref ( str -- newstr )
    html5 ?at [
        ! find the longest matching name
        dup dup length 1 (a,b) [ head html5 at ] with map-find
        [ swapd tail append ] [ drop "&" prepend ] if*
    ] unless ;

: replace-charref ( str -- newstr )
    "#" ?head [ numeric-charref ] [ named-charref ] if ;

CONSTANT: re-charref
R/ &(#[0-9]+|#[xX][0-9a-fA-F]+|[^\t\n\f <&#;]{1,32});?/

PRIVATE>

: html-unescape ( str -- newstr )
    re-charref [ rest replace-charref ] re-replace-with ;
