.\" 
.\" EyeClock - A clock application for X. The eyes follow the mouse pointer.
.\" 
.\" EyeClock Copyright (C) 1998-1999 Sakai Hiroaki.
.\" All Rights Reserved.
.\" 
.\" EyeClock is a simple clock application for X11. You can put your favorite
.\" picture on the face of the clock. And you can move the eyes of the
.\" picture following the mouse pointer.
.\" 
.\" This file is a part of EyeClock.
.\" EyeClock is FREE SOFTWARE. You can use, copy, modify, and/or redistribute
.\" it freely under the terms in the COPYRIGHT.
.\" See the COPYRIGHT for more details.
.\" 
.TH EYECLOCK 1 "Release 6" "X Version 11"

.SH NAME

EyeClock - A clock application for X. The eyes follow the mouse pointer.

.SH SYNOPSIS

.B eyeclock [ options ]

.SH DESCRIPTION

EyeClock is a simple clock application for X11. You can put your favorite
picture on the face of the clock. And you can move the eyes of the
picture following the mouse pointer.

.SH RESOURCES

You can use all of the standard X-Toolkit resources.
Default resource file is "<XRoot>/lib/X11/app-defaults/EyeClock".

.TP 8
.B eyeclock.geometry : [WxH+X+Y]

This resource specifies the placement of the window on the screen.

.TP 8
.B eyeclock.title : [titlename]

This resource specifies the title of the clock.

.TP 8
.B eyeclock.iconName : [titlename]

This resource specifies the title of the clock in icon.

.TP 8
.B eyeclock.iconPixmap : [XPM or Bitmap file]

This resource specifies icon picture.

.TP 8
.B eyeclock.iconMask : [XPM or Bitmap file]

This resource specifies mask picture of icon.

.TP 8
.B eyeclock.background : [color]

This resource specifies background color of the clock.
This resource is available when the face picture is not specified.

.TP 8
.B eyeclock.clock.geometry : [WxH+X+Y]

This resource specifies the placement of the clock on the screen.

.TP 8
.B eyeclock.clock.root : [True : False]

Pasting the clock to the root window or not.

.TP 8
.B eyeclock.clock.face : [XPM file]

This resource specifies the face picture of the clock.
All pictures in EyeClock are XPM format.

.TP 8
.B eyeclock.clock.interval : [milli seconds]

This resource specifies the interval timer for milli seconds.
Default value of interval timer is 100.

.TP 8
.B eyeclock.clock.Hand.geometry : [TxL+X+Y]

This resource specifies the length, thickness, and placement
of the hands of the clock.
These parameters are specified by percentage of the clock size.

.TP 8
.B eyeclock.clock.Hand.active : [True : False]

The hands are active or not.

.TP 8
.B eyeclock.clock.Hand.foreground : [color]

This resource specifies color of hands.

.TP 8
.B eyeclock.clock.Hand.borderColor : [color]

This resource specifies edge color of hands.

.TP 8
.B eyeclock.clock.Hand.borderWidth : [x]

This resource specifies edge width of hands by percentage of the clock size.

.TP 8
.B eyeclock.clock.Hand.width : [x]

This resource specifies the width of hands by percentage of the clock size.

.TP 8
.B eyeclock.clock.Hand.length : [x]

This resource specifies the length of hands by percentage of the clock size.

.PP
Resources like "eyeclock.clock.hour.XXXXXXXX",
"eyeclock.clock.minute.XXXXXXXX",
"eyeclock.clock.second.XXXXXXXX" are equal to above resources.
Resource like "eyeclock.clock.Hand.XXXXXXXX" effects all hands.
Resource like "eyeclock.clock.hour.XXXXXXXX" effects only hour hand.

.TP 8
.B eyeclock.clock.Number.geometry : [WxH+X+Y]

This resource specifies the placement of the numbers on the clock.
X and Y specify the center of the numbers by percentage of the clock.

.TP 8
.B eyeclock.clock.Number.active : [True : False]

The numbers are active or not.

.TP 8
.B eyeclock.clock.Number.length : [x]

This resource specifies distance of the numbers from center of the clock.

.TP 8
.B eyeclock.clock.Number.figure : [XPM file]

This resource specifies the picture of the numbers.

.TP 8
.B eyeclock.clock.Number.mask : [XPM file]

This resource specifies the mask picture of the numbers.
If mask pictures are not specified, EyeClock makes mask pictures automatically.

.TP 8
.B eyeclock.clock.Number.size : [WxH]

This resource specifies the size of the pictures.

.PP
Resources like "eyeclock.clock.number1.XXXXXXXX",
"eyeclock.clock.number2.XXXXXXXX", ... , and,
"eyeclock.clock.number12.XXXXXXXX" are equal to above resources.
Resource like "eyeclock.clock.Number.XXXXXXXX" effects all numbers.
Resource like "eyeclock.clock.number1.XXXXXXXX" effects only number 1.

.TP 8
.B eyeclock.clock.Eye.geometry : [WxH+X+Y]

This resource specifies the placement of the eyes.

.TP 8
.B eyeclock.clock.Eye.active : [True : False]

The eyes are active or not.

.TP 8
.B eyeclock.clock.Eye.fillColor : [True : False]

Being full of background color or not.

.TP 8
.B eyeclock.clock.Eye.fillPixmap : [True : False]

Being full of mask picture or not.

.TP 8
.B eyeclock.clock.Eye.background : [color]

This resource specifies background color of the eyes.

.TP 8
.B eyeclock.clock.Eye.move [XxY]

This resource specifies speed of the eyes moving by percentage.
Default value is 100x100.

.TP 8
.B eyeclock.clock.Eye.limit [XxY]

This resource specifies limit of the eyes moving by percentage.
Default value is 75x75.

.TP 8
.B eyeclock.clock.Eye.offset [XxY]

This resource specifies offset of the eyes placement for adjustment.
Default value is 0x0.

.TP 8
.B eyeclock.clock.Eye.coreFigure [XPM file]

This resource specifies picture of the iris.

.TP 8
.B eyeclock.clock.Eye.coreMask [XPM file]

This resource specifies mask picture of the iris.
If mask pictures are not specified, EyeClock makes mask pictures automatically.

.TP 8
.B eyeclock.clock.Eye.eyeFigure [XPM file]

This resource specifies picture of the eyes.

.TP 8
.B eyeclock.clock.Eye.eyeMask [XPM file]

This resource specifies mask picture of the eyes.
If mask pictures are not specified, EyeClock makes mask pictures automatically.

.TP 8
.B eyeclock.clock.Eye.coreSize [WxH]

This resource specifies the size of the iris.

.TP 8
.B eyeclock.clock.Eye.eyeSize [WxH]

This resource specifies the size of the eyes.

Resources like "eyeclock.clock.left.XXXXXXXX",
"eyeclock.clock.right.XXXXXXXX",
"eyeclock.clock.eye3.XXXXXXXX", ... , and,
"eyeclock.clock.eye8.XXXXXXXX" are equal to above resources.
Resource like "eyeclock.clock.Eye.XXXXXXXX" effects all eyes.
Resource like "eyeclock.clock.left.XXXXXXXX" effects only left eye.

.SH OPTIONS

You can use all of the standard X-Toolkit options.

.TP 8
.B -display [displayname]

This option specifies the name of the X server to use.

.TP 8
.B -geometry [WxH+X+Y]

This option specifies the placement of the window on the screen.

.TP 8
.B -title [titlename]

This option specifies the title of the clock.

.TP 8
.B -name [name]

This option specifies the name of the application.

.TP 8
.B -background [color], -bg [color]

This option specifies background color of the clock.
This option is available when the face picture is not specified.

.TP 8
.B -icon-pixmap : [XPM file]

This option specifies icon picture.

.TP 8
.B -icon-mask : [XPM file]

This option specifies mask picture of icon.

.TP 8
.B -clock-geometry : [WxH+X+Y]

This option specifies the placement of the clock on the screen.

.TP 8
.B -root

Pasting the clock to the root window.

.TP 8
.B -no-root

Not pasting the clock to the root window.

.TP 8
.B -face [XPM file]

This option specifies the face picture of the clock.
All pictures in EyeClock are XPM format.

.TP 8
.B -interval [milli seconds]

This option specifies the interval timer for milli seconds.
Default value of interval timer is 100.

.TP 8
.B -hands-geometry [TxL+X+Y]

This option specifies the length, thickness, and placement
of the hands of the clock.
These parameters are specified by percentage of the clock size.

.TP 8
.B -hands-active

The hands are active.

.TP 8
.B -hands-no-active

The hands are not active.

.TP 8
.B -hands-foreground [color], -hands-fg [color]

This option specifies color of hands.

.TP 8
.B -hands-bordercolor [color], -hands-bc [color]

This resource specifies edge color of hands.

.TP 8
.B -hands-borderwidth [x], -hands-bw [x]

This option specifies edge width of hands by percentage of the clock size.

.TP 8
.B -hands-width [x]

This option specifies the width of the hands by percentage of the clock size.

.TP 8
.B -hands-length [x]

This option specifies the length of the hands by percentage of the clock size.

.PP
Options like "-hour-XXXXXXXX", "-minute-XXXXXXXX", and, "-second-XXXXXXXX"
are equal to above options.
Option like "-hands-XXXXXXXX" effects all hands.
Option like "-hour-XXXXXXXX" effects only hour hand.

.TP 8
.B -numbers-geometry [WxH+X+Y]

This option specifies the placement of the numbers on the clock.
X and Y specify the center of the numbers by percentage of the clock.

.TP 8
.B -numbers-active

The numbers are active.

.TP 8
.B -numbers-no-active

The numbers are not active.

.TP 8
.B -numbers-length [x]

This option specifies distance of the numbers from center of the clock.

.TP 8
.B -numbers-figure [XPM file]

This option specifies the picture of the numbers.

.TP 8
.B -numbers-mask [XPM file]

This resource specifies the mask picture of the numbers.
If mask pictures are not specified, EyeClock makes mask pictures automatically.

.TP 8
.B -numbers-size [WxH]

This resource specifies the size of the pictures.

.PP
Options like "-number1-XXXXXXXX", "-number2-XXXXXXXX", ... , and,
"-number12-XXXXXXXX" are equal to above options.
Option like "-numbers-XXXXXXXX" effects all numbers.
Option like "-number1-XXXXXXXX" effects only number 1.

.TP 8
.B -eyes-geometry [WxH+X+Y]

This option specifies the placement of the eyes.

.TP 8
.B -eyes-active

The eyes are active.

.TP 8
.B -eyes-no-active

The eyes are not active.

.TP 8
.B -eyes-fill-color

Being full of background color.

.TP 8
.B -eyes-no-fill-color

Not being full of background color.

.TP 8
.B -eyes-fill-pixmap

Being full of mask picture.

.TP 8
.B -eyes-no-fill-pixmap

Not being full of mask picture.

.TP 8
.B -eyes-background [color], -eyes-bg [color]

This option specifies background color of the eyes.

.TP 8
.B -eyes-move [XxY]

This option specifies speed of the eyes moving by percentage.
Default value is 100x100.

.TP 8
.B -eyes-limit [XxY]

This option specifies limit of the eyes moving by percentage.
Default value is 75x75.

.TP 8
.B -eyes-offset [XxY]

This option specifies offset of the eyes placement for adjustment.
Default value is 0x0.

.TP 8
.B -eyes-core-figure [XPM file]

This option specifies picture of the iris.

.TP 8
.B -eyes-core-mask [XPM file]

This option specifies mask picture of the iris.
If mask pictures are not specified, EyeClock makes mask pictures automatically.

.TP 8
.B -eyes-eye-figure [XPM file]

This option specifies picture of the eyes.

.TP 8
.B -eyes-eye-mask [XPM file]

This option specifies mask picture of the eyes.
If mask pictures are not specified, EyeClock makes mask pictures automatically.

.TP 8
.B -eyes-core-size [WxH]

This option specifies the size of the iris.

.TP 8
.B -eyes-eye-size [WxH]

This option specifies the size of the eyes.

.PP
Options like "-left-XXXXXXXX", "-right-XXXXXXXX", "-eye3-XXXXXXXX", ... , and,
"-eye8-XXXXXXXX" are equal to above options.
Option like "-eyes-XXXXXXXX" effects all eyes.
Option like "-left-XXXXXXXX" effects only left eye.

.SH "DEFAULT PICTURES"

If you use below letters for picture in options or resources,
you can use default pictures.

.TP 8
.B DefaultIconFace

Default icon picture.

.TP 8
.B DefaultFace

Default face of the clock.

.TP 8
.B DefaultLeftCore

Default left core(iris) picture of the face.

.TP 8
.B DefaultRightCore

Default right core(iris) picture of the face.

.TP 8
.B DefaultLeftEye

Default left eye picture of the face.

.TP 8
.B DefaultRightEye

Default right eye picture of the face.

.TP 8
.B DefaultNumber1 - DefaultNumber12

Default number pictures of the clock.

.TP 8
.B DefaultRNumber1 - DefaultRNumber12

Default number pictures of the clock. (Roman letters)

.TP 8
.B DefaultNumberBig

Default number picture of the clock. (Large ball)

.TP 8
.B DefaultNumberSmall

Default number picture of the clock. (Small ball)

.TP 8
.B DefaultNumberNeedle0 - DefaultNumberNeedle5

Default number pictures of the clock. (Like needle)

.PP

.SH KEY OPERATION

.TP 8
.B i

Iconify Window.

.TP 8
.B r

Resize the window to default size.

.TP 8
.B q, Ctrl-c

Quit.

.PP

.SH SIGNAL

.TP 8
.B SIGINT

EyeClock will end by recerving SIGINT.

.TP 8
.B SIGHUP

EyeClock will raise the window to the top by recerving SIGHUP.

.PP

.SH PERIOD

EyeClock use the functions time(3) and localtime(3).
Period of EyeClock depends on them.

.SH "SEE ALSO"

X(1)

.SH FILES

.TP 8
.B <XRoot>/lib/X11/EyeClock

COPYRIGHT, README, XPM files, etc...

.TP 8
.B <XRoot>/lib/X11/app-defaults/EyeClock

Specifies required resources.

.PP

.SH AUTHOR

Programed by
.B Sakai Hiroaki.
.br
E-Mail : sakai@seki.ee.kagu.sut.ac.jp
.br
http://www.seki.ee.kagu.sut.ac.jp/~sakai/myfreesoft.html

.SH SPECIAL THANKS

.B Tsukuno Sawako, Morimi Asuka, and Kazuya Hirobe
for drawing many sample pictures.
.br
.B Umehara Taro
for drawing a default face picture.
.br
.B Tanaka Makoto
for giving a sample picture.
.br
.B Hashimoto Jun
for many advices.
.br
.B Sakai Takeyasu
for many advices.

.SH COPYRIGHT
EyeClock Copyright (C) 1998-1999 Sakai Hiroaki.
.br
All Rights Reserved.
