/*****************************************************************************/
/* EyeClock - A clock application for X. The eyes follow the mouse pointer.  */
/*                                                                           */
/* EyeClock Copyright (C) 1998-1999 Sakai Hiroaki.                           */
/* All Rights Reserved.                                                      */
/*                                                                           */
/* EyeClock is a simple clock application for X11. You can put your favorite */
/* picture on the face of the clock. And you can move the eyes of the        */
/* picture following the mouse pointer.                                      */
/*                                                                           */
/* This file is a part of EyeClock.                                          */
/* EyeClock is FREE SOFTWARE. You can use, copy, modify, and/or redistribute */
/* it freely under the terms in the COPYRIGHT.                               */
/* See the COPYRIGHT for more details.                                       */
/*****************************************************************************/

/*****************************************************************************/
/* Eye å                                                          */
/* (Τ)                                                            */
/*===========================================================================*/
/* Υե                                                        */
/*---------------------------------------------------------------------------*/
/* Υեϡץ饤١ȤʥإåեǤ                        */
/* ץ饤١ȤʥФ˥Ȥʳˤϡ                          */
/* 󥯥롼ɤƻѤʤǤ                                    */
/* Υե򥤥󥯥롼ɤСץ饤١ȤʥФ˥        */
/* ǽˤʤޤ                                                          */
/*****************************************************************************/

#ifndef _EyeP_h_INCLUDED_
#define _EyeP_h_INCLUDED_

/*****************************************************************************/
/*                                                                   */
/*****************************************************************************/

#include "Eye.h"

/*****************************************************************************/
/* إåեΥ󥯥롼(ץ饤١Ȥʤ)                          */
/*****************************************************************************/

#include <X11/IntrinsicP.h>
#include <X11/CoreP.h>

#include <stdio.h>
#include <stdlib.h>

#include "converter.h"
#include "etc.h"

/*****************************************************************************/
/* (ץ饤١Ȥʤ)                                            */
/*****************************************************************************/

/* None */

/*****************************************************************************/
/* (ץ饤١Ȥʤ)                                              */
/*****************************************************************************/

/* åȤΥ󥹥󥹤Υ쥳ɤ */
typedef struct _EyePart {
  Boolean active; /* 褹뤫ʤΥե饰 */
  Boolean fill_color; /* Хå饦ɥ顼ɤĤ֤ */
  Boolean fill_pixmap; /* Eye ɤĤ֤ */;

  /* ƥå(Clock å)ΥΨ */
  int face_size; /* פʸĤΥ */
  int face_width; /* פʸĤ */
  int face_height; /* פʸĤι⤵ */
  int ratio, ratio_x, ratio_y; /* Ψ */

  Pixmap core_figure; /* ܤβ */
  Pixmap core_mask;   /* ܤΥޥ */
  Pixmap eye_figure;  /* ܤβ */
  Pixmap eye_mask;    /* ܤΥޥ */
  XPoint core_size; /* ܤΥ */
  XPoint eye_size;   /* ܤΥ */

  Pixmap work_figure; /* ܤѥԥåޥå */
  Pixmap work_mask;   /* ܤѥԥåޥå */

  XPoint move;   /* ܤΰưΨ */
  XPoint limit;  /* ܤΰưΥߥå */
  XPoint offset; /* ܤΰ֤Υեå*/

  /* ܤꥵ */
  Pixmap resized_core_figure;
  Pixmap resized_core_mask;
  Pixmap resized_eye_figure;
  Pixmap resized_eye_mask;
  int resized_core_width, resized_core_height;
  int resized_eye_width, resized_eye_height;

  /*  GC */
  GC gc_fill, gc_black, gc_white;
  GC gc_copy_copy, gc_copy_and, gc_copy_or, gc_copy_andinv;
} EyePart;

typedef struct _EyeRec {
  CorePart core;
  EyePart eye;
} EyeRec;

typedef struct _EyeClassPart {
  int dummy; /* ߡ */
} EyeClassPart;

typedef struct _EyeClassRec {
  CoreClassPart core_class;
  EyeClassPart eye_class;
} EyeClassRec;

/*****************************************************************************/
/* ѿ(ץ饤١Ȥʤ)                                        */
/*****************************************************************************/

extern EyeClassRec eyeClassRec;

/*****************************************************************************/
/* ؿ                                                                      */
/*****************************************************************************/

/* None */

/*****************************************************************************/
/* ޤ                                                                  */
/*****************************************************************************/

#endif

/*****************************************************************************/
/* End of File.                                                              */
/*****************************************************************************/
