/*****************************************************************************/
/* EyeClock - A clock application for X. The eyes follow the mouse pointer.  */
/*                                                                           */
/* EyeClock Copyright (C) 1998-1999 Sakai Hiroaki.                           */
/* All Rights Reserved.                                                      */
/*                                                                           */
/* EyeClock is a simple clock application for X11. You can put your favorite */
/* picture on the face of the clock. And you can move the eyes of the        */
/* picture following the mouse pointer.                                      */
/*                                                                           */
/* This file is a part of EyeClock.                                          */
/* EyeClock is FREE SOFTWARE. You can use, copy, modify, and/or redistribute */
/* it freely under the terms in the COPYRIGHT.                               */
/* See the COPYRIGHT for more details.                                       */
/*****************************************************************************/

/*****************************************************************************/
/* Clock å                                                        */
/* (Τ)                                                            */
/*===========================================================================*/
/* Υե                                                        */
/*---------------------------------------------------------------------------*/
/* Υեϡץ饤١ȤʥإåեǤ                        */
/* ץ饤١ȤʥФ˥Ȥʳˤϡ                          */
/* 󥯥롼ɤƻѤʤǤ                                    */
/* Υե򥤥󥯥롼ɤСץ饤١ȤʥФ˥        */
/* ǽˤʤޤ                                                          */
/*****************************************************************************/

#ifndef _ClockP_h_INCLUDED_
#define _ClockP_h_INCLUDED_

/*****************************************************************************/
/*                                                                   */
/*****************************************************************************/

#include "Clock.h"

/*****************************************************************************/
/* إåեΥ󥯥롼(ץ饤١Ȥʤ)                          */
/*****************************************************************************/

#include <X11/IntrinsicP.h>
#include <X11/CoreP.h>
#include <X11/CompositeP.h>
#include <X11/ConstrainP.h>

#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include "Hand.h"
#include "Number.h"
#include "Eye.h"

#include "converter.h"
#include "etc.h"

/*****************************************************************************/
/* (ץ饤١Ȥʤ)                                            */
/*****************************************************************************/

/* None */

/*****************************************************************************/
/* (ץ饤١Ȥʤ)                                              */
/*****************************************************************************/

/* åȤΥ󥹥󥹤Υ쥳ɤ */
typedef struct _ClockPart {
  Boolean root;             /* 롼ȥɥĥդ뤫ɤΥե饰 */
  Pixmap face;              /* פʸĤβ */
  unsigned int face_width;  /* פʸĤβ */
  unsigned int face_height; /* פʸĤν */
  Pixmap resized_face;      /* פʸĤβ̾ */
  Pixmap pixmap;            /* פʸĤĥդѥԥåޥå */
  int interval;             /* ޤΥ󥿡Х */
  XtIntervalId interval_id; /* ॢȤ ID */
  XPoint pointer;           /* ݥ󥿤κɸ¸ */
  time_t timer;             /* ޤ¸ */

  XtAppContext app_context; /* ץꥱ󡦥ƥ */

  GC gc_copy_copy;          /* ԡ GC */
  GC gc_fill;               /* ɤĤ֤ GC */
} ClockPart;

typedef struct _ClockRec {
  CorePart core;
  CompositePart composite;
  ConstraintPart constraint;
  ClockPart clock;
} ClockRec;

typedef struct _ClockClassPart {
  int dummy; /* ߡ */
} ClockClassPart;

typedef struct _ClockClassRec {
  CoreClassPart core_class;
  CompositeClassPart composite_class;
  ConstraintClassPart constraint_class;
  ClockClassPart clock_class;
} ClockClassRec;

typedef struct _ClockConstraintPart {
  int dummy; /* ߡ */
} ClockConstraintPart;

typedef struct _ClockConstraintsRec {
  ClockConstraintPart clock;
} ClockConstraintsRec;

/*****************************************************************************/
/* ѿ(ץ饤١Ȥʤ)                                        */
/*****************************************************************************/

extern ClockClassRec clockClassRec;

/*****************************************************************************/
/* ؿ                                                                      */
/*****************************************************************************/

/* None */

/*****************************************************************************/
/* ޤ                                                                  */
/*****************************************************************************/

#endif

/*****************************************************************************/
/* End of File.                                                              */
/*****************************************************************************/
