%% Generated by the Erlang ASN.1 BER compiler. Version: 5.4
%% Purpose: Encoding and decoding of the types in CMSAesRsaesOaep-2009.

-module('CMSAesRsaesOaep-2009').
-moduledoc false.
-compile(nowarn_unused_vars).
-dialyzer(no_improper_lists).
-dialyzer(no_match).
-include("CMSAesRsaesOaep-2009.hrl").
-asn1_info([{vsn,'5.4'},
            {module,'CMSAesRsaesOaep-2009'},
            {options,[{i,"/buildroot/otp/lib/public_key/asn1/../src"},
 warnings,ber,errors,
 {cwd,"/buildroot/otp/lib/public_key/asn1"},
 {outdir,"/buildroot/otp/lib/public_key/asn1/../src"},
 der,noobj,asn1config,
 {i,"."},
 {i,"/buildroot/otp/lib/public_key/asn1"}]}]).

-export([encoding_rule/0,maps/0,bit_string_format/0,
         legacy_erlang_types/0]).
-export(['dialyzer-suppressions'/1]).
-export([
'enc_AES-IV'/2
]).

-export([
'dec_AES-IV'/2
]).

-export([
'enc_cea-aes128-cbc'/3,
'enc_cea-aes192-cbc'/3,
'enc_cea-aes256-cbc'/3,
'enc_kwa-aes128-wrap'/3,
'enc_kwa-aes192-wrap'/3,
'enc_kwa-aes256-wrap'/3,
'enc_kwa-aes256-wrap_smimeCaps'/3,
'enc_kwa-aes192-wrap_smimeCaps'/3,
'enc_kwa-aes128-wrap_smimeCaps'/3,
'enc_cea-aes256-cbc_smimeCaps'/3,
'enc_cea-aes192-cbc_smimeCaps'/3,
'enc_cea-aes128-cbc_smimeCaps'/3
]).

-export([
'dec_cea-aes128-cbc'/3,
'dec_cea-aes192-cbc'/3,
'dec_cea-aes256-cbc'/3,
'dec_kwa-aes128-wrap'/3,
'dec_kwa-aes192-wrap'/3,
'dec_kwa-aes256-wrap'/3,
'dec_kwa-aes256-wrap_smimeCaps'/3,
'dec_kwa-aes192-wrap_smimeCaps'/3,
'dec_kwa-aes128-wrap_smimeCaps'/3,
'dec_cea-aes256-cbc_smimeCaps'/3,
'dec_cea-aes192-cbc_smimeCaps'/3,
'dec_cea-aes128-cbc_smimeCaps'/3
]).

-export([
'getenc_AES-ContentEncryption'/1,
'getenc_AES-KeyWrap'/1,
getenc_SMimeCaps/1
]).

-export([
'getdec_AES-ContentEncryption'/1,
'getdec_AES-KeyWrap'/1,
getdec_SMimeCaps/1
]).

-export([
aes/0,
'id-aes128-CBC'/0,
'id-aes192-CBC'/0,
'id-aes256-CBC'/0,
'id-aes128-wrap'/0,
'id-aes192-wrap'/0,
'id-aes256-wrap'/0
]).

-export([info/0]).

-export([encode/2,decode/2]).

encoding_rule() -> ber.

maps() -> false.

bit_string_format() -> bitstring.

legacy_erlang_types() -> false.

encode(Type, Data) ->
try iolist_to_binary(element(1, encode_disp(Type, Data))) of
  Bytes ->
    {ok,Bytes}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.


decode(Type, Data) ->
try
   Result = decode_disp(Type, element(1, ber_decode_nif(Data))),
   {ok,Result}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.

encode_disp('AES-IV', Data) -> 'enc_AES-IV'(Data);
encode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

decode_disp('AES-IV', Data) -> 'dec_AES-IV'(Data);
decode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

info() ->
   case ?MODULE:module_info(attributes) of
     Attributes when is_list(Attributes) ->
       case lists:keyfind(asn1_info, 1, Attributes) of
         {_,Info} when is_list(Info) ->
           Info;
         _ ->
           []
       end;
     _ ->
       []
   end.


%%================================
%%  AES-IV
%%================================
'enc_AES-IV'(Val) ->
    'enc_AES-IV'(Val, [<<4>>]).

'enc_AES-IV'(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


'dec_AES-IV'(Tlv) ->
   'dec_AES-IV'(Tlv, [4]).

'dec_AES-IV'(Tlv, TagIn) ->
begin
Val1 = decode_octet_string(Tlv, TagIn),
C1 = byte_size(Val1),
if C1 =:= 16 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end.

aes() ->
{2,16,840,1,101,3,4,1}.

'id-aes128-CBC'() ->
{2,16,840,1,101,3,4,1,2}.

'id-aes192-CBC'() ->
{2,16,840,1,101,3,4,1,22}.

'id-aes256-CBC'() ->
{2,16,840,1,101,3,4,1,42}.

'id-aes128-wrap'() ->
{2,16,840,1,101,3,4,1,5}.

'id-aes192-wrap'() ->
{2,16,840,1,101,3,4,1,25}.

'id-aes256-wrap'() ->
{2,16,840,1,101,3,4,1,45}.




%%================================
%%  cea-aes128-cbc
%%================================
'enc_cea-aes128-cbc'('Params', Val, _RestPrimFieldName) ->
   'enc_AES-IV'(Val, [<<4>>]);
'enc_cea-aes128-cbc'(smimeCaps,  Val, [H|T]) ->
   'enc_cea-aes128-cbc_smimeCaps'(H, Val, T).


'dec_cea-aes128-cbc'('Params', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'dec_AES-IV'(Tlv, [4]);
'dec_cea-aes128-cbc'(smimeCaps, Bytes,[H|T]) ->
   'dec_cea-aes128-cbc_smimeCaps'(H, Bytes, T).

tlv_format(Bytes) when is_binary(Bytes) ->
  {Tlv,_} = ber_decode_nif(Bytes),
  Tlv;
tlv_format(Bytes) ->
  Bytes.



%%================================
%%  cea-aes192-cbc
%%================================
'enc_cea-aes192-cbc'('Params', Val, _RestPrimFieldName) ->
   'enc_AES-IV'(Val, [<<4>>]);
'enc_cea-aes192-cbc'(smimeCaps,  Val, [H|T]) ->
   'enc_cea-aes192-cbc_smimeCaps'(H, Val, T).


'dec_cea-aes192-cbc'('Params', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'dec_AES-IV'(Tlv, [4]);
'dec_cea-aes192-cbc'(smimeCaps, Bytes,[H|T]) ->
   'dec_cea-aes192-cbc_smimeCaps'(H, Bytes, T).




%%================================
%%  cea-aes256-cbc
%%================================
'enc_cea-aes256-cbc'('Params', Val, _RestPrimFieldName) ->
   'enc_AES-IV'(Val, [<<4>>]);
'enc_cea-aes256-cbc'(smimeCaps,  Val, [H|T]) ->
   'enc_cea-aes256-cbc_smimeCaps'(H, Val, T).


'dec_cea-aes256-cbc'('Params', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'dec_AES-IV'(Tlv, [4]);
'dec_cea-aes256-cbc'(smimeCaps, Bytes,[H|T]) ->
   'dec_cea-aes256-cbc_smimeCaps'(H, Bytes, T).




%%================================
%%  kwa-aes128-wrap
%%================================
'enc_kwa-aes128-wrap'('Params', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_kwa-aes128-wrap'(smimeCaps,  Val, [H|T]) ->
   'enc_kwa-aes128-wrap_smimeCaps'(H, Val, T).


'dec_kwa-aes128-wrap'('Params',  Bytes,_) ->
   Bytes;
'dec_kwa-aes128-wrap'(smimeCaps, Bytes,[H|T]) ->
   'dec_kwa-aes128-wrap_smimeCaps'(H, Bytes, T).




%%================================
%%  kwa-aes192-wrap
%%================================
'enc_kwa-aes192-wrap'('Params', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_kwa-aes192-wrap'(smimeCaps,  Val, [H|T]) ->
   'enc_kwa-aes192-wrap_smimeCaps'(H, Val, T).


'dec_kwa-aes192-wrap'('Params',  Bytes,_) ->
   Bytes;
'dec_kwa-aes192-wrap'(smimeCaps, Bytes,[H|T]) ->
   'dec_kwa-aes192-wrap_smimeCaps'(H, Bytes, T).




%%================================
%%  kwa-aes256-wrap
%%================================
'enc_kwa-aes256-wrap'('Params', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_kwa-aes256-wrap'(smimeCaps,  Val, [H|T]) ->
   'enc_kwa-aes256-wrap_smimeCaps'(H, Val, T).


'dec_kwa-aes256-wrap'('Params',  Bytes,_) ->
   Bytes;
'dec_kwa-aes256-wrap'(smimeCaps, Bytes,[H|T]) ->
   'dec_kwa-aes256-wrap_smimeCaps'(H, Bytes, T).




%%================================
%%  kwa-aes256-wrap_smimeCaps
%%================================
'enc_kwa-aes256-wrap_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_kwa-aes256-wrap_smimeCaps'('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  kwa-aes192-wrap_smimeCaps
%%================================
'enc_kwa-aes192-wrap_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_kwa-aes192-wrap_smimeCaps'('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  kwa-aes128-wrap_smimeCaps
%%================================
'enc_kwa-aes128-wrap_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_kwa-aes128-wrap_smimeCaps'('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  cea-aes256-cbc_smimeCaps
%%================================
'enc_cea-aes256-cbc_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_cea-aes256-cbc_smimeCaps'('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  cea-aes192-cbc_smimeCaps
%%================================
'enc_cea-aes192-cbc_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_cea-aes192-cbc_smimeCaps'('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  cea-aes128-cbc_smimeCaps
%%================================
'enc_cea-aes128-cbc_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_cea-aes128-cbc_smimeCaps'('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  AES-ContentEncryption
%%================================
'getenc_AES-ContentEncryption'(Id) when Id =:= {2,16,840,1,101,3,4,1,2} ->
    fun 'enc_cea-aes128-cbc'/3;
'getenc_AES-ContentEncryption'(Id) when Id =:= {2,16,840,1,101,3,4,1,22} ->
    fun 'enc_cea-aes192-cbc'/3;
'getenc_AES-ContentEncryption'(Id) when Id =:= {2,16,840,1,101,3,4,1,42} ->
    fun 'enc_cea-aes256-cbc'/3;
'getenc_AES-ContentEncryption'(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_AES-ContentEncryption'(Id) when Id =:= {2,16,840,1,101,3,4,1,2} ->
    fun 'dec_cea-aes128-cbc'/3;
'getdec_AES-ContentEncryption'(Id) when Id =:= {2,16,840,1,101,3,4,1,22} ->
    fun 'dec_cea-aes192-cbc'/3;
'getdec_AES-ContentEncryption'(Id) when Id =:= {2,16,840,1,101,3,4,1,42} ->
    fun 'dec_cea-aes256-cbc'/3;
'getdec_AES-ContentEncryption'(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  AES-KeyWrap
%%================================
'getenc_AES-KeyWrap'(Id) when Id =:= {2,16,840,1,101,3,4,1,5} ->
    fun 'enc_kwa-aes128-wrap'/3;
'getenc_AES-KeyWrap'(Id) when Id =:= {2,16,840,1,101,3,4,1,25} ->
    fun 'enc_kwa-aes192-wrap'/3;
'getenc_AES-KeyWrap'(Id) when Id =:= {2,16,840,1,101,3,4,1,45} ->
    fun 'enc_kwa-aes256-wrap'/3;
'getenc_AES-KeyWrap'(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_AES-KeyWrap'(Id) when Id =:= {2,16,840,1,101,3,4,1,5} ->
    fun 'dec_kwa-aes128-wrap'/3;
'getdec_AES-KeyWrap'(Id) when Id =:= {2,16,840,1,101,3,4,1,25} ->
    fun 'dec_kwa-aes192-wrap'/3;
'getdec_AES-KeyWrap'(Id) when Id =:= {2,16,840,1,101,3,4,1,45} ->
    fun 'dec_kwa-aes256-wrap'/3;
'getdec_AES-KeyWrap'(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  SMimeCaps
%%================================
getenc_SMimeCaps({2,16,840,1,101,3,4,1,2}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCaps({2,16,840,1,101,3,4,1,5}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCaps({2,16,840,1,101,3,4,1,22}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCaps({2,16,840,1,101,3,4,1,25}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCaps({2,16,840,1,101,3,4,1,42}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCaps({2,16,840,1,101,3,4,1,45}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCaps(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_SMimeCaps'({2,16,840,1,101,3,4,1,2}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_SMimeCaps'({2,16,840,1,101,3,4,1,5}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_SMimeCaps'({2,16,840,1,101,3,4,1,22}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_SMimeCaps'({2,16,840,1,101,3,4,1,25}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_SMimeCaps'({2,16,840,1,101,3,4,1,42}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_SMimeCaps'({2,16,840,1,101,3,4,1,45}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
getdec_SMimeCaps(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.



%%%
%%% Run-time functions.
%%%

'dialyzer-suppressions'(Arg) ->
    ok.

ber_decode_nif(B) ->
    asn1rt_nif:decode_ber_tlv(B).

ber_encode([Tlv]) ->
    ber_encode(Tlv);
ber_encode(Tlv) when is_binary(Tlv) ->
    Tlv;
ber_encode(Tlv) ->
    asn1rt_nif:encode_ber_tlv(Tlv).

collect_parts(TlvList) ->
    collect_parts(TlvList, []).

collect_parts([{_, L} | Rest], Acc) when is_list(L) ->
    collect_parts(Rest, [collect_parts(L) | Acc]);
collect_parts([{3, <<Unused,Bits/binary>>} | Rest], _Acc) ->
    collect_parts_bit(Rest, [Bits], Unused);
collect_parts([{_T, V} | Rest], Acc) ->
    collect_parts(Rest, [V | Acc]);
collect_parts([], Acc) ->
    list_to_binary(lists:reverse(Acc)).

collect_parts_bit([{3, <<Unused,Bits/binary>>} | Rest], Acc, Uacc) ->
    collect_parts_bit(Rest, [Bits | Acc], Unused + Uacc);
collect_parts_bit([], Acc, Uacc) ->
    list_to_binary([Uacc | lists:reverse(Acc)]).

decode_octet_string(Tlv, TagsIn) ->
    Bin = match_and_collect(Tlv, TagsIn),
    binary:copy(Bin).

encode_length(L) when L =< 127 ->
    {[L], 1};
encode_length(L) ->
    Oct = minimum_octets(L),
    Len = length(Oct),
    if
        Len =< 126 ->
            {[128 bor Len | Oct], Len + 1};
        true ->
            exit({error, {asn1, too_long_length_oct, Len}})
    end.

encode_restricted_string(OctetList, TagIn) when is_binary(OctetList) ->
    encode_tags(TagIn, OctetList, byte_size(OctetList));
encode_restricted_string(OctetList, TagIn) when is_list(OctetList) ->
    encode_tags(TagIn, OctetList, length(OctetList)).

encode_tags([Tag | Trest], BytesSoFar, LenSoFar) ->
    {Bytes2, L2} = encode_length(LenSoFar),
    encode_tags(Trest,
                [Tag, Bytes2 | BytesSoFar],
                LenSoFar + byte_size(Tag) + L2);
encode_tags([], BytesSoFar, LenSoFar) ->
    {BytesSoFar, LenSoFar}.

match_and_collect(Tlv, TagsIn) ->
    Val = match_tags(Tlv, TagsIn),
    case Val of
        [_ | _] = PartList ->
            collect_parts(PartList);
        Bin when is_binary(Bin) ->
            Bin
    end.

match_tags({T, V}, [T]) ->
    V;
match_tags({T, V}, [T | Tt]) ->
    match_tags(V, Tt);
match_tags([{T, V}], [T | Tt]) ->
    match_tags(V, Tt);
match_tags([{T, _V} | _] = Vlist, [T]) ->
    Vlist;
match_tags(Tlv, []) ->
    Tlv;
match_tags({Tag, _V} = Tlv, [T | _Tt]) ->
    exit({error, {asn1, {wrong_tag, {{expected, T}, {got, Tag, Tlv}}}}}).

minimum_octets(0, Acc) ->
    Acc;
minimum_octets(Val, Acc) ->
    minimum_octets(Val bsr 8, [Val band 255 | Acc]).

minimum_octets(Val) ->
    minimum_octets(Val, []).
