searchData={"items":[{"type":"module","title":"crashdump_viewer","doc":"A WxWidgets based tool for browsing Erlang crashdumps.\n\nFor details about how to get started with the Crashdump Viewer, see the\n[User's Guide](crashdump_ug.md).","ref":"crashdump_viewer.html"},{"type":"function","title":"crashdump_viewer.start/0","doc":"Starts the Crashdump Viewer GUI and opens a file dialog where the\ncrashdump can be selected.","ref":"crashdump_viewer.html#start/0"},{"type":"function","title":"crashdump_viewer.start/1","doc":"Starts the Crashdump Viewer GUI and loads the specified crashdump.","ref":"crashdump_viewer.html#start/1"},{"type":"function","title":"crashdump_viewer.stop/0","doc":"Terminates the Crashdump Viewer and closes all GUI windows.","ref":"crashdump_viewer.html#stop/0"},{"type":"module","title":"etop","doc":"Erlang Top is a tool for presenting information about Erlang processes similar\nto the information presented by \"top\" in UNIX.\n\nStart Erlang Top with the provided scripts `etop`. This starts a hidden Erlang\nnode that connects to the node to be measured. The measured node is specified\nwith option `-node`. If the measured node has a different cookie than the\ndefault cookie for the user who invokes the script, the cookie must be\nexplicitly specified with option `-setcookie`.\n\nUnder Windows, batch file `etop.bat` can be used.\n\nWhen executing the `etop` script, configuration parameters can be specified as\ncommand-line options, for example,\n`etop -node testnode@myhost -setcookie MyCookie`. The following configuration\nparameters exist for the tool:\n\n- **`node`** - The measured node.\n\n  Value: `t:atom/0`\n\n  Mandatory\n\n- **`setcookie`** - Cookie to use for the `etop` node. Must be same as the\n  cookie on the measured node.\n\n  Value: `t:atom/0`\n\n- **`lines`** - Number of lines (processes) to display.\n\n  Value: `t:integer/0`\n\n  Default: `10`\n\n- **`interval`** - Time interval (in seconds) between each update of the\n  display.\n\n  Value: `t:integer/0`\n\n  Default: `5`\n\n- **`accumulate`** - If `true`, the execution time and reductions are\n  accumulated.\n\n  Value: `t:boolean/0`\n\n  Default: `false`\n\n- **`sort`** - Identifies what information to sort by.\n\n  Value: `runtime | reductions | memory | msg_q`\n\n  Default: `runtime` (`reductions` if `tracing=off`)\n\n- **`tracing`** - `etop` uses the Erlang trace facility, and thus no other\n  tracing is possible on the measured node while `etop` is running, unless this\n  option is set to `off`. Also helpful if the `etop` tracing causes too high\n  load on the measured node. With tracing off, runtime is not measured.\n\n  Value: `on | off`\n\n  Default: `on`\n\nFor details about Erlang Top, see the [User's Guide](etop_ug.md).","ref":"etop.html"},{"type":"function","title":"etop.config/2","doc":"Changes the configuration parameters of the tool during runtime. Allowed\nparameters are `lines`, `interval`, `accumulate`, and `sort`.","ref":"etop.html#config/2"},{"type":"function","title":"etop.dump/1","doc":"Dumps the current display to a text file.","ref":"etop.html#dump/1"},{"type":"function","title":"etop.help/0","doc":"Displays the help of `etop` and its options.","ref":"etop.html#help/0"},{"type":"function","title":"etop.start/0","doc":"Starts `etop`. Notice that `etop` is preferably started with the `etop` script.","ref":"etop.html#start/0"},{"type":"function","title":"etop.start/1","doc":"Starts `etop`. To view the possible options, use `help/0`.","ref":"etop.html#start/1"},{"type":"function","title":"etop.stop/0","doc":"Terminates `etop`.","ref":"etop.html#stop/0"},{"type":"module","title":"observer","doc":"A GUI tool for observing an Erlang system.\n\nObserver is a graphical tool for observing the characteristics of Erlang\nsystems. The tool Observer displays system information, application supervisor\ntrees, process information, ETS tables, Mnesia tables, and contains a front end\nfor Erlang tracing with module `m:ttb`.\n\nFor details about how to get started, see the [`User's Guide`](observer_ug.md).","ref":"observer.html"},{"type":"function","title":"observer.start/0","doc":"Starts the Observer GUI. To stop the tool, close the window or call `stop/0`.","ref":"observer.html#start/0"},{"type":"function","title":"observer.start/1","doc":"Starts the Observer GUI and tries to connect it to `Node`.","ref":"observer.html#start/1"},{"type":"function","title":"observer.start_and_wait/0","doc":"Starts the Observer GUI and only return when it is either stopped or the window\nis closed","ref":"observer.html#start_and_wait/0"},{"type":"function","title":"observer.start_and_wait/1","doc":"Starts the Observer GUI and only return when it is either stopped or the window\nis closed, connects it directly to `Node` like `start/1`.","ref":"observer.html#start_and_wait/1"},{"type":"function","title":"observer.stop/0","doc":"Stops the Observer GUI.","ref":"observer.html#stop/0"},{"type":"module","title":"ttb","doc":"A base for building trace tools for distributed systems.\n\nThe Trace Tool Builder, `ttb`, is a base for building trace tools for\ndistributed systems.\n\nWhen using `ttb`, do not use module `dbg` in application Runtime_Tools in\nparallel.","ref":"ttb.html"},{"type":"function","title":"ttb.ctp/0","doc":"","ref":"ttb.html#ctp/0"},{"type":"function","title":"ttb.ctp/1","doc":"","ref":"ttb.html#ctp/1"},{"type":"function","title":"ttb.ctp/2","doc":"","ref":"ttb.html#ctp/2"},{"type":"function","title":"ttb.ctp/3","doc":"","ref":"ttb.html#ctp/3"},{"type":"function","title":"ttb.ctpe/1","doc":"","ref":"ttb.html#ctpe/1"},{"type":"function","title":"ttb.ctpg/0","doc":"","ref":"ttb.html#ctpg/0"},{"type":"function","title":"ttb.ctpg/1","doc":"","ref":"ttb.html#ctpg/1"},{"type":"function","title":"ttb.ctpg/2","doc":"","ref":"ttb.html#ctpg/2"},{"type":"function","title":"ttb.ctpg/3","doc":"","ref":"ttb.html#ctpg/3"},{"type":"function","title":"ttb.ctpl/0","doc":"","ref":"ttb.html#ctpl/0"},{"type":"function","title":"ttb.ctpl/1","doc":"","ref":"ttb.html#ctpl/1"},{"type":"function","title":"ttb.ctpl/2","doc":"","ref":"ttb.html#ctpl/2"},{"type":"function","title":"ttb.ctpl/3","doc":"","ref":"ttb.html#ctpl/3"},{"type":"function","title":"ttb.format/1","doc":"","ref":"ttb.html#format/1"},{"type":"function","title":"ttb.format/2","doc":"Reads the specified binary trace log(s). The logs are processed in the order of\ntheir time stamps as long as option `disable_sort` is not specified.\n\nIf `FormatHandler = {Function,InitialState}`, `Function` is called for each\ntrace message.\n\nIf `FormatHandler = get_et_handler()`, `et_viewer` in application ET is used for\npresenting the trace log graphically. `ttb` provides a few different filters\nthat can be selected from menu _Filters and scaling_ in the `et_viewer`.\n\nIf `FormatHandler` is not specified, a default handler is used presenting each\ntrace message as a text line.\n\nThe state returned from each call of `Function` is passed to the next call, even\nif the next call is to format a message from another log file.\n\nIf `Out` is specified, `FormatHandler` gets the file descriptor to `Out` as the\nfirst parameter.\n\n`Out` is ignored if the `et` format handler is used.\n\nWrap logs can be formatted one by one or all at once. To format one of the wrap\nlogs in a set, specify the exact file name. To format the whole set of wrap\nlogs, specify the name with `*` instead of the wrap count. For examples, see the\n[`User's Guide`](ttb_ug.md#format).","ref":"ttb.html#format/2"},{"type":"type","title":"ttb.format_fun/0","doc":"","ref":"ttb.html#t:format_fun/0"},{"type":"type","title":"ttb.format_handler/0","doc":"","ref":"ttb.html#t:format_handler/0"},{"type":"type","title":"ttb.format_opt/0","doc":"","ref":"ttb.html#t:format_opt/0"},{"type":"type","title":"ttb.format_opts/0","doc":"","ref":"ttb.html#t:format_opts/0"},{"type":"function","title":"ttb.get_et_handler/0","doc":"Returns the `et` handler, which can be used with [`format/2`](`format/2`) or\n[`tracer/2`](`tracer/2`).\n\nExample: `ttb:format(Dir, [{handler, ttb:get_et_handler()}])`.","ref":"ttb.html#get_et_handler/0"},{"type":"type","title":"ttb.item/0","doc":"","ref":"ttb.html#t:item/0"},{"type":"function","title":"ttb.list_config/1","doc":"Lists all entries in the specified configuration file.","ref":"ttb.html#list_config/1"},{"type":"function","title":"ttb.list_history/0","doc":"All calls to `ttb` is stored in the history. This function returns the current\ncontent of the history. Any entry can be reexecuted with\n[`run_history/1`](`run_history/1`) or stored in a configuration file with\n`write_config/2,3`.","ref":"ttb.html#list_history/0"},{"type":"type","title":"ttb.match_desc/0","doc":"","ref":"ttb.html#t:match_desc/0"},{"type":"type","title":"ttb.match_spec/0","doc":"","ref":"ttb.html#t:match_spec/0"},{"type":"type","title":"ttb.mfas/0","doc":"","ref":"ttb.html#t:mfas/0"},{"type":"type","title":"ttb.nodes/0","doc":"","ref":"ttb.html#t:nodes/0"},{"type":"function","title":"ttb.p/2","doc":"Sets the specified trace flags on the specified processes or ports. Flag\n`timestamp` is always turned on.\n\nSee the Reference Manual for module `m:dbg` for the possible trace flags.\nParameter `MatchDesc` is the same as returned from `dbg:p/2`.\n\nProcesses can be specified as registered names, globally registered names, or\nprocess identifiers. Ports can be specified as registered names or port\nidentifiers. If a registered name is specified, the flags are set on\nprocesses/ports with this name on all active nodes.\n\nIssuing this command starts the timer for this trace if option `timer` is\nspecified with [`tracer/2`](`tracer/2`).","ref":"ttb.html#p/2"},{"type":"function","title":"ttb.run_config/1","doc":"Executes all entries in the specified configuration file. Notice that the\nhistory of the last trace is always available in file `ttb_last_config`.","ref":"ttb.html#run_config/1"},{"type":"function","title":"ttb.run_config/2","doc":"Executes selected entries from the specified configuration file. `NumList` is a\nlist of integers pointing out the entries to be executed.\n\nTo list the contents of a configuration file, use\n[`list_config/1`](`list_config/1`).\n\nNotice that the history of the last trace is always available in file\n`ttb_last_config`.","ref":"ttb.html#run_config/2"},{"type":"function","title":"ttb.run_history/1","doc":"Executes the specified entry or entries from the history list. To list history,\nuse `list_history/0`.","ref":"ttb.html#run_history/1"},{"type":"function","title":"ttb.seq_trigger_ms/0","doc":"","ref":"ttb.html#seq_trigger_ms/0"},{"type":"function","title":"ttb.seq_trigger_ms/1","doc":"A match specification can turn on or off sequential tracing. This function\nreturns a match specification, which turns on sequential tracing with the\nspecified `Flags`.\n\nThis match specification can be specified as the last argument to `tp` or `tpl`.\nThe activated `Item` then becomes a _trigger_ for sequential tracing. This means\nthat if the item is called on a process with trace flag `call` set, the process\nis \"contaminated\" with token `seq_trace`.\n\nIf `Flags = all`, all possible flags are set.\n\nThe possible values for `SeqTraceFlag` are available in `m:seq_trace`.\n\nFor a description of the `match_spec()` syntax, see section\n[`Match Specifications in Erlang`](`e:erts:match_spec.md`) in ERTS, which\nexplains the general match specification \"language\".\n\n> #### Note {: .info }\n>\n> The _system tracer_ for sequential tracing is automatically initiated by `ttb`\n> when a trace port is started with `ttb:tracer/0,1,2`.\n\nAn example of how to use function `seq_trigger_ms/0,1` follows:\n\n```erlang\n(tiger@durin)5> ttb:tracer().\n{ok,[tiger@durin]}\n(tiger@durin)6> ttb:p(all,call).\n{ok,{[all],[call]}}\n(tiger@durin)7> ttb:tp(mod,func,ttb:seq_trigger_ms()).\n{ok,[{matched,1},{saved,1}]}\n(tiger@durin)8>\n```\n\nWhenever `mod:func(...)` is called after this, token `seq_trace` is set on the\nexecuting process.","ref":"ttb.html#seq_trigger_ms/1"},{"type":"function","title":"ttb.start_trace/4","doc":"This function is a shortcut allowing to start a trace with one command. Each\ntuple in `Patterns` is converted to a list, which in turn is passed to\n`ttb:tpl/2,3,4`.\n\nThe call:\n\n```erlang\n> ttb:start_trace([Node, OtherNode],\n                  [{mod, foo, []}, {mod, bar, 2}],\n                  {all, call},\n                  [{file, File}, {handler,{fun myhandler/4, S}}]).\n```\n\nis equivalent to:\n\n```erlang\n> ttb:start_trace([Node, OtherNode],\n                  [{file, File}, {handler,{fun myhandler/4, S}}]),\nttb:tpl(mod, foo, []),\nttb:tpl(mod, bar, 2, []),\nttb:p(all, call).\n```","ref":"ttb.html#start_trace/4"},{"type":"function","title":"ttb.stop/0","doc":"Equivalent to [`stop([])`](`stop/1`).","ref":"ttb.html#stop/0"},{"type":"function","title":"ttb.stop/1","doc":"Stops tracing on all nodes. Logs and trace information files are sent to the\ntrace control node and stored in a directory named\n`ttb_upload_FileName-Timestamp`, where `Filename` is the one provided with\n`{file, File}` during trace setup and `Timestamp` is of the form\n`yyyymmdd-hhmmss`. Even logs from nodes on the same machine as the trace control\nnode are moved to this directory. The history list is saved to a file named\n`ttb_last_config` for further reference (as it is no longer accessible through\nhistory and configuration management functions, like `ttb:list_history/0`).\n\n_Options:_\n\n- **`nofetch`** - Indicates that trace logs are not to be collected after\n  tracing is stopped.\n\n- **`{fetch, Dir}`** - Allows specification of the directory to fetch the data\n  to. If the directory already exists, an error is thrown.\n\n- **`format`** - Indicates the trace logs to be formatted after tracing is\n  stopped. All logs in the fetch directory are merged.\n\n- **`return_fetch_dir`** - Indicates the return value to be `{stopped, Dir}` and\n  not just `stopped`. This implies `fetch`.","ref":"ttb.html#stop/1"},{"type":"type","title":"ttb.stop_opt/0","doc":"","ref":"ttb.html#t:stop_opt/0"},{"type":"type","title":"ttb.stop_opts/0","doc":"","ref":"ttb.html#t:stop_opts/0"},{"type":"function","title":"ttb.tp/2","doc":"","ref":"ttb.html#tp/2"},{"type":"function","title":"ttb.tp/3","doc":"","ref":"ttb.html#tp/3"},{"type":"function","title":"ttb.tp/4","doc":"","ref":"ttb.html#tp/4"},{"type":"type","title":"ttb.tp_arity/0","doc":"","ref":"ttb.html#t:tp_arity/0"},{"type":"type","title":"ttb.tp_function/0","doc":"","ref":"ttb.html#t:tp_function/0"},{"type":"type","title":"ttb.tp_module/0","doc":"","ref":"ttb.html#t:tp_module/0"},{"type":"function","title":"ttb.tpe/2","doc":"","ref":"ttb.html#tpe/2"},{"type":"function","title":"ttb.tpl/2","doc":"","ref":"ttb.html#tpl/2"},{"type":"function","title":"ttb.tpl/3","doc":"","ref":"ttb.html#tpl/3"},{"type":"function","title":"ttb.tpl/4","doc":"These functions are to be used with trace flag `call`, `send`, and `'receive'`\nfor setting and clearing trace patterns.\n\nWhen trace flag `call` is set on a process, function calls are traced on that\nprocess if a trace pattern is set for the called function.\n\nThe `send` and `'receive'` flags enable tracing of all messages sent and\nreceived by the process/port. Trace patterns set with `tpe` may limit traced\nmessages based on the message content, the sender, and/or the receiver.\n\nTrace patterns specify how to trace a function or a message by using match\nspecifications. Match specifications are described in the\n[`ERTS User's Guide`](`e:erts:match_spec.md`).\n\nThese functions are equivalent to the corresponding functions in module `m:dbg`,\nbut all calls are stored in the history. The history buffer makes it easy to\ncreate configuration files; the same trace environment can be set up many times,\nfor example, to compare two test runs. It also reduces the amount of typing when\nusing `ttb` from the Erlang shell.\n\n- **`tp`** - Sets trace patterns on global function calls.\n\n- **`tpl`** - Sets trace patterns on local and global function calls.\n\n- **`tpe`** - Sets trace patterns on messages.\n\n- **`ctp`** - Clears trace patterns on local and global function calls.\n\n- **`ctpl`** - Clears trace patterns on local function calls.\n\n- **`ctpg`** - Clears trace patterns on global function calls.\n\n- **`ctpe`** - Clears trace patterns on messages.\n\nWith `tp` and `tpl`, one of the match specification shortcuts can be used (for\nexample, `ttb:tp(foo_module, caller)`).\n\nThe shortcuts are as follows:\n\n- `return` \\- for `[{'_',[],[{return_trace}]}]` (report the return value from a\n  traced function)\n- `caller` \\- for `[{'_',[],[{message,{caller}}]}]` (report the calling\n  function)\n- `{codestr, Str}` \\- for `dbg:fun2ms/1` arguments passed as strings (example:\n  `\"fun(_) -> return_trace() end\"`)","ref":"ttb.html#tpl/4"},{"type":"type","title":"ttb.trace_flag/0","doc":"","ref":"ttb.html#t:trace_flag/0"},{"type":"function","title":"ttb.tracer/0","doc":"","ref":"ttb.html#tracer/0"},{"type":"function","title":"ttb.tracer/1","doc":"Handy shortcuts for common tracing settings.\n\n`shell` is equivalent to\n[`tracer(node(),[{file, {local, \"ttb\"}}, shell])`](`tracer/2`).\n\n`dbg` is equivalent to [`tracer(node(),[{shell, only}])`](`tracer/2`).\n\n`Nodes` is equivalent to [`tracer(Nodes,[])`](`tracer/2`).","ref":"ttb.html#tracer/1"},{"type":"function","title":"ttb.tracer/2","doc":"Starts a file trace port on all specified nodes and points the system tracer for\nsequential tracing to the same port.\n\n_Options:_\n\n- **`Filename`** - The specified `Filename` is prefixed with the node name.\n  Default `Filename` is `ttb`.\n\n- **`File={wrap,Filename,Size,Count}`** - Can be used if the size of the trace\n  logs must be limited. Default values are `Size=128*1024` and `Count=8`.\n\n- **`Client`** - When tracing diskless nodes, `ttb` must be started from an\n  external \"trace control node\" with disk access, and `Client` must be\n  `{local, File}`. All trace information is then sent to the trace control node\n  where it is written to file.\n\n- **`queue_size`** - When tracing to shell or `{local,File}`, an ip trace driver\n  is used internally. The ip trace driver has a queue of maximum `QueueSize`\n  messages waiting to be delivered. If the driver cannot deliver messages as\n  fast as they are produced, the queue size might be exceeded and messages are\n  dropped. This parameter is optional, and is only useful if many `{drop,N}`\n  trace messages are received by the trace handler. It has no meaning if shell\n  or `{local,File}` is not used. See `dbg:trace_port/2` for more information\n  about the ip trace driver.\n\n- **`process_info`** - Indicates if process information is to be collected. If\n  `PI = true` (which is default), each process identifier `Pid` is replaced by a\n  tuple `{Pid,ProcessInfo,Node}`, where `ProcessInfo` is the registered process\n  name, its globally registered name, or its initial function. To turn off this\n  functionality, set `PI = false`.\n\n- **`{shell, ShellSpec}`** - Indicates that trace messages are to be printed on\n  the console as they are received by the tracing process. This implies trace\n  client `{local, File}`. If `ShellSpec` is `only` (instead of `true`), no trace\n  logs are stored.\n\n- **`shell`** - Shortcut for `{shell, true}`.\n\n- **`timer`** - Indicates that the trace is to be automatically stopped after\n  `MSec` milliseconds. `StopOpts` are passed to command `ttb:stop/1` if\n  specified (default is `[]`). Notice that the timing is approximate, as delays\n  related to network communication are always present. The timer starts after\n  `ttb:p/2` is issued, so you can set up your trace patterns before.\n\n- **`overload_check`** - Allows to enable overload checking on the nodes under\n  trace. `Module:Function(check)` is performed each `MSec` millisecond. If the\n  check returns `true`, the tracing is disabled on a specified node.\n\n  `Module:Function` must be able to handle at least three atoms: `init`,\n  `check`, and `stop`. `init` and `stop` allows you to initialize and clean up\n  the check environment.\n\n  When a node gets overloaded, it is not possible to issue `ttb:p/2` or any\n  command from the `ttb:tp/2,3,4` family, as it would lead to inconsistent\n  tracing state (different trace specifications on different nodes).\n\n- **`flush`** - Periodically flushes all file trace port clients (see\n  `dbg:flush_trace_port/1`). When enabled, the buffers are freed each `MSec`\n  millisecond. This option is not allowed with `{file, {local, File}}` tracing.\n\n- **`{resume, FetchTimeout}`** - Enables the autoresume feature. When enabled,\n  remote nodes try to reconnect to the controlling node if they are restarted.\n  The feature requires application Runtime_Tools to be started (so it has to be\n  present in the `.boot` scripts if the traced nodes run with embedded Erlang).\n  If this is not possible, resume can be performed manually by starting\n  `Runtime_Tools` remotely using `rpc:call/4`.\n\n  `ttb` tries to fetch all logs from a reconnecting node before reinitializing\n  the trace. This must finish within `FetchTimeout` milliseconds or is aborted.\n\n  By default, autostart information is stored in a file named\n  `ttb_autostart.bin` on each node. If this is not desired (for example, on\n  diskless nodes), a custom module handling autostart information storage and\n  retrieval can be provided by specifying environment variable\n  `ttb_autostart_module` for the application Runtime_Tools. The module must\n  respond to the following API:\n\n  - **`write_config(Data) -> ok`** - Stores the provided data for further\n    retrieval. It is important to realize that the data storage used must not be\n    affected by the node crash.\n\n  - **`read_config() -> {ok, Data} | {error, Error}`** - Retrieves configuration\n    stored with `write_config(Data)`.\n\n  - **`delete_config() -> ok`** - Deletes configuration stored with\n    `write_config(Data)`. Notice that after this call any subsequent calls to\n    `read_config` must return `{error, Error}`.\n\n  `resume` implies the default `FetchTimeout`, which is 10 seconds","ref":"ttb.html#tracer/2"},{"type":"function","title":"ttb.write_config/2","doc":"","ref":"ttb.html#write_config/2"},{"type":"function","title":"ttb.write_config/3","doc":"Creates or extends a configuration file, which can be used for restoring a\nspecific configuration later.\n\nThe contents of the configuration file can either be fetched from the history or\nspecified directly as a list of `{Mod,Func,Args}`.\n\nIf the complete history is to be stored in the configuration file, `Config` must\nbe `all`. If only a selected number of entries from the history are to be\nstored, `Config` must be a list of integers pointing out the entries to be\nstored.\n\nIf `Opts` is not specified or if it is `[]`, `ConfigFile` is deleted and a new\nfile is created. If `Opts = [append]`, `ConfigFile` is not deleted. The new\ninformation is appended at the end of the file.","ref":"ttb.html#write_config/3"},{"type":"function","title":"ttb.write_trace_info/2","doc":"File `.ti` contains `{Key,ValueList}` tuples. This function adds `Data` to the\n`ValueList` associated with `Key`. All information written with this function is\nincluded in the call to the format handler.","ref":"ttb.html#write_trace_info/2"},{"type":"extras","title":"Observer Application","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Observer Application","ref":"observer_app.html"},{"type":"extras","title":"Description - Observer Application","doc":"The Observer application contains tools for tracing and investigation of\ndistributed systems.","ref":"observer_app.html#description"},{"type":"extras","title":"Configuration - Observer Application","doc":"No configuration parameters are available for this application.","ref":"observer_app.html#configuration"},{"type":"extras","title":"Observer Release Notes","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Observer Release Notes\n\nThis document describes the changes made to the Observer application.","ref":"notes.html"},{"type":"extras","title":"Observer 2.17 - Observer Release Notes","doc":"","ref":"notes.html#observer-2-17"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Observer Release Notes","doc":"- In the Memory tab of `crashdump_viewer`, the blocks sizes in `Allocator Summary` would all be `N/A`.\n\n  Own Id: OTP-19353 Aux Id: [PR-8532]\n\n[PR-8532]: https://github.com/erlang/otp/pull/8532","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Observer Release Notes","doc":"- The Kernel application now recognizes the `epmd_module` and `erl_epmd_listen_port` parameters, similar to `-kernel:connect_all`.\n\n  Own Id: OTP-19253 Aux Id: [PR-8671]\n\n[PR-8671]: https://github.com/erlang/otp/pull/8671","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Observer 2.16 - Observer Release Notes","doc":"","ref":"notes.html#observer-2-16"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Observer Release Notes","doc":"- The dependencies for this application are now listed in the app file.\n\n  Own Id: OTP-18831 Aux Id: [PR-7441]\n\n[PR-7441]: https://github.com/erlang/otp/pull/7441","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Observer Release Notes","doc":"- The new function `proc_lib:set_label/1` can be used to add a descriptive term to any process that does not have a registered name. The name will be shown by tools such as `\\c:i/0`, `m:observer`, and it will be included in crash reports produced by processes using `m:gen_server`, `m:gen_statem`, `m:gen_event`, and `m:gen_fsm`.\n  \n  The label for a process can be retrieved by calling `proc_lib:get_label/1`.\n  \n  Note that those functions work on any process, not only processes that use `m:proc_lib`.\n  \n  Example:\n  \n  ```text\n  1> self().\n  <0.90.0>\n  2> proc_lib:set_label(my_label).\n  ok\n  3> i().\n      .\n      .\n      .\n  <0.90.0>              erlang:apply/2                        2586    75011    0\n  my_label              c:pinfo/2                               51\n  4> proc_lib:get_label(self()).\n  my_label\n  ```\n\n  Own Id: OTP-18789 Aux Id: [PR-7720], [PR-8003]\n\n- The documentation has been migrated to use Markdown and ExDoc.\n\n  Own Id: OTP-18955 Aux Id: [PR-8026]\n\n- `m:etop` has been updated to use `dbg:session/2` in order to not interfere with any other tracing.\n\n  Own Id: OTP-19082 Aux Id: [PR-8363]\n\n[PR-7720]: https://github.com/erlang/otp/pull/7720\n[PR-8003]: https://github.com/erlang/otp/pull/8003\n[PR-8026]: https://github.com/erlang/otp/pull/8026\n[PR-8363]: https://github.com/erlang/otp/pull/8363","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Observer 2.15.1 - Observer Release Notes","doc":"","ref":"notes.html#observer-2-15-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Observer Release Notes","doc":"- Closing the trace log window via the menu did not work.\n\n  Own Id: OTP-18722 Aux Id: PR-7462","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Observer 2.15 - Observer Release Notes","doc":"","ref":"notes.html#observer-2-15"},{"type":"extras","title":"Improvements and New Features - Observer Release Notes","doc":"- Runtime dependencies have been updated.\n\n  Own Id: OTP-18350\n\n- Added `start/1`, `start_and_wait functions/1|2` functions.\n\n  Own Id: OTP-18430 Aux Id: PR-6397\n\n- Deprecates `dbg:stop_clear/0` because it is simply a function alias to\n  `dbg:stop/0`\n\n  Own Id: OTP-18478 Aux Id: GH-6903","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Observer 2.14.0.1 - Observer Release Notes","doc":"","ref":"notes.html#observer-2-14-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Observer Release Notes","doc":"* Fixed runtime dependencies.\n\n  Own Id: OTP-19064","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Observer 2.14 - Observer Release Notes","doc":"","ref":"notes.html#observer-2-14"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Observer Release Notes","doc":"- A WX event race could causes a crash in when handling socket or port info.\n\n  Own Id: OTP-18339","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Observer Release Notes","doc":"- Improve the nodes menu to include more nodes.\n\n  Own Id: OTP-18269 Aux Id: PR-6030","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Observer 2.13 - Observer Release Notes","doc":"","ref":"notes.html#observer-2-13"},{"type":"extras","title":"Improvements and New Features - Observer Release Notes","doc":"- Fixed units in gui.\n\n  Own Id: OTP-18151 Aux Id: PR-6063","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Observer 2.12 - Observer Release Notes","doc":"","ref":"notes.html#observer-2-12"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Observer Release Notes","doc":"- Fixed default handling of Mac specific menus.\n\n  Own Id: OTP-17996 Aux Id: PR-5795\n\n- Reading port socket options on macOS and Windows \"skips\" invalid options.\n\n  Own Id: OTP-18012 Aux Id: #5798","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Observer Release Notes","doc":"- The configuration files [`.erlang`](`e:erts:erl_cmd.md`),\n  [`.erlang.cookie`](`e:system:distributed.md`) and\n  [`.erlang.crypt`](`m:beam_lib#module-erlang-crypt`) can now be located in the XDG\n  Config Home directory.\n\n  See the documentation for each file and `filename:basedir/2` for more details.\n\n  Own Id: OTP-17554 Aux Id: GH-5016 PR-5408 OTP-17821","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Observer 2.11.1 - Observer Release Notes","doc":"","ref":"notes.html#observer-2-11-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Observer Release Notes","doc":"- Fixed node information lookup for remote process identifiers in\n  `crashdump_viewer`.\n\n  Own Id: OTP-17995 Aux Id: PR-5804","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Observer 2.11 - Observer Release Notes","doc":"","ref":"notes.html#observer-2-11"},{"type":"extras","title":"Improvements and New Features - Observer Release Notes","doc":"- Calculate the display width in `etop`, instead of hard-coding it to 89\n  characters.\n\n  Own Id: OTP-17880 Aux Id: PR-5557","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Observer 2.10.1 - Observer Release Notes","doc":"","ref":"notes.html#observer-2-10-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Observer Release Notes","doc":"- Fix bug in crash dumps where the stackframe of a process would be printed\n  using an incorrect format.\n\n  Crash dump viewer has also been fixed to be able read the broken stack format.\n\n  The bug has existed since Erlang/OTP 23.0.\n\n  Own Id: OTP-17814 Aux Id: PR-5462","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Observer 2.10 - Observer Release Notes","doc":"","ref":"notes.html#observer-2-10"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Observer Release Notes","doc":"- Atoms with Unicode code points greater than 255 (for example Greek or Cyrillic\n  characters) would not be displayed correctly by `crashdump_viewer`.\n\n  Own Id: OTP-17377\n\n- Fix the crashdump_viewer to be able to parse\n  [`monitor_node/2`](`erlang:monitor_node/2`) monitors correctly.\n\n  Own Id: OTP-17425 Aux Id: PR-4799","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Observer Release Notes","doc":"- Observer now has a sectiion for new socket.\n\n  Own Id: OTP-17346\n\n- Added a trace all button to the trace window.\n\n  Own Id: OTP-17520 Aux Id: PR-4962","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Observer 2.9.6 - Observer Release Notes","doc":"","ref":"notes.html#observer-2-9-6"},{"type":"extras","title":"Improvements and New Features - Observer Release Notes","doc":"- Updated gui parts to work with the new wx version.\n\n  Own Id: OTP-17214","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Observer 2.9.5 - Observer Release Notes","doc":"","ref":"notes.html#observer-2-9-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Observer Release Notes","doc":"- Fix graph windows flickering on windows.\n\n  Own Id: OTP-16778","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Observer 2.9.4 - Observer Release Notes","doc":"","ref":"notes.html#observer-2-9-4"},{"type":"extras","title":"Improvements and New Features - Observer Release Notes","doc":"- Minor updates due to the new spawn improvements made.\n\n  Own Id: OTP-16368 Aux Id: OTP-15251","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Observer 2.9.3 - Observer Release Notes","doc":"","ref":"notes.html#observer-2-9-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Observer Release Notes","doc":"- Crashdump Viewer how handles crash dumps where the Old Binary VHeap has\n  overflowed.\n\n  Own Id: OTP-16296","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Observer 2.9.2 - Observer Release Notes","doc":"","ref":"notes.html#observer-2-9-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Observer Release Notes","doc":"- Fix bug after a user followed link on a pid from an expanded term window.\n\n  Own Id: OTP-15980 Aux Id: PR-2201","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Observer Release Notes","doc":"- Improved dark mode colors on Linux.\n\n  Own Id: OTP-15916 Aux Id: ERL-921","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Observer 2.9.1 - Observer Release Notes","doc":"","ref":"notes.html#observer-2-9-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Observer Release Notes","doc":"- All incorrect (that is, all) uses of \"can not\" has been corrected to \"cannot\"\n  in source code comments, documentation, examples, and so on.\n\n  Own Id: OTP-14282 Aux Id: PR-1891","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Observer 2.9 - Observer Release Notes","doc":"","ref":"notes.html#observer-2-9"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Observer Release Notes","doc":"- Since Logger was introduced in OTP-21.0, menu choice _Log > Toggle Log View_\n  in observer would cause a crash unless an `error_logger` event handler was\n  explicitly installed. This is now corrected.\n\n  Own Id: OTP-15553 Aux Id: ERL-848","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Observer Release Notes","doc":"- Since persistent_term was introduced, observer would sometimes crash when\n  expanding a term from a process state. This is now corrected.\n\n  Own Id: OTP-15493 Aux Id: ERL-810\n\n- Add `OBSERVER_SCALE` environment variable for HiDPI support.\n\n  Own Id: OTP-15586 Aux Id: PR-2105","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Observer 2.8.2 - Observer Release Notes","doc":"","ref":"notes.html#observer-2-8-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Observer Release Notes","doc":"- Literals such as `#{\"one\"=>1}` dumped to a crash dump would cause\n  `crashdump_viewer` to crash.\n\n  Own Id: OTP-15365 Aux Id: ERL-722\n\n- `crashdump_viewer` would sometimes crash when processing a dump which was\n  truncated in the `literals` area. This is now corrected.\n\n  Own Id: OTP-15377\n\n- Since OTP-20.2, `crashdump_viewer` was very slow when opening a crash dump\n  with many processes. An ets:select per process could be removed, which\n  improved the performance a lot.\n\n  A bug when parsing heap data in a crashdump caused `crashdump_viewer` to crash\n  when multiple `Yc` lines referenced the same reference counted binary. This is\n  now corrected.\n\n  Own Id: OTP-15391","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Observer 2.8.1 - Observer Release Notes","doc":"","ref":"notes.html#observer-2-8-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Observer Release Notes","doc":"- Improved documentation.\n\n  Own Id: OTP-15190","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Observer 2.8 - Observer Release Notes","doc":"","ref":"notes.html#observer-2-8"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Observer Release Notes","doc":"- Added possibility to garbage collect selected processes and fixed a crash when\n  the saved config file contained bad data.\n\n  Own Id: OTP-14993 Aux Id: PR-1666","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Observer Release Notes","doc":"- Use uri_string module instead of http_uri.\n\n  Own Id: OTP-14902","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Observer 2.7 - Observer Release Notes","doc":"","ref":"notes.html#observer-2-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Observer Release Notes","doc":"- etop.hrl used a relative path to include observer_backend.hrl, this is now\n  changed to use include_lib instead. runtime_tools/include is added to the\n  tertiary bootstrap.\n\n  Own Id: OTP-14842 Aux Id: ERL-534\n\n- If a crashdump was truncated in the attributes section for a module,\n  crashdump_viewer would crash when a module view was opened from the GUI. This\n  bug was introduced in OTP-20.2 and is now corrected.\n\n  Own Id: OTP-14846 Aux Id: ERL-537\n\n- Optimized ets and mnesia table view tab in observer gui, listing 10000 tables\n  was previously very slow.\n\n  Own Id: OTP-14856 Aux Id: ERIERL-117","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Observer Release Notes","doc":"- When a process has many links and/or monitors, it could earlier take very long\n  time to display the process information window. This is now improved by only\n  showing a few links and monitors, and then an link named \"more...\" to expand\n  the rest.\n\n  Own Id: OTP-14725\n\n- More crash dump info such as: process binary virtual heap stats, full info for\n  process causing out-of-mem during GC, more port related info, and dirty\n  scheduler info.\n\n  Own Id: OTP-14820","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Observer 2.6 - Observer Release Notes","doc":"","ref":"notes.html#observer-2-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Observer Release Notes","doc":"- A bug introduced in OTP-20 would make Crashdump Viewer crash when trying to\n  expand an empty binary. This is now corrected.\n\n  Own Id: OTP-14642\n\n- If a match spec in the config file contained more than one clause, observer\n  would earlier crash when trying to display it in the GUI. This is now\n  corrected.\n\n  Own Id: OTP-14643 Aux Id: ERL-489\n\n- Writing of crash dumps is significantly faster.\n\n  Maps are now included in crash dumps.\n\n  Constants terms would only be shown in one process, while other processes\n  referencing the same constant term would show a marker for incomplete heap.\n\n  Own Id: OTP-14685 Aux Id: OTP-14611, OTP-14603, OTP-14595","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Observer Release Notes","doc":"- Binaries and some other data in crash dumps are now encoded in base64 (instead\n  of in hex), which will reduce the size of crash dumps.\n\n  A few bugs in the handling of sub binaries in `crashdump_viewer` have been\n  fixed.\n\n  Own Id: OTP-14686\n\n- In order to allow future improvements, Crashdump Viewer now checks the version\n  tag of the crashdump to see that it is a known format. If the crashdump\n  version is newer than Crashdump Viewer is prepared to read, then an\n  information dialog is displayed before Crashdump Viewer terminates.\n\n  If an incomplete process heap is discovered in a crashdump, Crashdump Viewer\n  will now display a warning for this, similar to the warning displayed when a\n  crashdump is truncated. Incomplete heaps can occur if for instance the\n  literals are not included, which is the case for all dumps prior to OTP-20.2.\n\n  Own Id: OTP-14755","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Observer 2.5 - Observer Release Notes","doc":"","ref":"notes.html#observer-2-5"},{"type":"extras","title":"Improvements and New Features - Observer Release Notes","doc":"- The following improvements are done to Crashdump Viewer:\n\n  - Reading of crash dumps with many binaries is optimized.\n  - A progress bar is shown when the detail view for a process is opened.\n  - The `cdv` script now sets `ERL_CRASH_DUMP_SECONDS=0` to avoid generating a\n    new crash dump from the node running the Crashdump Viewer.\n  - A warning dialog is shown if the node running the Crashdump Viewer could\n    potentially overwrite the crash dump under inspection.\n  - Bugfix: In some situations, Crashdump Viewer could not find the end of the\n    'Last calls' section in a crash dump, and would erroneously mark the crash\n    dump as truncated. This is now corrected.\n  - Bugfix: In some situations, process info for a specific process would be\n    marked as truncated by Crashdump Viewer, even if the crash dump was\n    truncated in the binary section - and not related to the process in\n    question. This is now corrected.\n\n  Own Id: OTP-14386\n\n- General Unicode improvements.\n\n  Own Id: OTP-14462\n\n- Tools are updated to show Unicode atoms correctly.\n\n  Own Id: OTP-14464\n\n- Add system statistics and limits to frontpage in observer.\n\n  Own Id: OTP-14536","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Observer 2.4 - Observer Release Notes","doc":"","ref":"notes.html#observer-2-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Observer Release Notes","doc":"- `etop` had a hardcoded timeout value of 1 second when waiting for data from a\n  remote node. When this expired, which could happen for instance if there were\n  very many processes on the remote node, etop would exit with reason\n  `connection_lost`. To overcome this problem, the timeout is now changed to be\n  the same as the update interval, which is configurable.\n\n  Own Id: OTP-14393","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Observer Release Notes","doc":"- Show dirty-scheduler threads in performance monitor graph and add a column\n  with maximum allocated memory in the Memory Allocators table.\n\n  Own Id: OTP-14137\n\n- Keep table and port selection after refresh of tables. Store settings before\n  shutdown and restore when starting application.\n\n  Own Id: OTP-14270\n\n- Miscellaneous updates due to atoms containing arbitrary Unicode characters.\n\n  Own Id: OTP-14285\n\n- When observing a node older than OTP-19.0, a pop-up will be displayed when\n  trying to access port information. Earlier, observer would crash in this\n  situation.\n\n  Own Id: OTP-14345 Aux Id: ERL-399","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Observer 2.3.1 - Observer Release Notes","doc":"","ref":"notes.html#observer-2-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Observer Release Notes","doc":"- etop erroneously reported the average scheduler utilization since the tool was\n  first started instead of the scheduler utilization since last update. This is\n  now corrected.\n\n  Own Id: OTP-14090 Aux Id: seq13232\n\n- crashdump_viewer crashed when the 'Slogan' had more than one line. This is now\n  corrected.\n\n  Own Id: OTP-14093 Aux Id: ERL-318\n\n- When clicking an HTML-link to a port before the port tab has been opened for\n  the first time, observer would crash since port info is not initiated. This is\n  now corrected.\n\n  Own Id: OTP-14151 Aux Id: PR-1296\n\n- The dialyzer and observer applications will now use a portable way to find the\n  home directory. That means that there is no longer any need to manually set\n  the HOME environment variable on Windows.\n\n  Own Id: OTP-14249 Aux Id: ERL-161","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Observer 2.3 - Observer Release Notes","doc":"","ref":"notes.html#observer-2-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Observer Release Notes","doc":"- The shell script (priv/bin/cdv) and bat file (priv/bin/cdv.bat) which can be\n  used for starting crashdump_viewer both started a distributed erlang node.\n  This would cause any attempt at starting a second instance of the\n  crashdump_viewer to fail. To solve this problem, cdv and cdv.bat now use\n  non-distributed nodes when starting the crashdump_viewer.\n\n  Own Id: OTP-14010\n\n- A bug caused the number of buckets to be shown in the 'Objects' column, and\n  the number of objects to be shown in the 'Memory' column for ets table in\n  crashdump_viewer. This is now corrected.\n\n  Own Id: OTP-14064","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Observer Release Notes","doc":"- Add option `queue_size` to ttb:tracer/2. This sets the maximum queue size for\n  the IP trace driver which is used when tracing to shell and/or `{local,File}`.\n\n  The default value for `queue_size` is specified by `dbg`, and it is now\n  changed from 50 to 200.\n\n  Own Id: OTP-13829 Aux Id: seq13171\n\n- The port information page is updated to show more information per port.\n\n  Own Id: OTP-13948 Aux Id: ERL-272","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Observer 2.2.2 - Observer Release Notes","doc":"","ref":"notes.html#observer-2-2-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Observer Release Notes","doc":"- Fixed error handling in observer when mnesia tables was requested and not\n  available.\n\n  Own Id: OTP-13845 Aux Id: ERL-237","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Observer 2.2.1 - Observer Release Notes","doc":"","ref":"notes.html#observer-2-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Observer Release Notes","doc":"- Fixed a crash happening when observing another node, who have a different\n  number of schedulers than the current one.\n\n  Own Id: OTP-13702 Aux Id: ERL-171","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Observer 2.2 - Observer Release Notes","doc":"","ref":"notes.html#observer-2-2"},{"type":"extras","title":"Improvements and New Features - Observer Release Notes","doc":"- Update observer GUI to support tracing on ports, and to set matchspecs for\n  send/receive. This required some minor bugfixes in runtime_tools/dbg.\n\n  Own Id: OTP-13481\n\n- Update dbg and ttb to work with a tracer module as tracer and tracing on\n  ports.\n\n  Own Id: OTP-13500\n\n- Added possibility to change update frequency and length of the graph windows.\n\n  Own Id: OTP-13555\n\n- Improved background coloring to work with dark themes and other visual\n  improvements.\n\n  Own Id: OTP-13556\n\n- Crashdump viewer now allows port info \"Port controls forker process...\"\n\n  Own Id: OTP-13647","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Observer 2.1.2 - Observer Release Notes","doc":"","ref":"notes.html#observer-2-1-2"},{"type":"extras","title":"Improvements and New Features - Observer Release Notes","doc":"- Documentation corrections.\n\n  Own Id: OTP-12994","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Observer 2.1.1 - Observer Release Notes","doc":"","ref":"notes.html#observer-2-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Observer Release Notes","doc":"- Show ets owner pid in crashdump viewers popup window, thanks Leo Liu.\n\n  Own Id: OTP-13030\n\n- Several initialisms (eg, ERTS, ETS, SMP) are used as headings. They were being\n  capitalized incorrectly.\n\n  Own Id: OTP-13044\n\n- Fixed a crash in crashdump viewer when dump contained a truncated binary.\n\n  Own Id: OTP-13163","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Observer 2.1 - Observer Release Notes","doc":"","ref":"notes.html#observer-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Observer Release Notes","doc":"- Show run queue status in crashdump viewer.\n\n  Own Id: OTP-12401\n\n- Don't refresh observer table view if there was no change\n\n  Own Id: OTP-12819","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Observer Release Notes","doc":"- Added display of new crashdump information available in crashdumps from\n  Erlang/OTP 18.\n\n  Own Id: OTP-12363\n\n- Added the possibility to view sasl log entries for processes.\n\n  Own Id: OTP-12504\n\n- Add memory allocator usage and utilization graphs.\n\n  Own Id: OTP-12631","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Observer 2.0.4 - Observer Release Notes","doc":"","ref":"notes.html#observer-2-0-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Observer Release Notes","doc":"- Fix crash when opening a process information window.\n\n  Own Id: OTP-12634","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Observer 2.0.3 - Observer Release Notes","doc":"","ref":"notes.html#observer-2-0-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Observer Release Notes","doc":"- A note saying only R15B nodes can be observed is removed from the user guide.\n\n  Own Id: OTP-12078","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Observer 2.0.2 - Observer Release Notes","doc":"","ref":"notes.html#observer-2-0-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Observer Release Notes","doc":"- Fixed statusbar on Windows\n\n  Own Id: OTP-12162","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Observer 2.0.1 - Observer Release Notes","doc":"","ref":"notes.html#observer-2-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Observer Release Notes","doc":"- crashdump_viewer would crash if the owner of a timer was specified as the\n  process' registered name. This has been corrected.\n\n  Own Id: OTP-11919\n\n- Fix crash and minor updates.\n\n  Own Id: OTP-11949","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Observer 2.0 - Observer Release Notes","doc":"","ref":"notes.html#observer-2-0"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Observer Release Notes","doc":"- etop trace handler now works in smp environment (Thanks to Péter Gömöri)\n\n  Own Id: OTP-11633\n\n- Application upgrade (appup) files are corrected for the following\n  applications:\n\n  `asn1, common_test, compiler, crypto, debugger, dialyzer, edoc, eldap, erl_docgen, et, eunit, gs, hipe, inets, observer, odbc, os_mon, otp_mibs, parsetools, percept, public_key, reltool, runtime_tools, ssh, syntax_tools, test_server, tools, typer, webtool, wx, xmerl`\n\n  A new test utility for testing appup files is added to test_server. This is\n  now used by most applications in OTP.\n\n  (Thanks to Tobias Schlager)\n\n  Own Id: OTP-11744","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Observer Release Notes","doc":"- Removed gs based applications and gs based backends. The `observer`\n  application replaces the removed applications.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-10915\n\n- The `crashdump_viewer` is re-written using `wx`. The old `webtool` interface\n  for `crashdump_viewer` does no longer exist.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-11179","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Observer 1.3.1.2 - Observer Release Notes","doc":"","ref":"notes.html#observer-1-3-1-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Observer Release Notes","doc":"- The documentation for `ttb:tracer/2` incorrectly stated that there was an\n  option named '`overload`', while the correct name used in the implementation\n  is '`overload_check`'.\n\n  Own Id: OTP-11335 Aux Id: seq12385\n\n- Fixed typo in observer documentation. Thanks to Dave Parfitt.\n\n  Own Id: OTP-11475","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Observer 1.3.1.1 - Observer Release Notes","doc":"","ref":"notes.html#observer-1-3-1-1"},{"type":"extras","title":"Improvements and New Features - Observer Release Notes","doc":"- The encoding of the `notes.xml` file has been changed from latin1 to utf-8 to\n  avoid future merge problems.\n\n  Own Id: OTP-11310","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Observer 1.3.1 - Observer Release Notes","doc":"","ref":"notes.html#observer-1-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Observer Release Notes","doc":"- Some bugs related to calculation of CPU/scheduler utilization in observer are\n  corrected.\n\n  Current function for a process is accepted to be 'undefined' when running\n  hipe.\n\n  Own Id: OTP-10894","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Observer Release Notes","doc":"- - The new Memory field from a crash dump is now presented by crashdump viewer,\n    both in the process overview and in the process detail page.\n  - A summary of blocks- and carriers sizes is added to the allocator\n    information page in the crashdump viewer.\n\n  Own Id: OTP-10604 Aux Id: kunagi-336 \\[247]\n\n- Use \"open\" as default browser for crashdump viewer on Mac OS X. Thanks to\n  Magnus Henoch.\n\n  Own Id: OTP-10929\n\n- Fix observer table viewer crash on formatting improper lists. Thanks to Andrey\n  Tsirulev\n\n  Own Id: OTP-10931\n\n- Postscript files no longer needed for the generation of PDF files have been\n  removed.\n\n  Own Id: OTP-11016\n\n- Add processes state view in observer. Thanks to Eric Pailleau.\n\n  Own Id: OTP-11136","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Observer 1.3 - Observer Release Notes","doc":"","ref":"notes.html#observer-1-3"},{"type":"extras","title":"Improvements and New Features - Observer Release Notes","doc":"- Where necessary a comment stating encoding has been added to Erlang files. The\n  comment is meant to be removed in Erlang/OTP R17B when UTF-8 becomes the\n  default encoding.\n\n  Own Id: OTP-10630","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Observer 1.2 - Observer Release Notes","doc":"","ref":"notes.html#observer-1-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Observer Release Notes","doc":"- The module name in the link to the detail page for each loaded module was\n  earlier not URL encoded. If the module name contained e.g. a # this could\n  cause the crashdump viewer to crash when opening the link. This has been\n  corrected.\n\n  Own Id: OTP-10090 Aux Id: seq12068\n\n- Escape control characters in Table Viewer\n\n  Similar behaviour to old tv. Objects in tables supposed to be printed in a\n  single line and it looks ugly when a \\[...,10,...] integer list creates a\n  new-line. Fix Table Viewer search crash on new|changed|deleted rows.\n\n  Fix Table Viewer crash after a 'Found' -> 'Not found' search sequence\n\n  Start position was lost after a 'Found' -> 'Not found' search sequence leading\n  an undefined position in the next search. Thanks to Peti Gömori\n\n  Own Id: OTP-10218\n\n- observer: fix app file (Noticed-by: Motiejus Jakstys)\n\n  Add missing observer modules to observer.app.src. Thanks to Tuncer Ayaz.\n\n  Own Id: OTP-10221\n\n- Make Table Viewer search a bit faster\n\n  Edit table row in a multiline text dialog. Thanks to Peti Gomori.\n\n  Own Id: OTP-10225","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Observer Release Notes","doc":"- Allow tracing on bifs.\n\n  Ask epmd for local nodes, and remember users last input in connect.\n\n  Fix crashes when a table or process information could not be retrieved.\n\n  Own Id: OTP-10075","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Observer 1.0 - Observer Release Notes","doc":"","ref":"notes.html#observer-1-0"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Observer Release Notes","doc":"- The following bugs in `ttb` have been corrected:\n\n  - `ttb:tracer/2` would earlier crash when trying to set up tracing for a\n    diskless node to wrap files, i.e. when option\n    `{file,{local,{wrap,Filename,Size,Count}}}` was used.\n  - `ttb:stop([fetch])` would sometimes silently fail if multiple nodes with\n    different current working directories were traced.\n  - `ttb:stop([fetch])` would crash if the tracer was started with option\n    `{file,{local,Filename}}`\n  - A deadlock would sometimes occur due to an information printout from the\n    `ttb_control` process when `ttb` was stopped.\n\n  Own Id: OTP-9431\n\n- The file trace port to which the IP trace client relays all traces from\n  diskless nodes was not flushed and closed properly on ttb:stop. This has been\n  corrected.\n\n  Own Id: OTP-9665","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Observer Release Notes","doc":"- A new GUI for Observer. Integrating pman, etop, appmon and tv into observer\n  with tracing facilities.\n\n  Own Id: OTP-4779\n\n- The following new features are added to `ttb`:\n\n  - A one-command trace setup is added, `ttb:start_trace/4`.\n  - The following new options are added to `ttb:tracer/2`:\n    - _`shell`_ \\- Show trace messages on the console in real time\n    - _`timer`_ \\- Time constrained tracing\n    - _`overload`_ \\- Overload protection\n    - _`flush`_ \\- Flush file trace port buffers with given frequency\n    - _`resume`_ \\- Automatically resume tracing after node restart\n  - A new shortcut is added for common tracer settings similar to using the\n    `dbg` module directly, `ttb:tracer(shell | dbg)`.\n  - Some shortcuts are added for commonly used match specifications in `ttb:tp`\n    and `ttb:tpl`.\n  - The `Options` argument to functions `ttb:tracer`, `ttb:write_config`,\n    `ttb:stop` and `ttb:format` may now be one single option instead of a list.\n  - The history buffer of the last trace is now always automatically dumped to\n    the file `ttb_last_config` when `ttb:stop` is called.\n  - The following new options are added to `ttb:stop/1`:\n    - _`fetch_dir`_ \\- Specify where to store fetched logs\n    - _`{format,FormatOpts}`_ \\- Specify options to use when formatting the\n      fetched logs\n    - _`return_fetch_dir`_ \\- Indicate that the return value from `ttb:stop/1`\n      should include the name of the directory where the fetched logs are stored\n  - The option `disable_sort` is added to `ttb:format/2`. When this option is\n    used, trace messages from different logs are not merged according to\n    timestamps, but just appended one log after the other.\n\n  Own Id: OTP-9403\n\n- The following non backwards compatible changes are done in `ttb`:\n\n  - When setting up trace with ttb, the 'timestamp' trace flag will now always\n    be set.\n  - The 'fetch' option to ttb:stop/1 is removed since it is now default behavior\n    that trace logs are fetched when stopping ttb. Fetching can be disabled with\n    the 'nofetch' option to ttb:stop/1.\n  - The name of the upload directory is changed from ttb_upload-Timestamp to\n    ttb_upload_FileName-Timestamp.\n  - To format the output using 'et', you now need to provide the option\n    \\{handler,ttb:get_et_handler()\\} instead of \\{handler,et\\}.\n  - When formatting a trace log, the handler state was earlier reset after each\n    trace file, this is now changed so the handler state is passed not only from\n    one trace message to the next in the same file, but also from one file to\n    the next.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-9430","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Observer 0.9.10 - Observer Release Notes","doc":"","ref":"notes.html#observer-0-9-10"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Observer Release Notes","doc":"- Do not install \\*.bat files on non-win32 machines (Thanks to Hans Ulrich\n  Niedermann)\n\n  Own Id: OTP-9515","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Observer 0.9.9 - Observer Release Notes","doc":"","ref":"notes.html#observer-0-9-9"},{"type":"extras","title":"Improvements and New Features - Observer Release Notes","doc":"- The time needed for loading a crashump into the crashdump viewer would earlier\n  grow exponentially with the size of the crashdump file. Reading a file of 20M\n  would take a couple of minutes, and for a dump of 250M it would take between 1\n  and 2 hours. This has been solved.\n\n  Earlier, all processes, timers, funs or ets-tables would be loaded into the\n  memory of the crashdump viewer node before sending it on to the web server.\n  This has been changed and the pages are now sent to the web server in chunks.\n\n  A security function in newer web browsers prevents a full file path to be sent\n  from an HTML file input field, i.e. the field needed to implement the \"Browse\"\n  button when loading a file into the crashdump viewer. To overcome this, the\n  file input field is no longer used. Instead a normal text input field is used,\n  and the user needs to manually insert the complete file path. For convenience,\n  a shell script and a batch file are added to the observer application. These\n  can be used to start the crashdump_viewer and a browser and load a file - with\n  the file name given from the command line. The shell script and batch file are\n  called cdv and cdv.bat respectively, and can be found in the priv dir of the\n  observer application.\n\n  Own Id: OTP-9051 Aux Id: seq11789","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Observer 0.9.8.4 - Observer Release Notes","doc":"","ref":"notes.html#observer-0-9-8-4"},{"type":"extras","title":"Improvements and New Features - Observer Release Notes","doc":"- The multitrace.erl installation example file is now installed in the examples\n  directory. (Thanks to Peter Lemenkov.)\n\n  Own Id: OTP-8857","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Observer 0.9.8.3 - Observer Release Notes","doc":"","ref":"notes.html#observer-0-9-8-3"},{"type":"extras","title":"Improvements and New Features - Observer Release Notes","doc":"- The test suite has been updated for R14A.\n\n  Own Id: OTP-8708","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Observer 0.9.8.2 - Observer Release Notes","doc":"","ref":"notes.html#observer-0-9-8-2"},{"type":"extras","title":"Improvements and New Features - Observer Release Notes","doc":"- Misc updates\n\n  Own Id: OTP-8456","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Observer 0.9.8.1 - Observer Release Notes","doc":"","ref":"notes.html#observer-0-9-8-1"},{"type":"extras","title":"Improvements and New Features - Observer Release Notes","doc":"- Major improvements of the Erlang distribution for Erlang runtime systems with\n  SMP support. Previously distribution port locks were heavily contended, and\n  all encoding and decoding for a specific distribution channel had to be done\n  in sequence. Lock contention due to the distribution is now negligible and\n  both encoding and decoding of Erlang messages can be done in parallel.\n\n  The old atom cache protocol used by the Erlang distribution has been dropped\n  since it effectively prevented all parallel encoding and decoding of messages\n  passed over the same distribution channel.\n\n  A new atom cache protocol has been introduced which isolates atom cache\n  accesses and makes parallel encoding and decoding of messages passed over the\n  same distribution channel possible. The new atom cache protocol also use an\n  atom cache size 8 times larger than before. The new atom cache protocol is\n  documented in the ERTS users guide.\n\n  Erlang messages received via the distribution are now decoded by the receiving\n  Erlang processes without holding any distribution channel specific locks.\n  Erlang messages and signals sent over the distribution are as before encoded\n  by the sending Erlang process, but now without holding any distribution\n  channel specific locks during the encoding. That is, both encoding and\n  decoding can be and are done in parallel regardless of distribution channel\n  used.\n\n  The part that cannot be parallelized is the atom cache updates. Atom cache\n  updates are therefore now scheduled on the distribution port. Since it is only\n  one entity per distribution channel doing this work there is no lock\n  contention due to the atom cache updates.\n\n  The new runtime system does not understand the old atom cache protocol. New\n  and old runtime systems can however still communicate, but no atom cache will\n  be used.\n\n  Own Id: OTP-7774","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Observer 0.9.8 - Observer Release Notes","doc":"","ref":"notes.html#observer-0-9-8"},{"type":"extras","title":"Improvements and New Features - Observer Release Notes","doc":"- `etop` would crash if the emulator's custom allocators had been turned off\n  (e.g. using the `+Meamin` option).\n\n  Own Id: OTP-7519\n\n- The copyright notices have been updated.\n\n  Own Id: OTP-7851","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Observer 0.9.7.4 - Observer Release Notes","doc":"","ref":"notes.html#observer-0-9-7-4"},{"type":"extras","title":"Improvements and New Features - Observer Release Notes","doc":"- Minor Makefile changes.\n\n  Own Id: OTP-6689\n\n- Obsolete guard tests (such as list()) have been replaced with the modern guard\n  tests (such as is_list()).\n\n  Own Id: OTP-6725","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Observer 0.9.7.3 - Observer Release Notes","doc":"","ref":"notes.html#observer-0-9-7-3"},{"type":"extras","title":"Improvements and New Features - Observer Release Notes","doc":"- This application has been updated to eliminate warnings by Dialyzer.\n\n  Own Id: OTP-6551","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Observer 0.9.7.2 - Observer Release Notes","doc":"","ref":"notes.html#observer-0-9-7-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Observer Release Notes","doc":"- Several minor bugs and race conditions eliminated in the runtime_tools and\n  observer applications.\n\n  Own Id: OTP-6265","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Observer 0.9.7.1 - Observer Release Notes","doc":"","ref":"notes.html#observer-0-9-7-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Observer Release Notes","doc":"- Crash dump with large integers could crash the `crashdump_viewer`.\n\n  Own Id: OTP-6301","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Observer 0.9.7 (R11B) - Observer Release Notes","doc":"","ref":"notes.html#observer-0-9-7-r11b"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Observer Release Notes","doc":"- Fixed a bug in `etop` which made the Load and Memory information in the header\n  incorrect -- for example the value shown for `binary` (memory allocated for\n  binaries) was actually the number of currently running processes. (Thanks to\n  Rikard Johansson.)\n\n  Own Id: OTP-6075","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Observer 0.9.6.2 - Observer Release Notes","doc":"","ref":"notes.html#observer-0-9-6-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Observer Release Notes","doc":"- The Observer application has been recompiled because of a compiler bug.\n\n  Own Id: OTP-5700","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Observer 0.9.6.1 - Observer Release Notes","doc":"","ref":"notes.html#observer-0-9-6-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Observer Release Notes","doc":"- `crashdump_viewer` is faster when showing message, dictionary, and stack dump\n  for large processes.\n\n  Own Id: OTP-5408","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Introduction","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Introduction","ref":"introduction_ug.html"},{"type":"extras","title":"Scope - Introduction","doc":"The Observer application is a container including the following tools for\ntracing and investigation of distributed systems:\n\n- Observer\n- Trace Tool Builder\n- Erlang Top\n- Crashdump Viewer","ref":"introduction_ug.html#scope"},{"type":"extras","title":"Prerequisites - Introduction","doc":"It is assumed that the reader is familiar with the Erlang programming language.","ref":"introduction_ug.html#prerequisites"},{"type":"extras","title":"Observer","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Observer","ref":"observer_ug.html"},{"type":"extras","title":"Introduction - Observer","doc":"Observer is a graphical tool for observing the characteristics of Erlang\nsystems. Observer displays system information, application supervisor trees,\nprocess information, ETS tables, Mnesia tables and contains a front end for\nErlang tracing.","ref":"observer_ug.html#introduction"},{"type":"extras","title":"Getting Started - Observer","doc":"Run Observer from a standalone node to minimize the impact of the system being\nobserved.\n\n_Example:_\n\n```text\n% erl -sname observer -hidden -setcookie MyCookie -run observer\n```\n\nSelect the node to observe with menu _Nodes_. Menu _View > Refresh interval_\ncontrols how often the view is to be updated. The refresh interval is set per\nviewer so you can have different settings for each viewer. To minimize the\nsystem impact, only the active viewer is updated. Other views are updated when\nactivated.\n\nThe mouse buttons behave as expected. Use left-click to select objects,\nright-click to get a menu with the most used options, and double-click to\ndisplay information about the selected object. In most viewers with many\ncolumns, you can change the sort order by left-clicking the column header.","ref":"observer_ug.html#getting-started"},{"type":"extras","title":"System Tab - Observer","doc":"Tab _System_ displays general information about the active Erlang node and its\nruntime system, such as build configuration, system capabilities, and overall\nuse statistics.","ref":"observer_ug.html#system-tab"},{"type":"extras","title":"Load Charts Tab - Observer","doc":"Tab _Load Charts_ displays graphs of the current resource use on the active\nErlang node.\n\nGraph `Scheduler Utilization` shows scheduler use per scheduler, where each\nscheduler use has a unique color.\n\nGraph `Memory Usage` shows the total memory use and per memory category use,\nwhere each category has a unique color. The categories are as follows:\n\n- **`Total`** - The sum of all memory categories.\n\n- **`Processes`** - The sum of all process memory used.\n\n- **`Atom`** - The size used by the atom table.\n\n- **`Binary`** - The sum of all off-heap binaries allocated.\n\n- **`Code`** - The memory allocated for code storage.\n\n- **`Ets`** - The used memory for all ETS tables.\n\nGraph `IO Usage` shows the current I/O load on the system.","ref":"observer_ug.html#load-charts-tab"},{"type":"extras","title":"Memory Allocators Tab - Observer","doc":"Tab _Memory Allocators_ displays detailed information of the carrier size and\ncurrent memory carriers. For details about memory carriers, see module\n[`erts_alloc`](`e:erts:erts_alloc.md`) in application ERTS.\n\nThe `Max Carrier size` column shows the maximum value seen by observer since the\nlast node change or since the start of the application, i.e. switching nodes\nwill reset the max column. Values are sampled so higher values may have existed\nthan what is shown.","ref":"observer_ug.html#memory-allocators-tab"},{"type":"extras","title":"Applications Tab - Observer","doc":"Tab _Applications_ presents application information. Select an application in\nthe left list to display its supervisor tree. The right-click options in the\ntree are as follows:\n\n- **Process info** - Opens a detailed information window on the selected\n  process, including the following:\n\n  - **Process Information** - Shows the process information.\n\n  - **Messages** - Shows the process messages.\n\n  - **Dictionary** - Shows the process dictionary.\n\n  - **Stack Trace** - Shows the process current stack trace.\n\n  - **State** - Shows the process state.\n\n  - **Log** - If enabled and available, shows the process SASL log entries.\n\n- **Trace process** - Adds the selected process identifier to tab _Trace\n  Overview_ plus the node that the process resides on.\n\n- **Trace named process** - Adds the registered name of the process. This can be\n  useful when tracing on many nodes, as processes with that name are then traced\n  on all traced nodes.\n\n- **Trace process tree** - Adds the selected process and all processes below,\n  right of it, to tab _Trace Overview_.\n\n- **Trace named process tree** - Adds the selected process and all processes\n  below, right of it, to tab _Trace Overview_.","ref":"observer_ug.html#applications-tab"},{"type":"extras","title":"Processes Tab - Observer","doc":"Tab _Processes_ lists process information in columns. For each process the\nfollowing information is displayed:\n\n- **Pid** - The process identifier.\n\n- **Description** - Registered name, [process label](`proc_lib:set_label/1`) or\n  initial function.\n\n- **Reds** - The number of reductions executed on the process. This can be\n  presented as accumulated values or as values since the last update.\n\n- **Memory** - The size of the process, in bytes, obtained by a call to\n  [`process_info(Pid,memory)`](`process_info/2`).\n\n- **MsgQ** - The length of the message queue for the process.\n\nOption _Process info_ opens a detailed information window on the process under\nthe mouse pointer, including the following:\n\n- **Process Information** - Shows the process information.\n\n- **Messages** - Shows the process messages.\n\n- **Dictionary** - Shows the process dictionary.\n\n- **Stack Trace** - Shows the process current stack trace.\n\n- **State** - Shows the process state.\n\n- **Log** - If enabled and available, shows the process SASL log entries.\n\n> #### Note {: .info }\n>\n> _Log_ requires application SASL to be started on the observed node, with\n> `log_mf_h` as log handler. The Observed node must be Erlang/OTP R16B02 or\n> higher. The `rb` server must not be started on the observed node when clicking\n> menu _Log > Toggle log view_. The `rb` server is stopped on the observed node\n> when exiting or changing the observed node.\n\nOption _Trace selected processes_ adds the selected process identifiers to tab\n_Trace Overview_ plus the node that the processes reside on.\n\nOption _Trace selected processes by name_ adds the registered name of the\nprocesses. This can be useful when tracing is done on many nodes, as processes\nwith that name are then traced on all traced nodes.\n\nOption _Kill process_ brutally kills the processes under the mouse pointer by\nsending an exit signal with reason `kill`.","ref":"observer_ug.html#processes-tab"},{"type":"extras","title":"Ports Tab - Observer","doc":"Tab _Ports_ lists port information in columns. For each port the following\ninformation is displayed:\n\n- **Id** - The port identifier.\n\n- **Connected** - The process identifier for the process that owns the port.\n\n- **Name** - The registered name of the port, if any.\n\n- **Controls** - The name of the command set by `erlang:open_port/2`.\n\n- **Slot** - The internal index of the port.\n\nOption _Port info_ opens a detailed information window for the port under the\nmouse pointer. In addition to the information above, it also shows links and\nmonitors.\n\nOption _Trace selected ports_ adds the selected port identifiers, and the nodes\nthat the ports reside on, to tab _Trace Overview_.\n\nOption _Trace selected ports by name_ adds the registered name of the port to\ntab _Trace Overview_. This can be useful when tracing is done on many nodes, as\nports with that name are then traced on all traced nodes.\n\nOption _Close_ executes `erlang:port_close/1` on the port under the mouse\npointer.","ref":"observer_ug.html#ports-tab"},{"type":"extras","title":"Sockets Tab - Observer","doc":"Tab _Sockets_ is divided into two parts. The first part contains general\n`m:socket` information and the second part lists socket information in columns.\n\nFor each socket the following information is displayed:\n\n- **Id** - The socket identifier.\n\n- **Owner** - The process identifier for the process that owns the socket.\n\n- **Fd** - The underlying file descriptor of the socket.\n\n- **Domain** - The communication domain (e.g. inet or inet6) of this socket.\n\n- **Type** - The type (e.g. stream or dgram) of this socket.\n\n- **Protocol** - The protocol (e.g. tcp or udp) of this socket.\n\n- **Read State** - The read state of the socket.\n\n- **Write State** - The write state of the socket.\n\nOption _Socket info_ opens a detailed information window for the socket under\nthe mouse pointer. In addition to the information above, it also shows monitors.\n\nOption _Close_ executes `socket:close/1` on the socket under the mouse pointer.","ref":"observer_ug.html#sockets-tab"},{"type":"extras","title":"Table Viewer Tab - Observer","doc":"Tab _Table Viewer_ lists tables. By default, ETS tables are displayed whereas\nunreadable private ETS tables and tables created by OTP applications are not\ndisplayed. Use menu _View_ to view \"system\" ETS tables, unreadable ETS tables,\nor Mnesia tables.\n\nDouble-click to view the table content, or right-click and select option _Show\nTable Content_. To view table information, select the table and activate menu\n_View > Table information_, or right-click and select option _Table info_.\n\nYou can use [regular expressions](`m:re`) and search for objects, and edit or\ndelete them.","ref":"observer_ug.html#table-viewer-tab"},{"type":"extras","title":"Trace Overview Tab - Observer","doc":"Tab _Trace Overview_ handles tracing. Trace by selecting the processes or ports\nto be traced and how to trace them. For processes, you can trace messages,\nfunction calls, scheduling, garbage collections, and process-related events such\nas `spawn`, `exit`, and many others. For ports, you can trace messages,\nscheduling and port-related events.\n\nTo trace function calls, you also need to set up _trace patterns_. Trace\npatterns select the function calls to be traced. The number of traced function\ncalls can be further reduced with _match specifications_. Match specifications\ncan also be used to trigger more information in the trace messages.\n\nYou can also set match specifications on messages. By default, if tracing\nmessages, all messages sent and/or received by the process or port are traced.\nMatch specifications can be used to reduce the number of traced messages and/or\nto trigger more information in the trace messages.\n\n> #### Note {: .info }\n>\n> Trace patterns only apply to the traced processes and ports.\n\nProcesses are added from the _Applications_ or _Processes_ tabs. Ports are added\nfrom the _Ports_ tab. A special _new_ identifier, meaning all processes, or\nports, started after trace start, can be added with buttons _Add 'new'\nProcesses_ and _Add 'new' Ports_, respectively.\n\nWhen adding processes or ports, a window with trace options is displayed. The\nchosen options are set for the selected processes/ports. To change the options,\nright-click the process or port and select _Edit process options_. To remove a\nprocess or port from the list, right-click and select _Remove process_ or\n_Remove port_, respectively.\n\nProcesses and ports added by process/port identifiers add the nodes these\nprocesses/ports reside on in the node list. More nodes can be added by clicking\nbutton _Add Nodes_, or by right-clicking in the _Nodes_ list and select _Add\nNodes_. To remove nodes, select them, then right-click and choose _Remove\nnodes_.\n\nIf function calls are traced, trace patterns must be added by clicking button\n_Add Trace Pattern_. Select a module, function(s), and a match specification. If\nno functions are selected, all functions in the module are traced.\n\nTrace patterns can also be added for traced messages. Click button _Add Trace\nPattern_ and select _Messages sent_ or _Messages received_, and a match\nspecification.\n\nA few basic match specifications are provided in the tool, and you can provide\nyour own match specifications. The syntax of match specifications is described\nin the [`ERTS User's Guide`](`e:erts:match_spec.md`). To simplify the writing of\na match specification, they can also be written as `fun/1`. For details, see\nmodule `m:ms_transform` in application STDLIB.\n\nClick button _Start Trace_ to start the trace. By default, trace output is\nwritten to a new window. Tracing is stopped when the window is closed, or when\nclicking button _Stop Trace_. Trace output can be changed with menu _Options >\nOutput_. The trace settings, including match specifications, can be saved to, or\nloaded from, a file.\n\nFor details about tracing, see module `m:dbg` in application Runtime_Tools and\nin section \"Match specifications in Erlang\" in\n[`ERTS User's Guide`](`e:erts:match_spec.md`) and in module `m:ms_transform` in\napplication STDLIB.","ref":"observer_ug.html#trace-overview-tab"},{"type":"extras","title":"Trace Tool Builder","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Trace Tool Builder","ref":"ttb_ug.html"},{"type":"extras","title":"Introduction - Trace Tool Builder","doc":"Trace Tool Builder is a base for building trace tools for single node or\ndistributed Erlang systems. It requires the Runtime_Tools application to be\navailable on the traced node.\n\nThe following are the main features of Trace Tool Builder:\n\n- Start tracing to file ports on many nodes with one function call.\n- Write more information to a trace information file, which is read during\n  formatting.\n- Restore previous configuration by maintaining a history buffer and handling\n  configuration files.\n- Provide some simple support for sequential tracing.\n- Format binary trace logs and merge logs from multiple nodes.\n\nThe intention of Trace Tool Builder is to serve as a base for tailor-made trace\ntools, but it can also be used directly from the Erlang shell (it can mimic\n`dbg` behaviour while still providing useful additions, such as match\nspecification shortcuts). Trace Tool Builder only allows the use of file port\ntracer, so to use other types of trace clients it is better to use `dbg`\ndirectly.","ref":"ttb_ug.html#introduction"},{"type":"extras","title":"Getting Started - Trace Tool Builder","doc":"Module `ttb` is the interface to all functions in Trace Tool Builder.\n\nTo get started, the least you need to do is to start a tracer with\n[`ttb:tracer/0,1,2`](`ttb:tracer/0`), and set the required trace flags on the\nprocesses you want to trace with `ttb:p/2`.\n\nWhen the tracing is completed, stop the tracer with\n[`ttb:stop/0,1`](`ttb:stop/0`) and format the trace log with\n[`ttb:format/1,2`](`ttb:format/1`) (if there is anything to format).\n\n_Useful functions:_\n\n- **[`ttb:tracer/0,1,2`](`ttb:tracer/0`)** - Opens a trace port on each node to\n  be traced. By default, trace messages are written to binary files on remote\n  nodes (the binary trace log).\n\n- **`ttb:p/2`** - Specifies the processes to be traced. Trace flags specified in\n  this call specify what to trace on each process. This function can be called\n  many times if you like different trace flags to be set on different processes.\n\n- **[`ttb:tp/2,3,4`](`ttb:tp/2`) or [`ttb:tpl/2,3,4`](`ttb:tpl/2`)** - If you\n  want to trace function calls (that is, if you have trace flag `call` set on\n  any process), you must also set trace patterns on the required function(s)\n  with [`ttb:tp/2,3,4`](`ttb:tp/2`) or [`ttb:tpl/2,3,4`](`ttb:tpl/2`). A\n  function is only traced if it has a trace pattern. The trace pattern specifies\n  how to trace the function by using match specifications. Match specifications\n  are described in the [ERTS User's Guide](`e:erts:index.html`).\n\n- **[`ttb:stop/0,1`](`ttb:stop/0`)** - Stops tracing on all nodes, deletes all\n  trace patterns, and flushes the trace port buffer.\n\n- **[`ttb:format/1/2`](`ttb:format/1`)** - Translates the binary trace logs into\n  something readable. By default, `ttb` presents each trace message as a line of\n  text, but you can also write your own handler to make more complex\n  interpretations of the trace information. A trace log can also be presented\n  graphically with application Event Tracer (ET).\n\n  If option `format` is specified to `ttb:stop/1`, the formatting is\n  automatically done when stopping `ttb`.","ref":"ttb_ug.html#getting-started"},{"type":"extras","title":"Tracing Local Node from Erlang Shell - Trace Tool Builder","doc":"The following small module is used in the subsequent example:\n\n```erlang\n-module(m).\n-export([f/0]).\nf() ->\n   receive\n      From when is_pid(From) ->\n         Now = erlang:now(),\n         From ! {self(),Now}\n   end.\n```\n\nThe following example shows the basic use of `ttb` from the Erlang shell.\nDefault options are used both for starting the tracer and for formatting (the\ncustom fetch directory is however provided). This gives a trace log named\n`Node-ttb` in the newly created directory, where `Node` is the node name. The\ndefault handler prints the formatted trace messages in the shell:\n\n```erlang\n(tiger@durin)47> %% First I spawn a process running my test function\n(tiger@durin)47> Pid = spawn(m,f,[]).\n<0.125.0>\n(tiger@durin)48>\n(tiger@durin)48> %% Then I start a tracer...\n(tiger@durin)48> ttb:tracer().\n{ok,[tiger@durin]}\n(tiger@durin)49>\n(tiger@durin)49> %% and activate the new process for tracing\n(tiger@durin)49> %% function calls and sent messages.\n(tiger@durin)49> ttb:p(Pid,[call,send]).\n{ok,[{<0.125.0>,[{matched,tiger@durin,1}]}]}\n(tiger@durin)50>\n(tiger@durin)50> %% Here I set a trace pattern on erlang:now/0\n(tiger@durin)50> %% The trace pattern is a simple match spec\n(tiger@durin)50> %% indicating that the return value should be\n(tiger@durin)50> %% traced. Refer to the reference_manual for\n(tiger@durin)50> %% the full list of match spec shortcuts\n(tiger@durin)50> %% available.\n(tiger@durin)51> ttb:tp(erlang,now,return).\n{ok,[{matched,tiger@durin,1},{saved,1}]}\n(tiger@durin)52>\n(tiger@durin)52> %% I run my test (i.e. send a message to\n(tiger@durin)52> %% my new process)\n(tiger@durin)52> Pid ! self().\n<0.72.0>\n(tiger@durin)53>\n(tiger@durin)53> %% And then I have to stop ttb in order to flush\n(tiger@durin)53> %% the trace port buffer\n(tiger@durin)53> ttb:stop([return, {fetch_dir, \"fetch\"}]).\n{stopped, \"fetch\"}\n(tiger@durin)54>\n(tiger@durin)54> %% Finally I format my trace log\n(tiger@durin)54> ttb:format(\"fetch\").\n({<0.125.0>,{m,f,0},tiger@durin}) call erlang:now()\n({<0.125.0>,{m,f,0},tiger@durin}) returned from erlang:now/0 ->\n{1031,133451,667611}\n({<0.125.0>,{m,f,0},tiger@durin}) <0.72.0> !\n{<0.125.0>,{1031,133451,667611}}\nok\n```","ref":"ttb_ug.html#tracing-local-node-from-erlang-shell"},{"type":"extras","title":"Build Your Own Tool - Trace Tool Builder","doc":"The following example shows a simple tool for \"debug tracing\", that is, tracing\nof function calls with return values:\n\n```erlang\n-module(mydebug).\n-export([start/0,trc/1,stop/0,format/1]).\n-export([print/4]).\n%% Include ms_transform.hrl so that I can use dbg:fun2ms/2 to\n%% generate match specifications.\n-include_lib(\"stdlib/include/ms_transform.hrl\").\n%%% -------------Tool API-------------\n%%% ----------------------------------\n%%% Star the \"mydebug\" tool\nstart() ->\n    %% The options specify that the binary log shall be named\n    %%  -debug_log and that the print/4 function in this\n    %% module shall be used as format handler\n    ttb:tracer(all,[{file,\"debug_log\"},{handler,{{?MODULE,print},0}}]),\n    %% All processes (existing and new) shall trace function calls\n    %% We want trace messages to be sorted upon format, which requires\n    %% timestamp flag. The flag is however enabled by default in ttb.\n    ttb:p(all,call).\n\n%%% Set trace pattern on function(s)\ntrc(M) when is_atom(M) ->\n    trc({M,'_','_'});\ntrc({M,F}) when is_atom(M), is_atom(F) ->\n    trc({M,F,'_'});\ntrc({M,F,_A}=MFA) when is_atom(M), is_atom(F) ->\n    %% This match spec shortcut specifies that return values shall\n    %% be traced.\n    MatchSpec = dbg:fun2ms(fun(_) -> return_trace() end),\n    ttb:tpl(MFA,MatchSpec).\n\n%%% Format a binary trace log\nformat(Dir) ->\n    ttb:format(Dir).\n\n%%% Stop the \"mydebug\" tool\nstop() ->\n    ttb:stop(return).\n\n%%% --------Internal functions--------\n%%% ----------------------------------\n%%% Format handler\nprint(_Out,end_of_trace,_TI,N) ->\n    N;\nprint(Out,Trace,_TI,N) ->\n    do_print(Out,Trace,N),\n    N+1.\n\ndo_print(Out,{trace_ts,P,call,{M,F,A},Ts},N) ->\n    io:format(Out,\n              \"~w: ~w, ~w:~n\"\n              \"Call      : ~w:~w/~w~n\"\n              \"Arguments :~p~n~n\",\n              [N,Ts,P,M,F,length(A),A]);\ndo_print(Out,{trace_ts,P,return_from,{M,F,A},R,Ts},N) ->\n    io:format(Out,\n              \"~w: ~w, ~w:~n\"\n              \"Return from  : ~w:~w/~w~n\"\n              \"Return value :~p~n~n\",\n              [N,Ts,P,M,F,A,R]).\n```\n\nTo distinguish trace logs produced with this tool from other logs, option `file`\nis used in [`tracer/2`](`ttb:tracer/2`). The logs are therefore fetched to a\ndirectory named `ttb_upload_debug_log-YYYYMMDD-HHMMSS`\n\nBy using option `handler` when starting the tracer, the information about how to\nformat the file is stored in the trace information file (`.ti`). This is not\nnecessary, as it can be specified when formatting instead. However, It can be\nuseful if you, for example, want to format trace logs automatically using option\n`format` in `ttb:stop/1`. Also, you do not need any knowledge of the content of\na binary log to format it the way it is intended. If option `handler` is\nspecified both when starting the tracer and when formatting, the one specified\nwhen formatting is used.\n\nTrace flag `call` is set on all processes. This means that any function\nactivated with command `trc/1` is traced on all existing and new processes.","ref":"ttb_ug.html#build-your-own-tool"},{"type":"extras","title":"Running Trace Tool Builder against Remote Node - Trace Tool Builder","doc":"The Observer application might not always be available on the node to be traced\n(in the following called the \"traced node\"). However, Trace Tool Builder can\nstill be run from another node (in the following called the \"trace control\nnode\") as long as the following is fulfilled:\n\n- The Observer application is available on the trace control node.\n- The Runtime_Tools application is available on both the trace control node and\n  the traced node.\n\nIf Trace Tool Builder is to be used against a remote node, it is highly\nrecommended to start the trace control node as _hidden_. This way it can connect\nto the traced node without being \"seen\" by it, that is, if the `nodes/0` BIF is\ncalled on the traced node, the trace control node does not show. To start a\nhidden node, add option `-hidden` to the `erl` command, for example:\n\n```text\n% erl -sname trace_control -hidden\n```","ref":"ttb_ug.html#running-trace-tool-builder-against-remote-node"},{"type":"extras","title":"Diskless Node - Trace Tool Builder","doc":"If the traced node is diskless, `ttb` must be started from a trace control node\nwith disk access, and option `file` must be specified to function `tracer/2`\nwith value `{local, File}`, for example:\n\n```erlang\n(trace_control@durin)1> ttb:tracer(mynode@diskless,\n                                   {file,{local,{wrap,\"mytrace\"}}}).\n{ok,[mynode@diskless]}\n```","ref":"ttb_ug.html#diskless-node"},{"type":"extras","title":"More Tracing Options - Trace Tool Builder","doc":"When setting up a trace, the following features can also be activated:\n\n- Time-constrained tracing\n- Overload protection\n- Autoresume\n- `dbg` mode","ref":"ttb_ug.html#more-tracing-options"},{"type":"extras","title":"Time-Constrained Tracing - Trace Tool Builder","doc":"It can sometimes be helpful to enable trace for a specified period of time (for\nexample, to monitor a system for 24 hours or half a second). This can be done\nwith option `{timer, TimerSpec}`. If `TimerSpec` has the form of `MSec`, the\ntrace is stopped after `MSec` milliseconds using `ttb:stop/0`. If more options\nare provided (`TimerSpec = {MSec, Opts}`), `ttb:stop/1` is called instead with\n`Opts` as argument.\n\nThe timer is started with `ttb:p/2`, so any trace patterns must be set up in\nadvance. `ttb:start_trace/4` always sets up all patterns before invoking\n`ttb:p/2`.\n\nThe following example shows how to set up a trace that is automatically stopped\nand formatted after 5 seconds:\n\n```erlang\n(tiger@durin)1> ttb:start_trace([node()],\n                                [{erlang, now,[]}],\n                                {all, call},\n                                [{timer, {5000, format}}]).\n```\n\n> #### Note {: .info }\n>\n> Because of network and processing delays, the period of tracing is\n> approximate.","ref":"ttb_ug.html#time-constrained-tracing"},{"type":"extras","title":"Overload Protection - Trace Tool Builder","doc":"When tracing live systems, always take special care to not overload a node with\ntoo heavy tracing. `ttb` provides option `overload` to address this problem.\n\n`{overload, MSec, Module, Function}` instructs the `ttb` back end (a part of the\n[Runtime_Tools](`e:runtime_tools:index.html`) application) to perform overload\ncheck every `MSec` millisecond. If the check (named `Module:Function(check)`)\nreturns `true`, tracing is disabled on the selected node.\n\nOverload protection activated on one node does not affect other nodes, where the\ntracing continues as normal. `ttb:stop/0` fetches data from all clients,\nincluding everything collected before the activation of overload protection.\n\n> #### Note {: .info }\n>\n> It is not allowed to change trace details (with `ttb:p/2` and `ttb:tp/tpl...`)\n> once overload protection is activated in one of the traced nodes. This is to\n> avoid trace setup being inconsistent between nodes.\n\n`Module:Function` provided with option `overload` must handle three calls:\n`init`, `check`, and `stop`. `init` and `stop` allow some setup and teardown\nrequired by the check. An overload check module can look as follows:\n\n```erlang\n-module(overload).\n-export([check/1]).\n\ncheck(init) ->\n    Pid = sophisticated_module:start(),\n    put(pid, Pid);\ncheck(check) ->\n    get(pid) ! is_overloaded,\n    receive\n        Reply ->\n            Reply\n    after 5000 ->\n            true\n    end;\ncheck(stop) ->\n    get(pid) ! stop.\n```\n\n> #### Note {: .info }\n>\n> `check` is always called by the same process, so `put` and `get` are possible.","ref":"ttb_ug.html#overload-protection"},{"type":"extras","title":"Autoresume - Trace Tool Builder","doc":"A node can crash (probably a buggy one, hence traced). Use `resume` to resume\ntracing on the node automatically when it gets back. The failing node then tries\nto reconnect to trace control node when `Runtime_Tools` is started. This implies\nthat `Runtime_Tools` must be included in the startup chain of other nodes (if\nnot, you can still resume tracing by starting `Runtime_Tools` manually, that is,\nby an RPC call).\n\nTo not lose the data that the failing node stored up to the point of crash, the\ncontrol node tries to fetch it before restarting trace. This must occur within\nthe allowed time frame, otherwise it is aborted (default is 10 seconds, but it\ncan be changed with `{resume, MSec}`). The data fetched this way is then merged\nwith all other traces.\n\nThe autostart feature requires more data to be stored on traced nodes. By\ndefault, the data is stored automatically to the file named \"ttb_autostart.bin\"\nin the current working directory (cwd) of the traced node. Users can change this\nbehaviour (that is, on diskless nodes) by specifying their own module to handle\nautostart data storage and retrieval (`ttb_autostart_module` environment\nvariable of `runtime_tools`). For information about the API, see module `m:ttb`.\nThe following example shows the default handler:\n\n```erlang\n-module(ttb_autostart).\n-export([read_config/0,\n         write_config/1,\n         delete_config/0]).\n\n-define(AUTOSTART_FILENAME, \"ttb_autostart.bin\").\n\ndelete_config() ->\n    file:delete(?AUTOSTART_FILENAME).\n\nread_config() ->\n    case file:read_file(?AUTOSTART_FILENAME) of\n        {ok, Data} -> {ok, binary_to_term(Data)};\n        Error      -> Error\n    end.\n\nwrite_config(Data) ->\n    file:write_file(?AUTOSTART_FILENAME, term_to_binary(Data)).\n```\n\n> #### Note {: .info }\n>\n> Remember that file trace ports buffer the data by default. If the node\n> crashes, trace messages are not flushed to the binary log. If the risk of\n> failure is high, it can be a good idea to flush the buffers every now and then\n> automatically. Passing `{flush, MSec}` as an option of `ttb:tracer/2` flushes\n> all buffers every `MSec` millisecond.","ref":"ttb_ug.html#autoresume"},{"type":"extras","title":"dbg Mode - Trace Tool Builder","doc":"Option `{shell, ShellType}` allows making `ttb` operation similar to `m:dbg`.\nUsing `{shell, true}` displays all trace messages in the shell before storing\nthem. `{shell, only}` additionally disables message storage (making the tool to\nbehave exactly like `dbg`). This is allowed only with IP trace ports\n(`{trace, {local, File}}`).\n\nCommand `ttb:tracer(dbg)` is a shortcut for the pure `dbg` mode\n(`{shell, only}`).\n\n[](){: #trace_info }","ref":"ttb_ug.html#dbg-mode"},{"type":"extras","title":"Trace Information and File .ti - Trace Tool Builder","doc":"In addition to the trace log file(s), a file with extension `.ti` is created\nwhen Trace Tool Builder is started. This is the trace information file. It is a\nbinary file, which contains the process information, trace flags used, the name\nof the node to which it belongs, and all information written with function\n`ttb:write_trace_info/2`. `.ti` files are always fetched with other logs when\nthe trace is stopped.\n\nExcept for the process information, everything in the trace information file is\npassed on to the handler function when formatting. Parameter `TI` is a list of\n`{Key,ValueList}` tuples. The keys `flags`, `handler`, `file`, and `node` are\nused for information written directly by `ttb`.\n\nInformation to the trace information file by can be added by calling\n`ttb:write_trace_info/2`. Notice that `ValueList` always is a list, and if you\ncall `write_trace_info/2` many times with the same `Key`, the `ValueList` is\nextended with a new value each time.\n\n_Example:_\n\n`ttb:write_trace_info(mykey,1)` gives the entry `{mykey,[1]}` in `TI`. Another\ncall, `ttb:write_trace_info(mykey,2)`, changes this entry to `{mykey,[1,2]}`.","ref":"ttb_ug.html#trace-information-and-file-ti"},{"type":"extras","title":"Wrap Logs - Trace Tool Builder","doc":"If you want to limit the size of the trace logs, you can use wrap logs. This\nworks almost like a circular buffer. You can specify the maximum number of\nbinary logs and the maximum size of each log. `ttb` then creates a new binary\nlog each time a log reaches the maximum size. When the maximum number of logs\nare reached, the oldest log is deleted before a new one is created.\n\n> #### Note {: .info }\n>\n> The overall size of data generated by `ttb` can be greater than the wrap\n> specification suggests. If a traced node restarts and autoresume is enabled,\n> the old wrap log is always stored and a new one is created.\n\nWrap logs can be formatted one by one or all at once. See\n[Formatting](ttb_ug.md#format).\n\n[](){: #format }","ref":"ttb_ug.html#wrap-logs"},{"type":"extras","title":"Formatting - Trace Tool Builder","doc":"Formatting can be done automatically when stopping `ttb` (see section\n[Automatically Collect and Format Logs from All Nodes](ttb_ug.md#fetch_format)),\nor explicitly by calling function `ttb:format/1,2`.\n\nFormatting means to read a binary log and present it in a readable format. You\ncan use the default format handler in `ttb` to present each trace message as a\nline of text, or write your own handler to make more complex interpretations of\nthe trace information. You can also use application ET to present the trace log\ngraphically (see section\n[Presenting Trace Logs with Event Tracer](ttb_ug.md#et_viewer)).\n\nThe first argument to `ttb:format/1,2` specifies which binary log(s) to format.\nThis is usually the name of a directory that `ttb` created during log fetch.\nUnless option `disable_sort` is provided, the logs from different files are\nalways sorted according to time-stamp in traces.\n\nThe second argument to `ttb:format/2` is a list of options as follows:\n\n- **`out`** - Specifies the destination to write the formatted text. Default\n  destination is `standard_io`, but a filename can also be specified.\n\n- **`handler`** - Specifies the format handler to use. If this option is not\n  specified, option `handler` that is specified when starting the tracer is\n  used. If option `handler` is not specified when starting the tracer either, a\n  default handler is used, which prints each trace message as a text line.\n\n- **`disable_sort`** - Indicates that the logs are not to be merged according to\n  time-stamp, but processed one file after another (this can be a bit faster).\n\nA format handler is a fun taking four arguments. This fun is called for each\ntrace message in the binary log(s). A simple example that only prints each trace\nmessage can be as follows:\n\n```erlang\nfun(Fd, Trace, _TraceInfo, State) ->\n   io:format(Fd, \"Trace: ~p~n\", [Trace]),\n   State\nend.\n```\n\nHere, `Fd` is the file descriptor for the destination file, or the atom\n`standard_io`. `_TraceInfo` contains information from the trace information file\n(see section [Trace Information and File .ti](ttb_ug.md#trace_info)). `State` is\na state variable for the format handler fun. The initial value of variable\n`State` is specified with the handler option, for example:\n\n```erlang\nttb:format(\"tiger@durin-ttb\", [{handler, {{Mod,Fun}, initial_state}}])\n                                                     ^^^^^^^^^^^^^\n```\n\nAnother format handler can be used to calculate the time spent by the garbage\ncollector:\n\n```erlang\nfun(_Fd,{trace_ts,P,gc_start,_Info,StartTs},_TraceInfo,State) ->\n      [{P,StartTs}|State];\n   (Fd,{trace_ts,P,gc_end,_Info,EndTs},_TraceInfo,State) ->\n      {value,{P,StartTs}} = lists:keysearch(P,1,State),\n      Time = diff(StartTs,EndTs),\n      io:format(\"GC in process ~w: ~w milliseconds~n\", [P,Time]),\n      State -- [{P,StartTs}]\nend\n```\n\nA more refined version of this format handler is function `handle_gc/4` in\nmodule `multitrace.erl` included in directory `src` of the Observer application.\n\nThe trace message is passed as the second argument (`Trace`). The possible\nvalues of `Trace` are the following:\n\n- All trace messages described in `erlang:trace/3`\n- `{drop, N}` if IP tracer is used (see `dbg:trace_port/2`)\n- `end_of_trace` received once when all trace messages are processed\n\nBy giving the format handler [`ttb:get_et_handler()`](`ttb:get_et_handler/0`),\nyou can have the trace log presented graphically with `et_viewer` in the ET\napplication (see section\n[Presenting Trace Logs with Event Tracer](ttb_ug.md#et_viewer)).\n\nYou can always decide not to format the whole trace data contained in the fetch\ndirectory, but analyze single files instead. To do so, a single file (or list of\nfiles) must be passed as the first argument to `format/1,2`.\n\nWrap logs can be formatted one by one or all at once. To format one of the wrap\nlogs in a set, specify the exact file name. To format the whole set of wrap\nlogs, specify the name with `*` instead of the wrap count.\n\n_Example:_\n\nStart tracing:\n\n```erlang\n(tiger@durin)1> ttb:tracer(node(),{file,{wrap,\"trace\"}}).\n{ok,[tiger@durin]}\n(tiger@durin)2> ttb:p(...)\n...\n```\n\nThis gives a set of binary logs, for example:\n\n```text\ntiger@durin-trace.0.wrp\ntiger@durin-trace.1.wrp\ntiger@durin-trace.2.wrp\n...\n```\n\nFormat the whole set of logs:\n\n```erlang\n1> ttb:format(\"tiger@durin-trace.*.wrp\").\n....\nok\n2>\n```\n\nFormat only the first log:\n\n```erlang\n1> ttb:format(\"tiger@durin-trace.0.wrp\").\n....\nok\n2>\n```\n\nTo merge all wrap logs from two nodes:\n\n```erlang\n1> ttb:format([\"tiger@durin-trace.*.wrp\",\"lion@durin-trace.*.wrp\"]).\n....\nok\n2>\n```\n\n[](){: #et_viewer }","ref":"ttb_ug.html#formatting"},{"type":"extras","title":"Presenting Trace Logs with Event Tracer - Trace Tool Builder","doc":"For detailed information about the Event Tracer, see the [ET](`e:et:index.html`)\napplication.\n\nBy giving the format handler [`ttb:get_et_handler()`](`ttb:get_et_handler/0`),\nyou can have the trace log presented graphically with `et_viewer` in the ET\napplication. `ttb` provides filters that can be selected from the menu _Filter_\nin the `et_viewer` window. The filters are names according to the type of actors\nthey present (that is, what each vertical line in the sequence diagram\nrepresents). Interaction between actors is shown as red arrows between two\nvertical lines, and activities within an actor are shown as blue text to the\nright of the actors line.\n\nThe `processes` filter is the only filter showing all trace messages from a\ntrace log. Each vertical line in the sequence diagram represents a process.\nErlang messages, spawn, and link/unlink are typical interactions between\nprocesses. Function calls, scheduling, and garbage collection, are typical\nactivities within a process. `processes` is the default filter.\n\nThe remaining filters only show function calls and function returns. All other\ntrace message are discarded. To get the most out of these filters, `et_viewer`\nmust know the caller of each function and the time of return. This can be\nobtained using both the `call` and `return_to` flags when tracing. Notice that\nflag `return_to` only works with local call trace, that is, when trace patterns\nare set with `ttb:tpl`.\n\nThe same result can be obtained by using the flag `call` only and setting a\nmatch specification on local or global function calls as follows:\n\n```erlang\n1> dbg:fun2ms(fun(_) -> return_trace(),message(caller()) end).\n[{'_',[],[{return_trace},{message,{caller}}]}]\n```\n\nThis must however be done with care, as function `{return_trace}` in the match\nspecification destroys tail recursiveness.\n\nThe `modules` filter shows each module as a vertical line in the sequence\ndiagram. External function calls/returns are shown as interactions between\nmodules, and internal function calls/returns are shown as activities within a\nmodule.\n\nThe `functions` filter shows each function as a vertical line in the sequence\ndiagram. A function calling itself is shown as an activity within a function,\nand all other function calls are shown as interactions between functions.\n\nThe `mods_and_procs` and `funcs_and_procs` filters are equivalent to the\n`modules` and `functions` filters respectively, except that each module or\nfunction can have many vertical lines, one for each process it resides on.\n\nIn the following example, modules `foo` and `bar` are used:\n\n```erlang\n-module(foo).\n-export([start/0,go/0]).\n\nstart() ->\n    spawn(?MODULE, go, []).\n\ngo() ->\n    receive\n        stop ->\n            ok;\n        go ->\n            bar:f1(),\n            go()\n    end.\n```\n\n```erlang\n-module(bar).\n-export([f1/0,f3/0]).\nf1() ->\n    f2(),\n    ok.\nf2() ->\n    spawn(?MODULE,f3,[]).\nf3() ->\n    ok.\n```\n\nSetting up the trace:\n\n```erlang\n(tiger@durin)1> %%First we retrieve the Pid to limit traced processes set\n(tiger@durin)1> Pid = foo:start().\n(tiger@durin)2> %%Now we set up tracing\n(tiger@durin)2> ttb:tracer().\n(tiger@durin)3> ttb:p(Pid, [call, return_to, procs, set_on_spawn]).\n(tiger@durin)4> ttb:tpl(bar, []).\n(tiger@durin)5> %%Invoke our test function and see output with et viewer\n(tiger@durin)5> Pid ! go.\n(tiger@durin)6> ttb:stop({format, {handler, ttb:get_et_handler()}}).\n```\n\nThis renders a result similar to the following:\n\n![Filter: \"processes\"](assets/et_processes.gif \"Filter: \"processes\"\")\n\n![Filter: \"mods_and_procs\"](assets/et_modsprocs.gif \"Filter: \"mods_and_procs\"\")\n\nNotice that function `ttb:start_trace/4` can be used as help as follows:\n\n```erlang\n(tiger@durin)1> Pid = foo:start().\n(tiger@durin)2> ttb:start_trace([node()],\n                                [{bar,[]}],\n                                {Pid, [call, return_to, procs, set_on_spawn]}\n                                {handler, ttb:get_et_handler()}).\n(tiger@durin)3> Pid ! go.\n(tiger@durin)4> ttb:stop(format).\n```\n\n[](){: #fetch_format }","ref":"ttb_ug.html#presenting-trace-logs-with-event-tracer"},{"type":"extras","title":"Automatically Collect and Format Logs from All Nodes - Trace Tool Builder","doc":"By default, `ttb:stop/1` fetches trace logs and trace information files from all\nnodes. The logs are stored in a new directory named\n`ttb_upload-Filename-Timestamp` under the working directory of the trace control\nnode. Fetching can be disabled by providing option `nofetch` to `ttb:stop/1`.\nThe user can specify a fetch directory by passing option `{fetch_dir, Dir}`.\n\nIf option `format` is specified to `ttb:stop/1`, the trace logs are\nautomatically formatted after tracing is stopped.","ref":"ttb_ug.html#automatically-collect-and-format-logs-from-all-nodes"},{"type":"extras","title":"History and Configuration Files - Trace Tool Builder","doc":"For the tracing functionality, `m:dbg` can be used instead of `ttb` for setting\ntrace flags on processes and trace patterns for call trace, that is, the\nfunctions `p`, `tp`, `tpl`, `ctp`, `ctpl`, and `ctpg`. Only the following two\nthings are added by `ttb` for these functions:\n\n- All calls are stored in the history buffer and can be recalled and stored in a\n  configuration file. This makes it easy to set up the same trace environment,\n  for example, if you want to compare two test runs. It also reduces the amount\n  of typing when using `ttb` from the Erlang shell.\n- Shortcuts are provided for the most common match specifications (to not force\n  you to use [`dbg:fun2ms`](`dbg:fun2ms/1`) continually).\n\nUse `ttb:list_history/0` to see the content of the history buffer and\n`ttb:run_history/1` to re-execute one of the entries.\n\nThe main purpose of the history buffer is the possibility to create\nconfiguration files. Any function stored in the history buffer can be written to\na configuration file and used for creating a specific configuration at any time\nwith a single function call.\n\nA configuration file is created or extended with\n[`ttb:write_config/2,3`](`ttb:write_config/2`). Configuration files are binary\nfiles and can therefore only be read and written with functions provided by\n`ttb`.\n\nThe complete content of the history buffer can be written to a configuration\nfile by calling `ttb:write_config(ConfigFile,all)`. Selected entries from the\nhistory can be written by calling `ttb:write_config(ConfigFile,NumList)`, where\n`NumList` is a list of integers pointing out the history entries to write.\nMoreover, the history buffer is always dumped to `ttb_last_config` when\n`ttb:stop/0,1` is called.\n\nUser-defined entries can also be written to a configuration file by calling\nfunction `ttb:write_config(ConfigFile,ConfigList)`, where `ConfigList` is a list\nof `{Module,Function,Args}`.\n\nAny existing file `ConfigFile` is deleted and a new file is created when\n`write_config/2` is called. Option `append` can be used to add something at the\nend of an existing configuration file, for example,\n`ttb:write_config(ConfigFile,What,[append])`.\n\n_Example:_\n\nSee the content of the history buffer:\n\n```erlang\n(tiger@durin)191> ttb:tracer().\n{ok,[tiger@durin]}\n(tiger@durin)192> ttb:p(self(),[garbage_collection,call]).\n{ok,{[<0.1244.0>],[garbage_collection,call]}}\n(tiger@durin)193> ttb:tp(ets,new,2,[]).\n{ok,[{matched,1}]}\n(tiger@durin)194> ttb:list_history().\n[{1,{ttb,tracer,[tiger@durin,[]]}},\n {2,{ttb,p,[<0.1244.0>,[garbage_collection,call]]}},\n {3,{ttb,tp,[ets,new,2,[]]}}]\n```\n\nExecute an entry from the history buffer:\n\n```erlang\n(tiger@durin)195> ttb:ctp(ets,new,2).\n{ok,[{matched,1}]}\n(tiger@durin)196> ttb:list_history().\n[{1,{ttb,tracer,[tiger@durin,[]]}},\n {2,{ttb,p,[<0.1244.0>,[garbage_collection,call]]}},\n {3,{ttb,tp,[ets,new,2,[]]}},\n {4,{ttb,ctp,[ets,new,2]}}]\n(tiger@durin)197> ttb:run_history(3).\nttb:tp(ets,new,2,[]) ->\n{ok,[{matched,1}]}\n```\n\nWrite the content of the history buffer to a configuration file:\n\n```erlang\n(tiger@durin)198> ttb:write_config(\"myconfig\",all).\nok\n(tiger@durin)199> ttb:list_config(\"myconfig\").\n[{1,{ttb,tracer,[tiger@durin,[]]}},\n {2,{ttb,p,[<0.1244.0>,[garbage_collection,call]]}},\n {3,{ttb,tp,[ets,new,2,[]]}},\n {4,{ttb,ctp,[ets,new,2]}},\n {5,{ttb,tp,[ets,new,2,[]]}}]\n```\n\nExtend an existing configuration:\n\n```erlang\n(tiger@durin)200> ttb:write_config(\"myconfig\",[{ttb,tp,[ets,delete,1,[]]}],\n[append]).\nok\n(tiger@durin)201> ttb:list_config(\"myconfig\").\n[{1,{ttb,tracer,[tiger@durin,[]]}},\n {2,{ttb,p,[<0.1244.0>,[garbage_collection,call]]}},\n {3,{ttb,tp,[ets,new,2,[]]}},\n {4,{ttb,ctp,[ets,new,2]}},\n {5,{ttb,tp,[ets,new,2,[]]}},\n {6,{ttb,tp,[ets,delete,1,[]]}}]\n```\n\nGo back to a previous configuration after stopping Trace Tool Builder:\n\n```erlang\n(tiger@durin)202> ttb:stop().\nok\n(tiger@durin)203> ttb:run_config(\"myconfig\").\nttb:tracer(tiger@durin,[]) ->\n{ok,[tiger@durin]}\n\nttb:p(<0.1244.0>,[garbage_collection,call]) ->\n{ok,{[<0.1244.0>],[garbage_collection,call]}}\n\nttb:tp(ets,new,2,[]) ->\n{ok,[{matched,1}]}\n\nttb:ctp(ets,new,2) ->\n{ok,[{matched,1}]}\n\nttb:tp(ets,new,2,[]) ->\n{ok,[{matched,1}]}\n\nttb:tp(ets,delete,1,[]) ->\n{ok,[{matched,1}]}\n\nok\n```\n\nWrite selected entries from the history buffer to a configuration file:\n\n```erlang\n(tiger@durin)204> ttb:list_history().\n[{1,{ttb,tracer,[tiger@durin,[]]}},\n {2,{ttb,p,[<0.1244.0>,[garbage_collection,call]]}},\n {3,{ttb,tp,[ets,new,2,[]]}},\n {4,{ttb,ctp,[ets,new,2]}},\n {5,{ttb,tp,[ets,new,2,[]]}},\n {6,{ttb,tp,[ets,delete,1,[]]}}]\n(tiger@durin)205> ttb:write_config(\"myconfig\",[1,2,3,6]).\nok\n(tiger@durin)206> ttb:list_config(\"myconfig\").\n[{1,{ttb,tracer,[tiger@durin,[]]}},\n {2,{ttb,p,[<0.1244.0>,[garbage_collection,call]]}},\n {3,{ttb,tp,[ets,new,2,[]]}},\n {4,{ttb,tp,[ets,delete,1,[]]}}]\n(tiger@durin)207>\n```","ref":"ttb_ug.html#history-and-configuration-files"},{"type":"extras","title":"Sequential Tracing - Trace Tool Builder","doc":"To learn what sequential tracing is and how it can be used, see the Reference\nManual for `m:seq_trace`.\n\nThe support for sequential tracing provided by Trace Tool Builder includes the\nfollowing:\n\n- Initiation of the system tracer. This is automatically done when a trace port\n  is started with [`ttb:tracer/0,1,2`](`ttb:tracer/0`).\n- Creation of match specifications that activates sequential tracing.\n\nStarting sequential tracing requires that a tracer is started with function\n`ttb:tracer/0,1,2`. Sequential tracing can then be started in either of the\nfollowing ways:\n\n- Through a trigger function with a match specification created with\n  [`ttb:seq_trigger_ms/0,1`](`ttb:seq_trigger_ms/0`).\n- Directly by using module `m:seq_trace`.\n\n_Example 1:_\n\nIn the following example, function `dbg:get_tracer/0` is used as trigger for\nsequential tracing:\n\n```erlang\n(tiger@durin)110> ttb:tracer().\n{ok,[tiger@durin]}\n(tiger@durin)111> ttb:p(self(),call).\n{ok,{[<0.158.0>],[call]}}\n(tiger@durin)112> ttb:tp(dbg,get_tracer,0,ttb:seq_trigger_ms(send)).\n{ok,[{matched,1},{saved,1}]}\n(tiger@durin)113> dbg:get_tracer(), seq_trace:reset_trace().\ntrue\n(tiger@durin)114> ttb:stop(format).\n({<0.158.0>,{shell,evaluator,3},tiger@durin}) call dbg:get_tracer()\nSeqTrace [0]: ({<0.158.0>,{shell,evaluator,3},tiger@durin})\n{<0.237.0>,dbg,tiger@durin} ! {<0.158.0>,{get_tracer,tiger@durin}}\n[Serial: {0,1}]\nSeqTrace [0]: ({<0.237.0>,dbg,tiger@durin})\n{<0.158.0>,{shell,evaluator,3},tiger@durin} ! {dbg,{ok,#Port<0.222>}}\n[Serial: {1,2}]\nok\n(tiger@durin)116>\n```\n\n_Example 2:_\n\nStarting sequential tracing with a trigger is more useful if the trigger\nfunction is not called directly from the shell, but rather implicitly within a\nlarger system. When calling a function from the shell, it is simpler to start\nsequential tracing directly, for example, as follows:\n\n```erlang\n(tiger@durin)116> ttb:tracer().\n{ok,[tiger@durin]}\n(tiger@durin)117> seq_trace:set_token(send,true), dbg:get_tracer(),\nseq_trace:reset_trace().\ntrue\n(tiger@durin)118> ttb:stop(format).\nSeqTrace [0]: ({<0.158.0>,{shell,evaluator,3},tiger@durin})\n{<0.246.0>,dbg,tiger@durin} ! {<0.158.0>,{get_tracer,tiger@durin}}\n[Serial: {0,1}]\nSeqTrace [0]: ({<0.246.0>,dbg,tiger@durin})\n{<0.158.0>,{shell,evaluator,3},tiger@durin} ! {dbg,{ok,#Port<0.229>}}\n[Serial: {1,2}]\nok\n(tiger@durin)120>\n```\n\nIn both previous examples, `seq_trace:reset_trace/0` resets the trace token\nimmediately after the traced function to avoid many trace messages because of\nthe printouts in the Erlang shell.\n\nAll functions in module `seq_trace`, except `set_system_tracer/1`, can be used\nafter the trace port is started with `ttb:tracer/0,1,2`.","ref":"ttb_ug.html#sequential-tracing"},{"type":"extras","title":"Multipurpose Trace Tool - Trace Tool Builder","doc":"Module `multitrace` in directory `src` of the Observer application provides a\nsmall tool with three possible trace settings. The trace messages are written to\nbinary files, which can be formatted with function `multitrace:format/1,2`:\n\n- **`multitrace:debug(What)`** - Start calltrace on all processes and trace the\n  specified function(s). The format handler used is `multitrace:handle_debug/4`\n  that prints each call and returns. `What` must be an item or a list of items\n  to trace, specified on the format `{Module,Function,Arity}`,\n  `{Module,Function}`, or only `Module`.\n\n- **`multitrace:gc(Procs)`** - Trace garbage collection on the specified\n  process(es). The format handler used is `multitrace:handle_gc/4` that prints\n  start, stop, and the time spent for each garbage collection.\n\n- **`multitrace:schedule(Procs)`** - Trace in-scheduling and out-scheduling on\n  the specified process(es). The format handler used is\n  `multitrace:handle_schedule/4` that prints each in-scheduling and\n  out-scheduling with process, time-stamp, and current function. It also prints\n  the total time each traced process was scheduled in.","ref":"ttb_ug.html#multipurpose-trace-tool"},{"type":"extras","title":"Erlang Top","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Erlang Top","ref":"etop_ug.html"},{"type":"extras","title":"Introduction - Erlang Top","doc":"Erlang Top, `etop`, is a tool for presenting information about Erlang processes\nsimilar to the information presented by `top` in UNIX.","ref":"etop_ug.html#introduction"},{"type":"extras","title":"Getting Started - Erlang Top","doc":"Start Erlang Top in either of the following ways:\n\n- Use script `etop`.\n- Use batch file `etop.bat`, for example, `etop -node tiger@durin`.","ref":"etop_ug.html#getting-started"},{"type":"extras","title":"Output - Erlang Top","doc":"The output from Erlang Top is as follows:\n\n```text\n========================================================================================\n tiger@durin                                                               13:40:32\n Load:  cpu         0               Memory:  total        1997    binary         33\n        procs     197                        processes       0    code          173\n        runq      135                        atom         1002    ets            95\n\nPid            Name or Initial Func    Time    Reds  Memory    MsgQ Current Function\n----------------------------------------------------------------------------------------\n<127.23.0>     code_server                0   59585   78064       0 gen_server:loop/6\n<127.21.0>     file_server_2              0   36380   44276       0 gen_server:loop/6\n<127.2.0>      erl_prim_loader            0   27962    3740       0 erl_prim_loader:loop\n<127.9.0>      kernel_sup                 0    6998    4676       0 gen_server:loop/6\n<127.17.0>     net_kernel                62    6018    3136       0 gen_server:loop/6\n<127.0.0>      init                       0    4156    4352       0 init:loop/1\n<127.16.0>     auth                       0    1765    1264       0 gen_server:loop/6\n<127.18.0>     inet_tcp_dist:accept       0     660    1416       0 prim_inet:accept0/2\n<127.5.0>      application_controll       0     569    6756       0 gen_server:loop/6\n<127.137.0>    net_kernel:do_spawn_       0     553    5840       0 dbg:do_relay_1/1\n========================================================================================\n```\n\nThe header includes some system information:\n\n- **`Load`**\n\n  - **`cpu`** - `Runtime/Wallclock`, that is, the percentage of time where the\n    node has been active.\n\n  - **`procs`** - The number of processes on the node.\n\n  - **`runq`** - The number of processes that are ready to run.\n\n- **`Memory`** - The memory allocated by the node in kilobytes.\n\nFor each process the following information is presented:\n\n- **`Time`** - The runtime for the process, that is, the time that the process\n  has been scheduled in.\n\n- **`Reds`** - The number of reductions executed on the process.\n\n- **`Memory`** - The size of the process in bytes, obtained by a call to\n  [`process_info(Pid,memory)`](`process_info/2`).\n\n- **`MsgQ`** - The length of the message queue for the process.\n\n> #### Note {: .info }\n>\n> _Time_ and _Reds_ can be presented as accumulated values or as values since\n> the last update.","ref":"etop_ug.html#output"},{"type":"extras","title":"Configuration - Erlang Top","doc":"All configuration parameters can be set at start by adding `-OptName Value` to\nthe command line, for example:\n\n```text\n% etop -node tiger@durin -setcookie mycookie -lines 15\n```\n\nA list of all valid Erlang Top configuration parameters is available in module\n`m:etop`.\n\nThe parameters `lines`, `interval`, `accumulate`, and `sort` can be changed\nduring runtime with function `etop:config/2`.\n\n_Example:_\n\nChange configuration parameter `lines` with text-based presentation. Before the\nchange, 10 lines are presented as follows:\n\n```text\n========================================================================================\n tiger@durin                                                               10:12:39\n Load:  cpu         0               Memory:  total        1858    binary         33\n        procs     191                        processes       0    code          173\n        runq        2                        atom         1002    ets            95\n\nPid            Name or Initial Func    Time    Reds  Memory    MsgQ Current Function\n----------------------------------------------------------------------------------------\n<127.23.0>     code_server                0   60350   71176       0 gen_server:loop/6\n<127.21.0>     file_server_2              0   36380   44276       0 gen_server:loop/6\n<127.2.0>      erl_prim_loader            0   27962    3740       0 erl_prim_loader:loop\n<127.17.0>     net_kernel                 0   13808    3916       0 gen_server:loop/6\n<127.9.0>      kernel_sup                 0    6998    4676       0 gen_server:loop/6\n<127.0.0>      init                       0    4156    4352       0 init:loop/1\n<127.18.0>     inet_tcp_dist:accept       0    2196    1416       0 prim_inet:accept0/2\n<127.16.0>     auth                       0    1893    1264       0 gen_server:loop/6\n<127.43.0>     ddll_server                0     582    3744       0 gen_server:loop/6\n<127.5.0>      application_controll       0     569    6756       0 gen_server:loop/6\n========================================================================================\n```\n\nFunction `etop:config/2` is called to change the number of showed lines to 5:\n\n```text\n> etop:config(lines,5).\nok\n```\n\nAfter the change, 5 lines are presented as follows:\n\n```text\n(etop@durin)2>\n========================================================================================\n tiger@durin                                                               10:12:44\n Load:  cpu         0               Memory:  total        1859    binary         33\n        procs     192                        processes       0    code          173\n        runq        2                        atom         1002    ets            95\n\nPid            Name or Initial Func    Time    Reds  Memory    MsgQ Current Function\n----------------------------------------------------------------------------------------\n<127.17.0>     net_kernel               183      70    4092       0 gen_server:loop/6\n<127.335.0>    inet_tcp_dist:do_acc     141      22    1856       0 dist_util:con_loop/9\n<127.19.0>     net_kernel:ticker/2      155       6    1244       0 net_kernel:ticker1/2\n<127.341.0>    net_kernel:do_spawn_       0       0    5840       0 dbg:do_relay_1/1\n<127.43.0>     ddll_server                0       0    3744       0 gen_server:loop/6\n========================================================================================\n```","ref":"etop_ug.html#configuration"},{"type":"extras","title":"Print to File - Erlang Top","doc":"At any time, the current Erlang Top display can be dumped to a text file with\nfunction `etop:dump/1`.","ref":"etop_ug.html#print-to-file"},{"type":"extras","title":"Stop - Erlang Top","doc":"To stop Erlang Top, use function `etop:stop/0`.","ref":"etop_ug.html#stop"},{"type":"extras","title":"Crashdump Viewer","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Crashdump Viewer","ref":"crashdump_ug.html"},{"type":"extras","title":"Introduction - Crashdump Viewer","doc":"The Crashdump Viewer is a WxWidgets based tool for browsing Erlang crashdumps.","ref":"crashdump_ug.html#introduction"},{"type":"extras","title":"Getting Started - Crashdump Viewer","doc":"The easiest way to start Crashdump Viewer is to use shell script `cdv` with the\nfull path to the Erlang crashdump as argument. The script is located in\ndirectory `priv` of the Observer application. This starts the Crashdump Viewer\nGUI and loads the specified file. If no filename is specified, a file dialog is\nopened where the file can be selected.\n\nUnder Windows, the batch file `cdv.bat` can be used.\n\nCrashdump Viewer can also be started from an Erlang node by calling\n`crashdump_viewer:start/0` or `crashdump_viewer:start/1`.","ref":"crashdump_ug.html#getting-started"},{"type":"extras","title":"GUI - Crashdump Viewer","doc":"The GUI main window is opened when Crashdump Viewer has loaded a crashdump. It\ncontains a title bar, a menu bar, information tabs, and a status bar.\n\nThe title bar shows the name of the currently loaded crashdump.\n\nThe menu bar contains a _File_ menu and a _Help_ menu. From the _File_ menu, a\nnew crashdump can be loaded or the tool can be terminated. From the _Help_ menu,\nthis User's Guide and section \"How to interpret the Erlang crash dumps\" from the\nERTS application can be opened. \"How to interpret the Erlang crash dumps\"\ndescribes the raw crashdumps in detail and includes information about each field\nin the information pages.\"How to interpret the Erlang crash dumps\" is also\navailable in the OTP online documentation.\n\nThe status bar at the bottom of the window shows a warning if the currently\nloaded dump is truncated.\n\nThe center area of the main window contains the information tabs. Each tab\ndisplays information about a specific item or a list of items. Select a tab by\nclicking the tab title.\n\nFrom tabs displaying lists of items, for example, the _Processes_ tab or the\n_Ports_ tab, a new window with more information can be opened by double-clicking\na row or by right- clicking the row and selecting an item from the drop-down\nmenu. The new window is called a detail window. Detail windows can be opened for\nprocesses, ports, nodes, and modules.\n\nThe information shown in a detail window can contain links to processes or\nports. Clicking one of these links opens the detail window for the process or\nport in question. If the process or port resides on a remote node, no\ninformation is available. Clicking the link then displays a dialog where you can\nchoose to open the detail window for the remote node.\n\nSome tabs contain a left-hand menu where subitems of the information area can be\nselected. Click one of the rows, and the information is displayed in the\nright-hand information area.","ref":"crashdump_ug.html#gui"},{"type":"extras","title":"Tab Content - Crashdump Viewer","doc":"Each tab in the main window contains an information page. If no information is\nfound for an item, the page is empty. The reason for not finding information\nabout an item can be the following:\n\n- It is a dump from an old OTP release in which this item was not written.\n- The item was not present in the system at the point of failure.\n- The dump is truncated. In this case, a warning is displayed in the status bar\n  of the main window.\n\nEven if some information about an item exists, there can be empty fields if the\ndump originates from an old OTP release.\n\nThe value `-1` in any field means \"unknown\", and in most cases it means that the\ndump was truncated somewhere around this field.\n\nThe following sections describe some of the fields in the information tabs.\nThese are fields that do not exist in the raw crashdump, or in some way differ\nfrom the fields in the raw crashdump. For details about other fields, see the\n[ERTS User's Guide](`e:erts:index.html`), section \"How to interpret the Erlang\ncrash dumps\". That section can also be opened from the _Help_ menu in the main\nwindow. There are also links from the following sections to related information\nin \"How to interpret the Erlang crash dumps\".\n\n[](){: #general_info }","ref":"crashdump_ug.html#tab-content"},{"type":"extras","title":"General Tab - Crashdump Viewer","doc":"Tab _General_ shows a short overview of the dump.\n\nThe following fields are not described in the ERTS User's Guide:\n\n- **`Crashdump created on`** - Time of failure.\n\n- **`Memory allocated`** - The total number of bytes allocated, equivalent to\n  `c:memory(total)`.\n\n- **`Memory maximum`** - The maximum number of bytes that has been allocated\n  during the lifetime of the originating node. This is only shown if the Erlang\n  runtime system is run instrumented.\n\n- **`Atoms`** - If available in the dump, this is the total number of atoms in\n  the atom table. If the size of the atom table is unavailable, the number of\n  atoms visible in the dump is displayed.\n\n- **`Processes`** - The number of processes visible in the dump.\n\n- **`ETS tables`** - The number of ETS tables visible in the dump.\n\n- **`Funs`** - The number of funs visible in the dump.\n\nFor details, see [General Information](`e:erts:crash_dump.md#general-information`) in\nsection \"How to Interpret the Erlang Crash Dumps\" in ERTS.\n\n[](){: #processes }","ref":"crashdump_ug.html#general-tab"},{"type":"extras","title":"Processes Tab - Crashdump Viewer","doc":"Tab _Processes_ shows a list of all processes found in the crashdump, including\nbrief information about each process. By default, the processes are sorted by\ntheir pids. To sort by another topic, click the desired column heading.\n\nColumn _Memory_ shows the 'Memory' field that was added to crashdumps in\nErlang/OTP R16B01. This is the total amount of memory used by the process. For\ncrashdumps from earlier releases, this column shows the 'Stack+heap' field. The\nvalue is always in bytes.\n\nTo view detailed information about a specific process, double- click the row in\nthe list, or right-click the row and select _Properties for  _.\n\nFor details, see [Process Information](`e:erts:crash_dump.md#process-data`) in\nsection \"How to Interpret the Erlang Crash Dumps\" in ERTS.\n\n[](){: #ports }","ref":"crashdump_ug.html#processes-tab"},{"type":"extras","title":"Ports Tab - Crashdump Viewer","doc":"Tab _Ports_ is similar to the _Processes_ tab, except it lists all ports found\nin the crashdump.\n\nTo view more details about a specific port, double-click the row or right-click\nit and select _Properties for  _. From the right-click menu, you can also\nselect _Properties for  _, where ` ` is the process connected to the\nport.\n\nFor details, see [Port Information](`e:erts:crash_dump.md#port-information`) in section\n\"How to Interpret the Erlang Crash Dumps\" in ERTS.\n\n[](){: #ets_tables } [](){: #internal_ets_tables }","ref":"crashdump_ug.html#ports-tab"},{"type":"extras","title":"ETS Tables Tab - Crashdump Viewer","doc":"Tab _ETS Tables_ shows all ETS table information found in the dump. _Id_ is the\nsame as the 'Table' field in the raw crashdump. _Memory_ is the 'Words' field\nfrom the raw crashdump translated into bytes. For tree tables, there is no value\nin the 'Objects' field.\n\nTo open the detailed information page about the table, double- click, or\nright-click the row and select _Properties for 'Identifier'_.\n\nTo open the detailed information page about the owner process of an ETS table,\nright-click the row and select _Properties for  _.\n\nFor details, see [ETS Tables](`e:erts:crash_dump.md#ets-tables`) in section \"How\nto Interpret the Erlang Crash Dumps\" in ERTS.\n\n[](){: #timers }","ref":"crashdump_ug.html#ets-tables-tab"},{"type":"extras","title":"Timers Tab - Crashdump Viewer","doc":"Tab _Timers_ shows all timer information found in the dump.\n\nTo open the detailed information page about the owner process of a timer,\nright-click the row and select _Properties for  _.\n\nDouble-clicking a row in the _Timers_ tab has no effect.\n\nFor details, see [Timers](`e:erts:crash_dump.md#timers`) in section \"How to\nInterpret the Erlang Crash Dumps\" in ERTS.\n\n[](){: #schedulers }","ref":"crashdump_ug.html#timers-tab"},{"type":"extras","title":"Schedulers Tab - Crashdump Viewer","doc":"Tab _Schedulers_ shows all scheduler information found in the dump.\n\nTo open the detailed information page about the scheduler, double-click, or\nright-click the row and select _Properties for 'Identifier'_.\n\nFor details, see [Scheduler Information](`e:erts:crash_dump.md#scheduler-information`) in\nsection \"How to Interpret the Erlang Crash Dumps\" in ERTS.\n\n[](){: #funs }","ref":"crashdump_ug.html#schedulers-tab"},{"type":"extras","title":"Funs Tab - Crashdump Viewer","doc":"Tab _Funs_ shows all fun information found in the dump.\n\nTo open the detailed information page about the module to which the fun belongs,\nright-click the row and select _Properties for  _.\n\nDouble-clicking a row in the _Funs_ tab has no effect.\n\nFor details, see [Fun Information](`e:erts:crash_dump.md#fun-information`) in section \"How\nto Interpret the Erlang Crash Dumps\" in ERTS.\n\n[](){: #atoms }","ref":"crashdump_ug.html#funs-tab"},{"type":"extras","title":"Atoms Tab - Crashdump Viewer","doc":"Tab _Atoms_ lists all atoms found in the dump. By default the atoms are sorted\nin creation order from first to last. This is opposite of the raw crashdump\nwhere atoms are listed from last to first, meaning that if the dump was\ntruncated in the middle of the atom list, only the last created atoms are\nvisible in the _Atoms_ tab.\n\nFor details, see [Atoms](`e:erts:crash_dump.md#atoms`) in section \"How to\nInterpret the Erlang Crash Dumps\" in ERTS.\n\n[](){: #distribution_info }","ref":"crashdump_ug.html#atoms-tab"},{"type":"extras","title":"Nodes Tab - Crashdump Viewer","doc":"Tab _Nodes_ shows a list of all external Erlang nodes that are referenced from\nthe crashdump.\n\nIf the page is empty, it means either of the following:\n\n- The crashed node is not distributed.\n- The crashed node is distributed but has no references to other nodes.\n- The dump is truncated.\n\nIf the node is distributed, all referenced nodes are visible. Column _Connection\ntype_ shows if the node is visible, hidden, or not connected. Visible nodes are\nalive nodes with a living connection to the originating node. Hidden nodes are\nthe same as visible nodes, except they are started with flag `-hidden`. Not\nconnected nodes are nodes that are not connected to the originating node\nanymore, but references (that is, process or port identifiers) exist.\n\nTo see more detailed information about a node, double-click the row, or\nright-click the row and select _Properties for node  _. From the\nright-click menu, you can also select _Properties for  _, to open the\ndetailed information window for the controlling port.\n\nIn the detailed information window for a node, any existing links and monitors\nbetween processes on the originating node and the connected node are displayed.\n_Extra Info_ can contain debug information (that is, special information written\nif the emulator is debug-compiled) or error information.\n\nFor details, see\n[Distribution Information](`e:erts:crash_dump.md#distribution-information`) in section\n\"How to Interpret the Erlang Crash Dumps\" in ERTS.\n\n[](){: #loaded_modules }","ref":"crashdump_ug.html#nodes-tab"},{"type":"extras","title":"Modules Tab - Crashdump Viewer","doc":"Tab _Modules_ lists all modules loaded on the originating node, and the current\ncode size. If old code exists, the old size is also shown.\n\nTo view detailed information about a specific module, double- click the row, or\nright-click it and select _Properties for  _.\n\nFor details, see\n[Loaded Module Information](`e:erts:crash_dump.md#loaded-module-information`) in section\n\"How to Interpret the Erlang Crash Dumps\" in ERTS.\n\n[](){: #memory }","ref":"crashdump_ug.html#modules-tab"},{"type":"extras","title":"Memory Tab - Crashdump Viewer","doc":"Tab _Memory_ shows memory and allocator information. From the left-hand menu you\ncan select the following:\n\n- **_Memory_** - See [Memory Information](`e:erts:crash_dump.md#memory-information`) in\n  section \"How to Interpret the Erlang Crash Dumps\" in ERTS.\n\n- **_Allocator Summary_** - This page presents a summary of values from all\n  allocators underneath it.\n\n- **_ _** - One entry per allocator. See\n  [Allocator](`e:erts:crash_dump.md#allocator`) in section \"How to Interpret the\n  Erlang Crash Dumps\" in ERTS.\n\n- **_Allocated Areas_** - See\n  [Allocated Areas](`e:erts:crash_dump.md#allocated-areas`) in section \"How to\n  Interpret the Erlang Crash Dumps\" in ERTS.\n\n[](){: #internal_tables }","ref":"crashdump_ug.html#memory-tab"},{"type":"extras","title":"Internal Tables Tab - Crashdump Viewer","doc":"On tab _Internal Tables_ you can from the left-hand menu select _Hash Tables_,\n_Index Tables_, or _Internal ETS Tables_.\n\nFor details, see\n[Internal Table Information](`e:erts:crash_dump.md#internal-table-information`) in section\n\"How to Interpret the Erlang Crash Dumps\" in ERTS.","ref":"crashdump_ug.html#internal-tables-tab"},{"type":"extras","title":"cdv","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# cdv\n\nScript to start the Crashdump Viewer from the OS command line.","ref":"cdv_cmd.html"},{"type":"extras","title":"Description - cdv","doc":"The `cdv` shell script is located in directory `priv` of the Observer\napplication. The script is used for starting the Crashdump Viewer tool from the\nOS command line.\n\nFor Windows users, `cdv.bat` is found in the same location.","ref":"cdv_cmd.html#description"},{"type":"extras","title":"cdv \\[file] - cdv","doc":"Argument `file` is optional. If not specified, a file dialog is displayed,\nallowing you to select a crashdump from the file system.","ref":"cdv_cmd.html#cdv-file"}],"proglang":"erlang","content_type":"text/markdown","producer":{"name":"ex_doc","version":"0.37.3"}}