searchData={"items":[{"type":"module","title":"cpu_sup","doc":"A CPU Load and CPU Utilization Supervisor Process\n\n`cpu_sup` is a process which supervises the CPU load and CPU utilization. It is\npart of the OS_Mon application, see [os_mon(6)](os_mon_app.md). Available for\nUnix, although CPU utilization values (`util/0,1`) are only available for\nSolaris, Linux, FreeBSD and OpenBSD.\n\nThe load values are proportional to how long time a runnable Unix process has to\nspend in the run queue before it is scheduled. Accordingly, higher values mean\nmore system load. The returned value divided by 256 produces the figure\ndisplayed by `rup` and `top`. What is displayed as 2.00 in `rup`, is displayed\nas load up to the second mark in `xload`.\n\nFor example, `rup` displays a load of 128 as 0.50, and 512 as 2.00.\n\nIf the user wants to view load values as percentage of machine capacity, then\nthis way of measuring presents a problem, because the load values are not\nrestricted to a fixed interval. In this case, the following simple mathematical\ntransformation can produce the load value as a percentage:\n\n```text\nPercentLoad = 100 * (1 - D/(D + Load))\n```\n\n`D` determines which load value should be associated with which percentage.\nChoosing `D` = 50 means that 128 is 60% load, 256 is 80%, 512 is 90%, and so on.\n\nAnother way of measuring system load is to divide the number of busy CPU cycles\nby the total number of CPU cycles. This produces values in the 0-100 range\nimmediately. However, this method hides the fact that a machine can be more or\nless saturated. CPU utilization is therefore a better name than system load for\nthis measure.\n\nA server which receives just enough requests to never become idle will score a\nCPU utilization of 100%. If the server receives 50% more requests, it will still\nscore 100%. When the system load is calculated with the percentage formula shown\npreviously, the load will increase from 80% to 87%.\n\nThe `avg1/0`, `avg5/0`, and `avg15/0` functions can be used for retrieving\nsystem load values, and the `util/0` and [`util/1`](`util/1`) functions can be\nused for retrieving CPU utilization values.\n\nWhen run on Linux, `cpu_sup` assumes that the `/proc` file system is present and\naccessible by `cpu_sup`. If it is not, `cpu_sup` will terminate.","ref":"cpu_sup.html"},{"type":"module","title":"See Also - cpu_sup","doc":"[os_mon(3)](os_mon_app.md)","ref":"cpu_sup.html#module-see-also"},{"type":"function","title":"cpu_sup.avg1/0","doc":"Returns the average system load in the last minute, as described above. 0\nrepresents no load, 256 represents the load reported as 1.00 by `rup`.\n\nReturns 0 if `cpu_sup` is not available.","ref":"cpu_sup.html#avg1/0"},{"type":"function","title":"cpu_sup.avg5/0","doc":"Returns the average system load in the last five minutes, as described above. 0\nrepresents no load, 256 represents the load reported as 1.00 by `rup`.\n\nReturns 0 if `cpu_sup` is not available.","ref":"cpu_sup.html#avg5/0"},{"type":"function","title":"cpu_sup.avg15/0","doc":"Returns the average system load in the last 15 minutes, as described above. 0\nrepresents no load, 256 represents the load reported as 1.00 by `rup`.\n\nReturns 0 if `cpu_sup` is not available.","ref":"cpu_sup.html#avg15/0"},{"type":"function","title":"cpu_sup.nprocs/0","doc":"Returns the number of UNIX processes running on this machine. This is a crude\nway of measuring the system load, but it may be of interest in some cases.\n\nReturns 0 if `m:cpu_sup` is not available.","ref":"cpu_sup.html#nprocs/0"},{"type":"function","title":"cpu_sup.util/0","doc":"Returns CPU utilization since the last call to `util/0` or [`util/1`](`util/1`)\nby the calling process.\n\n> #### Note {: .info }\n>\n> The returned value of the first call to `util/0` or [`util/1`](`util/1`) by a\n> process will on most systems be the CPU utilization since system boot, but\n> this is not guaranteed and the value should therefore be regarded as garbage.\n> This also applies to the first call after a restart of `cpu_sup`.\n\nThe CPU utilization is defined as the sum of the percentage shares of the CPU\ncycles spent in all busy processor states (see [`util/1`](`util/1`)) in\naverage on all CPUs.\n\nReturns 0 if `cpu_sup` is not available.","ref":"cpu_sup.html#util/0"},{"type":"function","title":"cpu_sup.util/1","doc":"Returns CPU utilization since the last call to `util/0` or [`util/1`](`util/1`)\nby the calling process, in more detail than `util/0`.\n\n> #### Note {: .info }\n>\n> The returned value of the first call to `util/0` or [`util/1`](`util/1`) by a\n> process will on most systems be the CPU utilization since system boot, but\n> this is not guaranteed and the value should therefore be regarded as garbage.\n> This also applies to the first call after a restart of `cpu_sup`.\n\nCurrently recognized options:\n\n- **`detailed`** - The returned `UtilDesc`(s) will be even more detailed.\n\n- **`per_cpu`** - Each CPU will be specified separately (assuming this\n  information can be retrieved from the operating system), that is, a list with\n  one `UtilDesc` per CPU will be returned.\n\nDescription of `UtilDesc = {Cpus, Busy, NonBusy, Misc}`:\n\n- **`Cpus`** - If the `detailed` and/or `per_cpu` option is given, this is the\n  CPU number, or a list of the CPU numbers.\n\n  If not, this is the atom `all` which implies that the `UtilDesc` contains\n  information about all CPUs.\n\n- **`Busy`** - If the `detailed` option is given, this is a list of\n  `{State, Share}` tuples, where each tuple contains information about a\n  processor state that has been identified as a busy processor state (see\n  below). The atom `State` is the name of the state, and the float `Share`\n  represents the percentage share of the CPU cycles spent in this state since\n  the last call to `util/0` or [`util/1`](`util/1`).\n\n  If not, this is the sum of the percentage shares of the CPU cycles spent in\n  all states identified as busy.\n\n  If the `per_cpu` is not given, the value(s) presented are the average of all\n  CPUs.\n\n- **`NonBusy`** - Similar to `Busy`, but for processor states that have been\n  identified as non-busy (see below).\n\n- **`Misc`** - Currently unused; reserved for future use.\n\nCurrently these processor states are identified as busy:\n\n- **`user`** - Executing code in user mode.\n\n- **`nice_user`** - Executing code in low priority (nice) user mode. This state\n  is currently only identified on Linux.\n\n- **`kernel`** - Executing code in kernel mode.\n\nCurrently these processor states are identified as non-busy:\n\n- **`wait`** - Waiting. This state is currently only identified on Solaris.\n\n- **`idle`** - Idle.\n\n> #### Note {: .info }\n>\n> Identified processor states may be different on different operating systems\n> and may change between different versions of `cpu_sup` on the same operating\n> system. The sum of the percentage shares of the CPU cycles spent in all busy\n> and all non-busy processor states will always add up to 100%, though.\n\nReturns `{all,0,0,[]}` if `cpu_sup` is not available.","ref":"cpu_sup.html#util/1"},{"type":"type","title":"cpu_sup.util_cpus/0","doc":"","ref":"cpu_sup.html#t:util_cpus/0"},{"type":"type","title":"cpu_sup.util_desc/0","doc":"","ref":"cpu_sup.html#t:util_desc/0"},{"type":"type","title":"cpu_sup.util_state/0","doc":"","ref":"cpu_sup.html#t:util_state/0"},{"type":"type","title":"cpu_sup.util_value/0","doc":"","ref":"cpu_sup.html#t:util_value/0"},{"type":"module","title":"disksup","doc":"A Disk Supervisor Process\n\n`disksup` is a process which supervises the available disk space in the system.\nIt is part of the OS_Mon application, see [os_mon(6)](os_mon_app.md). Available\nfor Unix and Windows.\n\nPeriodically checks the disks. For each disk or partition which uses more than a\ncertain amount of the available space, the alarm\n`{{disk_almost_full, MountedOn}, []}` is set.\n\n- **On Unix** - All (locally) mounted disks are checked, including the swap disk\n  if it is present.\n\n- **On WIN32** - All logical drives of type \"FIXED_DISK\" are checked.\n\nAlarms are reported to the SASL alarm handler, see `m:alarm_handler`. To set an\nalarm, [`alarm_handler:set_alarm(Alarm)`](`alarm_handler:set_alarm/1`) is called\nwhere `Alarm` is the alarm specified above.\n\nThe alarms are cleared automatically when the alarm cause is no longer valid.","ref":"disksup.html"},{"type":"module","title":"Configuration - disksup","doc":"The following configuration parameters can be used to change the default values\nfor time interval and threshold:\n\n- **`disk_space_check_interval = ` `t:time/0`** - The time interval for the\n  periodic disk space check. The default is 30 minutes.\n\n- **`disk_almost_full_threshold = float()`** - The threshold, as percentage of\n  total disk space, for how much disk can be utilized before the\n  `disk_almost_full` alarm is set. The default is 0.80 (80%).\n\n- **`disksup_posix_only = bool()`** - Specifies whether the `disksup` helper\n  process should only use POSIX conformant commands (`true`) or not. The default\n  is `false`. Setting this parameter to `true` can be necessary on embedded\n  systems with stripped-down versions of Unix tools like `df`. The returned disk\n  data and alarms can be different when using this option.\n\n  The parameter is ignored on platforms that are known to not be POSIX\n  compatible (Windows and SunOS).\n\nSee [config](`e:kernel:config.md`) for information about how to change the\nvalue of configuration parameters.","ref":"disksup.html#module-configuration"},{"type":"module","title":"See Also - disksup","doc":"`m:alarm_handler`, [os_mon](os_mon_app.md)","ref":"disksup.html#module-see-also"},{"type":"function","title":"disksup.get_almost_full_threshold/0","doc":"Returns the threshold, in percent, for disk space utilization.","ref":"disksup.html#get_almost_full_threshold/0"},{"type":"function","title":"disksup.get_check_interval/0","doc":"Returns the time interval, in milliseconds, for the periodic disk space check.","ref":"disksup.html#get_check_interval/0"},{"type":"function","title":"disksup.get_disk_data/0","doc":"Returns the result of the latest disk check.\n\n`Id` is a string that identifies the disk or partition. `TotalKiB` is the\ntotal size of the disk or partition in kibibytes. `Capacity` is the\npercentage of disk space used.\n\nThe function is asynchronous in the sense that it does not invoke a disk check,\nbut returns the latest available value.\n\nReturns `[{\"none\",0,0}]` if `disksup` is not available.","ref":"disksup.html#get_disk_data/0"},{"type":"function","title":"disksup.get_disk_info/0","doc":"Immediately fetches total space, available space and capacity for local disks.\n\n`Id` is a string that identifies the disk or partition. `TotalKiB` is the total\nsize of the disk or partition in kibibytes. `AvailableKiB` is the disk space\nused in kibibytes. `Capacity` is the percentage of disk space used.\n\nReturns `[{\"none\",0,0,0}]` if `disksup` is not available.","ref":"disksup.html#get_disk_info/0"},{"type":"function","title":"disksup.get_disk_info/1","doc":"Immediately fetches total space, available space and capacity for a path.\n\n`Id` is a string that identifies the disk or partition. `TotalKiB` is the total size\nof the disk or partition in kibibytes. `AvailableKiB` is the disk space used in\nkibibytes. `Capacity` is the percentage of disk space used.\n\nReturns `[{Path,0,0,0}]` if the `Path` is invalid or space can't be determined.\nReturns `[{\"none\",0,0,0}]` if `disksup` is not available.","ref":"disksup.html#get_disk_info/1"},{"type":"function","title":"disksup.set_almost_full_threshold/1","doc":"Changes the threshold, given as a float (`0.0 =< Float =< 1.0`), for disk space\nutilization.\n\nThe change will take effect during the next disk space check and is non-persist.\nThat is, in case of a process restart, this value is forgotten and the default\nvalue will be used. See [Configuration](`m:disksup#module-configuration`) above.","ref":"disksup.html#set_almost_full_threshold/1"},{"type":"function","title":"disksup.set_check_interval/1","doc":"Changes the time interval for the periodic disk space check.\n\nThe change will take effect after the next disk space check and is non-persist.\nThat is, in case of a process restart, this value is forgotten and the default\nvalue will be used. See [Configuration](`m:disksup#module-configuration`) above.","ref":"disksup.html#set_check_interval/1"},{"type":"type","title":"disksup.time/0","doc":"Time unit used for disklog APIs.\n\nSupported units are:\n\n- **`integer() >= 1`** - The time interval in minutes.\n\n- **`{TimeUnit, Time}`** - The time interval `Time` in a time unit specified by\n  `TimeUnit` where `TimeUnit` is of the type `t:erlang:time_unit/0` and `Time`\n  is a positive integer. The time interval needs to be at least one millisecond\n  long.","ref":"disksup.html#t:time/0"},{"type":"module","title":"memsup","doc":"A Memory Supervisor Process\n\n`memsup` is a process which supervises the memory usage for the system and for\nindividual processes. It is part of the OS_Mon application, see\n[os_mon](os_mon_app.md). Available for Unix and Windows.\n\nPeriodically performs a memory check:\n\n- If more than a certain amount of available system memory is allocated, as\n  reported by the underlying operating system, the alarm\n  `{system_memory_high_watermark, []}` is set. How the amount of available\n  memory is determined depends on the underlying OS and may change as better\n  values become available.\n- If any Erlang process `Pid` in the system has allocated more than a certain\n  amount of total system memory, the alarm\n  `{process_memory_high_watermark, Pid}` is set.\n\nAlarms are reported to the SASL alarm handler, see `m:alarm_handler`. To set an\nalarm, `alarm_handler:set_alarm(Alarm)` is called where `Alarm` is either of the\nalarms specified above.\n\nThe alarms are cleared automatically when the alarm cause is no longer valid.\n\nThe function [get_memory_data()](`get_memory_data/0`) can be used to retrieve\nthe result of the latest periodic memory check.\n\nThere is also a interface to system dependent memory data,\n[get_system_memory_data()](`get_system_memory_data/0`). The result is highly\ndependent on the underlying operating system and the interface is targeted\nprimarily for systems without virtual memory. However, the output on other\nsystems is still valid, although sparse.\n\nA call to `get_system_memory_data/0` is more costly than a call to\n`get_memory_data/0` as data is collected synchronously when this function is\ncalled.\n\nThe total system memory reported under UNIX is the number of physical pages of\nmemory times the page size, and the available memory is the number of available\nphysical pages times the page size. This is a reasonable measure as swapping\nshould be avoided anyway, but the task of defining total memory and available\nmemory is difficult because of virtual memory and swapping.","ref":"memsup.html"},{"type":"module","title":"Configuration - memsup","doc":"The following configuration parameters can be used to change the default values\nfor time intervals and thresholds:\n\n- **`memory_check_interval = int()>0`** - The time interval, in minutes, for the\n  periodic memory check. The default is one minute.\n\n- **`system_memory_high_watermark = float()`** - The threshold, as percentage of\n  system memory, for how much system memory can be allocated before the\n  corresponding alarm is set. The default is 0.80 (80%).\n\n- **`process_memory_high_watermark = float()`** - The threshold, as percentage\n  of system memory, for how much system memory can be allocated by one Erlang\n  process before the corresponding alarm is set. The default is 0.05 (5%).\n\n- **`memsup_helper_timeout = int()>0`** - A timeout, in seconds, for how long\n  the `memsup` process should wait for a result from a memory check. If the\n  timeout expires, a warning message `\"OS_MON (memsup) timeout\"` is issued via\n  `error_logger` and any pending, synchronous client calls will return a dummy\n  value. Normally, this situation should not occur. There have been cases on\n  Linux, however, where the pseudo file from which system data is read is\n  temporarily unavailable when the system is heavily loaded.\n\n  The default is 30 seconds.\n\n- **`memsup_system_only = bool()`** - Specifies whether the `memsup` process\n  should only check system memory usage (`true`) or not. The default is `false`,\n  meaning that information regarding both system memory usage and Erlang process\n  memory usage is collected.\n\n  It is recommended to set this parameter to `false` on systems with many\n  concurrent processes, as each process memory check makes a traversal of the\n  entire list of processes.\n\nSee [config](`e:kernel:config.md`) for information about how to change the\nvalue of configuration parameters.","ref":"memsup.html#module-configuration"},{"type":"module","title":"See Also - memsup","doc":"`m:alarm_handler`, [os_mon](os_mon_app.md)","ref":"memsup.html#module-see-also"},{"type":"function","title":"memsup.get_check_interval/0","doc":"Returns the time interval, in milliseconds, for the periodic memory check.","ref":"memsup.html#get_check_interval/0"},{"type":"function","title":"memsup.get_helper_timeout/0","doc":"Returns the timeout value, in seconds, for memory checks.","ref":"memsup.html#get_helper_timeout/0"},{"type":"function","title":"memsup.get_memory_data/0","doc":"Returns the result of the latest memory check, where `Total` is the total memory\nsize and `Allocated` the allocated memory size, in bytes.\n\n`Worst` is the pid and number of allocated bytes of the largest Erlang process\non the node. If `memsup` should not collect process data, that is if the\nconfiguration parameter `memsup_system_only` was set to `true`, `Worst` is\n`undefined`.\n\nThe function is normally asynchronous in the sense that it does not invoke a\nmemory check, but returns the latest available value. The one exception if is\nthe function is called before a first memory check is finished, in which case it\ndoes not return a value until the memory check is finished.\n\nReturns `{0,0,{pid(),0}}` or `{0,0,undefined}` if `memsup` is not available, or\nif all memory checks so far have timed out.","ref":"memsup.html#get_memory_data/0"},{"type":"function","title":"memsup.get_os_wordsize/0","doc":"Returns the wordsize of the current running operating system.","ref":"memsup.html#get_os_wordsize/0"},{"type":"function","title":"memsup.get_procmem_high_watermark/0","doc":"Returns the threshold, in percent, for process memory allocation.","ref":"memsup.html#get_procmem_high_watermark/0"},{"type":"function","title":"memsup.get_sysmem_high_watermark/0","doc":"Returns the threshold, in percent, for system memory allocation.","ref":"memsup.html#get_sysmem_high_watermark/0"},{"type":"function","title":"memsup.get_system_memory_data/0","doc":"Invokes a memory check and returns the resulting, system dependent, data as a\nlist of tagged tuples, where `Tag` currently can be one of the following:\n\n- **`total_memory`** - The total amount of memory available to the Erlang\n  emulator, allocated and free. May or may not be equal to the amount of memory\n  configured in the system.\n\n- **`available_memory`** - Informs about the amount memory that is available for\n  increased usage if there is an increased memory need. This value is not based\n  on a calculation of the other provided values and should give a better value\n  of the amount of memory that actually is available than calculating a value\n  based on the other values reported. This value is currently only present on\n  newer Linux kernels. If this value is not available on Linux, you can use the\n  sum of `cached_memory`, `buffered_memory`, and `free_memory` as an\n  approximation.\n\n- **`free_memory`** - The amount of free memory available to the Erlang emulator\n  for allocation.\n\n- **`system_total_memory`** - The amount of memory available to the whole\n  operating system. This may well be equal to `total_memory` but not\n  necessarily.\n\n- **`buffered_memory`** - The amount of memory the system uses for temporary\n  storing raw disk blocks.\n\n- **`cached_memory`** - The amount of memory the system uses for cached files\n  read from disk. On Linux, also memory marked as reclaimable in the kernel slab\n  allocator will be added to this value.\n\n- **`total_swap`** - The amount of total amount of memory the system has\n  available for disk swap.\n\n- **`free_swap`** - The amount of memory the system has available for disk swap.\n\n> #### Note {: .info }\n>\n> Note that new tagged tuples may be introduced in the result at any time\n> without prior notice\n\nNote that the order of the tuples in the resulting list is undefined and may\nchange at any time.\n\nAll memory sizes are presented as number of _bytes_.\n\nReturns the empty list [] if `memsup` is not available, or if the memory check\ntimes out.","ref":"memsup.html#get_system_memory_data/0"},{"type":"function","title":"memsup.set_check_interval/1","doc":"Changes the time interval, given in minutes, for the periodic memory check.\n\nThe change will take effect after the next memory check and is non-persistent.\nThat is, in case of a process restart, this value is forgotten and the default\nvalue will be used. See [Configuration](`m:memsup#module-configuration`).","ref":"memsup.html#set_check_interval/1"},{"type":"function","title":"memsup.set_helper_timeout/1","doc":"Changes the timeout value, given in seconds, for memory checks.\n\nThe change will take effect for the next memory check and is non-persistent.\nThat is, in the case of a process restart, this value is forgotten and the\ndefault value will be used. See [Configuration](`m:memsup#module-configuration`) above.","ref":"memsup.html#set_helper_timeout/1"},{"type":"function","title":"memsup.set_procmem_high_watermark/1","doc":"Changes the threshold, given as a float, for process memory allocation.\n\nThe change will take effect during the next periodic memory check and is\nnon-persistent. That is, in case of a process restart, this value is forgotten\nand the default value will be used. See [Configuration](`m:memsup#module-configuration`).","ref":"memsup.html#set_procmem_high_watermark/1"},{"type":"function","title":"memsup.set_sysmem_high_watermark/1","doc":"Changes the threshold, given as a float, for system memory allocation.\n\nThe change will take effect during the next periodic memory check and is\nnon-persistent. That is, in case of a process restart, this value is forgotten\nand the default value will be used. See [Configuration](`m:memsup#module-configuration`)\nabove.","ref":"memsup.html#set_sysmem_high_watermark/1"},{"type":"module","title":"nteventlog","doc":"Interface to Windows Event Log\n\n`nteventlog` provides a generic interface to the Windows event log. It is part\nof the OS_Mon application, see [os_mon](os_mon_app.md).\n\nThis module is used as the Windows backend for `os_sup`. See `m:os_sup`.\n\nTo retain backwards compatibility, this module can also be used to start a\nstandalone `nteventlog` process which is not part of the OS_Mon supervision\ntree. When starting such a process, the user has to supply an identifier as well\nas a callback function to handle the messages.\n\nThe identifier, an arbitrary string, should be reused whenever the same\napplication (or node) wants to start the process. `nteventlog` is informed about\nall events that have arrived to the eventlog since the last accepted message for\nthe current identifier. As long as the same identifier is used, the same\neventlog record will not be sent to `nteventlog` more than once (with the\nexception of when graved system failures arise, in which case the last records\nwritten before the failure may be sent to Erlang again after reboot).\n\nIf the event log is configured to wrap around automatically, records that have\narrived to the log and been overwritten when `nteventlog` was not running are\nlost. However, it detects this state and loses no records that are not\noverwritten.\n\nThe callback function works as described in `m:os_sup`.","ref":"nteventlog.html"},{"type":"module","title":"See Also - nteventlog","doc":"[os_mon](os_mon_app.md), `m:os_sup`\n\nWindows NT documentation","ref":"nteventlog.html#module-see-also"},{"type":"function","title":"nteventlog.start/2","doc":"Equivalent to [`start_link(Identifier, MFA)`](`start_link/2`) except that no\nlink is created between `nteventlog` and the calling process.","ref":"nteventlog.html#start/2"},{"type":"function","title":"nteventlog.start_link/2","doc":"This function starts the standalone `nteventlog` process and, if\n[`start_link/2`](`start_link/2`) is used, links to it.\n\n`Identifier` is an identifier as described above.\n\n`MFA` is the supplied callback function. When `nteventlog` receives information\nabout a new event, this function will be called as\n[`apply(Mod, Func, [Event|Args])`](`apply/3`) where `Event` is a tuple","ref":"nteventlog.html#start_link/2"},{"type":"function","title":"nteventlog.stop/0","doc":"Stops `nteventlog`. Usually only used during development. The server does not\nhave to be shut down gracefully to maintain its state.","ref":"nteventlog.html#stop/0"},{"type":"module","title":"os_sup","doc":"Interface to OS System Messages\n\n`os_sup` is a process providing a message passing service from the operating\nsystem to the error logger in the Erlang runtime system. It is part of the\nOS_Mon application, see [os_mon](os_mon_app.md). Available for Solaris and\nWindows.\n\nMessages received from the operating system results in an user defined callback\nfunction being called. This function can do whatever filtering and formatting is\nnecessary and then deploy any type of logging suitable for the user's\napplication.","ref":"os_sup.html"},{"type":"module","title":"Solaris Operation - os_sup","doc":"The Solaris (SunOS 5.x) messages are retrieved from the syslog daemon,\n`syslogd`.\n\nEnabling the service includes actions which require root privileges, such as\nchange of ownership and file privileges of an executable binary file, and\ncreating a modified copy of the configuration file for `syslogd`. When `os_sup`\nis terminated, the service must be disabled, meaning the original configuration\nmust be restored. Enabling/disabling can be done either outside or inside\n`os_sup`. See [Configuration](`m:os_sup#config`) below.\n\n> #### Warning {: .warning }\n>\n> This process cannot run in multiple instances on the same hardware. OS_Mon\n> must be configured to start `os_sup` on one node only if two or more Erlang\n> nodes execute on the same machine.\n\nThe format of received events is not defined.","ref":"os_sup.html#module-solaris-operation"},{"type":"module","title":"Windows Operation - os_sup","doc":"The Windows messages are retrieved from the eventlog file.\n\nThe `nteventlog` module is used to implement `os_sup`. See `m:nteventlog`. Note\nthat the start functions of `nteventlog` does not need to be used, as in this\ncase the process is started automatically as part of the OS_Mon supervision\ntree.\n\nOS messages are formatted as a tuple\n`{Time, Category, Facility, Severity, Message}`:\n\n- **`Time = {MegaSecs, Secs, MicroSecs}`** - A time stamp as returned by the BIF\n  `now/0`.\n\n- **`Category = string()`** - Usually one of `\"System\"`, `\"Application\"` or\n  `\"Security\"`. Note that the NT eventlog viewer has another notion of category,\n  which in most cases is totally meaningless and therefore not imported into\n  Erlang. What is called a category here is one of the main three types of\n  events occurring in a normal NT system.\n\n- **`Facility = string()`** - The source of the message, usually the name of the\n  application that generated it. This could be almost any string. When matching\n  messages from certain applications, the version number of the application may\n  have to be accounted for. This is what the NT event viewer calls \"source\".\n\n- **`Severity = string()`** - One of `\"Error\"`, `\"Warning\"`, `\"Informational\"`,\n  `\"Audit_Success\"`, `\"Audit_Faulure\"` or, in case of a currently unknown\n  Windows NT version `\"Severity_Unknown\"`.\n\n- **`Message = string()`** - Formatted exactly as it would be in the NT eventlog\n  viewer. Binary data is not imported into Erlang.\n\n[](){: #config }","ref":"os_sup.html#module-windows-operation"},{"type":"module","title":"Configuration - os_sup","doc":"- **`os_sup_mfa = {Module, Function, Args}`** - The callback function to use.\n  `Module` and `Function` are atoms and `Args` is a list of terms. When an OS\n  message `Msg` is received, this function is called as\n  [`apply(Module, Function, [Msg | Args])`](`apply/3`).\n\n  Default is `{os_sup, error_report, [Tag]}` which will send the event to the\n  error logger using\n  [error_logger:error_report(Tag, Msg)](`error_logger:error_report/2`). `Tag` is\n  the value of `os_sup_errortag`, see below.\n\n- **`os_sup_errortag = atom()`** - This parameter defines the error report type\n  used when messages are sent to error logger using the default callback\n  function. Default is `std_error`, which means the events are handled by the\n  standard event handler.\n\n- **`os_sup_enable = bool()`** - Solaris only. Defines if the service should be\n  enabled (and disabled) inside (`true`) or outside (`false`) `os_sup`. For\n  backwards compatibility reasons, the default is `true`. The recommended value\n  is `false`, as the Erlang emulator should normally not be run with `root`\n  privileges, as is required for enabling the service.\n\n- **`os_sup_own = string()`** - Solaris only. Defines the directory which\n  contains the backup copy and the Erlang specific configuration files for\n  `syslogd`, and a named pipe to receive the messages from `syslogd`. Default is\n  `\"/etc\"`.\n\n- **`os_sup_syslogconf = string()`** - Solaris only. Defines the full name of\n  the configuration file for `syslogd`. Default is `\"/etc/syslog.conf\"`.","ref":"os_sup.html#module-configuration"},{"type":"module","title":"See also - os_sup","doc":"`m:error_logger`, [os_mon](os_mon_app.md)\n\n`syslogd(1M)`, `syslog.conf(4)` in the Solaris documentation.","ref":"os_sup.html#module-see-also"},{"type":"function","title":"os_sup.disable/0","doc":"","ref":"os_sup.html#disable/0"},{"type":"function","title":"os_sup.disable/2","doc":"Disables the `os_sup` service. Needed on Solaris only.\n\nIf the configuration parameter `os_sup_enable` is `false`, this function is\ncalled automatically by `os_sup`, using the same arguments as when\n[`enable/2`](`enable/2`) was called.\n\nIf `os_sup_enable` is `true`, this function must be called _after_\nOS_Mon/`os_sup` is stopped. `Dir` defines the directory which contains the\nbackup copy and the Erlang specific configuration files for `syslogd`, and a\nnamed pipe to receive the messages from `syslogd`. Defaults to `\"/etc\"`. `Conf`\ndefines the full name of the configuration file for `syslogd`. Default is\n`\"/etc/syslog.conf\"`.\n\nResults in a OS call to:\n\n```text\n /bin/mod_syslog nootp Dir Conf\n```\n\nwhere ` ` is the `priv` directory of OS_Mon, `code:priv_dir(os_mon)`.\n\nReturns `ok` if this yields the expected result `\"0\"`, and `{error, Res}` if it\nyields anything else.\n\n> #### Note {: .info }\n>\n> This function requires root privileges to succeed.","ref":"os_sup.html#disable/2"},{"type":"function","title":"os_sup.enable/0","doc":"","ref":"os_sup.html#enable/0"},{"type":"function","title":"os_sup.enable/2","doc":"Enables the `os_sup` service. Needed on Solaris only.\n\nIf the configuration parameter `os_sup_enable` is `false`, this function is\ncalled automatically by `os_sup`, using the values of `os_sup_own` and\n`os_sup_syslogconf` as arguments.\n\nIf `os_sup_enable` is `true`, this function must be called _before_\nOS_Mon/`os_sup` is started. `Dir` defines the directory which contains the\nbackup copy and the Erlang specific configuration files for `syslogd`, and a\nnamed pipe to receive the messages from `syslogd`. Defaults to `\"/etc\"`. `Conf`\ndefines the full name of the configuration file for `syslogd`. Default is\n`\"/etc/syslog.conf\"`.\n\nResults in a OS call to:\n\n```text\n /bin/mod_syslog otp Dir Conf\n```\n\nwhere ` ` is the `priv` directory of OS_Mon, `code:priv_dir(os_mon)`.\n\nReturns `ok` if this yields the expected result `\"0\"`, and `{error, Res}` if it\nyields anything else.\n\n> #### Note {: .info }\n>\n> This function requires root privileges to succeed.","ref":"os_sup.html#enable/2"},{"type":"extras","title":"OS Monitoring Application","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# OS Monitoring Application","ref":"os_mon_app.html"},{"type":"extras","title":"Description - OS Monitoring Application","doc":"The operating system monitor, OS_Mon, provides the following services:\n\n- `m:cpu_sup` CPU load and utilization supervision (Unix)\n- `m:disksup` Disk supervision(Unix, Windows)\n- `m:memsup` Memory supervision (Unix, Windows)\n- `m:os_sup` Interface to OS system messages (Solaris, Windows)\n\nTo simplify usage of OS_Mon on distributed Erlang systems, it is not considered\nan error trying to use a service at a node where it is not available (either\nbecause OS_Mon is not running, or because the service is not available for that\nOS, or because the service is not started). Instead, a warning message is issued\nvia `error_logger` and a dummy value is returned, which one is specified in the\nman pages for the respective services.","ref":"os_mon_app.html#description"},{"type":"extras","title":"Configuration - OS Monitoring Application","doc":"When OS_Mon is started, by default all services available for the OS, except\n`os_sup`, are automatically started. This configuration can be changed using the\nfollowing application configuration parameters:\n\n- **`start_cpu_sup = bool()`** - Specifies if `cpu_sup` should be started.\n  Defaults to `true`.\n\n- **`start_disksup = bool()`** - Specifies if `disksup` should be started.\n  Defaults to `true`.\n\n- **`start_memsup = bool()`** - Specifies if `memsup` should be started.\n  Defaults to `true`.\n\n- **`start_os_sup = bool()`** - Specifies if `os_sup` should be started.\n  Defaults to `false`.\n\nConfiguration parameters effecting the different OS_Mon services are described\nin the respective man pages.\n\nSee [config](`e:kernel:config.md`) for information about how to change the\nvalue of configuration parameters.","ref":"os_mon_app.html#configuration"},{"type":"extras","title":"See Also - OS Monitoring Application","doc":"`m:cpu_sup`, `m:disksup`, `m:memsup`, `m:os_sup`, `m:nteventlog`, `m:snmp`.","ref":"os_mon_app.html#see-also"},{"type":"extras","title":"OS_Mon Release Notes","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# OS_Mon Release Notes\n\nThis document describes the changes made to the OS_Mon application.","ref":"notes.html"},{"type":"extras","title":"Os_Mon 2.10.1 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-10-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - OS_Mon Release Notes","doc":"- Fixed the `m:memsup` memory alarm to use `available_memory` when available, instead of always using `free_memory`.\n\n  Own Id: OTP-19304 Aux Id: [PR-8776], [GH-8759]\n\n[PR-8776]: https://github.com/erlang/otp/pull/8776\n[GH-8759]: https://github.com/erlang/otp/issues/8759","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Os_Mon 2.10 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-10"},{"type":"extras","title":"Improvements and New Features - OS_Mon Release Notes","doc":"- Function specifications and types have been added to all public API functions.\n\n  Own Id: OTP-18913\n\n- The documentation has been migrated to use Markdown and ExDoc.\n\n  Own Id: OTP-18955 Aux Id: [PR-8026]\n\n[PR-8026]: https://github.com/erlang/otp/pull/8026","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Os_Mon 2.9.1 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-9-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - OS_Mon Release Notes","doc":"- Fixed some benign compile warnings on Windows.\n\n  Own Id: OTP-18895","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Os_Mon 2.9 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-9"},{"type":"extras","title":"Fixed Bugs and Malfunctions - OS_Mon Release Notes","doc":"- Fix internal os_mon_sysinfo:get_disk_info/1 function to not crash when run on\n  Windows with multiple drives.\n\n  Own Id: OTP-18246 Aux Id: PR-6284 GH-6156\n\n- Fixed a memory leak when calling `cpu_sup:util/0,1` on FreeBSD.\n\n  Own Id: OTP-18546 Aux Id: GH-7070, PR-7071","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - OS_Mon Release Notes","doc":"- The `disksup:get_disk_info/0` and `disksup:get_disk_info/1` functions have\n  been introduced. These can be used in order to immediately fetch information\n  about current disk usage.\n\n  Own Id: OTP-18303 Aux Id: PR-6384\n\n- Runtime dependencies have been updated.\n\n  Own Id: OTP-18350\n\n- Support for `cpu_sup:util()` on OpenBSD.\n\n  Own Id: OTP-18566 Aux Id: PR-7080","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Os_Mon 2.8.2.1 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-8-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - OS_Mon Release Notes","doc":"* Fixed runtime dependencies.\n\n  Own Id: OTP-19064","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Os_Mon 2.8.2 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-8-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - OS_Mon Release Notes","doc":"- Avoid error report from failing `erlang:port_close` at shutdown of `cpu_sup`\n  and `memsup`. Bug exists since OTP 25.3 (os_mon-2.8.1).\n\n  Own Id: OTP-18559 Aux Id: ERIERL-942","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Os_Mon 2.8.1 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-8-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - OS_Mon Release Notes","doc":"- The port programs used by `cpu_sup` and `memsup` are now gracefully shut down\n  when `cpu_sup` and `memsup` are shut down.\n\n  Own Id: OTP-18469 Aux Id: PR-6689","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Os_Mon 2.8 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-8"},{"type":"extras","title":"Improvements and New Features - OS_Mon Release Notes","doc":"- The [`disk_space_check_interval`](`m:disksup#module-configuration`) configuration parameter\n  of `disksup` can now be set to values smaller than a minute.\n\n  Own Id: OTP-18304 Aux Id: PR-6385","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Os_Mon 2.7.1 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-7-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - OS_Mon Release Notes","doc":"- On a Mac with Apple Silicon, `memsup:get_os_wordsize/0` would return 32\n  instead of 64.\n\n  Own Id: OTP-17441","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Os_Mon 2.7 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-7"},{"type":"extras","title":"Improvements and New Features - OS_Mon Release Notes","doc":"- The temporarily introduced configuration parameter\n  `memsup_improved_system_memory_data` has been removed.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-16943 Aux Id: OTP-16906\n\n- Fix `disk_sup` to also search the system PATH on linux when looking for the\n  `df` program.\n\n  Own Id: OTP-16944 Aux Id: PR-2787","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Os_Mon 2.6.1 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-6-1"},{"type":"extras","title":"Improvements and New Features - OS_Mon Release Notes","doc":"- The configuration parameter `memsup_improved_system_memory_data` has been\n  introduced. It can be used to modify the result returned by\n  `memsup:get_system_memory_data()`. For more information see the `memsup`\n  documentation.\n\n  Note that the configuration parameter is intended to be removed in OTP 24 and\n  the modified result is intended to be used as of OTP 24.\n\n  Own Id: OTP-16906 Aux Id: ERIERL-532","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Os_Mon 2.6 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - OS_Mon Release Notes","doc":"- `memsup` now returns the correct amount of system memory on macOS.\n\n  Own Id: OTP-16798 Aux Id: ERL-1327","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - OS_Mon Release Notes","doc":"- Fix memsup:get_os_wordsize/0 to return the current size on aarch64.\n\n  Own Id: OTP-16742","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Os_Mon 2.5.2 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-5-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - OS_Mon Release Notes","doc":"- Fix various compiler warnings on 64-bit Windows.\n\n  Own Id: OTP-15800","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - OS_Mon Release Notes","doc":"- Refactored the internal handling of deprecated and removed functions.\n\n  Own Id: OTP-16469","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Os_Mon 2.5.1.1 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-5-1-1"},{"type":"extras","title":"Improvements and New Features - OS_Mon Release Notes","doc":"- The configuration parameter `memsup_improved_system_memory_data` has been\n  introduced. It can be used to modify the result returned by\n  `memsup:get_system_memory_data()`. For more information see the `memsup`\n  documentation.\n\n  Note that the configuration parameter is intended to be removed in OTP 24 and\n  the modified result is intended to be used as of OTP 24.\n\n  Own Id: OTP-16906 Aux Id: ERIERL-532","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Os_Mon 2.5.1 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-5-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - OS_Mon Release Notes","doc":"- Fix `disk_sup` to ignore squashfs on Linux when determining if a mounted\n  filesystem is full or not.\n\n  Own Id: OTP-15778\n\n- Fix bug where `cpu_sup:util()` always returned 100% on systems not using gnu\n  libc, for example Alpine OS.\n\n  Own Id: OTP-15974 Aux Id: ERL-1012","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Os_Mon 2.5 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - OS_Mon Release Notes","doc":"- Fix typespec of `cpu_sup:util()`.\n\n  Own Id: OTP-15770 Aux Id: PR-2208","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - OS_Mon Release Notes","doc":"- The application otp_mibs has been removed from OTP. Some of its components\n  (mibs) have been moved to other apps (snmp), or removed completely (os_mon).\n\n  Own Id: OTP-14984 Aux Id: OTP-15329","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Os_Mon 2.4.7 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-4-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - OS_Mon Release Notes","doc":"- Due to `/proc` restrictions in newer Android releases enforced by SELinux,\n  cpu_sup is fixed so that it gets some basic CPU stats using the `sysinfo`\n  syscall rather than reading `/proc/loadavg`.\n\n  Own Id: OTP-15387 Aux Id: PR-1966","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Os_Mon 2.4.6 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-4-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - OS_Mon Release Notes","doc":"- Improved documentation.\n\n  Own Id: OTP-15190","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Os_Mon 2.4.5 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-4-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - OS_Mon Release Notes","doc":"- Fix `disksup` to handle mount paths with spaces in them.\n\n  Own Id: OTP-14513","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Os_Mon 2.4.4 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-4-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - OS_Mon Release Notes","doc":"- Removed all old unused files in the documentation.\n\n  Own Id: OTP-14475 Aux Id: ERL-409, PR-1493","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Os_Mon 2.4.3 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-4-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - OS_Mon Release Notes","doc":"- On macOS 10.13 (High Sierra), disksup could not grab information for any disks\n  that used the new APFS file system. That has been corrected.\n\n  Own Id: OTP-14560 Aux Id: ERL-461","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Os_Mon 2.4.2 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-4-2"},{"type":"extras","title":"Improvements and New Features - OS_Mon Release Notes","doc":"- Support s390x in os_mon.\n\n  Own Id: OTP-14161 Aux Id: PR-1309","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Os_Mon 2.4.1 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-4-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - OS_Mon Release Notes","doc":"- Fix type specification for cpu_sup:util/1\n\n  Own Id: OTP-13526 Aux Id: PR-1029\n\n- Fix strict compilation on SUN/SPARC\n\n  Own Id: OTP-13548 Aux Id: PR-1046\n\n- Implement cpu_sup:util/0,1 on Mac OSX\n\n  Own Id: OTP-13597 Aux Id: PR-1049\n\n- Fix memsup:get_os_wordsize() on 64-bit FreeBSD and 64-bit Linux PPC\n\n  Own Id: OTP-13601 Aux Id: PR-1039","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Os_Mon 2.4 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-4"},{"type":"extras","title":"Improvements and New Features - OS_Mon Release Notes","doc":"- cpu_sup should use native sysctl/libkvm calls on BSD\n\n  This avoids forking off with os:cmd every time we just want to collect the\n  load averages. riak does this every second, which results in a lot of\n  unnecessary load.\n\n  Own Id: OTP-12730\n\n- Implement native cpu_sup:util/0,1 for FreeBSD\n\n  Own Id: OTP-12796","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Os_Mon 2.3.1 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - OS_Mon Release Notes","doc":"- Do not crash with badmatch when integer part of loadavg has more than 2\n  digits.\n\n  Own Id: OTP-12581","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - OS_Mon Release Notes","doc":"- Fix compilation of memsup on OpenBSD.\n\n  Own Id: OTP-12404","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Os_Mon 2.3 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-3"},{"type":"extras","title":"Improvements and New Features - OS_Mon Release Notes","doc":"- Adds a new application parameter 'disksup_posix_only', to make diskup use only\n  options defined in the POSIX standard.\n\n  Own Id: OTP-12053","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Os_Mon 2.2.15 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-2-15"},{"type":"extras","title":"Fixed Bugs and Malfunctions - OS_Mon Release Notes","doc":"- Application upgrade (appup) files are corrected for the following\n  applications:\n\n  `asn1, common_test, compiler, crypto, debugger, dialyzer, edoc, eldap, erl_docgen, et, eunit, gs, hipe, inets, observer, odbc, os_mon, otp_mibs, parsetools, percept, public_key, reltool, runtime_tools, ssh, syntax_tools, test_server, tools, typer, webtool, wx, xmerl`\n\n  A new test utility for testing appup files is added to test_server. This is\n  now used by most applications in OTP.\n\n  (Thanks to Tobias Schlager)\n\n  Own Id: OTP-11744","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - OS_Mon Release Notes","doc":"- Calls to erlang:open_port/2 with 'spawn' are updated to handle space in the\n  command path.\n\n  Own Id: OTP-10842","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Os_Mon 2.2.14 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-2-14"},{"type":"extras","title":"Fixed Bugs and Malfunctions - OS_Mon Release Notes","doc":"- Fix incorrect reporting of memory on OS X via memsup. Thanks to Christopher\n  Meiklejohn.\n\n  Own Id: OTP-11454","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Os_Mon 2.2.13 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-2-13"},{"type":"extras","title":"Fixed Bugs and Malfunctions - OS_Mon Release Notes","doc":"- Use 'df -k -l' to query FreeBSD and OpenBSD about diskspace on local disks.\n  Previously 'df' -k -t ufs' was used but this will not handle zfs or other\n  disks. Just use '-l' instead of listing potential filesystems.\n\n  Own Id: OTP-11207","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - OS_Mon Release Notes","doc":"- Fix compilation on Solaris. Thanks to Maciej Malecki.\n\n  Own Id: OTP-11213\n\n- Fix broken cpu_sup:nprocs and others on Solaris 64-bit. Thanks to Simon\n  Cornish.\n\n  Own Id: OTP-11298","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Os_Mon 2.2.12 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-2-12"},{"type":"extras","title":"Fixed Bugs and Malfunctions - OS_Mon Release Notes","doc":"- Compilation fixes for NetBSD. Thanks to YAMAMOTO Takashi.\n\n  Own Id: OTP-10941","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - OS_Mon Release Notes","doc":"- Fixed disksup:get_disk_data for SUSv3, specifically OS X ML. Thanks to Sriram\n  Melkote.\n\n  Own Id: OTP-10945","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Os_Mon 2.2.11 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-2-11"},{"type":"extras","title":"Fixed Bugs and Malfunctions - OS_Mon Release Notes","doc":"- Removed deprecated function calls to snmp\n\n  Own Id: OTP-10448","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Os_Mon 2.2.10 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-2-10"},{"type":"extras","title":"Fixed Bugs and Malfunctions - OS_Mon Release Notes","doc":"- Infinity timeout added to internal calls in disksup to allow it to work\n  properly under very heavy load.\n\n  Own Id: OTP-10100\n\n- Clarify error messages from os_mon port programs\n\n  Own Id: OTP-10161","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Os_Mon 2.2.9 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-2-9"},{"type":"extras","title":"Fixed Bugs and Malfunctions - OS_Mon Release Notes","doc":"- Fix segmentation fault in memsup\n\n  when /proc/meminfo does not include information about buffers/cache (for\n  instance inside OpenVZ container) (Thanks to Anton Vorobev)\n\n  Own Id: OTP-9913","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Os_Mon 2.2.8 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-2-8"},{"type":"extras","title":"Improvements and New Features - OS_Mon Release Notes","doc":"- Erlang/OTP can now be built using parallel make if you limit the number of\n  jobs, for instance using '`make -j6`' or '`make -j10`'. '`make -j`' does not\n  work at the moment because of some missing dependencies.\n\n  Own Id: OTP-9451\n\n- Tuple funs (a two-element tuple with a module name and a function) are now\n  officially deprecated and will be removed in R16. Use '`fun M:F/A`' instead.\n  To make you aware that your system uses tuple funs, the very first time a\n  tuple fun is applied, a warning will be sent to the error logger.\n\n  Own Id: OTP-9649","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Os_Mon 2.2.7 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-2-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - OS_Mon Release Notes","doc":"- Remove misc. compiler warnings\n\n  Own Id: OTP-9542","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Os_Mon 2.2.6 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-2-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - OS_Mon Release Notes","doc":"- Add NetBSD support to memsup and disksup (Thanks to Andrew Thompson)\n\n  Own Id: OTP-9216\n\n- Add support for DragonFlyBSD to memsup\n\n  DragonFly was partially supported by os_mon already but when trying to start\n  the os_mon application it'd crash with an error about an unknown operating\n  system in memsup. This patch changes memsup to use the FreeBSD sysctl method\n  to get memory information when on DragonFly. (Thanks to Andrew Thompson )\n\n  Own Id: OTP-9217","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Os_Mon 2.2.5 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-2-5"},{"type":"extras","title":"Improvements and New Features - OS_Mon Release Notes","doc":"- Cleanups suggested by tidier and modernization of types and specs.\n\n  Own Id: OTP-8455","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Os_Mon 2.2.4 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-2-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - OS_Mon Release Notes","doc":"- Memsup did not read memory correctly on macOS X Snowleopard. This has now been\n  corrected. (Thanks to Joel Reymont)\n\n  Own Id: OTP-8211\n\n- Removed unused code in `cpu_sup.erl`.\n\n  Own Id: OTP-8226","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - OS_Mon Release Notes","doc":"- The documentation is now built with open source tools (xsltproc and fop) that\n  exists on most platforms. One visible change is that the frames are removed.\n\n  Own Id: OTP-8201","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Os_Mon 2.2.3 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-2-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - OS_Mon Release Notes","doc":"- A missing define in `memsup.c` caused a build error on IRIX machines. This has\n  now been fixed.\n\n  Own Id: OTP-8094","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Os_Mon 2.2.2 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-2-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - OS_Mon Release Notes","doc":"- disksup:get_disk_data/0 returned disk volume in bytes instead of kbytes as\n  stated in the documentation. The problem occurred on Windows only and is now\n  corrected.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-7741","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Os_Mon 2.2.1 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - OS_Mon Release Notes","doc":"- An error in `memsup` could cause `os_mon` to report erroneous memory values on\n  windows for ranges of memory between 2GB and 4GB. This have now been fixed.\n\n  Own Id: OTP-7944","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - OS_Mon Release Notes","doc":"- Added support for dragonfly OS.\n\n  Own Id: OTP-7938","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Os_Mon 2.2 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-2"},{"type":"extras","title":"Improvements and New Features - OS_Mon Release Notes","doc":"- The copyright notices have been updated.\n\n  Own Id: OTP-7851","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Os_Mon 2.1.8 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-1-8"},{"type":"extras","title":"Fixed Bugs and Malfunctions - OS_Mon Release Notes","doc":"- A problem with `OTP-OS-MON-MIB.mib` for 64-bit environments has now been\n  fixed. The mib has been extended with 64-bit memory retrieval counterparts.\n\n  In addition, a new function `get_os_wordsize/0` has been added in the `memsup`\n  module\n\n  Own Id: OTP-7441\n\n- An error in `memsup.c` caused the compilation to crash on bsd environments.\n  This has now been fixed.\n\n  Own Id: OTP-7558","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Os_Mon 2.1.7 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-1-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - OS_Mon Release Notes","doc":"- Fixed a build error that occurred on NetBSD (Thanks to Per Hedeland and\n  Raphael Langerhorst)\n\n  Own Id: OTP-7505","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - OS_Mon Release Notes","doc":"- Memory information in `memsup:get_system_memory_data/0` now has additional\n  entries in its property list for Linux.\n\n  Own Id: OTP-7409 Aux Id: seq10984","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Os_Mon 2.1.6 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-1-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - OS_Mon Release Notes","doc":"- System information retrieval on darwin platforms with environments locales not\n  conforming to the C locale caused an error in `cpu_sup` resulting in process\n  termination.\n\n  Own Id: OTP-7320","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Os_Mon 2.1.5 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-1-5"},{"type":"extras","title":"Improvements and New Features - OS_Mon Release Notes","doc":"- CPU utilization, on linux, is now measured via a port program instead of\n  os:cmd in erlang. This should enhance performance.\n\n  Own Id: OTP-7108 Aux Id: OTP-6935","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Os_Mon 2.1.3 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-1-3"},{"type":"extras","title":"Improvements and New Features - OS_Mon Release Notes","doc":"- Extended memsup memory probing on Linux to use a port program to probe memory\n  usage. This is faster than the previous implementation.\n\n  Own Id: OTP-6860 Aux Id: seq10616","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Os_Mon 2.1.2.1 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-1-2-1"},{"type":"extras","title":"Improvements and New Features - OS_Mon Release Notes","doc":"- Minor Makefile changes.\n\n  Own Id: OTP-6689","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"OS_Mon 2.1.2 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-1-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - OS_Mon Release Notes","doc":"- When the `memsup_system_only` flag was set to `true`, a `badmatch` exception\n  occurred in the function `os_mon_mib:get_load/1`.\n\n  Own Id: OTP-6351 Aux Id: seq10517","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"OS_Mon 2.1.1 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - OS_Mon Release Notes","doc":"- Did not build on Mac OS X.\n\n  Added support for IRIX. (Thanks to Michel Urvoy and Daniel Solaz.)\n\n  Own Id: OTP-6136","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - OS_Mon Release Notes","doc":"- `disksup`: Now using [`round(T*100)`](`round/1`) instead of\n  [`trunc(T*100)`](`trunc/1`) when setting the threshold value given a float\n  `T`.\n\n  Own Id: OTP-6153","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Os_Mon 2.1 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - OS_Mon Release Notes","doc":"- In 2.0, a call to `alarm_handler:get_alarms/0` was introduced in `memsup` and\n  `disksup`. This will lead to problems if the default `alarm_handler` event\n  handler is not used, however, and the call has now been removed. (Thanks to\n  Serge Aleynikov for pointing this out.)\n\n  Own Id: OTP-6029\n\n- A bug that in rare cases caused `cpu_sup` to crash has been corrected.\n\n  Own Id: OTP-6102 Aux Id: seq10312","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"OS_Mon 2.0 - OS_Mon Release Notes","doc":"A note on backwards compatibility: The behaviour of OS_Mon 2.0 is backwards\ncompatible under normal operation, but has changed somewhat in error situations:\nThe services do not terminate and the API functions do not raise exceptions in\nall cases where they did before. Also, in the case where a service does\nterminate, the exit reason may be different. See below for details.","ref":"notes.html#os_mon-2-0"},{"type":"extras","title":"Fixed Bugs and Malfunctions - OS_Mon Release Notes","doc":"- A call to a OS_Mon service (cpu_sup, disksup, ...) when OS_Mon is not running,\n  or when the service is not available for the OS, or when the service is not\n  started, will no longer result in an exception. Instead a warning is issued\n  via error_logger and a dummy value is returned, which one is specified in the\n  man pages for the respective service.\n\n  The reason is that it should not be necessary for a service to be started on\n  each and every node of a distributed Erlang system for the OS-MON-MIB and\n  other OS_Mon users to work properly.\n\n  Own Id: OTP-4332 Aux Id: seq7358\n\n- References to the obsolete EVA application in OTP-OS-MON-MIB has been removed.\n\n  Own Id: OTP-5699\n\n- Setting the option `memsup_system_only` to `true` did not work, but would\n  crash the `memsup` process.\n\n  Own Id: OTP-5890 Aux Id: seq10185\n\n- `cpu_sup:nprocs/0` returned 0 on FreeBsd.\n\n  Own Id: OTP-5901\n\n- If the OS_Mon service `disksup` or `memsup` was restarted, the same alarm\n  could be set twice. Also, set alarms were not cleared when the application was\n  stopped.\n\n  Own Id: OTP-5910","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - OS_Mon Release Notes","doc":"- Thresholds and time intervals in `disksup` and `memsup` are now configurable\n  in run-time.\n\n  Own Id: OTP-4246 Aux Id: Seq7230\n\n- `memsup` can now handle systems with more than 4GB of RAM.\n\n  Own Id: OTP-5800 Aux Id: seq10130\n\n- The entire OS_Mon application (code and documentation) has been reviewed and\n  consequently updated with the goal to make the application more robust,\n  homogeneous and easier to configure.\n\n  The behaviour under normal operation is backwards compatible. However,\n  recoverable errors now no longer terminate the affected service (and thus\n  possible the entire application), instead `error_logger` is used to warn the\n  user if/when such errors occurs. Also, in the case of unrecoverable errors,\n  the services have been made more homogeneous with respect to behavior and exit\n  reasons. See below for more information and refer to the man pages for\n  details.\n\n  Port handling has been unified, meaning that if a port program sends garbage\n  or unexpectedly dies, this is now handled the same way by all OS_Mon services,\n  namely immediate process termination with the exit reason\n  `{port_error,Garbage}` or `{port_died,Reason}`, respectively.\n\n  Application configuration parameter handling has been unified. Bad parameter\n  values are no longer silently ignored (`disksup`) or cause application\n  termination (`memsup`, `os_sup`). Instead a warning is issued and the default\n  value for the parameter is used. Also, some cases where a bad parameter value\n  accidentally could be accepted have been corrected.\n\n  Message handling has been unified. Unknown (`gen_server-`) calls cause process\n  termination, whereas unknown casts and messages are now ignored by all OS_Mon\n  services.\n\n  Own Id: OTP-5897\n\n- The following changes have been made to the `os_sup` service:\n\n  It is now available on Windows, using `nteventlog` as backend.\n\n  On Solaris, enabling the service (that is, installing a new configuration file\n  for `syslogd` etc.) can now be done outside the `os_sup` process. The reason\n  for this is that the Erlang emulator should normally not be run with `root`\n  privileges, as is otherwise required. The new application configuration\n  parameter `os_sup_config` must be set to `false`.\n\n  Also, `os_sup` can now be configured using a new configuration parameter\n  `os_sup_mfa` to call an arbitrary Erlang function when a message is received\n  from the OS.\n\n  Own Id: OTP-5925\n\n- The `memsup` service has been rewritten, replacing the supervised\n  `memsup_helper` with a linked help process. This gives the `memsup` process\n  more control and prevents a situation where it gets out of synch with the\n  received memory data and thus possibly returns erroneous results.\n\n  Own Id: OTP-5927","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"OS_Mon 1.8.1 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-1-8-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - OS_Mon Release Notes","doc":"- `cpu_sup:util/0` failed with error reason `negative_diff` when called the\n  first time on a machine (hw) that had been up for a very long time.\n\n  Own Id: OTP-5869 Aux Id: seq10166","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"OS_Mon 1.8 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-1-8"},{"type":"extras","title":"Improvements and New Features - OS_Mon Release Notes","doc":"- The memsup part of the OS_Mon application has been made more stable. If there\n  are (possibly temporary) problems collecting memory data, the interface\n  functions (`get_memory_data/0`, `get_system_memory_data/0`) now do not fail,\n  but return the previously collected value, if any, or a dummy value otherwise.\n  Also, a warning message is printed.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-5798","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"OS_Mon 1.7.4 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-1-7-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - OS_Mon Release Notes","doc":"- Corrected several problems in the error handling/error recovery (especially\n  when OS_Mon is starting up).\n\n  Own Id: OTP-5559","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"OS_Mon 1.7.3 - OS_Mon Release Notes","doc":"","ref":"notes.html#os_mon-1-7-3"},{"type":"extras","title":"Improvements and New Features - OS_Mon Release Notes","doc":"- `memsup.c` will now compile on OpenBSD. (Thanks to Geoff White and Jay\n  Nelson.)\n\n  The `disksup` and `cpu_sup` modules now work on Mac OS X (tested on Mac OS\n  10.3.8).\n\n  The `memsup` module should now work on Linux 2.6.\\* as well as on older\n  Linuxes. (`/proc/meminfo` has slightly different formats in different releases\n  of Linux.)\n\n  Own Id: OTP-5421  \n  Aux Id: OTP-5194, OTP-5228, OTP-5291","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"OS_Mon 1.7.2 - OS_Mon Release Notes","doc":"This version is identical with 1.7.","ref":"notes.html#os_mon-1-7-2"}],"content_type":"text/plain","producer":{"name":"ex_doc","version":[48,46,51,52,46,49]}}