note
	description:
		"[
			Widget onto which graphical primatives may be drawn.
			Primitives are drawn directly onto the screen without buffering.
			(When buffering is required use EV_PIXMAP.)
		]"
	legal: "See notice at end of class."
	status: "See notice at end of class."
	keywords: "drawable, expose, primitive, figure, draw, paint, image"
	date: "$Date: 2016-09-27 15:50:48 +0000 (Tue, 27 Sep 2016) $"
	revision: "$Revision: 99192 $"

class
	EV_DRAWING_AREA

inherit
	EV_DRAWABLE
		redefine
			implementation,
			is_in_default_state
		end

	EV_PRIMITIVE
		undefine
			set_background_color,
			background_color,
			set_foreground_color,
			foreground_color
		redefine
			implementation,
			is_in_default_state,
			is_in_default_state_for_tabs
		end

	EV_DRAWABLE_ACTION_SEQUENCES

create
	default_create

feature -- Basic operations

	redraw
			-- Call `expose_actions' for `Current' when next idle.
		require
			not_destroyed: not is_destroyed
		do
			implementation.redraw
		end

	clear_and_redraw
			-- Clear the window.
			-- Call `expose_actions' for `Current' when next idle.
		require
			not_destroyed: not is_destroyed
		do
			implementation.clear_and_redraw
		end

	redraw_rectangle (a_x, a_y, a_width, a_height: INTEGER)
			-- Call `expose_actions' for rectangle described with upper-left
			-- corner on (`a_x', `a_y') with size `a_width' and `a_height' when next idle.
		require
			not_destroyed: not is_destroyed
		do
			implementation.redraw_rectangle (a_x, a_y, a_width, a_height)
		end

	clear_and_redraw_rectangle (a_x, a_y, a_width, a_height: INTEGER)
			-- Clear rectangle described with upper-left corner on (`a_x', `a_y')
			-- with size `a_width' and `a_height'.
			-- Call `expose_actions' for rectangle when next idle.
		require
			not_destroyed: not is_destroyed
		do
			implementation.clear_and_redraw_rectangle (a_x, a_y, a_width, a_height)
		end

	flush
			-- Execute any delayed calls to `expose_actions' without waiting
			-- for next idle. Delayed calls to `expose_actions' happen as a
			-- result of calling on of `redraw', `clear_and_redraw',
			-- `redraw_rectangle' or `clear_and_redraw_rectngle'.
			-- Call this feature to make the effects of one or more previous
			-- calls to these features immediately visible.
		require
			not_destroyed: not is_destroyed
		do
			implementation.flush
		end

	enable_focus_on_press
			-- Enable focus on press handling.
		require
			not_destroyed: not is_destroyed
		do
			implementation.enable_focus_on_press
		end

	disable_focus_on_press
			-- Disable default focus handling when mouse button is pressed on drawing area.
		require
			not_destroyed: not is_destroyed
		do
			implementation.disable_focus_on_press
		end

feature {EV_ANY} -- Contract support

	is_in_default_state: BOOLEAN
			-- Is `Current' in its default state?
		do
			Result := Precursor {EV_PRIMITIVE} and then Precursor {EV_DRAWABLE}
		end

	is_in_default_state_for_tabs: BOOLEAN
			-- Is `Current' in its default state with regards to tabs?
		do
			Result := not is_tabable_to and not is_tabable_from
		end

feature {EV_ANY, EV_ANY_I, EV_ANY_HANDLER} -- Implementation

	implementation: EV_DRAWING_AREA_I
		-- Responsible for interaction with native graphics toolkit.

feature {NONE} -- Implementation

	create_implementation
			-- See `{EV_ANY}.create_implementation'.
		do
			create {EV_DRAWING_AREA_IMP} implementation.make
		end

note
	copyright:	"Copyright (c) 1984-2014, Eiffel Software and others"
	license:	"Eiffel Forum License v2 (see http://www.eiffel.com/licensing/forum.txt)"
	source: "[
			Eiffel Software
			5949 Hollister Ave., Goleta, CA 93117 USA
			Telephone 805-685-1006, Fax 805-685-6869
			Website http://www.eiffel.com
			Customer support http://support.eiffel.com
		]"




end -- class EV_DRAWING_AREA









