note

	description: "Area which enables alternate way of choosing a setting"
	legal: "See notice at end of class.";
	status: "See notice at end of class.";
	date: "$Date: 2013-01-28 23:34:19 +0000 (Mon, 28 Jan 2013) $";
	revision: "$Revision: 91020 $"

class

	RADIO_BOX

inherit

	MANAGER
		redefine
			implementation
		end

create

	make, make_unmanaged

feature {NONE} -- Initialization

	make (a_name: STRING; a_parent: COMPOSITE)
			-- Create a radio box with `a_name' as identifier,
			-- `a_parent' as parent and call `set_default'.
		require
			valid_name: a_name /= Void;
			valid_parent: a_parent /= Void
		do
			create_ev_widget (a_name, a_parent, True)
		ensure
			parent_set: parent = a_parent;
			identifier_set: identifier.is_equal (a_name);
			managed: managed
		end;

	make_unmanaged (a_name: STRING; a_parent: COMPOSITE)
			-- Create a radio box with `a_name' as identifier,
			-- `a_parent' as parent and call `set_default'.
		require
			valid_name: a_name /= Void;
			valid_parent: a_parent /= Void
		do
			create_ev_widget (a_name, a_parent, False)
		ensure
			parent_set: parent = a_parent;
			identifier_set: identifier.is_equal (a_name);
			not_managed: not managed
		end;

	create_ev_widget (a_name: STRING; a_parent: COMPOSITE; man: BOOLEAN)
			-- Create a radio box with `a_name' as identifier,
			-- `a_parent' as parent and call `set_default'.
		require
			Valid_name: a_name /= Void;
			Valid_parent: a_parent /= Void
		do
			depth := a_parent.depth+1;
			widget_manager.new (Current, a_parent);
			identifier:= a_name.twin
			create {RADIO_BOX_IMP} implementation.make (Current, man, a_parent);
			implementation.set_widget_default;
			set_default
		ensure
			Parent_set: parent = a_parent;
			identifier_set: identifier.is_equal (a_name)
		end;

feature -- Status setting

	set_always_one (flag: BOOLEAN)
		require
			exists: not destroyed
		do
			implementation.set_always_one (flag);
		end;

feature {NONE} -- Implementation

	set_default
			-- Set default values to current radio box.
		do
		end;

feature {G_ANY, G_ANY_I, WIDGET_I, TOOLKIT} -- Implementation

	implementation: RADIO_BOX_I;
			-- Implementation of radio box

note
	copyright:	"Copyright (c) 1984-2006, Eiffel Software and others"
	license:	"Eiffel Forum License v2 (see http://www.eiffel.com/licensing/forum.txt)"
	source: "[
			 Eiffel Software
			 356 Storke Road, Goleta, CA 93117 USA
			 Telephone 805-685-1006, Fax 805-685-6869
			 Website http://www.eiffel.com
			 Customer support http://support.eiffel.com
		]"




end -- class RADIO_BOX

