note
	description: "Control interfaces. Help file: "
	legal: "See notice at end of class."
	status: "See notice at end of class."
	generator: "Automatically generated by the EiffelCOM Wizard."

class
	TAG_MSG_RECORD

inherit
	ECOM_STRUCTURE
		redefine
			make
		end

create
	make,
	make_from_pointer

feature {NONE}  -- Initialization

	make
			-- Make.
		do
			Precursor {ECOM_STRUCTURE}
		end

	make_from_pointer (a_pointer: POINTER)
			-- Make from pointer.
		do
			make_by_pointer (a_pointer)
		end

feature -- Access

	h_wnd: POINTER
			-- No description available.
		do
			Result := ccom_tag_msg_h_wnd (item)
		end

	h_wnd_integer: INTEGER
			-- Handle as INTEGER.
		do
			Result := cwel_pointer_to_integer (h_wnd)
		end
		
	message: INTEGER
			-- No description available.
		do
			Result := ccom_tag_msg_message (item)
		end

	w_param: INTEGER
			-- No description available.
		do
			Result := ccom_tag_msg_w_param (item)
		end

	l_param: INTEGER
			-- No description available.
		do
			Result := ccom_tag_msg_l_param (item)
		end

	time: INTEGER
			-- No description available.
		do
			Result := ccom_tag_msg_time (item)
		end

	pt: TAG_POINT_RECORD
			-- No description available.
		do
			Result := ccom_tag_msg_pt (item)
		ensure
			valid_pt: Result.item /= default_pointer
		end

feature -- Measurement

	structure_size: INTEGER
			-- Size of structure
		do
			Result := c_size_of_tag_msg
		end

feature -- Basic Operations

	set_h_wnd (a_h_wnd: POINTER)
			-- Set `h_wnd' with `a_h_wnd'.
		do
			ccom_tag_msg_set_h_wnd (item, a_h_wnd)
		end

	set_message (a_message: INTEGER)
			-- Set `message' with `a_message'.
		do
			ccom_tag_msg_set_message (item, a_message)
		end

	set_w_param (a_w_param: INTEGER)
			-- Set `w_param' with `a_w_param'.
		do
			ccom_tag_msg_set_w_param (item, a_w_param)
		end

	set_l_param (a_l_param: INTEGER)
			-- Set `l_param' with `a_l_param'.
		do
			ccom_tag_msg_set_l_param (item, a_l_param)
		end

	set_time (a_time: INTEGER)
			-- Set `time' with `a_time'.
		do
			ccom_tag_msg_set_time (item, a_time)
		end

	set_pt (a_pt: TAG_POINT_RECORD)
			-- Set `pt' with `a_pt'.
		require
			non_void_a_pt: a_pt /= Void
			valid_a_pt: a_pt.item /= default_pointer
		do
			ccom_tag_msg_set_pt (item, a_pt.item)
		end

feature {NONE}  -- Externals

	c_size_of_tag_msg: INTEGER
			-- Size of structure
		external
			"C [macro %"ecom_control_library_tagMSG_s.h%"]"
		alias
			"sizeof(ecom_control_library::tagMSG)"
		end

	ccom_tag_msg_h_wnd (a_pointer: POINTER): POINTER
			-- No description available.
		external
			"C++ [macro %"ecom_control_library_tagMSG_s_impl.h%"](ecom_control_library::tagMSG *):EIF_POINTER"
		end

	ccom_tag_msg_set_h_wnd (a_pointer: POINTER; arg2: POINTER)
			-- No description available.
		external
			"C++ [macro %"ecom_control_library_tagMSG_s_impl.h%"](ecom_control_library::tagMSG *, ecom_control_library::wireHWND)"
		end

	ccom_tag_msg_message (a_pointer: POINTER): INTEGER
			-- No description available.
		external
			"C++ [macro %"ecom_control_library_tagMSG_s_impl.h%"](ecom_control_library::tagMSG *):EIF_INTEGER"
		end

	ccom_tag_msg_set_message (a_pointer: POINTER; arg2: INTEGER)
			-- No description available.
		external
			"C++ [macro %"ecom_control_library_tagMSG_s_impl.h%"](ecom_control_library::tagMSG *, UINT)"
		end

	ccom_tag_msg_w_param (a_pointer: POINTER): INTEGER
			-- No description available.
		external
			"C++ [macro %"ecom_control_library_tagMSG_s_impl.h%"](ecom_control_library::tagMSG *):EIF_INTEGER"
		end

	ccom_tag_msg_set_w_param (a_pointer: POINTER; arg2: INTEGER)
			-- No description available.
		external
			"C++ [macro %"ecom_control_library_tagMSG_s_impl.h%"](ecom_control_library::tagMSG *, UINT)"
		end

	ccom_tag_msg_l_param (a_pointer: POINTER): INTEGER
			-- No description available.
		external
			"C++ [macro %"ecom_control_library_tagMSG_s_impl.h%"](ecom_control_library::tagMSG *):EIF_INTEGER"
		end

	ccom_tag_msg_set_l_param (a_pointer: POINTER; arg2: INTEGER)
			-- No description available.
		external
			"C++ [macro %"ecom_control_library_tagMSG_s_impl.h%"](ecom_control_library::tagMSG *, LONG)"
		end

	ccom_tag_msg_time (a_pointer: POINTER): INTEGER
			-- No description available.
		external
			"C++ [macro %"ecom_control_library_tagMSG_s_impl.h%"](ecom_control_library::tagMSG *):EIF_INTEGER"
		end

	ccom_tag_msg_set_time (a_pointer: POINTER; arg2: INTEGER)
			-- No description available.
		external
			"C++ [macro %"ecom_control_library_tagMSG_s_impl.h%"](ecom_control_library::tagMSG *, ULONG)"
		end

	ccom_tag_msg_pt (a_pointer: POINTER): TAG_POINT_RECORD
			-- No description available.
		external
			"C++ [macro %"ecom_control_library_tagMSG_s_impl.h%"](ecom_control_library::tagMSG *):EIF_REFERENCE"
		end

	ccom_tag_msg_set_pt (a_pointer: POINTER; arg2: POINTER)
			-- No description available.
		external
			"C++ [macro %"ecom_control_library_tagMSG_s_impl.h%"](ecom_control_library::tagMSG *, ecom_control_library::tagPOINT *)"
		end

note
	copyright:	"Copyright (c) 1984-2006, Eiffel Software and others"
	license:	"Eiffel Forum License v2 (see http://www.eiffel.com/licensing/forum.txt)"
	source: "[
			 Eiffel Software
			 356 Storke Road, Goleta, CA 93117 USA
			 Telephone 805-685-1006, Fax 805-685-6869
			 Website http://www.eiffel.com
			 Customer support http://support.eiffel.com
		]"




end -- TAG_MSG_RECORD

