note
	description: "Task Scheduler service. Task Scheduler."
	generator: "Automatically generated by the EiffelCOM Wizard."

class
	CTASK_SCHEDULER_PROXY

inherit
	ITASK_SCHEDULER_INTERFACE

	ECOM_QUERIABLE

create
	make,
	make_from_other,
	make_from_pointer

feature {NONE}  -- Initialization

	make
			-- Creation
		do
			initializer := ccom_create_ctask_scheduler_coclass
			item := ccom_item (initializer)
		end

	make_from_pointer (a_object: POINTER)
			-- Make from pointer
		do
			initializer := ccom_create_ctask_scheduler_coclass_from_pointer(a_object)
			item := ccom_item (initializer)
		end

feature -- Basic Operations

	set_target_computer (pwsz_computer: STRING)
			-- Selects the computer that the ITaskScheduler interface operates on.
			-- `pwsz_computer' [in].  
		do
			ccom_set_target_computer (initializer, pwsz_computer)
		end

	get_target_computer (ppwsz_computer: CELL [STRING])
			-- Returns the name of the computer on which ITaskScheduler is currently targeted.
			-- `ppwsz_computer' [out].  
		do
			ccom_get_target_computer (initializer, ppwsz_computer)
		end

	enum (pp_enum_work_items: CELL [IENUM_WORK_ITEMS_INTERFACE])
			-- Retrieves a pointer to an OLE enumerator object that enumerates the tasks in the current task folder.
			-- `pp_enum_work_items' [out].  
		do
			ccom_enum (initializer, pp_enum_work_items)
		end

	activate (pwsz_name: STRING; a_riid: ECOM_GUID; pp_unk: CELL [ECOM_INTERFACE])
			-- Returns an active interface to the specified task.
			-- `pwsz_name' [in].  
			-- `a_riid' [in].  
			-- `pp_unk' [out].  
		do
			ccom_activate (initializer, pwsz_name, a_riid.item, pp_unk)
		end

	delete (pwsz_name: STRING)
			-- Deletes a task.
			-- `pwsz_name' [in].  
		do
			ccom_delete (initializer, pwsz_name)
		end

	new_work_item (pwsz_task_name: STRING; rclsid: ECOM_GUID; a_riid: ECOM_GUID; pp_unk: CELL [ECOM_INTERFACE])
			-- Allocates space for a new task and retrieves its address.
			-- `pwsz_task_name' [in].  
			-- `rclsid' [in].  
			-- `a_riid' [in].  
			-- `pp_unk' [out].  
		do
			ccom_new_work_item (initializer, pwsz_task_name, rclsid.item, a_riid.item, pp_unk)
		end

	add_work_item (pwsz_task_name: STRING; p_work_item: ISCHEDULED_WORK_ITEM_INTERFACE)
			-- Adds a task to the schedule of tasks.
			-- `pwsz_task_name' [in].  
			-- `p_work_item' [in].  
		local
			l__p_work_item_item: POINTER
			a_stub: ECOM_STUB
		do
			if p_work_item /= Void then
				if (p_work_item.item = default_pointer) then
					a_stub ?= p_work_item
					if a_stub /= Void then
						a_stub.create_item
					end
				end
				l__p_work_item_item := p_work_item.item
			end
			ccom_add_work_item (initializer, pwsz_task_name, l__p_work_item_item)
		end

	is_of_type (pwsz_name: STRING; a_riid: ECOM_GUID)
			-- Checks the object type.
			-- `pwsz_name' [in].  
			-- `a_riid' [in].  
		do
			ccom_is_of_type (initializer, pwsz_name, a_riid.item)
		end

feature {NONE}  -- Implementation

	delete_wrapper
			-- Delete wrapper
		do
			ccom_delete_ctask_scheduler_coclass(initializer)
		end

feature {NONE}  -- Externals

	ccom_set_target_computer (a_object: POINTER; pwsz_computer: STRING)
			-- Selects the computer that the ITaskScheduler interface operates on.
		external
			"C++ [ecom_MS_TaskSched_lib::CTaskScheduler %"ecom_MS_TaskSched_lib_CTaskScheduler.h%"](EIF_OBJECT)"
		end

	ccom_get_target_computer (a_object: POINTER; ppwsz_computer: CELL [STRING])
			-- Returns the name of the computer on which ITaskScheduler is currently targeted.
		external
			"C++ [ecom_MS_TaskSched_lib::CTaskScheduler %"ecom_MS_TaskSched_lib_CTaskScheduler.h%"](EIF_OBJECT)"
		end

	ccom_enum (a_object: POINTER; pp_enum_work_items: CELL [IENUM_WORK_ITEMS_INTERFACE])
			-- Retrieves a pointer to an OLE enumerator object that enumerates the tasks in the current task folder.
		external
			"C++ [ecom_MS_TaskSched_lib::CTaskScheduler %"ecom_MS_TaskSched_lib_CTaskScheduler.h%"](EIF_OBJECT)"
		end

	ccom_activate (a_object: POINTER; pwsz_name: STRING; a_riid: POINTER; pp_unk: CELL [ECOM_INTERFACE])
			-- Returns an active interface to the specified task.
		external
			"C++ [ecom_MS_TaskSched_lib::CTaskScheduler %"ecom_MS_TaskSched_lib_CTaskScheduler.h%"](EIF_OBJECT,GUID *,EIF_OBJECT)"
		end

	ccom_delete (a_object: POINTER; pwsz_name: STRING)
			-- Deletes a task.
		external
			"C++ [ecom_MS_TaskSched_lib::CTaskScheduler %"ecom_MS_TaskSched_lib_CTaskScheduler.h%"](EIF_OBJECT)"
		end

	ccom_new_work_item (a_object: POINTER; pwsz_task_name: STRING; rclsid: POINTER; a_riid: POINTER; pp_unk: CELL [ECOM_INTERFACE])
			-- Allocates space for a new task and retrieves its address.
		external
			"C++ [ecom_MS_TaskSched_lib::CTaskScheduler %"ecom_MS_TaskSched_lib_CTaskScheduler.h%"](EIF_OBJECT,GUID *,GUID *,EIF_OBJECT)"
		end

	ccom_add_work_item (a_object: POINTER; pwsz_task_name: STRING; p_work_item: POINTER)
			-- Adds a task to the schedule of tasks.
		external
			"C++ [ecom_MS_TaskSched_lib::CTaskScheduler %"ecom_MS_TaskSched_lib_CTaskScheduler.h%"](EIF_OBJECT,ecom_MS_TaskSched_lib::IScheduledWorkItem *)"
		end

	ccom_is_of_type (a_object: POINTER; pwsz_name: STRING; a_riid: POINTER)
			-- Checks the object type.
		external
			"C++ [ecom_MS_TaskSched_lib::CTaskScheduler %"ecom_MS_TaskSched_lib_CTaskScheduler.h%"](EIF_OBJECT,GUID *)"
		end

	ccom_create_ctask_scheduler_coclass: POINTER
			-- Creation
		external
			"C++ [new ecom_MS_TaskSched_lib::CTaskScheduler %"ecom_MS_TaskSched_lib_CTaskScheduler.h%"]()"
		end

	ccom_delete_ctask_scheduler_coclass (a_pointer: POINTER)
			-- Release resource
		external
			"C++ [delete ecom_MS_TaskSched_lib::CTaskScheduler %"ecom_MS_TaskSched_lib_CTaskScheduler.h%"]()"
		end

	ccom_create_ctask_scheduler_coclass_from_pointer (a_pointer: POINTER): POINTER
			-- Create from pointer
		external
			"C++ [new ecom_MS_TaskSched_lib::CTaskScheduler %"ecom_MS_TaskSched_lib_CTaskScheduler.h%"](IUnknown *)"
		end

	ccom_item (a_object: POINTER): POINTER
			-- Item
		external
			"C++ [ecom_MS_TaskSched_lib::CTaskScheduler %"ecom_MS_TaskSched_lib_CTaskScheduler.h%"](): EIF_POINTER"
		end

end -- CTASK_SCHEDULER_PROXY


