/*
 * Code for class PATH
 */

#include "eif_eiffel.h"
#include "../E1/estructure.h"
#include "../E1/eoffsets.h"

#include "pa2774.h"
#include "eif_path_name.h"
#include "eif_built_in.h"
#include <ctype.h>
#include "eif_eiffel.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifndef INLINE_F3870_47018
static int inline_F3870_47018 (EIF_POINTER arg1, EIF_POINTER arg2)
{
	EIF_BOOLEAN Result = EIF_FALSE;
#ifdef EIF_WINDOWS
		/* To check this, we use `CreateFileW' to open both file, and then using the information
		 * returned by `GetFileInformationByHandle' we can check whether or not they are indeed
		 * the same.
		 * Note: it is important to use the W version of CreateFileW because arguments
		 * are Unicode, not ASCII. */
	BY_HANDLE_FILE_INFORMATION l_path1_info, l_path2_info;
	HANDLE l_path2_file = CreateFileW ((LPCWSTR) arg2, GENERIC_READ, FILE_SHARE_READ, NULL,
		OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	HANDLE l_path1_file = CreateFileW ((LPCWSTR) arg1, GENERIC_READ, FILE_SHARE_READ, NULL,
			OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);

	if ((l_path2_file == INVALID_HANDLE_VALUE) || (l_path1_file == INVALID_HANDLE_VALUE)) {
			/* We do not need the handles anymore, simply close them. Since Microsoft
			 * API accepts INVALID_HANDLE_VALUE we don't check the validity of arguments. */
		CloseHandle(l_path2_file);
		CloseHandle(l_path1_file);
	} else {
		BOOL success = GetFileInformationByHandle (l_path2_file, &l_path2_info);
		success = success && GetFileInformationByHandle (l_path1_file, &l_path1_info);
			/* We do not need the handles anymore, simply close them. */
		CloseHandle(l_path2_file);
		CloseHandle(l_path1_file);
		if (success) {
				/* Check that `path2' and `path1' do not represent the same file. */
			if
				((l_path2_info.dwVolumeSerialNumber == l_path1_info.dwVolumeSerialNumber) &&
				(l_path2_info.nFileIndexLow == l_path1_info.nFileIndexLow) &&
				(l_path2_info.nFileIndexHigh == l_path1_info.nFileIndexHigh))
			{
				Result = EIF_TRUE;
			}
		}
	}
#else
	struct stat buf1, buf2;
	int status;
	#ifdef HAS_LSTAT
		status = lstat(arg1, &buf1);
		if (status == 0) {
				/* We found a file, now let's check if it is not a symbolic link. If it is, we use `stat'
			 	 * to ensure the validity of the link. */
			if ((buf1.st_mode & S_IFLNK) == S_IFLNK) {
				status = stat (arg1, &buf1);
			}
		}
		
		if (status == 0) {
			status = lstat(arg2, &buf2);
			if (status == 0) {
					/* We found a file, now let's check if it is not a symbolic link. If it is, we use `stat'
				 	 * to ensure the validity of the link. */
				if ((buf2.st_mode & S_IFLNK) == S_IFLNK) {
					status = stat (arg2, &buf2);
				}
			}
		}
	#else
		status = stat (arg1, &buf1);
		if (status == 0) {
			status = stat (arg2, &buf2);
		}
	#endif
	if (status == 0) {
			/* Both files are present, check they represent the same one. */
		if ((buf1.st_dev == buf2.st_dev) && (buf1.st_ino == buf2.st_ino)) {
			Result = EIF_TRUE;
		}
	}
#endif
return Result;
	;
}
#define INLINE_F3870_47018
#endif

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* {PATH}.make_empty */
void F3870_46957 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTEAA("make_empty", 3869, Current, 0, 0, 49809);
	RTGC;
	RTHOOK(1);
	tr1 = RTLNSMART(eif_new_type(4148, 0).id);
	F4139_50514(RTCW(tr1));
	RTAR(Current, tr1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	RTHOOK(2);
	*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	RTHOOK(3);
	F3870_47004(Current);
	RTHOOK(6);
	RTLE;
	RTEE;
}

/* {PATH}.make_current */
void F3870_46958 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTEAA("make_current", 3869, Current, 0, 0, 49810);
	RTGC;
	RTHOOK(1);
	tr1 = RTLNSMART(eif_new_type(4148, 0).id);
	ti4_1 = F3870_47003(Current);
	F4147_50843(RTCW(tr1), ti4_1);
	RTAR(Current, tr1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	RTHOOK(2);
	tr1 = *(EIF_REFERENCE *)(Current);
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R40970[Dtype(RTCW(tr1))-4148])(tr1, (EIF_CHARACTER_8) '.');
	RTHOOK(3);
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
		RTHOOK(4);
		tr1 = *(EIF_REFERENCE *)(Current);
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R40970[Dtype(RTCW(tr1))-4148])(tr1, (EIF_CHARACTER_8) '\000');
	}
	RTHOOK(5);
	*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	RTHOOK(6);
	F3870_47004(Current);
	RTHOOK(10);
	RTLE;
	RTEE;
}

/* {PATH}.make_from_string */
void F3870_46959 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,arg1);
	RTLIU(3);
	
	RTEAA("make_from_string", 3869, Current, 0, 1, 49811);
	RTGC;
	RTHOOK(1);
	tr1 = RTLNSMART(eif_new_type(4148, 0).id);
	ti4_1 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R40717[Dtype(RTCW(arg1))-4142])(arg1);
	ti4_2 = F3870_47003(Current);
	F4147_50843(RTCW(tr1), (EIF_INTEGER_32) (ti4_1 * ti4_2));
	RTAR(Current, tr1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	RTHOOK(2);
	tb1 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE)) R40695[Dtype(RTCW(arg1))-4142])(arg1);
	if ((EIF_BOOLEAN) !tb1) {
		RTHOOK(3);
		F3870_47012(Current, *(EIF_REFERENCE *)(Current), arg1, (EIF_CHARACTER_8) '\000');
		RTHOOK(4);
		F3870_47005(Current);
	} else {
		RTHOOK(5);
		*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	}
	RTHOOK(6);
	F3870_47004(Current);
	RTHOOK(11);
	RTLE;
	RTEE;
}

/* {PATH}.make_from_storage */
void F3870_46961 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,arg1);
	RTLIU(2);
	
	RTEAA("make_from_storage", 3869, Current, 0, 1, 49813);
	RTGC;
	RTHOOK(1);
	RTAR(Current, arg1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) arg1;
	RTHOOK(2);
	F3870_47005(Current);
	RTHOOK(3);
	F3870_47004(Current);
	RTHOOK(6);
	RTLE;
	RTEE;
}

/* {PATH}.make_from_normalized_storage */
void F3870_46962 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,arg1);
	RTLIU(2);
	
	RTEAA("make_from_normalized_storage", 3869, Current, 0, 1, 49814);
	RTGC;
	RTHOOK(1);
	RTAR(Current, arg1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) arg1;
	RTHOOK(2);
	*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	RTHOOK(3);
	F3870_47004(Current);
	RTHOOK(6);
	RTLE;
	RTEE;
}

/* {PATH}.make_from_pointer */
void F3870_46963 (EIF_REFERENCE Current, EIF_POINTER arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_BOOLEAN tb1;
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,loc1);
	RTLR(2,tr1);
	RTLIU(3);
	
	RTEAA("make_from_pointer", 3869, Current, 2, 1, 49815);
	RTGC;
	RTHOOK(1);
	loc2 = F1775_25296(Current, arg1);
	RTHOOK(2);
	loc2 -= (EIF_INTEGER_32) (loc2 % F3870_47003(Current));
	RTHOOK(3);
	loc1 = RTLNS(eif_new_type(1848, 0x00).id, 1848, _OBJSIZ_1_0_0_1_0_0_0_0_);
	F1849_26683(RTCW(loc1), arg1, loc2);
	RTHOOK(4);
	tr1 = F1849_26690(RTCW(loc1), ((EIF_INTEGER_32) 1L), loc2);
	RTAR(Current, tr1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	RTHOOK(5);
	tr1 = *(EIF_REFERENCE *)(Current);
	tb1 = F2392_29294(RTCW(tr1));
	if ((EIF_BOOLEAN) !tb1) {
		RTHOOK(6);
		F3870_47005(Current);
	}
	RTHOOK(7);
	F3870_47004(Current);
	RTHOOK(8);
	RTLE;
	RTEE;
}

/* {PATH}.is_current_symbol */
EIF_BOOLEAN F3870_46964 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTEAA("is_current_symbol", 3869, Current, 0, 0, 49816);
	RTGC;
	RTHOOK(1);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O40942[Dtype(tr1)-4146]);
	if ((EIF_BOOLEAN)(ti4_1 == F3870_47003(Current))) {
		RTHOOK(2);
		RTHOOK(3);
		RTLE;
		RTEE;
		return (EIF_BOOLEAN) F3870_47015(Current, *(EIF_REFERENCE *)(Current), ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '.');
	}
	RTHOOK(4);
	RTLE;
	RTEE;
	return (EIF_BOOLEAN) 0;
}

/* {PATH}.is_parent_symbol */
EIF_BOOLEAN F3870_46965 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTEAA("is_parent_symbol", 3869, Current, 0, 0, 49817);
	RTGC;
	RTHOOK(1);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O40942[Dtype(tr1)-4146]);
	if ((EIF_BOOLEAN)(ti4_1 == (EIF_INTEGER_32) (((EIF_INTEGER_32) 2L) * F3870_47003(Current)))) {
		RTHOOK(2);
		Result = F3870_47015(Current, *(EIF_REFERENCE *)(Current), ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '.');
		RTHOOK(3);
		tr1 = *(EIF_REFERENCE *)(Current);
		ti4_1 = F3870_47003(Current);
		Result = F3870_47015(Current, tr1, (EIF_INTEGER_32) (((EIF_INTEGER_32) 1L) + ti4_1), (EIF_CHARACTER_8) '.');
	}
	RTHOOK(4);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.has_root */
EIF_BOOLEAN F3870_46966 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("has_root", 3869, Current, 0, 0, 49818);
	RTGC;
	RTHOOK(1);
	ti4_1 = F3870_47009(Current);
	Result = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 != ((EIF_INTEGER_32) 0L));
	RTHOOK(3);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.is_empty */
EIF_BOOLEAN F3870_46967 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTEAA("is_empty", 3869, Current, 0, 0, 49819);
	RTGC;
	RTHOOK(1);
	tr1 = *(EIF_REFERENCE *)(Current);
	Result = F2392_29294(RTCW(tr1));
	RTHOOK(2);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.is_relative */
EIF_BOOLEAN F3870_46968 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("is_relative", 3869, Current, 0, 0, 49820);
	RTGC;
	RTHOOK(1);
	Result = F3870_46969(Current);
	Result = (EIF_BOOLEAN) (EIF_BOOLEAN) !Result;
	RTHOOK(2);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.is_absolute */
EIF_BOOLEAN F3870_46969 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_CHARACTER_8 tc1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTEAA("is_absolute", 3869, Current, 1, 0, 49821);
	RTGC;
	RTHOOK(1);
	loc1 = F3870_47009(Current);
	RTHOOK(2);
	if ((EIF_BOOLEAN) (loc1 > ((EIF_INTEGER_32) 0L))) {
		RTHOOK(3);
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
			RTHOOK(4);
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = F3870_47003(Current);
			tc1 = F3870_46985(Current);
			Result = F3870_47015(Current, tr1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (loc1 - ti4_1) + ((EIF_INTEGER_32) 1L)), tc1);
		} else {
			RTHOOK(5);
			RTHOOK(6);
			RTLE;
			RTEE;
			return (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
		}
	}
	RTHOOK(7);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.is_same_file_as */
EIF_BOOLEAN F3870_46971 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_POINTER tp2;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,loc2);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTEAA("is_same_file_as", 3869, Current, 2, 1, 49823);
	RTGC;
	RTHOOK(1);
	loc1 = F3870_47000(Current);
	RTHOOK(2);
	loc2 = F3870_47000(RTCW(arg1));
	RTHOOK(3);
	tp1 = *(EIF_POINTER *)(RTCW(loc1)+ _PTROFF_0_1_0_1_0_0_);
	tp2 = *(EIF_POINTER *)(RTCW(loc2)+ _PTROFF_0_1_0_1_0_0_);
	Result = EIF_TEST (inline_F3870_47018(tp1, tp2));
	RTHOOK(4);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.has_extension */
EIF_BOOLEAN F3870_46972 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTEAA("has_extension", 3869, Current, 1, 1, 49824);
	RTGC;
	RTHOOK(1);
	Result = '\0';
	tr1 = F3870_46976(Current);
	loc1 = tr1;
	if (EIF_TEST(loc1)) {
		tb1 = F4139_50556(loc1, arg1);
		Result = tb1;
	}
	RTHOOK(2);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.root */
EIF_REFERENCE F3870_46973 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,Result);
	RTLIU(3);
	
	RTEAA("root", 3869, Current, 1, 0, 49825);
	RTGC;
	RTHOOK(1);
	loc1 = F3870_47009(Current);
	RTHOOK(2);
	if ((EIF_BOOLEAN)(loc1 != ((EIF_INTEGER_32) 0L))) {
		RTHOOK(3);
		tr1 = *(EIF_REFERENCE *)(Current);
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O40942[Dtype(tr1)-4146]);
		if ((EIF_BOOLEAN)(loc1 == ti4_1)) {
			RTHOOK(4);
			tr1 = RTLNS(eif_new_type(3869, 0x00).id, 3869, _OBJSIZ_2_1_0_0_0_0_0_0_);
			F3870_46962(RTCW(tr1), *(EIF_REFERENCE *)(Current));
			RTHOOK(5);
			RTLE;
			RTEE;
			return (EIF_REFERENCE) tr1;
		} else {
			RTHOOK(6);
			Result = RTLNS(eif_new_type(3869, 0x00).id, 3869, _OBJSIZ_2_1_0_0_0_0_0_0_);
			tr1 = *(EIF_REFERENCE *)(Current);
			tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R40758[Dtype(RTCW(tr1))-4142])(tr1, ((EIF_INTEGER_32) 1L), loc1);
			F3870_46962(RTCW(Result), tr1);
		}
	}
	RTHOOK(8);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.parent */
EIF_REFERENCE F3870_46974 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,loc3);
	RTLR(2,tr1);
	RTLR(3,Result);
	RTLIU(4);
	
	RTEAA("parent", 3869, Current, 3, 0, 49826);
	RTGC;
	RTHOOK(1);
	loc1 = F3870_47010(Current);
	RTHOOK(2);
	if ((EIF_BOOLEAN)(loc1 == ((EIF_INTEGER_32) 0L))) {
		RTHOOK(3);
		tr1 = F3870_46973(Current);
		loc3 = tr1;
		if (EIF_TEST(loc3)) {
			
			RTHOOK(5);
			RTHOOK(6);
			RTLE;
			RTEE;
			return (EIF_REFERENCE) loc3;
		} else {
			RTHOOK(7);
			tr1 = RTLNS(eif_new_type(3869, 0x00).id, 3869, _OBJSIZ_2_1_0_0_0_0_0_0_);
			F3870_46958(RTCW(tr1));
			RTHOOK(8);
			RTLE;
			RTEE;
			return (EIF_REFERENCE) tr1;
		}
	} else {
		RTHOOK(9);
		if ((EIF_BOOLEAN)(loc1 == F3870_47003(Current))) {
			RTHOOK(10);
			Result = RTLNS(eif_new_type(3869, 0x00).id, 3869, _OBJSIZ_2_1_0_0_0_0_0_0_);
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = F3870_47003(Current);
			tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R40758[Dtype(RTCW(tr1))-4142])(tr1, ((EIF_INTEGER_32) 1L), ti4_1);
			F3870_46962(RTCW(Result), tr1);
		} else {
			RTHOOK(11);
			loc2 = F3870_47009(Current);
			RTHOOK(12);
			if ((EIF_BOOLEAN) (loc1 <= loc2)) {
				RTHOOK(13);
				tr1 = *(EIF_REFERENCE *)(Current);
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O40942[Dtype(tr1)-4146]);
				if ((EIF_BOOLEAN)(loc2 == ti4_1)) {
					RTHOOK(14);
					RTHOOK(15);
					RTLE;
					RTEE;
					return (EIF_REFERENCE) Current;
				} else {
					RTHOOK(16);
					Result = RTLNS(eif_new_type(3869, 0x00).id, 3869, _OBJSIZ_2_1_0_0_0_0_0_0_);
					tr1 = *(EIF_REFERENCE *)(Current);
					tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R40758[Dtype(RTCW(tr1))-4142])(tr1, ((EIF_INTEGER_32) 1L), loc2);
					F3870_46962(RTCW(Result), tr1);
				}
			} else {
				RTHOOK(17);
				Result = RTLNS(eif_new_type(3869, 0x00).id, 3869, _OBJSIZ_2_1_0_0_0_0_0_0_);
				tr1 = *(EIF_REFERENCE *)(Current);
				ti4_1 = F3870_47003(Current);
				tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R40758[Dtype(RTCW(tr1))-4142])(tr1, ((EIF_INTEGER_32) 1L), (EIF_INTEGER_32) (loc1 - ti4_1));
				F3870_46962(RTCW(Result), tr1);
			}
		}
	}
	RTHOOK(18);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.entry */
EIF_REFERENCE F3870_46975 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_BOOLEAN tb4;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,tr2);
	RTLR(3,Result);
	RTLIU(4);
	
	RTEAA("entry", 3869, Current, 2, 0, 49827);
	RTGC;
	RTHOOK(1);
	loc1 = F3870_47010(Current);
	RTHOOK(2);
	if ((EIF_BOOLEAN)(loc1 == ((EIF_INTEGER_32) 0L))) {
		RTHOOK(3);
		loc2 = F3870_47009(Current);
		RTHOOK(4);
		if ((EIF_BOOLEAN) (loc2 > ((EIF_INTEGER_32) 0L))) {
			RTHOOK(5);
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O40942[Dtype(tr1)-4146]);
			if ((EIF_BOOLEAN) (loc2 < ti4_1)) {
				RTHOOK(6);
				Result = RTLNS(eif_new_type(3869, 0x00).id, 3869, _OBJSIZ_2_1_0_0_0_0_0_0_);
				tr1 = *(EIF_REFERENCE *)(Current);
				tr2 = *(EIF_REFERENCE *)(Current);
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr2) + O40942[Dtype(tr2)-4146]);
				tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R40758[Dtype(RTCW(tr1))-4142])(tr1, (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L)), ti4_1);
				F3870_46962(RTCW(Result), tr1);
			}
		} else {
			RTHOOK(7);
			Result = (EIF_REFERENCE) Current;
		}
	} else {
		RTHOOK(8);
		loc2 = F3870_47009(Current);
		RTHOOK(9);
		if ((EIF_BOOLEAN) (loc1 <= loc2)) {
			RTHOOK(10);
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O40942[Dtype(tr1)-4146]);
			if ((EIF_BOOLEAN) (loc2 < ti4_1)) {
				RTHOOK(11);
				Result = RTLNS(eif_new_type(3869, 0x00).id, 3869, _OBJSIZ_2_1_0_0_0_0_0_0_);
				tr1 = *(EIF_REFERENCE *)(Current);
				tr2 = *(EIF_REFERENCE *)(Current);
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr2) + O40942[Dtype(tr2)-4146]);
				tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R40758[Dtype(RTCW(tr1))-4142])(tr1, (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L)), ti4_1);
				F3870_46962(RTCW(Result), tr1);
			}
		} else {
			RTHOOK(12);
			Result = RTLNS(eif_new_type(3869, 0x00).id, 3869, _OBJSIZ_2_1_0_0_0_0_0_0_);
			tr1 = *(EIF_REFERENCE *)(Current);
			tr2 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr2) + O40942[Dtype(tr2)-4146]);
			tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R40758[Dtype(RTCW(tr1))-4142])(tr1, (EIF_INTEGER_32) (loc1 + ((EIF_INTEGER_32) 1L)), ti4_1);
			F3870_46962(RTCW(Result), tr1);
		}
	}
	RTHOOK(13);
	tb1 = '\0';
	if ((EIF_BOOLEAN)(Result != NULL)) {
		tb2 = '\01';
		tb3 = '\01';
		tb4 = F3870_46967(RTCW(Result));
		if (!tb4) {
			tb4 = F3870_46964(RTCW(Result));
			tb3 = tb4;
		}
		if (!tb3) {
			tb3 = F3870_46965(RTCW(Result));
			tb2 = tb3;
		}
		tb1 = tb2;
	}
	if (tb1) {
		RTHOOK(14);
		RTHOOK(15);
		RTLE;
		RTEE;
		return (EIF_REFERENCE) NULL;
	}
	RTHOOK(17);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.extension */
EIF_REFERENCE F3870_46976 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc3 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_CHARACTER_32 tw1;
	RTLD;
	
	RTLI(4);
	RTLR(0,loc4);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,loc1);
	RTLIU(4);
	
	RTEAA("extension", 3869, Current, 4, 0, 49828);
	RTGC;
	RTHOOK(1);
	tr1 = F3870_46975(Current);
	loc4 = tr1;
	if (EIF_TEST(loc4)) {
		RTHOOK(2);
		loc1 = F3870_46998(loc4);
		RTHOOK(3);
		loc3 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_0_0_2_);
		RTHOOK(4);
		tw1 = (EIF_CHARACTER_32) (EIF_CHARACTER_8) '.';
		loc2 = F4142_50656(RTCW(loc1), tw1, loc3);
		RTHOOK(5);
		if ((EIF_BOOLEAN) ((EIF_BOOLEAN)(loc2 != ((EIF_INTEGER_32) 0L)) && (EIF_BOOLEAN)(loc2 != loc3))) {
			RTHOOK(6);
			tr1 = F4143_50710(RTCW(loc1), (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L)), loc3);
			RTHOOK(7);
			RTLE;
			RTEE;
			return (EIF_REFERENCE) tr1;
		}
	}
	RTHOOK(10);
	RTLE;
	RTEE;
	return (EIF_REFERENCE) 0;
}

/* {PATH}.components */
EIF_REFERENCE F3870_46977 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc3 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,Result);
	RTLR(2,loc1);
	RTLR(3,tr1);
	RTLIU(4);
	
	RTEAA("components", 3869, Current, 3, 0, 49829);
	RTGC;
	RTHOOK(1);
	{
		static EIF_TYPE_INDEX typarr0[] = {2639,3869,0xFFFF};
		EIF_TYPE typres0;
		static EIF_TYPE typcache0 = {INVALID_DTYPE, 0};
		
		typres0 = (typcache0.id != INVALID_DTYPE ? typcache0 : (typcache0 = eif_compound_id(Dftype(Current), typarr0)));
		Result = RTLNS(typres0.id, 2639, _OBJSIZ_1_1_0_1_0_0_0_0_);
	}
	F2640_30068(RTCW(Result), ((EIF_INTEGER_32) 10L));
	RTHOOK(2);
	loc3 = F3870_47009(Current);
	RTHOOK(3);
	if ((EIF_BOOLEAN) (loc3 > ((EIF_INTEGER_32) 0L))) {
		RTHOOK(4);
		loc1 = RTLNS(eif_new_type(4148, 0x00).id, 4148, _OBJSIZ_1_1_0_3_0_0_0_0_);
		F4147_50843(RTCW(loc1), loc3);
		RTHOOK(5);
		F4149_50955(RTCW(loc1), *(EIF_REFERENCE *)(Current), ((EIF_INTEGER_32) 1L), loc3);
		RTHOOK(6);
		tr1 = RTLNS(eif_new_type(3869, 0x00).id, 3869, _OBJSIZ_2_1_0_0_0_0_0_0_);
		F3870_46962(RTCW(tr1), loc1);
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R25435[Dtype(RTCW(Result))-2351])(Result, tr1);
		RTHOOK(7);
		loc3++;
	} else {
		RTHOOK(8);
		loc3 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
	}
	RTHOOK(9);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O40942[Dtype(tr1)-4146]);
	if ((EIF_BOOLEAN) (loc3 <= ti4_1)) {
		RTHOOK(10);
		loc2 = (EIF_INTEGER_32) loc3;
		RTHOOK(11);
		loc3 = F3870_47011(Current, loc2);
		for (;;) {
			RTHOOK(12);
			if ((EIF_BOOLEAN)(loc3 == ((EIF_INTEGER_32) 0L))) break;
			RTHOOK(13);
			loc1 = RTLNS(eif_new_type(4148, 0x00).id, 4148, _OBJSIZ_1_1_0_3_0_0_0_0_);
			F4147_50843(RTCW(loc1), (EIF_INTEGER_32) (loc3 - loc2));
			RTHOOK(14);
			F4149_50955(RTCW(loc1), *(EIF_REFERENCE *)(Current), loc2, (EIF_INTEGER_32) (loc3 - ((EIF_INTEGER_32) 1L)));
			RTHOOK(15);
			tr1 = RTLNS(eif_new_type(3869, 0x00).id, 3869, _OBJSIZ_2_1_0_0_0_0_0_0_);
			F3870_46962(RTCW(tr1), loc1);
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R25435[Dtype(RTCW(Result))-2351])(Result, tr1);
			RTHOOK(16);
			loc2 = F3870_47003(Current);
			loc2 = (EIF_INTEGER_32) (EIF_INTEGER_32) (loc3 + loc2);
			RTHOOK(17);
			loc3 = F3870_47011(Current, loc2);
		}
		RTHOOK(18);
		tr1 = *(EIF_REFERENCE *)(Current);
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O40942[Dtype(tr1)-4146]);
		if ((EIF_BOOLEAN) (loc2 <= ti4_1)) {
			RTHOOK(19);
			loc1 = RTLNS(eif_new_type(4148, 0x00).id, 4148, _OBJSIZ_1_1_0_3_0_0_0_0_);
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O40942[Dtype(tr1)-4146]);
			F4147_50843(RTCW(loc1), (EIF_INTEGER_32) (ti4_1 - loc2));
			RTHOOK(20);
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O40942[Dtype(tr1)-4146]);
			F4149_50955(RTCW(loc1), *(EIF_REFERENCE *)(Current), loc2, ti4_1);
			RTHOOK(21);
			tr1 = RTLNS(eif_new_type(3869, 0x00).id, 3869, _OBJSIZ_2_1_0_0_0_0_0_0_);
			F3870_46962(RTCW(tr1), loc1);
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R25435[Dtype(RTCW(Result))-2351])(Result, tr1);
		}
	}
	RTHOOK(22);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.absolute_path */
EIF_REFERENCE F3870_46978 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,Result);
	RTLIU(3);
	
	RTEAA("absolute_path", 3869, Current, 0, 0, 49830);
	RTGC;
	RTHOOK(1);
	tr1 = F1779_25381(RTCV(RTOUCR(372,F3870_47008, (Current))));
	Result = F3870_46979(Current, tr1);
	RTHOOK(2);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.absolute_path_in */
EIF_REFERENCE F3870_46979 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_REFERENCE tr3 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_CHARACTER_8 tc1;
	EIF_CHARACTER_8 tc2;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(8);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,arg1);
	RTLR(3,loc1);
	RTLR(4,Result);
	RTLR(5,tr2);
	RTLR(6,tr3);
	RTLR(7,loc2);
	RTLIU(8);
	
	RTEAA("absolute_path_in", 3869, Current, 2, 1, 49831);
	RTGC;
	RTHOOK(1);
	tr1 = *(EIF_REFERENCE *)(Current);
	tb1 = F2392_29294(RTCW(tr1));
	if (tb1) {
		RTHOOK(2);
		RTHOOK(3);
		RTLE;
		RTEE;
		return (EIF_REFERENCE) arg1;
	} else {
		RTHOOK(4);
		if (F3870_46969(Current)) {
			RTHOOK(5);
			RTHOOK(6);
			RTLE;
			RTEE;
			return (EIF_REFERENCE) Current;
		} else {
			RTHOOK(7);
			if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
				RTHOOK(8);
				tr1 = F3870_46973(Current);
				loc1 = tr1;
				if (EIF_TEST(loc1)) {
					RTHOOK(9);
					tb1 = '\0';
					tb2 = '\0';
					tr1 = *(EIF_REFERENCE *)(loc1);
					ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O40942[Dtype(tr1)-4146]);
					if ((EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 4L))) {
						tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
						ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O40942[Dtype(tr1)-4146]);
						tb2 = (EIF_BOOLEAN) (ti4_1 >= ((EIF_INTEGER_32) 4L));
					}
					if (tb2) {
						tb2 = '\0';
						tr1 = *(EIF_REFERENCE *)(loc1);
						tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R25641[Dtype(RTCW(tr1))-2534])(tr1, ((EIF_INTEGER_32) 1L)));
						tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
						tc2 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R25641[Dtype(RTCW(tr1))-2534])(tr1, ((EIF_INTEGER_32) 1L)));
						if ((EIF_BOOLEAN)(tc1 == tc2)) {
							tr1 = *(EIF_REFERENCE *)(loc1);
							tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R25641[Dtype(RTCW(tr1))-2534])(tr1, ((EIF_INTEGER_32) 3L)));
							tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
							tc2 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R25641[Dtype(RTCW(tr1))-2534])(tr1, ((EIF_INTEGER_32) 3L)));
							tb2 = (EIF_BOOLEAN)(tc1 == tc2);
						}
						tb1 = tb2;
					}
					if (tb1) {
						RTHOOK(10);
						Result = (EIF_REFERENCE) eif_builtin_ANY_twin (arg1);
					} else {
						RTHOOK(11);
						Result = (EIF_REFERENCE) loc1;
					}
					RTHOOK(12);
					tr1 = *(EIF_REFERENCE *)(RTCW(Result));
					tr2 = *(EIF_REFERENCE *)(Current);
					tr3 = *(EIF_REFERENCE *)(loc1);
					ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr3) + O40942[Dtype(tr3)-4146]);
					tr3 = *(EIF_REFERENCE *)(Current);
					ti4_2 = *(EIF_INTEGER_32 *)(RTCW(tr3) + O40942[Dtype(tr3)-4146]);
					tc1 = F3870_46985(Current);
					F3870_47014(Current, tr1, tr2, (EIF_INTEGER_32) (ti4_1 + ((EIF_INTEGER_32) 1L)), ti4_2, tc1);
				} else {
					RTHOOK(13);
					if (F3870_47015(Current, *(EIF_REFERENCE *)(Current), ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '\\')) {
						RTHOOK(14);
						Result = (EIF_REFERENCE) eif_builtin_ANY_twin (arg1);
						RTHOOK(15);
						tr1 = F3870_46973(RTCW(Result));
						loc2 = tr1;
						if (EIF_TEST(loc2)) {
							RTHOOK(16);
							Result = (EIF_REFERENCE) loc2;
						}
					} else {
						RTHOOK(17);
						Result = (EIF_REFERENCE) eif_builtin_ANY_twin (arg1);
					}
					RTHOOK(18);
					tr1 = *(EIF_REFERENCE *)(RTCW(Result));
					tr2 = *(EIF_REFERENCE *)(Current);
					tc1 = F3870_46985(Current);
					F3870_47013(Current, tr1, tr2, tc1);
				}
			} else {
				RTHOOK(19);
				Result = (EIF_REFERENCE) eif_builtin_ANY_twin (arg1);
				RTHOOK(20);
				tr1 = *(EIF_REFERENCE *)(RTCW(Result));
				tr2 = *(EIF_REFERENCE *)(Current);
				tc1 = F3870_46985(Current);
				F3870_47013(Current, tr1, tr2, tc1);
			}
			RTHOOK(21);
			F3870_47004(RTCW(Result));
		}
	}
	RTHOOK(23);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.canonical_path */
EIF_REFERENCE F3870_46980 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc5 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_CHARACTER_8 tc1;
	RTLD;
	
	RTLI(7);
	RTLR(0,loc2);
	RTLR(1,Current);
	RTLR(2,loc4);
	RTLR(3,tr1);
	RTLR(4,loc3);
	RTLR(5,loc1);
	RTLR(6,loc5);
	RTLIU(7);
	
	RTEAA("canonical_path", 3869, Current, 5, 0, 49832);
	RTGC;
	RTHOOK(1);
	loc2 = F3870_46978(Current);
	RTHOOK(2);
	tr1 = F3870_46973(RTCW(loc2));
	loc4 = tr1;
	if (EIF_TEST(loc4)) {
		RTHOOK(3);
		loc3 = RTLNSMART(eif_new_type(4148, 0).id);
		tr1 = *(EIF_REFERENCE *)(RTCW(loc2));
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O40942[Dtype(tr1)-4146]);
		F4147_50843(RTCW(loc3), ti4_1);
		RTHOOK(4);
		loc1 = F3870_46977(RTCW(loc2));
		
		RTHOOK(7);
		F2640_30099(RTCW(loc1));
		RTHOOK(8);
		tr1 = F2640_30073(RTCW(loc1));
		tr1 = *(EIF_REFERENCE *)(RTCW(tr1));
		tc1 = F3870_46985(Current);
		F3870_47013(Current, loc3, tr1, tc1);
		RTHOOK(9);
		(FUNCTION_CAST(void, (EIF_REFERENCE)) R25452[Dtype(RTCW(loc1))-2458])(loc1);
		for (;;) {
			RTHOOK(10);
			tb1 = F2569_29561(RTCW(loc1));
			if (tb1) break;
			RTHOOK(11);
			tr1 = F2640_30073(RTCW(loc1));
			tb2 = F3870_46964(RTCW(tr1));
			if (tb2) {
				RTHOOK(12);
				(FUNCTION_CAST(void, (EIF_REFERENCE)) R25452[Dtype(RTCW(loc1))-2458])(loc1);
			} else {
				RTHOOK(13);
				tr1 = F2640_30073(RTCW(loc1));
				tb2 = F3870_46965(RTCW(tr1));
				if (tb2) {
					RTHOOK(14);
					tb2 = F2537_29497(RTCW(loc1));
					if ((EIF_BOOLEAN) !tb2) {
						RTHOOK(15);
						F2640_30102(RTCW(loc1));
						RTHOOK(16);
						(FUNCTION_CAST(void, (EIF_REFERENCE)) R25452[Dtype(RTCW(loc1))-2458])(loc1);
					}
					RTHOOK(17);
					(FUNCTION_CAST(void, (EIF_REFERENCE)) R25452[Dtype(RTCW(loc1))-2458])(loc1);
				} else {
					RTHOOK(18);
					F2640_30101(RTCW(loc1));
				}
			}
		}
		RTHOOK(19);
		loc5 = F2640_30082(RTCW(loc1));
		for (;;) {
			tb2 = F2103_28501(loc5);
			if (tb2) break;
			RTHOOK(20);
			tr1 = F2103_28492(loc5);
			tr1 = *(EIF_REFERENCE *)(RTCW(tr1));
			tc1 = F3870_46985(Current);
			F3870_47013(Current, loc3, tr1, tc1);
			RTHOOK(21);
			F2103_28507(loc5);
		}
		RTHOOK(22);
		tr1 = RTLNS(eif_new_type(3869, 0x00).id, 3869, _OBJSIZ_2_1_0_0_0_0_0_0_);
		F3870_46962(RTCW(tr1), loc3);
		RTHOOK(23);
		RTLE;
		RTEE;
		return (EIF_REFERENCE) tr1;
	} else {
		
		RTHOOK(25);
		RTHOOK(26);
		RTLE;
		RTEE;
		return (EIF_REFERENCE) loc2;
	}/* NOTREACHED */
	
}

/* {PATH}.hash_code */
EIF_INTEGER_32 F3870_46981 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTEAA("hash_code", 3869, Current, 0, 0, 49833);
	RTGC;
	RTHOOK(1);
	if ((EIF_BOOLEAN) EIF_TEST(eif_case_sensitive_path_names())) {
		RTHOOK(2);
		tr1 = *(EIF_REFERENCE *)(Current);
		Result = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R37919[Dtype(RTCW(tr1))-3843])(tr1);
	} else {
		RTHOOK(3);
		Result = F4139_50524(RTCV(F3870_46998(Current)));
	}
	RTHOOK(4);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.native_string */
EIF_REFERENCE F3870_46982 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(2);
	RTLR(0,tr1);
	RTLR(1,Current);
	RTLIU(2);
	
	RTEAA("native_string", 3869, Current, 0, 0, 49834);
	RTGC;
	RTHOOK(1);
	tr1 = RTLNS(eif_new_type(1775, 0x00).id, 1775, _OBJSIZ_1_0_0_1_0_0_0_0_);
	F1776_25302(RTCW(tr1), *(EIF_REFERENCE *)(Current));
	RTHOOK(2);
	RTLE;
	RTEE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.directory_separator */
EIF_CHARACTER_8 F3870_46985 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("directory_separator", 3869, Current, 0, 0, 49837);
	RTGC;
	RTHOOK(1);
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
		RTHOOK(2);
		RTHOOK(3);
		RTLE;
		RTEE;
		return (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
	} else {
		RTHOOK(4);
		RTHOOK(5);
		RTLE;
		RTEE;
		return (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
	}/* NOTREACHED */
	
}

/* {PATH}.extended */
EIF_REFERENCE F3870_46986 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_INTEGER_32 ti4_4;
	EIF_BOOLEAN tb1;
	EIF_CHARACTER_8 tc1;
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTEAA("extended", 3869, Current, 2, 1, 49838);
	RTGC;
	RTHOOK(1);
	loc1 = RTLNSMART(eif_new_type(4148, 0).id);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O40942[Dtype(tr1)-4146]);
	ti4_2 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R40717[Dtype(RTCW(arg1))-4142])(arg1);
	ti4_3 = F3870_47003(Current);
	ti4_4 = F3870_47003(Current);
	F4147_50843(RTCW(loc1), (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 + (EIF_INTEGER_32) (ti4_2 * ti4_3)) + ti4_4));
	RTHOOK(2);
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R40966[Dtype(RTCW(loc1))-4148])(loc1, *(EIF_REFERENCE *)(Current));
	RTHOOK(3);
	tb1 = '\0';
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1) + O40942[Dtype(loc1)-4146]);
	if ((EIF_BOOLEAN) (ti4_1 > ((EIF_INTEGER_32) 0L))) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1) + O40942[Dtype(loc1)-4146]);
		tb1 = (EIF_BOOLEAN)(F3870_47009(Current) == ti4_1);
	}
	if (tb1) {
		RTHOOK(4);
		F3870_47012(Current, loc1, arg1, (EIF_CHARACTER_8) '\000');
	} else {
		RTHOOK(5);
		tc1 = F3870_46985(Current);
		F3870_47012(Current, loc1, arg1, tc1);
	}
	RTHOOK(6);
	tr1 = RTLNS(eif_new_type(3869, 0x00).id, 3869, _OBJSIZ_2_1_0_0_0_0_0_0_);
	F3870_46961(RTCW(tr1), loc1);
	RTHOOK(7);
	RTLE;
	RTEE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.extended_path */
EIF_REFERENCE F3870_46987 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_BOOLEAN tb1;
	EIF_CHARACTER_8 tc1;
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTEAA("extended_path", 3869, Current, 1, 1, 49839);
	RTGC;
	RTHOOK(1);
	loc1 = RTLNSMART(eif_new_type(4148, 0).id);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O40942[Dtype(tr1)-4146]);
	tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
	ti4_2 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O40942[Dtype(tr1)-4146]);
	ti4_3 = F3870_47003(Current);
	F4147_50843(RTCW(loc1), (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 + ti4_2) + ti4_3));
	RTHOOK(2);
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R40966[Dtype(RTCW(loc1))-4148])(loc1, *(EIF_REFERENCE *)(Current));
	RTHOOK(3);
	tb1 = '\0';
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1) + O40942[Dtype(loc1)-4146]);
	if ((EIF_BOOLEAN) (ti4_1 > ((EIF_INTEGER_32) 0L))) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1) + O40942[Dtype(loc1)-4146]);
		tb1 = (EIF_BOOLEAN)(F3870_47009(Current) == ti4_1);
	}
	if (tb1) {
		RTHOOK(4);
		tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
		F3870_47013(Current, loc1, tr1, (EIF_CHARACTER_8) '\000');
	} else {
		RTHOOK(5);
		tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
		tc1 = F3870_46985(Current);
		F3870_47013(Current, loc1, tr1, tc1);
	}
	RTHOOK(6);
	tr1 = RTLNS(eif_new_type(3869, 0x00).id, 3869, _OBJSIZ_2_1_0_0_0_0_0_0_);
	F3870_46962(RTCW(tr1), loc1);
	RTHOOK(7);
	RTLE;
	RTEE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.appended */
EIF_REFERENCE F3870_46988 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTEAA("appended", 3869, Current, 1, 1, 49840);
	RTGC;
	RTHOOK(1);
	loc1 = RTLNSMART(eif_new_type(4148, 0).id);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O40942[Dtype(tr1)-4146]);
	ti4_2 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R40717[Dtype(RTCW(arg1))-4142])(arg1);
	ti4_3 = F3870_47003(Current);
	F4147_50843(RTCW(loc1), (EIF_INTEGER_32) (ti4_1 + (EIF_INTEGER_32) (ti4_2 * ti4_3)));
	RTHOOK(2);
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R40966[Dtype(RTCW(loc1))-4148])(loc1, *(EIF_REFERENCE *)(Current));
	RTHOOK(3);
	F3870_47012(Current, loc1, arg1, (EIF_CHARACTER_8) '\000');
	RTHOOK(4);
	tr1 = RTLNS(eif_new_type(3869, 0x00).id, 3869, _OBJSIZ_2_1_0_0_0_0_0_0_);
	F3870_46961(RTCW(tr1), loc1);
	RTHOOK(5);
	RTLE;
	RTEE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.appended_with_extension */
EIF_REFERENCE F3870_46989 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_INTEGER_32 ti4_4;
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTEAA("appended_with_extension", 3869, Current, 2, 1, 49841);
	RTGC;
	RTHOOK(1);
	loc1 = RTLNSMART(eif_new_type(4148, 0).id);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O40942[Dtype(tr1)-4146]);
	ti4_2 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R40717[Dtype(RTCW(arg1))-4142])(arg1);
	ti4_3 = F3870_47003(Current);
	ti4_4 = F3870_47003(Current);
	F4147_50843(RTCW(loc1), (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 + (EIF_INTEGER_32) (ti4_2 * ti4_3)) + ti4_4));
	RTHOOK(2);
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R40966[Dtype(RTCW(loc1))-4148])(loc1, *(EIF_REFERENCE *)(Current));
	RTHOOK(3);
	F3870_47012(Current, loc1, arg1, (EIF_CHARACTER_8) '.');
	RTHOOK(4);
	tr1 = RTLNS(eif_new_type(3869, 0x00).id, 3869, _OBJSIZ_2_1_0_0_0_0_0_0_);
	F3870_46962(RTCW(tr1), loc1);
	RTHOOK(5);
	RTLE;
	RTEE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.same_as */
EIF_BOOLEAN F3870_46990 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(2);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLIU(2);
	
	RTEAA("same_as", 3869, Current, 0, 1, 49842);
	RTGC;
	RTHOOK(1);
	if ((EIF_BOOLEAN)(arg1 == NULL)) {
	} else {
		RTHOOK(2);
		if ((EIF_BOOLEAN)(arg1 == Current)) {
			RTHOOK(3);
			RTHOOK(4);
			RTLE;
			RTEE;
			return (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
		} else {
			RTHOOK(5);
			if ((EIF_BOOLEAN) EIF_TEST(eif_case_sensitive_path_names())) {
				RTHOOK(6);
				RTHOOK(7);
				RTLE;
				RTEE;
				return (EIF_BOOLEAN) F3870_46993(Current, arg1);
			} else {
				RTHOOK(8);
				RTHOOK(9);
				RTLE;
				RTEE;
				return (EIF_BOOLEAN) F3870_46994(Current, arg1);
			}
		}
	}
	RTHOOK(10);
	RTLE;
	RTEE;
	return (EIF_BOOLEAN) 0;
}

/* {PATH}.is_less */
EIF_BOOLEAN F3870_46991 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,arg1);
	RTLR(3,tr2);
	RTLIU(4);
	
	RTEAA("is_less", 3869, Current, 0, 1, 49843);
	RTGC;
	RTHOOK(1);
	if ((EIF_BOOLEAN) EIF_TEST(eif_case_sensitive_path_names())) {
		RTHOOK(2);
		tr1 = *(EIF_REFERENCE *)(Current);
		tr2 = *(EIF_REFERENCE *)(RTCW(arg1));
		Result = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE, EIF_REFERENCE)) R21024[Dtype(RTCW(tr1))-1660])(tr1, tr2);
	} else {
		RTHOOK(3);
		tr1 = F4143_50707(RTCV(F3870_46998(Current)));
		tr2 = F3870_46998(RTCW(arg1));
		tr2 = F4143_50707(RTCW(tr2));
		Result = F4142_50672(RTCW(tr1), tr2);
	}
	RTHOOK(4);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.is_equal */
EIF_BOOLEAN F3870_46992 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	
	
	RTEAA("is_equal", 3869, Current, 0, 1, 49844);
	RTHOOK(1);
	RTHOOK(2);
	RTEE;
	return (EIF_BOOLEAN) F3870_46990(Current, arg1);
}

/* {PATH}.is_case_sensitive_equal */
EIF_BOOLEAN F3870_46993 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLIU(4);
	
	RTEAA("is_case_sensitive_equal", 3869, Current, 0, 1, 49845);
	RTGC;
	RTHOOK(1);
	if ((EIF_BOOLEAN)(arg1 == Current)) {
		RTHOOK(2);
		RTHOOK(3);
		RTLE;
		RTEE;
		return (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	} else {
		RTHOOK(4);
		tr1 = *(EIF_REFERENCE *)(Current);
		tr2 = *(EIF_REFERENCE *)(RTCW(arg1));
		Result = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE, EIF_REFERENCE)) R11[Dtype(RTCW(tr1))-3])(tr1, tr2);
	}
	RTHOOK(5);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.is_case_insensitive_equal */
EIF_BOOLEAN F3870_46994 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLIU(4);
	
	RTEAA("is_case_insensitive_equal", 3869, Current, 0, 1, 49846);
	RTGC;
	RTHOOK(1);
	if ((EIF_BOOLEAN)(arg1 == Current)) {
		RTHOOK(2);
		RTHOOK(3);
		RTLE;
		RTEE;
		return (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	} else {
		RTHOOK(4);
		tr1 = F3870_46998(Current);
		tr2 = F3870_46998(RTCW(arg1));
		Result = F4142_50668(RTCW(tr1), tr2);
	}
	RTHOOK(5);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.copy */
void F3870_46995 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(3);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLIU(3);
	
	RTEAA("copy", 3869, Current, 0, 1, 49847);
	RTGC;
	RTHOOK(1);
	if ((EIF_BOOLEAN)(arg1 != Current)) {
		RTHOOK(2);
		eif_builtin_ANY_standard_copy (Current, arg1);
		RTHOOK(3);
		tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
		tr1 = (EIF_REFERENCE) eif_builtin_ANY_twin (tr1);
		RTAR(Current, tr1);
		*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	}
	RTHOOK(4);
	RTLE;
	RTEE;
}

/* {PATH}.out */
EIF_REFERENCE F3870_46996 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	
	
	RTEAA("out", 3869, Current, 0, 0, 49848);
	RTHOOK(1);
	RTHOOK(2);
	RTEE;
	return (EIF_REFERENCE) F3870_46997(Current);
}

/* {PATH}.utf_8_name */
EIF_REFERENCE F3870_46997 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	struct eif_ex_335 sloc1;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) sloc1.data;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	memset (&sloc1.overhead, 0, OVERHEAD + _OBJSIZ_0_0_0_0_0_0_0_0_);
	sloc1.overhead.ov_flags = EO_EXP | EO_STACK;
	RT_DFS(&sloc1.overhead, eif_new_type(378, 0x00).id);
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,Result);
	RTLIU(4);
	
	RTEAA("utf_8_name", 3869, Current, 1, 0, 49849);
	RTGC;
	RTHOOK(1);
	tr1 = F3870_46998(Current);
	Result = F379_7686(RTCW(loc1), tr1);
	RTHOOK(2);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.name */
EIF_REFERENCE F3870_46998 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	struct eif_ex_335 sloc1;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) sloc1.data;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	memset (&sloc1.overhead, 0, OVERHEAD + _OBJSIZ_0_0_0_0_0_0_0_0_);
	sloc1.overhead.ov_flags = EO_EXP | EO_STACK;
	RT_DFS(&sloc1.overhead, eif_new_type(378, 0x00).id);
	RTLI(5);
	RTLR(0,loc2);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,loc1);
	RTLR(4,Result);
	RTLIU(5);
	
	RTEAA("name", 3869, Current, 2, 0, 49850);
	RTGC;
	RTHOOK(1);
	tr1 = *(EIF_REFERENCE *)(Current + _REFACS_1_);
	loc2 = tr1;
	if (EIF_TEST(loc2)) {
		RTHOOK(2);
		RTHOOK(3);
		RTLE;
		RTEE;
		return (EIF_REFERENCE) loc2;
	} else {
		RTHOOK(4);
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
			RTHOOK(5);
			Result = RTLNS(eif_new_type(4142, 0x00).id, 4142, _OBJSIZ_1_0_0_4_0_0_0_0_);
			tr1 = F379_7728(RTCW(loc1), *(EIF_REFERENCE *)(Current));
			F4142_50646(RTCW(Result), tr1);
		} else {
			RTHOOK(6);
			Result = RTLNS(eif_new_type(4142, 0x00).id, 4142, _OBJSIZ_1_0_0_4_0_0_0_0_);
			tr1 = F379_7701(RTCW(loc1), *(EIF_REFERENCE *)(Current));
			F4142_50646(RTCW(Result), tr1);
		}
		RTHOOK(7);
		RTAR(Current, Result);
		*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) Result;
	}
	RTHOOK(9);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.debug_output */
EIF_REFERENCE F3870_46999 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	
	
	RTEAA("debug_output", 3869, Current, 0, 0, 49851);
	RTHOOK(1);
	RTHOOK(2);
	RTEE;
	return (EIF_REFERENCE) F3870_46998(Current);
}

/* {PATH}.to_pointer */
EIF_REFERENCE F3870_47000 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	RTLD;
	
	RTLI(3);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLIU(3);
	
	RTEAA("to_pointer", 3869, Current, 1, 0, 49852);
	RTGC;
	RTHOOK(1);
	loc1 = RTLNS(eif_new_type(1848, 0x00).id, 1848, _OBJSIZ_1_0_0_1_0_0_0_0_);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O40942[Dtype(tr1)-4146]);
	ti4_2 = F3870_47003(Current);
	F1849_26679(RTCW(loc1), (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 + ti4_2) - ((EIF_INTEGER_32) 1L)));
	RTHOOK(2);
	F1849_26703(RTCW(loc1), *(EIF_REFERENCE *)(Current));
	RTHOOK(3);
	tr1 = *(EIF_REFERENCE *)(RTCW(loc1));
	RTHOOK(4);
	RTLE;
	RTEE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.unit_size */
EIF_INTEGER_32 F3870_47003 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("unit_size", 3869, Current, 0, 0, 49855);
	RTGC;
	RTHOOK(1);
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
		RTHOOK(2);
		RTHOOK(3);
		RTLE;
		RTEE;
		return (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
	} else {
		RTHOOK(4);
		RTHOOK(5);
		RTLE;
		RTEE;
		return (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
	}/* NOTREACHED */
	
}

/* {PATH}.reset_internal_data */
void F3870_47004 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	
	
	RTEAA("reset_internal_data", 3869, Current, 0, 0, 49856);
	RTHOOK(1);
	*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) NULL;
	RTHOOK(2);
	RTEE;
}

/* {PATH}.normalize */
void F3870_47005 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc3 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc4 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc5 = (EIF_INTEGER_32) 0;
	EIF_BOOLEAN loc6 = (EIF_BOOLEAN) 0;
	EIF_BOOLEAN loc7 = (EIF_BOOLEAN) 0;
	EIF_BOOLEAN loc8 = (EIF_BOOLEAN) 0;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_CHARACTER_8 tc1;
	RTLD;
	
	RTLI(2);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLIU(2);
	
	RTEAA("normalize", 3869, Current, 8, 0, 49857);
	RTGC;
	RTHOOK(1);
	loc1 = *(EIF_REFERENCE *)(Current);
	RTHOOK(2);
	loc4 = *(EIF_INTEGER_32 *)(RTCW(loc1) + O40942[Dtype(loc1)-4146]);
	RTHOOK(3);
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
		RTHOOK(4);
		loc2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
		RTHOOK(5);
		if ((EIF_BOOLEAN) (loc4 >= ((EIF_INTEGER_32) 10L))) {
			RTHOOK(6);
			tb1 = '\01';
			tb2 = '\0';
			if (F3870_47015(Current, loc1, ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '/')) {
				tb3 = '\01';
				if (!F3870_47015(Current, loc1, ((EIF_INTEGER_32) 3L), (EIF_CHARACTER_8) '/')) {
					tb3 = F3870_47015(Current, loc1, ((EIF_INTEGER_32) 3L), (EIF_CHARACTER_8) '\\');
				}
				tb2 = tb3;
			}
			if (!(tb2)) {
				tb2 = '\0';
				if (F3870_47015(Current, loc1, ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '\\')) {
					tb3 = '\01';
					if (!F3870_47015(Current, loc1, ((EIF_INTEGER_32) 3L), (EIF_CHARACTER_8) '\\')) {
						tb3 = F3870_47015(Current, loc1, ((EIF_INTEGER_32) 3L), (EIF_CHARACTER_8) '/');
					}
					tb2 = tb3;
				}
				tb1 = tb2;
			}
			if (tb1) {
				RTHOOK(7);
				tb1 = '\0';
				if ((EIF_BOOLEAN) !F3870_47015(Current, loc1, ((EIF_INTEGER_32) 5L), (EIF_CHARACTER_8) '/')) {
					tb1 = (EIF_BOOLEAN) !F3870_47015(Current, loc1, ((EIF_INTEGER_32) 5L), (EIF_CHARACTER_8) '\\');
				}
				if (tb1) {
					RTHOOK(8);
					loc2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 5L);
					RTHOOK(9);
					loc8 = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
				}
			}
		}
		RTHOOK(10);
		loc3 = (EIF_INTEGER_32) loc2;
		RTHOOK(11);
		loc7 = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
		for (;;) {
			RTHOOK(12);
			if ((EIF_BOOLEAN) (loc2 > loc4)) break;
			RTHOOK(13);
			if (loc6) {
				RTHOOK(14);
				loc7 = '\0';
				if ((EIF_BOOLEAN) !F3870_47015(Current, loc1, loc2, (EIF_CHARACTER_8) '\\')) {
					loc7 = (EIF_BOOLEAN) !F3870_47015(Current, loc1, loc2, (EIF_CHARACTER_8) '/');
				}
				RTHOOK(15);
				loc6 = (EIF_BOOLEAN) (EIF_BOOLEAN) !loc7;
			} else {
				RTHOOK(16);
				if (F3870_47015(Current, loc1, loc2, (EIF_CHARACTER_8) '/')) {
					RTHOOK(17);
					tc1 = (EIF_CHARACTER_8) '\\';
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE, EIF_REFERENCE)) R25444[Dtype(RTCW(loc1))-2534])(loc1, (EIF_REFERENCE) &tc1, (EIF_REFERENCE) &loc2);
					RTHOOK(18);
					loc6 = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
				} else {
					RTHOOK(19);
					loc6 = F3870_47015(Current, loc1, loc2, (EIF_CHARACTER_8) '\\');
				}
			}
			RTHOOK(20);
			if (loc7) {
				RTHOOK(21);
				if ((EIF_BOOLEAN)(loc2 != loc3)) {
					RTHOOK(22);
					tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R25641[Dtype(RTCW(loc1))-2534])(loc1, loc2));
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE, EIF_REFERENCE)) R25444[Dtype(RTCW(loc1))-2534])(loc1, (EIF_REFERENCE) &tc1, (EIF_REFERENCE) &loc3);
					RTHOOK(23);
					tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R25641[Dtype(RTCW(loc1))-2534])(loc1, (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L))));
					ti4_1 = (EIF_INTEGER_32) (loc3 + ((EIF_INTEGER_32) 1L));
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE, EIF_REFERENCE)) R25444[Dtype(RTCW(loc1))-2534])(loc1, (EIF_REFERENCE) &tc1, (EIF_REFERENCE) &ti4_1);
				}
				RTHOOK(24);
				loc3 += ((EIF_INTEGER_32) 2L);
			}
			RTHOOK(25);
			loc2 += ((EIF_INTEGER_32) 2L);
		}
	} else {
		RTHOOK(26);
		loc2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
		RTHOOK(27);
		loc3 = (EIF_INTEGER_32) loc2;
		RTHOOK(28);
		loc7 = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
		for (;;) {
			RTHOOK(29);
			if ((EIF_BOOLEAN) (loc2 > loc4)) break;
			RTHOOK(30);
			if (loc6) {
				RTHOOK(31);
				loc7 = F3870_47015(Current, loc1, loc2, (EIF_CHARACTER_8) '/');
				loc7 = (EIF_BOOLEAN) (EIF_BOOLEAN) !loc7;
				RTHOOK(32);
				loc6 = (EIF_BOOLEAN) (EIF_BOOLEAN) !loc7;
			} else {
				RTHOOK(33);
				loc6 = F3870_47015(Current, loc1, loc2, (EIF_CHARACTER_8) '/');
			}
			RTHOOK(34);
			if (loc7) {
				RTHOOK(35);
				if ((EIF_BOOLEAN)(loc2 != loc3)) {
					RTHOOK(36);
					tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R25641[Dtype(RTCW(loc1))-2534])(loc1, loc2));
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE, EIF_REFERENCE)) R25444[Dtype(RTCW(loc1))-2534])(loc1, (EIF_REFERENCE) &tc1, (EIF_REFERENCE) &loc3);
				}
				RTHOOK(37);
				loc3++;
			}
			RTHOOK(38);
			loc2++;
		}
	}
	RTHOOK(39);
	if ((EIF_BOOLEAN)(loc2 != loc3)) {
		RTHOOK(40);
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_INTEGER_32)) R40796[Dtype(RTCW(loc1))-4143])(loc1, (EIF_INTEGER_32) (loc3 - ((EIF_INTEGER_32) 1L)));
	}
	RTHOOK(41);
	*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	RTHOOK(42);
	if (loc8) {
		RTHOOK(43);
		loc5 = F3870_47009(Current);
		RTHOOK(44);
		if ((EIF_BOOLEAN)(loc5 == ((EIF_INTEGER_32) 0L))) {
			RTHOOK(45);
			ti4_1 = F3870_47003(Current);
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_INTEGER_32)) R40802[Dtype(RTCW(loc1))-4143])(loc1, ti4_1);
		}
	}
	RTHOOK(46);
	tb1 = '\0';
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1) + O40942[Dtype(loc1)-4146]);
	ti4_2 = F3870_47003(Current);
	tc1 = F3870_46985(Current);
	if (F3870_47015(Current, loc1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 - ti4_2) + ((EIF_INTEGER_32) 1L)), tc1)) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1) + O40942[Dtype(loc1)-4146]);
		tb1 = (EIF_BOOLEAN) (F3870_47009(Current) < ti4_1);
	}
	if (tb1) {
		RTHOOK(47);
		ti4_1 = F3870_47003(Current);
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_INTEGER_32)) R40804[Dtype(RTCW(loc1))-4143])(loc1, ti4_1);
	}
	RTHOOK(49);
	RTLE;
	RTEE;
}

/* {PATH}.env */
static EIF_REFERENCE F3870_47008_body (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
#define Result RTOTRR
	RTOUDR(372)

	RTLI(2);
	RTLR(0,tr1);
	RTLR(1,Current);
	RTLIU(2);
	
	RTEAA("env", 3869, Current, 0, 0, 49860);
	RTGC;
	RTOTP;
	RTHOOK(1);
	tr1 = RTLNS(eif_new_type(1778, 0x00).id, 1778, _OBJSIZ_0_0_0_1_0_0_0_0_);
	Result = (EIF_REFERENCE) tr1;
	RTOTE;
	RTHOOK(2);
	RTLE;
	RTEE;
	return Result;
#undef Result
}

EIF_REFERENCE F3870_47008 (EIF_REFERENCE Current)
{
	GTCX
	return RTOUCR(372,F3870_47008_body,(Current));
}

/* {PATH}.root_end_position */
EIF_INTEGER_32 F3870_47009 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_CHARACTER_8 loc1 = (EIF_CHARACTER_8) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_CHARACTER_8 tc1;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTEAA("root_end_position", 3869, Current, 2, 0, 49861);
	RTGC;
	RTHOOK(1);
	tr1 = *(EIF_REFERENCE *)(Current);
	tb1 = F2392_29294(RTCW(tr1));
	if ((EIF_BOOLEAN) !tb1) {
		RTHOOK(2);
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
			RTHOOK(3);
			tb1 = '\0';
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O40942[Dtype(tr1)-4146]);
			if ((EIF_BOOLEAN)(ti4_1 == F3870_47003(Current))) {
				tb1 = F3870_47015(Current, *(EIF_REFERENCE *)(Current), ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '\\');
			}
			if (tb1) {
				RTHOOK(4);
				RTHOOK(5);
				RTLE;
				RTEE;
				return (EIF_INTEGER_32) F3870_47003(Current);
			} else {
				RTHOOK(6);
				tb1 = '\0';
				tr1 = *(EIF_REFERENCE *)(Current);
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O40942[Dtype(tr1)-4146]);
				if ((EIF_BOOLEAN) (ti4_1 >= ((EIF_INTEGER_32) 4L))) {
					tb2 = '\0';
					tr1 = *(EIF_REFERENCE *)(Current);
					tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R25641[Dtype(RTCW(tr1))-2534])(tr1, ((EIF_INTEGER_32) 2L)));
					if ((EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '\000')) {
						tr1 = *(EIF_REFERENCE *)(Current);
						tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R25641[Dtype(RTCW(tr1))-2534])(tr1, ((EIF_INTEGER_32) 4L)));
						tb2 = (EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '\000');
					}
					tb1 = tb2;
				}
				if (tb1) {
					RTHOOK(7);
					tr1 = *(EIF_REFERENCE *)(Current);
					loc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R25641[Dtype(RTCW(tr1))-2534])(tr1, ((EIF_INTEGER_32) 1L)));
					loc1 = (EIF_CHARACTER_8) tolower(loc1);
					RTHOOK(8);
					tb1 = '\0';
					if ((EIF_BOOLEAN) ((EIF_BOOLEAN) (loc1 >= (EIF_CHARACTER_8) 'a') && (EIF_BOOLEAN) (loc1 <= (EIF_CHARACTER_8) 'z'))) {
						tr1 = *(EIF_REFERENCE *)(Current);
						tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R25641[Dtype(RTCW(tr1))-2534])(tr1, ((EIF_INTEGER_32) 3L)));
						tb1 = (EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) ':');
					}
					if (tb1) {
						RTHOOK(9);
						tb1 = '\0';
						tr1 = *(EIF_REFERENCE *)(Current);
						ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O40942[Dtype(tr1)-4146]);
						if ((EIF_BOOLEAN) (ti4_1 >= (EIF_INTEGER_32) (((EIF_INTEGER_32) 3L) * F3870_47003(Current)))) {
							tb1 = F3870_47015(Current, *(EIF_REFERENCE *)(Current), ((EIF_INTEGER_32) 5L), (EIF_CHARACTER_8) '\\');
						}
						if (tb1) {
							RTHOOK(10);
							RTHOOK(11);
							RTLE;
							RTEE;
							return (EIF_INTEGER_32) ((EIF_INTEGER_32) 6L);
						} else {
							RTHOOK(12);
							RTHOOK(13);
							RTLE;
							RTEE;
							return (EIF_INTEGER_32) ((EIF_INTEGER_32) 4L);
						}
					} else {
						RTHOOK(14);
						tb1 = '\0';
						if ((EIF_BOOLEAN)(loc1 == (EIF_CHARACTER_8) '\\')) {
							tr1 = *(EIF_REFERENCE *)(Current);
							tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R25641[Dtype(RTCW(tr1))-2534])(tr1, ((EIF_INTEGER_32) 3L)));
							tb1 = (EIF_BOOLEAN)(tc1 != (EIF_CHARACTER_8) '\\');
						}
						if (tb1) {
							RTHOOK(15);
							Result = F3870_47003(Current);
						} else {
							RTHOOK(16);
							tb1 = '\0';
							tb2 = '\0';
							tb3 = '\0';
							tr1 = *(EIF_REFERENCE *)(Current);
							ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O40942[Dtype(tr1)-4146]);
							if ((EIF_BOOLEAN) (ti4_1 >= ((EIF_INTEGER_32) 10L))) {
								tb3 = (EIF_BOOLEAN)(loc1 == (EIF_CHARACTER_8) '\\');
							}
							if (tb3) {
								tr1 = *(EIF_REFERENCE *)(Current);
								tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R25641[Dtype(RTCW(tr1))-2534])(tr1, ((EIF_INTEGER_32) 3L)));
								tb2 = (EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '\\');
							}
							if (tb2) {
								tr1 = *(EIF_REFERENCE *)(Current);
								tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R25641[Dtype(RTCW(tr1))-2534])(tr1, ((EIF_INTEGER_32) 5L)));
								tb1 = (EIF_BOOLEAN)(tc1 != (EIF_CHARACTER_8) '\\');
							}
							if (tb1) {
								RTHOOK(17);
								loc2 = F3870_47011(Current, ((EIF_INTEGER_32) 7L));
								RTHOOK(18);
								tb1 = '\0';
								if ((EIF_BOOLEAN) (loc2 > ((EIF_INTEGER_32) 0L))) {
									tr1 = *(EIF_REFERENCE *)(Current);
									ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O40942[Dtype(tr1)-4146]);
									tb1 = (EIF_BOOLEAN) ((EIF_INTEGER_32) (loc2 + F3870_47003(Current)) <= ti4_1);
								}
								if (tb1) {
									RTHOOK(19);
									ti4_1 = F3870_47003(Current);
									ti4_1 = F3870_47011(Current, (EIF_INTEGER_32) (loc2 + ti4_1));
									loc2 = (EIF_INTEGER_32) ti4_1;
									RTHOOK(20);
									if ((EIF_BOOLEAN) (loc2 > ((EIF_INTEGER_32) 0L))) {
										RTHOOK(21);
										RTHOOK(22);
										RTLE;
										RTEE;
										return (EIF_INTEGER_32) (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L));
									} else {
										RTHOOK(23);
										tr1 = *(EIF_REFERENCE *)(Current);
										Result = *(EIF_INTEGER_32 *)(RTCW(tr1) + O40942[Dtype(tr1)-4146]);
									}
								}
							}
						}
					}
				}
			}
		} else {
			RTHOOK(24);
			tr1 = *(EIF_REFERENCE *)(Current);
			tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R25641[Dtype(RTCW(tr1))-2534])(tr1, ((EIF_INTEGER_32) 1L)));
			if ((EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '/')) {
				RTHOOK(25);
				RTHOOK(26);
				RTLE;
				RTEE;
				return (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			}
		}
	}
	RTHOOK(30);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.end_position_of_last_directory_separator */
EIF_INTEGER_32 F3870_47010 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_CHARACTER_8 tc1;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTEAA("end_position_of_last_directory_separator", 3869, Current, 0, 0, 49862);
	RTGC;
	RTHOOK(1);
	tr1 = *(EIF_REFERENCE *)(Current);
	tb1 = F2392_29294(RTCW(tr1));
	if ((EIF_BOOLEAN) !tb1) {
		RTHOOK(2);
		tr1 = *(EIF_REFERENCE *)(Current);
		Result = *(EIF_INTEGER_32 *)(RTCW(tr1) + O40942[Dtype(tr1)-4146]);
		ti4_1 = F3870_47003(Current);
		Result = (EIF_INTEGER_32) (EIF_INTEGER_32) ((EIF_INTEGER_32) (Result - ti4_1) + ((EIF_INTEGER_32) 1L));
		RTHOOK(3);
		if ((EIF_BOOLEAN) (Result >= ((EIF_INTEGER_32) 1L))) {
			for (;;) {
				RTHOOK(4);
				tb1 = '\01';
				if (!(EIF_BOOLEAN) (Result < ((EIF_INTEGER_32) 1L))) {
					tr1 = *(EIF_REFERENCE *)(Current);
					tc1 = F3870_46985(Current);
					tb1 = F3870_47015(Current, tr1, Result, tc1);
				}
				if (tb1) break;
				RTHOOK(5);
				Result -= F3870_47003(Current);
			}
		}
		RTHOOK(6);
		if ((EIF_BOOLEAN) (Result < ((EIF_INTEGER_32) 0L))) {
			RTHOOK(7);
			RTHOOK(8);
			RTLE;
			RTEE;
			return (EIF_INTEGER_32) ((EIF_INTEGER_32) 0L);
		} else {
			RTHOOK(9);
			ti4_1 = F3870_47003(Current);
			Result = (EIF_INTEGER_32) (EIF_INTEGER_32) ((EIF_INTEGER_32) (Result + ti4_1) - ((EIF_INTEGER_32) 1L));
		}
	}
	RTHOOK(13);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.next_directory_separator */
EIF_INTEGER_32 F3870_47011 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_CHARACTER_8 loc3 = (EIF_CHARACTER_8) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_BOOLEAN tb1;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,loc4);
	RTLIU(2);
	
	RTEAA("next_directory_separator", 3869, Current, 4, 1, 49863);
	RTGC;
	RTHOOK(1);
	loc2 = F3870_47003(Current);
	RTHOOK(2);
	loc3 = F3870_46985(Current);
	RTHOOK(3);
	Result = (EIF_INTEGER_32) arg1;
	RTHOOK(4);
	loc4 = *(EIF_REFERENCE *)(Current);
	RTHOOK(5);
	loc1 = *(EIF_INTEGER_32 *)(RTCW(loc4) + O40942[Dtype(loc4)-4146]);
	for (;;) {
		RTHOOK(6);
		tb1 = '\01';
		if (!(EIF_BOOLEAN) ((EIF_BOOLEAN) (Result < ((EIF_INTEGER_32) 1L)) || (EIF_BOOLEAN) (Result > loc1))) {
			tb1 = F3870_47015(Current, loc4, Result, loc3);
		}
		if (tb1) break;
		RTHOOK(7);
		Result += loc2;
	}
	RTHOOK(8);
	if ((EIF_BOOLEAN) (Result > loc1)) {
		RTHOOK(9);
		RTHOOK(10);
		RTLE;
		RTEE;
		return (EIF_INTEGER_32) ((EIF_INTEGER_32) 0L);
	}
	RTHOOK(14);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.internal_append_into */
void F3870_47012 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2, EIF_CHARACTER_8 arg3)
{
	GTCX
	RTEX;
	struct eif_ex_335 sloc1;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) sloc1.data;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_CHARACTER_32 tw1;
	EIF_CHARACTER_32 tw2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_BOOLEAN tb4;
	RTLD;
	
	memset (&sloc1.overhead, 0, OVERHEAD + _OBJSIZ_0_0_0_0_0_0_0_0_);
	sloc1.overhead.ov_flags = EO_EXP | EO_STACK;
	RT_DFS(&sloc1.overhead, eif_new_type(378, 0x00).id);
	RTLI(4);
	RTLR(0,arg2);
	RTLR(1,arg1);
	RTLR(2,Current);
	RTLR(3,loc1);
	RTLIU(4);
	
	RTEAA("internal_append_into", 3869, Current, 1, 3, 49864);
	RTGC;
	RTHOOK(1);
	tb1 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE)) R40695[Dtype(RTCW(arg2))-4142])(arg2);
	if ((EIF_BOOLEAN) !tb1) {
		RTHOOK(2);
		tb1 = '\0';
		tb2 = '\0';
		tb3 = '\0';
		if ((EIF_BOOLEAN)(arg3 != (EIF_CHARACTER_8) '\000')) {
			tb4 = F2392_29294(RTCW(arg1));
			tb3 = (EIF_BOOLEAN) !tb4;
		}
		if (tb3) {
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(arg1) + O40942[Dtype(arg1)-4146]);
			ti4_2 = F3870_47003(Current);
			tb2 = (EIF_BOOLEAN) !F3870_47015(Current, arg1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 - ti4_2) + ((EIF_INTEGER_32) 1L)), arg3);
		}
		if (tb2) {
			tw1 = (FUNCTION_CAST(EIF_CHARACTER_32, (EIF_REFERENCE, EIF_INTEGER_32)) R40681[Dtype(RTCW(arg2))-4142])(arg2, ((EIF_INTEGER_32) 1L));
			tw2 = (EIF_CHARACTER_32) (EIF_CHARACTER_8) '/';
			tb1 = (EIF_BOOLEAN)(tw1 != tw2);
		}
		if (tb1) {
			RTHOOK(3);
			if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
				RTHOOK(4);
				tw1 = (FUNCTION_CAST(EIF_CHARACTER_32, (EIF_REFERENCE, EIF_INTEGER_32)) R40681[Dtype(RTCW(arg2))-4142])(arg2, ((EIF_INTEGER_32) 1L));
				tw2 = (EIF_CHARACTER_32) (EIF_CHARACTER_8) '\\';
				if ((EIF_BOOLEAN)(tw1 != tw2)) {
					RTHOOK(5);
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R40970[Dtype(RTCW(arg1))-4148])(arg1, arg3);
					RTHOOK(6);
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R40970[Dtype(RTCW(arg1))-4148])(arg1, (EIF_CHARACTER_8) '\000');
				}
			} else {
				RTHOOK(7);
				(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R40970[Dtype(RTCW(arg1))-4148])(arg1, arg3);
			}
		}
		RTHOOK(8);
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
			RTHOOK(9);
			F379_7715(RTCW(loc1), arg2, arg1);
		} else {
			RTHOOK(10);
			F379_7690(RTCW(loc1), arg2, arg1);
		}
	}
	RTHOOK(11);
	RTLE;
	RTEE;
}

/* {PATH}.internal_path_append_into */
void F3870_47013 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2, EIF_CHARACTER_8 arg3)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_BOOLEAN tb4;
	RTLD;
	
	RTLI(3);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,arg2);
	RTLIU(3);
	
	RTEAA("internal_path_append_into", 3869, Current, 0, 3, 49865);
	RTGC;
	RTHOOK(1);
	tb1 = '\0';
	tb2 = '\0';
	tb3 = '\0';
	if ((EIF_BOOLEAN)(arg3 != (EIF_CHARACTER_8) '\000')) {
		tb4 = F2392_29294(RTCW(arg1));
		tb3 = (EIF_BOOLEAN) !tb4;
	}
	if (tb3) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(arg1) + O40942[Dtype(arg1)-4146]);
		ti4_2 = F3870_47003(Current);
		tb2 = (EIF_BOOLEAN) !F3870_47015(Current, arg1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 - ti4_2) + ((EIF_INTEGER_32) 1L)), arg3);
	}
	if (tb2) {
		tb1 = (EIF_BOOLEAN) !F3870_47015(Current, arg2, ((EIF_INTEGER_32) 1L), arg3);
	}
	if (tb1) {
		RTHOOK(2);
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R40970[Dtype(RTCW(arg1))-4148])(arg1, arg3);
		RTHOOK(3);
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
			RTHOOK(4);
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R40970[Dtype(RTCW(arg1))-4148])(arg1, (EIF_CHARACTER_8) '\000');
		}
	}
	RTHOOK(5);
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R40966[Dtype(RTCW(arg1))-4148])(arg1, arg2);
	RTHOOK(6);
	RTLE;
	RTEE;
}

/* {PATH}.internal_path_append_substring_into */
void F3870_47014 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_CHARACTER_8 arg5)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_BOOLEAN tb4;
	RTLD;
	
	RTLI(3);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,arg2);
	RTLIU(3);
	
	RTEAA("internal_path_append_substring_into", 3869, Current, 0, 5, 49866);
	RTGC;
	RTHOOK(1);
	tb1 = '\0';
	tb2 = '\0';
	tb3 = '\0';
	if ((EIF_BOOLEAN)(arg5 != (EIF_CHARACTER_8) '\000')) {
		tb4 = F2392_29294(RTCW(arg1));
		tb3 = (EIF_BOOLEAN) !tb4;
	}
	if (tb3) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(arg1) + O40942[Dtype(arg1)-4146]);
		ti4_2 = F3870_47003(Current);
		tb2 = (EIF_BOOLEAN) !F3870_47015(Current, arg1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 - ti4_2) + ((EIF_INTEGER_32) 1L)), arg5);
	}
	if (tb2) {
		tb1 = (EIF_BOOLEAN) !F3870_47015(Current, arg2, arg3, arg5);
	}
	if (tb1) {
		RTHOOK(2);
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R40970[Dtype(RTCW(arg1))-4148])(arg1, arg5);
		RTHOOK(3);
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
			RTHOOK(4);
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R40970[Dtype(RTCW(arg1))-4148])(arg1, (EIF_CHARACTER_8) '\000');
		}
	}
	RTHOOK(5);
	F4149_50955(RTCW(arg1), arg2, arg3, arg4);
	RTHOOK(6);
	RTLE;
	RTEE;
}

/* {PATH}.is_character */
EIF_BOOLEAN F3870_47015 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_INTEGER_32 arg2, EIF_CHARACTER_8 arg3)
{
	GTCX
	RTEX;
	EIF_CHARACTER_8 tc1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLIU(2);
	
	RTEAA("is_character", 3869, Current, 0, 3, 49867);
	RTGC;
	RTHOOK(1);
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
		RTHOOK(2);
		Result = '\0';
		tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R25641[Dtype(RTCW(arg1))-2534])(arg1, arg2));
		if ((EIF_BOOLEAN)(tc1 == arg3)) {
			tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R25641[Dtype(RTCW(arg1))-2534])(arg1, (EIF_INTEGER_32) (arg2 + ((EIF_INTEGER_32) 1L))));
			Result = (EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '\000');
		}
	} else {
		RTHOOK(3);
		tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R25641[Dtype(RTCW(arg1))-2534])(arg1, arg2));
		Result = (EIF_BOOLEAN) (EIF_BOOLEAN)(tc1 == arg3);
	}
	RTHOOK(5);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.c_same_files */
EIF_BOOLEAN F3870_47018 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2)
{
	GTCX
	RTEX;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("c_same_files", 3869, Current, 0, 2, 49870);
	Result = EIF_TEST(inline_F3870_47018 ((EIF_POINTER) arg1, (EIF_POINTER) arg2));
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

void EIF_Minit2774 (void)
{
	GTCX
}


#ifdef __cplusplus
}
#endif
