# Gobo Eiffel Utility Library

This library contains pattern classes as described in "Design Patterns"
from the "Gang of Four", and utility classes which does not deserve to
have a library on their own. The aim of this library is to always be under
construction.

**Included in this library:**

* `src`: this folder contains the clusters and classes making up this library.
  * `config`: Parser of config files made up of name/value pairs
    and preprocessor instructions.
  * `error`: Error messages and error handling cluster.
  * `formatter`: Formatter classes for IO operations or string handling.
  * `support`: Miscellaneous classes.
  * `transcoder`: Base64 encoding and decoding.
  * `uri`: URI classes.
* `test`: this folder contains the unit tests for this library as well as
  tests to exercise the examples.

A more detailed documentation for this library will be provided in
future releases.

## Authors

Copyright (c) 1997-2017, Eric Bezault and others
