note

	description:

		"Eiffel inline agents with an external procedure as associated feature"

	library: "Gobo Eiffel Tools Library"
	copyright: "Copyright (c) 2007-2014, Eric Bezault and others"
	license: "MIT License"
	date: "$Date: 2016-05-06 19:15:38 +0000 (Fri, 06 May 2016) $"
	revision: "$Revision: 98678 $"

class ET_EXTERNAL_PROCEDURE_INLINE_AGENT

inherit

	ET_PROCEDURE_INLINE_AGENT
		rename
			make as make_procedure
		end

	ET_EXTERNAL_ROUTINE_INLINE_AGENT
		rename
			make as make_inline_agent
		end

create

	make

feature {NONE} -- Initialization

	make (a_formal_args: like formal_arguments; a_language: like language; an_actual_args: like actual_arguments)
			-- Create a new inline agent whose associated feature is an external procedure.
		require
			a_language_not_void: a_language /= Void
		do
			language := a_language
			make_procedure (a_formal_args, an_actual_args)
		ensure
			formal_arguments_set: formal_arguments = a_formal_args
			language_set: language = a_language
			actual_arguments_set: actual_arguments = an_actual_args
		end

feature -- Processing

	process (a_processor: ET_AST_PROCESSOR)
			-- Process current node.
		do
			a_processor.process_external_procedure_inline_agent (Current)
		end

end
