/*
 * Code for class GDK_X11
 */

#include "eif_eiffel.h"
#include "../E1/estructure.h"
#include "../E1/eoffsets.h"

#include "gd183.h"
#include <ev_gtk.h>
#include "eif_misc.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifndef INLINE_F218_2936
static void inline_F218_2936 (EIF_POINTER arg1)
{
	#ifdef GDK_WINDOWING_X11
	return gdk_x11_display_error_trap_push ((GdkDisplay *)arg1);
#endif
	;
}
#define INLINE_F218_2936
#endif
#ifndef INLINE_F218_2938
static EIF_POINTER inline_F218_2938 (EIF_POINTER arg1)
{
	#ifdef GDK_WINDOWING_X11 
		/* Declarations */
	GC gc;									/* handle of newly created GC.  */
	unsigned long valuemask = 0;			/* which values in 'values' to  */
	Window win =  gdk_x11_window_get_xid ((GdkWindow *)arg1);
	Display* display = GDK_SCREEN_XDISPLAY(gdk_window_get_screen ((GdkWindow *)arg1));
		/* Define properties/values for the GC.  */
	XGCValues values;						/* initial values for the GC.   */
	unsigned int line_width = 1;			/* line width for the GC.       */
	int line_style = LineSolid;				/* style for lines drawing and  */
	int cap_style = CapButt;				/* style of the line's edje and */
	int join_style = JoinBevel;				/* joined lines.		*/
	values.function = GXcopy;               /* src */
	values.subwindow_mode = ClipByChildren; /* GCSubwindowMode */
	values.line_width = line_width;
	values.fill_style = FillSolid;
	values.arc_mode = ArcPieSlice;
	values.graphics_exposures = False;
	valuemask = GCFunction | GCFillStyle | GCArcMode | GCSubwindowMode | GCGraphicsExposures;
		/* Create the GC object */
	gc = XCreateGC(display, win, valuemask, &values);
	if (gc < 0) {
		fprintf(stderr, "XCreateGC: \n");
	}
	return gc;
#endif
	;
}
#define INLINE_F218_2938
#endif
#ifndef INLINE_F218_2942
static EIF_POINTER inline_F218_2942 (EIF_POINTER arg1)
{
	#ifdef GDK_WINDOWING_X11 
	return (EIF_POINTER) GDK_SCREEN_XDISPLAY(gdk_window_get_screen ((GdkWindow *)arg1));
#endif
	;
}
#define INLINE_F218_2942
#endif
#ifndef INLINE_F218_2957
static EIF_INTEGER_32 inline_F218_2957 (void)
{
	#ifdef GDK_WINDOWING_X11
return LineSolid;
#endif
	;
}
#define INLINE_F218_2957
#endif
#ifndef INLINE_F218_2958
static EIF_INTEGER_32 inline_F218_2958 (void)
{
	#ifdef GDK_WINDOWING_X11
return CapButt;
#endif
	;
}
#define INLINE_F218_2958
#endif
#ifndef INLINE_F218_2959
static EIF_INTEGER_32 inline_F218_2959 (void)
{
	#ifdef GDK_WINDOWING_X11
return JoinBevel;
#endif
	;
}
#define INLINE_F218_2959
#endif
#ifndef INLINE_F218_2946
static void inline_F218_2946 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5, EIF_INTEGER_32 arg6)
{
	#ifdef GDK_WINDOWING_X11 
				XSetLineAttributes((Display*) arg1, (GC) arg2, 
					(unsigned int) arg3,
      				(int) arg4, (int) arg5, (int) arg6);
				#endif
	;
}
#define INLINE_F218_2946
#endif
#ifndef INLINE_F218_2947
static void inline_F218_2947 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_POINTER arg4, EIF_INTEGER_32 arg5)
{
	#ifdef GDK_WINDOWING_X11 
	XSetDashes ((Display*) arg1, (GC) arg2, (int) arg3, (char*) arg4, (int) arg5);
#endif
	;
}
#define INLINE_F218_2947
#endif
#ifndef INLINE_F218_2956
static EIF_INTEGER_32 inline_F218_2956 (void)
{
	#ifdef GDK_WINDOWING_X11
return LineOnOffDash;
#endif
	;
}
#define INLINE_F218_2956
#endif
#ifndef INLINE_F218_2943
static EIF_POINTER inline_F218_2943 (EIF_POINTER arg1)
{
	#ifdef GDK_WINDOWING_X11 
	return (EIF_POINTER) gdk_x11_window_get_xid ((GdkWindow *) arg1);
#endif
	;
}
#define INLINE_F218_2943
#endif
#ifndef INLINE_F218_2944
static void inline_F218_2944 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3)
{
	#ifdef GDK_WINDOWING_X11 
XSetFunction((Display*) arg1, (GC) arg2, (int) arg3);
#endif
	;
}
#define INLINE_F218_2944
#endif
#ifndef INLINE_F218_2945
static void inline_F218_2945 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3)
{
	#ifdef GDK_WINDOWING_X11 
XSetSubwindowMode((Display *)arg1, (GC)arg2, (int)arg3);
#endif
	;
}
#define INLINE_F218_2945
#endif
#ifndef INLINE_F218_2948
static void inline_F218_2948 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3)
{
	#ifdef GDK_WINDOWING_X11 
XSetFillStyle((Display*)arg1, (GC) arg2, (int)arg3);	
#endif
	;
}
#define INLINE_F218_2948
#endif
#ifndef INLINE_F218_2950
static void inline_F218_2950 (EIF_POINTER arg1)
{
	#ifdef GDK_WINDOWING_X11 
	XFlush((Display*) arg1);
#endif
	;
}
#define INLINE_F218_2950
#endif
#ifndef INLINE_F218_2951
static EIF_INTEGER_32 inline_F218_2951 (void)
{
	#ifdef GDK_WINDOWING_X11
return FillSolid;
#endif
	;
}
#define INLINE_F218_2951
#endif
#ifndef INLINE_F218_2952
static EIF_INTEGER_32 inline_F218_2952 (void)
{
	#ifdef GDK_WINDOWING_X11
return FillTiled;
#endif
	;
}
#define INLINE_F218_2952
#endif
#ifndef INLINE_F218_2961
static EIF_INTEGER_32 inline_F218_2961 (void)
{
	#ifdef GDK_WINDOWING_X11 
return IncludeInferiors;
#endif
	;
}
#define INLINE_F218_2961
#endif
#ifndef INLINE_F218_2964
static void inline_F218_2964 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5)
{
	#ifdef GDK_WINDOWING_X11 
XColor color;
/* */
Colormap cmap =  DefaultColormap((Display*) arg1, DefaultScreen((Display*) arg1) );
color.red =   arg3;
color.green = arg4;
color.blue =  arg5;
color.flags = DoRed | DoGreen | DoBlue;
/* */
XAllocColor((Display*) arg1, cmap, &color);
XSetBackground((Display*) arg1, (GC) arg2, (unsigned long) color.pixel);
#endif
	;
}
#define INLINE_F218_2964
#endif
#ifndef INLINE_F218_2965
static void inline_F218_2965 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5)
{
	#ifdef GDK_WINDOWING_X11 
XColor color;
Colormap cmap = DefaultColormap((Display*) arg1, DefaultScreen((Display*) arg1));
color.red =   arg3;
color.green = arg4;
color.blue =  arg5;
color.flags = DoRed | DoGreen | DoBlue;
XAllocColor((Display*) arg1, cmap, &color);
XSetForeground((Display*) arg1, (GC) arg2, (unsigned long) color.pixel);
#endif
	;
}
#define INLINE_F218_2965
#endif
#ifndef INLINE_F218_2967
static EIF_INTEGER_32 inline_F218_2967 (void)
{
	#ifdef GDK_WINDOWING_X11
return GXand;
#endif
	;
}
#define INLINE_F218_2967
#endif
#ifndef INLINE_F218_2969
static EIF_INTEGER_32 inline_F218_2969 (void)
{
	#ifdef GDK_WINDOWING_X11
return GXcopy;
#endif
	;
}
#define INLINE_F218_2969
#endif
#ifndef INLINE_F218_2972
static EIF_INTEGER_32 inline_F218_2972 (void)
{
	#ifdef GDK_WINDOWING_X11
return GXxor;
#endif
	;
}
#define INLINE_F218_2972
#endif
#ifndef INLINE_F218_2973
static EIF_INTEGER_32 inline_F218_2973 (void)
{
	#ifdef GDK_WINDOWING_X11
return GXor;
#endif
	;
}
#define INLINE_F218_2973
#endif
#ifndef INLINE_F218_2976
static EIF_INTEGER_32 inline_F218_2976 (void)
{
	#ifdef GDK_WINDOWING_X11
return GXinvert;
#endif
	;
}
#define INLINE_F218_2976
#endif
#ifndef INLINE_F218_2982
static void inline_F218_2982 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5, EIF_INTEGER_32 arg6, EIF_INTEGER_32 arg7)
{
	#ifdef GDK_WINDOWING_X11 
	Window win = (Window) arg1;
	/*
	 * TODO check Gdkgc-x11 _gdk_x11_gc_flush implementation 
	 * that's used before
	 * for example gdk_x11_draw_segments the usage of
	 * GDK_GC_GET_XGC (gc),
	 * https://github.com/coapp-packages/gtk/blob/master/gdk/x11/gdkdrawable-x11.c
	 */
						
	XDrawLine((Display*) arg2, win, arg3, arg4, arg5, arg6, arg7);
	
#endif
	;
}
#define INLINE_F218_2982
#endif
#ifndef INLINE_F218_2983
static void inline_F218_2983 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5)
{
	#ifdef GDK_WINDOWING_X11 
	XDrawPoint ((Display*) arg2, (Drawable) arg1, arg3, arg4, arg5);
#endif
	;
}
#define INLINE_F218_2983
#endif
#ifndef INLINE_F218_2984
static void inline_F218_2984 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4, EIF_INTEGER_32 arg5, EIF_INTEGER_32 arg6, EIF_INTEGER_32 arg7, EIF_INTEGER_32 arg8, EIF_INTEGER_32 arg9, EIF_INTEGER_32 arg10)
{
	#ifdef GDK_WINDOWING_X11 
					Window win = (Window) arg1;
					if (arg7 < 0 || arg8 < 0)
					{
						gint real_width;
						gint real_height;
						XWindowAttributes wa;
						XGetWindowAttributes((Display*) arg2, win, &wa);
						real_width = wa.width;
						real_height = wa.height;

						if (arg7 < 0)
							arg7 = real_width;
						if (arg8 < 0)
							arg8 = real_height;
					}

					if (arg4)
					    XFillArc ((Display*) arg2, win, arg3, arg5, arg6, arg7, arg8, arg9, arg10);
					else
					    XDrawArc ((Display*) arg2, win, arg3, arg5, arg6, arg7, arg8, arg9, arg10);	
	
				#endif
	;
}
#define INLINE_F218_2984
#endif
#ifndef INLINE_F218_2985
static void inline_F218_2985 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4, EIF_INTEGER_32 arg5, EIF_INTEGER_32 arg6, EIF_INTEGER_32 arg7, EIF_INTEGER_32 arg8)
{
	#ifdef GDK_WINDOWING_X11 
					Window win = (Window) arg1;
					if (arg7 < 0 || arg8 < 0)
					{
						gint real_width;
						gint real_height;
						
						XWindowAttributes wa;
						XGetWindowAttributes((Display*) arg2, win, &wa);
						real_width = wa.width;
						real_height = wa.height;
					   
					   	if (arg7 < 0)
							arg7 = real_width;
						if (arg8 < 0)
							arg8 = real_height;
					}

					if (arg4)
					    XFillRectangle ((Display*) arg2, win, arg3, arg5, arg6, arg7, arg8);
					else
					    XDrawRectangle ((Display*) arg2, win, arg3, arg5, arg6, arg7, arg8);

				#endif
	;
}
#define INLINE_F218_2985
#endif
#ifndef INLINE_F218_2986
static void inline_F218_2986 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_POINTER arg4, EIF_INTEGER_32 arg5)
{
	#ifdef GDK_WINDOWING_X11 
					Window win = (Window) arg1;
					gint i;
					XPoint *tmp_points = g_new (XPoint, arg5);

					for (i=0; i<arg5; i++)
				    {
				      tmp_points[i].x = ((GdkPoint *)arg4)[i].x;
				      tmp_points[i].y = ((GdkPoint *)arg4)[i].y;
				    }
				    					
					XDrawLines ((Display*) arg2, win, arg3, tmp_points, arg5, CoordModeOrigin);
					g_free (tmp_points);
				#endif
	;
}
#define INLINE_F218_2986
#endif
#ifndef INLINE_F218_2987
static void inline_F218_2987 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4, EIF_POINTER arg5, EIF_INTEGER_32 arg6)
{
	#ifdef GDK_WINDOWING_X11 
					Window win = (Window) arg1;
					XPoint *tmp_points;
 					gint tmp_npoints, i;


					if (!(arg4) &&
				      ( ((GdkPoint *)arg5)[0].x != ((GdkPoint *)arg5)[arg6-1].x || ((GdkPoint *)arg5)[0].y != ((GdkPoint *)arg5)[arg6-1].y))
				    {
				      tmp_npoints = arg6 + 1;
				      tmp_points = g_new (XPoint, tmp_npoints);
				      tmp_points[arg6].x = ((GdkPoint *)arg5)[0].x;
				      tmp_points[arg6].y = ((GdkPoint *)arg5)[0].y;
				    }
				  	else
				    {
				      tmp_npoints = arg6;
				      tmp_points = g_new (XPoint, tmp_npoints);
				    }

				  	for (i=0; i<arg6; i++)
				    {
				      tmp_points[i].x = ((GdkPoint *)arg5)[i].x;
				      tmp_points[i].y = ((GdkPoint *)arg5)[i].y;
				    }


				    if (arg4)
						XFillPolygon ((Display*) arg2, win, arg3, tmp_points, tmp_npoints, Complex, CoordModeOrigin);					
					else	
						XDrawLines ((Display*) arg2, win, arg3, tmp_points, tmp_npoints, CoordModeOrigin);
						
					g_free (tmp_points);
				#endif
	;
}
#define INLINE_F218_2987
#endif

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* {GDK_X11}.gdk_x11_display_error_trap_push */
void F218_2936 (EIF_REFERENCE Current, EIF_POINTER arg1)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("gdk_x11_display_error_trap_push", 217, Current, 0, 1, 3013);
	inline_F218_2936 ((EIF_POINTER) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.create_gc */
EIF_POINTER F218_2938 (EIF_REFERENCE Current, EIF_POINTER arg1)
{
	GTCX
	RTEX;
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("create_gc", 217, Current, 0, 1, 3015);
	Result = inline_F218_2938 ((EIF_POINTER) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.set_line_attributes_to_solid_style */
void F218_2939 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3)
{
	GTCX
	RTEX;
	EIF_POINTER tp1;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("set_line_attributes_to_solid_style", 217, Current, 0, 3, 3016);
	RTGC;
	RTHOOK(1);
	tp1 = inline_F218_2942(arg1);
	ti4_1 = inline_F218_2957();
	ti4_2 = inline_F218_2958();
	ti4_3 = inline_F218_2959();
	inline_F218_2946(tp1, arg2, arg3, ti4_1, ti4_2, ti4_3);
	RTHOOK(2);
	RTLE;
	RTEE;
}

/* {GDK_X11}.set_line_attributes_to_dashed_style */
void F218_2940 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3)
{
	GTCX
	RTEX;
	EIF_POINTER loc1 = (EIF_POINTER) 0;
	EIF_INTEGER_16 loc2 = (EIF_INTEGER_16) 0;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_INTEGER_16 ti2_1;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("set_line_attributes_to_dashed_style", 217, Current, 2, 3, 3017);
	RTGC;
	RTHOOK(1);
	loc1 = inline_F218_2942(arg1);
	RTHOOK(2);
	ti2_1 = eif_bit_shift_left(((EIF_INTEGER_16) 3L),((EIF_INTEGER_32) 8L));
	loc2 = eif_bit_or(((EIF_INTEGER_16) 3L),ti2_1);
	RTHOOK(3);
	inline_F218_2947(loc1, arg2, ((EIF_INTEGER_32) 0L), (EIF_INTEGER_16 *) &(loc2), ((EIF_INTEGER_32) 2L));
	RTHOOK(4);
	ti4_1 = inline_F218_2956();
	ti4_2 = inline_F218_2958();
	ti4_3 = inline_F218_2959();
	inline_F218_2946(loc1, arg2, arg3, ti4_1, ti4_2, ti4_3);
	RTHOOK(5);
	RTLE;
	RTEE;
}

/* {GDK_X11}.x_display */
EIF_POINTER F218_2942 (EIF_REFERENCE Current, EIF_POINTER arg1)
{
	GTCX
	RTEX;
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_display", 217, Current, 0, 1, 3019);
	Result = inline_F218_2942 ((EIF_POINTER) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.x_window */
EIF_POINTER F218_2943 (EIF_REFERENCE Current, EIF_POINTER arg1)
{
	GTCX
	RTEX;
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_window", 217, Current, 0, 1, 3020);
	Result = inline_F218_2943 ((EIF_POINTER) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.x_set_function */
void F218_2944 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_set_function", 217, Current, 0, 3, 3021);
	inline_F218_2944 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_INTEGER_32) arg3);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.x_set_subwindow_mode */
void F218_2945 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_set_subwindow_mode", 217, Current, 0, 3, 3022);
	inline_F218_2945 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_INTEGER_32) arg3);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.x_set_line_attributes */
void F218_2946 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5, EIF_INTEGER_32 arg6)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_set_line_attributes", 217, Current, 0, 6, 3023);
	inline_F218_2946 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_INTEGER_32) arg3, (EIF_INTEGER_32) arg4, (EIF_INTEGER_32) arg5, (EIF_INTEGER_32) arg6);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.x_set_dashes */
void F218_2947 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_POINTER arg4, EIF_INTEGER_32 arg5)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_set_dashes", 217, Current, 0, 5, 3024);
	inline_F218_2947 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_INTEGER_32) arg3, (EIF_POINTER) arg4, (EIF_INTEGER_32) arg5);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.x_set_fill_style */
void F218_2948 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_set_fill_style", 217, Current, 0, 3, 3025);
	inline_F218_2948 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_INTEGER_32) arg3);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.x_flush */
void F218_2950 (EIF_REFERENCE Current, EIF_POINTER arg1)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_flush", 217, Current, 0, 1, 3027);
	inline_F218_2950 ((EIF_POINTER) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.x_fill_solid */
EIF_INTEGER_32 F218_2951 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_fill_solid", 217, Current, 0, 0, 3028);
	Result = inline_F218_2951 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.x_fill_tiled */
EIF_INTEGER_32 F218_2952 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_fill_tiled", 217, Current, 0, 0, 3029);
	Result = inline_F218_2952 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.x_style_line_on_off_dash */
EIF_INTEGER_32 F218_2956 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_style_line_on_off_dash", 217, Current, 0, 0, 3033);
	Result = inline_F218_2956 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.x_style_line_solid */
EIF_INTEGER_32 F218_2957 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_style_line_solid", 217, Current, 0, 0, 3034);
	Result = inline_F218_2957 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.x_style_cap_butt */
EIF_INTEGER_32 F218_2958 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_style_cap_butt", 217, Current, 0, 0, 3035);
	Result = inline_F218_2958 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.x_style_join_bevel */
EIF_INTEGER_32 F218_2959 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_style_join_bevel", 217, Current, 0, 0, 3036);
	Result = inline_F218_2959 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.x_subwindow_mode_include_inferiors */
EIF_INTEGER_32 F218_2961 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_subwindow_mode_include_inferiors", 217, Current, 0, 0, 3038);
	Result = inline_F218_2961 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.set_drawable_background */
void F218_2962 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5)
{
	GTCX
	RTEX;
	EIF_POINTER loc1 = (EIF_POINTER) 0;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("set_drawable_background", 217, Current, 1, 5, 3039);
	RTGC;
	RTHOOK(1);
	loc1 = inline_F218_2942(arg1);
	RTHOOK(2);
	inline_F218_2964(loc1, arg2, arg3, arg4, arg5);
	RTHOOK(3);
	RTLE;
	RTEE;
}

/* {GDK_X11}.set_drawable_foreground */
void F218_2963 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5)
{
	GTCX
	RTEX;
	EIF_POINTER loc1 = (EIF_POINTER) 0;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("set_drawable_foreground", 217, Current, 1, 5, 3040);
	RTGC;
	RTHOOK(1);
	loc1 = inline_F218_2942(arg1);
	RTHOOK(2);
	inline_F218_2965(loc1, arg2, arg3, arg4, arg5);
	RTHOOK(3);
	RTLE;
	RTEE;
}

/* {GDK_X11}.x_set_background */
void F218_2964 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_set_background", 217, Current, 0, 5, 3041);
	inline_F218_2964 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_INTEGER_32) arg3, (EIF_INTEGER_32) arg4, (EIF_INTEGER_32) arg5);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.x_set_foreground */
void F218_2965 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_set_foreground", 217, Current, 0, 5, 3042);
	inline_F218_2965 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_INTEGER_32) arg3, (EIF_INTEGER_32) arg4, (EIF_INTEGER_32) arg5);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.x_function_gxand */
EIF_INTEGER_32 F218_2967 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_function_gxand", 217, Current, 0, 0, 3044);
	Result = inline_F218_2967 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.x_function_gxcopy */
EIF_INTEGER_32 F218_2969 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_function_gxcopy", 217, Current, 0, 0, 3046);
	Result = inline_F218_2969 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.x_function_gxxor */
EIF_INTEGER_32 F218_2972 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_function_gxxor", 217, Current, 0, 0, 3049);
	Result = inline_F218_2972 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.x_function_gxor */
EIF_INTEGER_32 F218_2973 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_function_gxor", 217, Current, 0, 0, 3050);
	Result = inline_F218_2973 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.x_function_gxinvert */
EIF_INTEGER_32 F218_2976 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_function_gxinvert", 217, Current, 0, 0, 3053);
	Result = inline_F218_2976 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.draw_line */
void F218_2982 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5, EIF_INTEGER_32 arg6, EIF_INTEGER_32 arg7)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("draw_line", 217, Current, 0, 7, 3006);
	inline_F218_2982 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_POINTER) arg3, (EIF_INTEGER_32) arg4, (EIF_INTEGER_32) arg5, (EIF_INTEGER_32) arg6, (EIF_INTEGER_32) arg7);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.draw_point */
void F218_2983 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("draw_point", 217, Current, 0, 5, 3007);
	inline_F218_2983 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_POINTER) arg3, (EIF_INTEGER_32) arg4, (EIF_INTEGER_32) arg5);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.draw_arc */
void F218_2984 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4, EIF_INTEGER_32 arg5, EIF_INTEGER_32 arg6, EIF_INTEGER_32 arg7, EIF_INTEGER_32 arg8, EIF_INTEGER_32 arg9, EIF_INTEGER_32 arg10)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("draw_arc", 217, Current, 0, 10, 3008);
	inline_F218_2984 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_POINTER) arg3, (EIF_BOOLEAN) arg4, (EIF_INTEGER_32) arg5, (EIF_INTEGER_32) arg6, (EIF_INTEGER_32) arg7, (EIF_INTEGER_32) arg8, (EIF_INTEGER_32) arg9, (EIF_INTEGER_32) arg10);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.draw_rectangle */
void F218_2985 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4, EIF_INTEGER_32 arg5, EIF_INTEGER_32 arg6, EIF_INTEGER_32 arg7, EIF_INTEGER_32 arg8)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("draw_rectangle", 217, Current, 0, 8, 3009);
	inline_F218_2985 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_POINTER) arg3, (EIF_BOOLEAN) arg4, (EIF_INTEGER_32) arg5, (EIF_INTEGER_32) arg6, (EIF_INTEGER_32) arg7, (EIF_INTEGER_32) arg8);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.draw_lines */
void F218_2986 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_POINTER arg4, EIF_INTEGER_32 arg5)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("draw_lines", 217, Current, 0, 5, 3010);
	inline_F218_2986 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_POINTER) arg3, (EIF_POINTER) arg4, (EIF_INTEGER_32) arg5);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.draw_polygon */
void F218_2987 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4, EIF_POINTER arg5, EIF_INTEGER_32 arg6)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("draw_polygon", 217, Current, 0, 6, 3011);
	inline_F218_2987 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_POINTER) arg3, (EIF_BOOLEAN) arg4, (EIF_POINTER) arg5, (EIF_INTEGER_32) arg6);
	RTHOOK(1);
	RTLE;
	RTEE;
}

void EIF_Minit183 (void)
{
	GTCX
}


#ifdef __cplusplus
}
#endif
