note

	description:

		"Objects that implement the XPath compare() function"

	library: "Gobo Eiffel XPath Library"
	copyright: "Copyright (c) 2004-2015, Colin Adams and others"
	license: "MIT License"
	date: "$Date: 2016-05-06 19:15:38 +0000 (Fri, 06 May 2016) $"
	revision: "$Revision: 98678 $"

class XM_XPATH_COMPARE

inherit

	XM_XPATH_SYSTEM_FUNCTION
		undefine
			pre_evaluate, check_static_type
		redefine
			evaluate_item
		end

	XM_XPATH_COLLATING_FUNCTION

create

	make

feature {NONE} -- Initialization

	make
			-- Establish invariant
		do
			name := "compare"
			namespace_uri := Xpath_standard_functions_uri
			fingerprint := Compare_function_type_code
			minimum_argument_count := 2
			maximum_argument_count := 3
			create arguments.make (3)
			arguments.set_equality_tester (expression_tester)
			initialized := True
		end

feature -- Access

	item_type: XM_XPATH_ITEM_TYPE
			-- Data type of the expression, where known
		do
			Result := type_factory.integer_type
			if Result /= Void then
				-- Bug in SE 1.0 and 1.1: Make sure that
				-- that `Result' is not optimized away.
			end
		end

feature -- Status report

	required_type (argument_number: INTEGER): XM_XPATH_SEQUENCE_TYPE
			-- Type of argument number `argument_number'
		do
			if argument_number < 3 then
				create Result.make_optional_string
			else
				create Result.make_single_string
			end
		end

feature -- Evaluation

	evaluate_item (a_result: DS_CELL [detachable XM_XPATH_ITEM]; a_context: XM_XPATH_CONTEXT)
			-- Evaluate as a single item to `a_result'.
		local
			l_collator: detachable ST_COLLATOR
			l_s1, l_s2: STRING
			l_comparison_result: INTEGER
		do
			l_collator := collator (3, a_context, True)
			if l_collator = Void then
				a_result.put (create {XM_XPATH_INVALID_ITEM}.make_from_string ("Unsupported collation", Xpath_errors_uri, "FOCH0002", Dynamic_error))
			else
				arguments.item (1).evaluate_item (a_result, a_context)
				if not attached a_result.item as a_result_item_1 then
					-- nothing to do
				elseif not a_result_item_1.is_atomic_value then
					a_result.put (Void)
				else
					l_s1 := a_result_item_1.as_atomic_value.string_value
					a_result.put (Void)
					arguments.item (2).evaluate_item (a_result, a_context)
					if not attached a_result.item as a_result_item_2 then
						-- nothing to do
					elseif not a_result_item_2.is_atomic_value then
						a_result.put (Void)
					else
						l_s2 := a_result_item_2.as_atomic_value.string_value
						l_comparison_result := l_collator.three_way_comparison (l_s1, l_s2)
						a_result.put (create {XM_XPATH_INTEGER_VALUE}.make_from_integer (l_comparison_result))
					end
				end
			end
		end

feature {XM_XPATH_EXPRESSION} -- Restricted

	compute_cardinality
			-- Compute cardinality.
		do
			set_cardinality_optional
		end

end

