note
	description:
		"Evaluators for test steps"
	legal: "See notice at end of class."

	status: "See notice at end of class."
	date: "$Date: 2008-12-29 20:27:11 +0000 (Mon, 29 Dec 2008) $"
	revision: "$Revision: 76420 $"

deferred class EVALUATOR inherit

	CALLBACK
		rename
			callback as test_step, set_callback as set_test_step
		end

feature -- Access

	name: STRING
			-- Name of evaluator

feature -- Status report

	is_setup_ok: BOOLEAN
			-- Is evaluator set up?
		do
			Result := name /= Void and then not name.is_empty
		end

	is_true: BOOLEAN
			-- Does evaluator yield true?
		require
			setup_ok: is_setup_ok
		deferred
		end
	 
feature -- Status setting

	set_name (s: STRING)
			-- Set name to `s'.
		require
			non_empty_name: s /= Void and then not s.is_empty
		do
			name := s
		ensure
			name_set: name = s
		end

note
	copyright:	"Copyright (c) 1984-2006, Eiffel Software and others"
	license:	"Eiffel Forum License v2 (see http://www.eiffel.com/licensing/forum.txt)"
	source: "[
			 Eiffel Software
			 356 Storke Road, Goleta, CA 93117 USA
			 Telephone 805-685-1006, Fax 805-685-6869
			 Website http://www.eiffel.com
			 Customer support http://support.eiffel.com
		]"




end -- class EVALUATOR

