#include <map>
#include <vector>
#include <fstream>
#include "sentence.hpp"
#include "models.hpp"
#include "unlabeled_edge_feature_extractor_interface.hpp"
#include "eda_unlabeled_edge_feature_extractor.hpp"
#include "simple_edge_label_feature_extractor.hpp"

using namespace std;
using namespace maeda;

int main(int argc, char *argv[]) {
  string model_file = "tmp.model";

  vector<Sentence> sentence_list;
  {
    ifstream ifs("labeled_corpus.txt");
    if (ifs) {
      while (ifs) {
        Sentence sentence;
        if (ReadSentenceDependencies(ifs, &sentence)) {
          sentence_list.push_back(sentence);
        }
      }
    }
  }

  EdgeLabelModel edge_label_model(
                     new SimpleEdgeLabelFeatureExtractor);

  edge_label_model.Train(sentence_list);

  cerr << "Printing to: " << model_file << endl;

  edge_label_model.Save(model_file);


  cerr << "Try parsing." << endl;

  //  for (size_t i = 0; i < sentence_list.size(); i++) {
    Sentence sent = sentence_list[0];
    edge_label_model.LabelEdges(&sent);
    cout << "ID=" << 0 << endl;
    for (size_t j = 1; j < sent.rows.size(); j++) {
      cout << j
           << " " << sent.rows[j].target
           << " " << sent.rows[j].word
           << " " << sent.rows[j].pos
           << " " << sent.rows[j].edge_label  << endl;
    }
    cout << endl;
    //  }

  return 0;
}
