#ifndef LOG_LINEAR_SGD_PARSER_LEARNER_HPP_
#define LOG_LINEAR_SGD_PARSER_LEARNER_HPP_

#include <vector>
#include "parser_learner_interface.hpp"

namespace maeda {


class Random {
public:
  Random(unsigned int seed = 0) {
    srand(seed);
  }
  ptrdiff_t operator()(ptrdiff_t m) const {
    return static_cast<ptrdiff_t>(static_cast<double>(rand()) / RAND_MAX * m);
  }
};

// weight_map_training
class LogLinearSGDParserLearner : public ParserLearnerInterface {
public:
  LogLinearSGDParserLearner();

  void Learn(
    const std::vector<FeatureVectorList > *feature_vector_list_list,
    const std::vector<int> *gold_standard_index_list,
    WeightMap *weight_map);

private:
  double c1_;
  double c2_;
  double learning_rate_;
  double scale_;

  double obj_func_;

  Random rand_generator;

  int num_iterations_;

  const std::vector<FeatureVectorList>* feature_vector_list_list_;

  const std::vector<int>* gold_standard_index_list_;

  WeightMap *weight_;


  void Iterate();

  void ShowStatistics() const;
};


} // maeda


#endif // LOG_LINEAR_SGD_PARSER_LEARNER_HPP_
