#include <cmath>
#include <vector>
#include <limits>
#include <algorithm>
#include <lbfgs.h>
#include "liblbfgs_parser_learner.hpp"


namespace maeda {

//stepϻȤʤ
lbfgsfloatval_t lbfgs_evaluate(void *instance,
                               const lbfgsfloatval_t *x,
                               lbfgsfloatval_t *grad,
                               const int n,
                               const lbfgsfloatval_t step) {
  const LibLBFGSParserLearner *learner = (LibLBFGSParserLearner*)instance;

  const std::vector<FeatureVectorList>* const feature_vector_list_list_ = 
      learner->feature_vector_list_list_;

  const std::vector<int>* const gold_standard_index_list_ =
      learner->gold_standard_index_list_;

  const WeightMap &weight_by_training_data_ =
      learner->weight_by_training_data_;

  const double &C_ = learner->C_;

  if (int(weight_by_training_data_.size()) != n) {
    std::cerr << "Internal Error!!" << std::endl;
    exit(1);
  }

  double obj_func = 0.0;
  // ߤνŤ
  WeightMap current_weight((double*)(&x[0]), (double*)(&x[n]));
  // iterationǻȤweight_map
  WeightMap tmp_weight(n);

  for (size_t i = 0; i < gold_standard_index_list_->size(); i++) {
    const std::vector<FeatureVector> &feature_vector_list =
        feature_vector_list_list_->at(i);
    const size_t num_feature_vectors = feature_vector_list.size();

    double scores[num_feature_vectors];
    double sum = 0.0;

    for (size_t t = 0; t < num_feature_vectors; t++) {
      scores[t] = exp(feature_vector_list[t].Product(current_weight));
      sum += scores[t];
    }

    for (size_t t = 0; t < num_feature_vectors; t++) {
      for (FeatureVector::const_iterator it = feature_vector_list[t].begin();
           it != feature_vector_list[t].end(); ++it) {
        tmp_weight[it->id] += it->value * (scores[t] / sum);
      }
    }

    const int gold_index = gold_standard_index_list_->at(i);
    obj_func -=
        feature_vector_list[gold_index].Product(current_weight) - log(sum);
  }

  obj_func /= gold_standard_index_list_->size();

  for (int f = 0; f < n; f++) {
    grad[f] = tmp_weight[f] - weight_by_training_data_[f];
    grad[f] /= gold_standard_index_list_->size();
    double lambda = current_weight[f];
    grad[f] += lambda * C_;
    obj_func += lambda * lambda * 0.5 * C_;
  }

  return obj_func;
}


int lbfgs_progress(void *instance,
                   const lbfgsfloatval_t *x,
                   const lbfgsfloatval_t *g,
                   const lbfgsfloatval_t fx,
                   const lbfgsfloatval_t xnorm,
                   const lbfgsfloatval_t gnorm,
                   const lbfgsfloatval_t step,
                   int n,
                   int k,
                   int ls) {
  std::cerr << "obj=" << fx << ", norm=" << gnorm << std::endl;
  return 0;
}


LibLBFGSParserLearner::LibLBFGSParserLearner(const double &C) : C_(C) {}


void LibLBFGSParserLearner::Learn(
    const std::vector<FeatureVectorList>* const feature_vector_list_list,
    const std::vector<int>* const gold_standard_index_list,
    WeightMap *weight) {
  const size_t feature_space_dimension = weight->size();

  weight_by_training_data_.resize(feature_space_dimension);
  for (size_t n = 0; n < gold_standard_index_list->size(); n++) {
    const FeatureVector &gold_feature_vector =
        feature_vector_list_list->at(n)[gold_standard_index_list->at(n)];
    for (FeatureVector::const_iterator it = gold_feature_vector.begin();
         it != gold_feature_vector.end(); ++it) {
      weight_by_training_data_[it->id] += it->value;
    }
  }

  lbfgsfloatval_t *x = lbfgs_malloc(feature_space_dimension);
  if (x == NULL) {
    std::cerr << "Error: Failed to allocate a memory block for variables."
              << std::endl;
    exit(1);
  }

  for (size_t i = 0; i < feature_space_dimension; i++) {
    x[i] = 0.0;
  }

  feature_vector_list_list_ = feature_vector_list_list;

  gold_standard_index_list_ = gold_standard_index_list;

  const double C_saved = C_;
  C_ = C_saved / gold_standard_index_list_->size();

  lbfgs_parameter_t param;
  lbfgs_parameter_init(&param);

  param.max_iterations = 30;

  (void)lbfgs(int(feature_space_dimension),
              x,
              NULL,
              lbfgs_evaluate,
              lbfgs_progress,
              (void*)(this),
              &param);

  for (size_t i = 0; i < feature_space_dimension; i++) {
    weight->at(i) = x[i];
  }

  lbfgs_free(x);
  C_ = C_saved;
}


} // maeda
