#ifndef EDGE_LABEL_FEATURE_EXTRACTOR_INTERFACE_HPP_
#define EDGE_LABEL_FEATURE_EXTRACTOR_INTERFACE_HPP_

#include <vector>
#include "sentence.hpp"


namespace maeda {


class EdgeLabelFeatureExtractorInterface {
public:
  virtual ~EdgeLabelFeatureExtractorInterface() {}

  virtual std::string name() const = 0;

  // ʸstd::vectorpush
  virtual void Extract(const Sentence &sentence,
                       const int source, const int target,
                       std::string *feature_string) const = 0;

protected:
  EdgeLabelFeatureExtractorInterface() {};
};


} // maeda

#endif // EDGE_LABEL_FEATURE_EXTRACTOR_INTERFACE_HPP_
