#
# CDDL HEADER START
#
# The contents of this file are subject to the terms of the
# Common Development and Distribution License (the "License").
# You may not use this file except in compliance with the License.
#
# You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
# or http://www.opensolaris.org/os/licensing.
# See the License for the specific language governing permissions
# and limitations under the License.
#
# When distributing Covered Code, include this CDDL HEADER in each
# file and include the License file at usr/src/OPENSOLARIS.LICENSE.
# If applicable, add the following below this CDDL HEADER, with the
# fields enclosed by brackets "[]" replaced with your own identifying
# information: Portions Copyright [yyyy] [name of copyright owner]
#
# CDDL HEADER END
#

#
# Copyright 2019 Apple, Inc.  All rights reserved.
# Use is subject to license terms.

if [ -b /dev/lockprof ]; then
	echo "Skipping..."
	exit 0
fi

dtrace -s /dev/stdin <<EOF
/*
 * ASSERTION: Verify that lockprof held/miss/spin ticket probes can be created and triggered
 */
lockprof:::ticket-held-10000
{
	held = 1;
}

lockprof:::ticket-miss-2
{
	miss = 1;
}

lockprof:::ticket-spin-100us
{
	spin = 1;
}

tick-1s
/ held && miss && spin /
{
	exit(0);
}

tick-120s
{
	printf("held: %d\n", held);
	printf("miss: %d\n", miss);
	printf("spin: %d\n", spin);
	exit(1);
}

EOF
exit $?
