/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */

/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#pragma ident	"@(#)tst.DiscardWithZero.d	1.1	06/08/28 SMI"

/*
 * ASSERTION: An Id of zero though invalid may be passed to speculate(),
 * commit() and discard() without any ill effects.
 *
 * SECTION: Speculative Tracing/Creating a Speculation;
 *	Options and Tunables/cleanrate
 */
#pragma D option quiet
#pragma D option cleanrate=4000

BEGIN
{
	self->discardFlag = 0;
	self->var1 = speculation();
	printf("Speculative buffer ID: %d\n", self->var1);
	self->spec = speculation();
	printf("Speculative buffer ID: %d\n", self->spec);
}

BEGIN
/0 == self->spec/
{
	discard(self->spec);
	self->discardFlag++;
}

BEGIN
/0 < self->discardFlag/
{
	printf("discard(), self->discardFlag = %d\n", self->discardFlag);
	exit(0);
}

BEGIN
/0 == self->discardFlag/
{
	printf("discard(), self->discardFlag = %d\n", self->discardFlag);
	exit(1);
}
