/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */

/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#pragma	ident	"@(#)tst.bcopy.d	1.1	06/08/28 SMI"

/*
 * ASSERTION:
 *	bcopy should copy from one memory location to another
 *
 * SECTION: Actions and Subroutines/alloca();
 * 	Actions and Subroutines/bcopy()
 *
 */

#pragma D option quiet


BEGIN
{
	ptr = alloca(sizeof (int));
#if !defined(__APPLE__)
	bcopy((void *)&`kmem_flags, ptr, sizeof (int));
	intp = (int *)ptr;
	ret = (`kmem_flags == *intp) ? 0 : 1;
#else
	bcopy((void *)&`max_ncpus, ptr, sizeof (int));
	intp = (int *)ptr;
	ret = (`max_ncpus == *intp) ? 0 : 1;
#endif /* __APPLE__ */
}

tick-1
/ret == 0/
{
	exit(0);
}

tick-1
/ret == 1/
{
#if !defined(__APPLE__)
	printf("memory address contained 0x%x, expected 0x%x\n",
		*intp, `kmem_flags);
#else
	printf("memory address contained 0x%x, expected 0x%x\n",
		*intp, `max_ncpus);
#endif /* __APPLE__ */
	exit(1);
}
