%define ver 0.18
%define name drwright

Summary: A program that reminds you to take wrist breaks
Name: %name
Version: %ver
Release: imendio.1
Source: %{name}-%{ver}.tar.gz
License: GPL
Group: Applications/System
BuildRoot: %{_tmppath}/%{name}-root

BuildRequires: pango-devel >= 1.2
BuildRequires: gtk2-devel >= 2.2.0
BuildRequires: GConf2-devel >= 1.2.0
BuildRequires: libglade2-devel >= 2.0.0
BuildRequires: desktop-file-utils >= 0.2.90
%description
DrWright is a program that reminds you to take wrist breaks to rest your hands.
%prep
%setup -q

%build
%configure
make

%install
rm -rf $RPM_BUILD_ROOT

export GCONF_DISABLE_MAKEFILE_SCHEMA_INSTALL=1
%makeinstall
unset GCONF_DISABLE_MAKEFILE_SCHEMA_INSTALL

desktop-file-install --vendor gnome --delete-original       \
  --dir $RPM_BUILD_ROOT%{_datadir}/applications             \
  --add-category X-Red-Hat-Extra                            \
  $RPM_BUILD_ROOT%{_datadir}/applications/*

%find_lang %{name}

%clean
rm -rf $RPM_BUILD_ROOT

%post
export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`
gconftool-2 --makefile-install-rule %{_sysconfdir}/gconf/schemas/drwright.schemas > /dev/null

%files -f %{name}.lang
%defattr(-,root,root)

%doc AUTHORS COPYING ChangeLog NEWS README

%{_sysconfdir}/gconf/schemas/drwright.schemas
%{_bindir}/*
%{_datadir}/applications
%{_datadir}/drwright/*

%changelog
* Thu Dec 12 2002 Jean Schurger <yshark@schurger.org>
- append -f %{name}.lang to the %files line works with find_lang
- remove %{_datadir} /locale/sv/LC_MESSAGES/drwright.mo from %files
- because it's done with find_lang

* Wed Oct 9 2002 Richard Hult <richard@imendio.com>
- Generate spec file from drwright.spec.in.

* Fri Aug 23 2002 Anders Carlsson <andersca@gnu.org>
- Initial build.


