// Code generated by protoc-gen-go.
// source: google/logging/v2/logging.proto
// DO NOT EDIT!

package logging

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_api3 "google.golang.org/genproto/googleapis/api/monitoredres"
import _ "github.com/golang/protobuf/ptypes/duration"
import google_protobuf5 "github.com/golang/protobuf/ptypes/empty"
import _ "github.com/golang/protobuf/ptypes/timestamp"
import _ "google.golang.org/genproto/googleapis/rpc/status"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// The parameters to DeleteLog.
type DeleteLogRequest struct {
	// Required. The resource name of the log to delete:
	//
	//     "projects/[PROJECT_ID]/logs/[LOG_ID]"
	//     "organizations/[ORGANIZATION_ID]/logs/[LOG_ID]"
	//
	// `[LOG_ID]` must be URL-encoded. For example,
	// `"projects/my-project-id/logs/syslog"`,
	// `"organizations/1234567890/logs/cloudresourcemanager.googleapis.com%2Factivity"`.
	// For more information about log names, see
	// [LogEntry][google.logging.v2.LogEntry].
	LogName string `protobuf:"bytes,1,opt,name=log_name,json=logName" json:"log_name,omitempty"`
}

func (m *DeleteLogRequest) Reset()                    { *m = DeleteLogRequest{} }
func (m *DeleteLogRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteLogRequest) ProtoMessage()               {}
func (*DeleteLogRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{0} }

func (m *DeleteLogRequest) GetLogName() string {
	if m != nil {
		return m.LogName
	}
	return ""
}

// The parameters to WriteLogEntries.
type WriteLogEntriesRequest struct {
	// Optional. A default log resource name that is assigned to all log entries
	// in `entries` that do not specify a value for `log_name`:
	//
	//     "projects/[PROJECT_ID]/logs/[LOG_ID]"
	//     "organizations/[ORGANIZATION_ID]/logs/[LOG_ID]"
	//
	// `[LOG_ID]` must be URL-encoded. For example,
	// `"projects/my-project-id/logs/syslog"` or
	// `"organizations/1234567890/logs/cloudresourcemanager.googleapis.com%2Factivity"`.
	// For more information about log names, see
	// [LogEntry][google.logging.v2.LogEntry].
	LogName string `protobuf:"bytes,1,opt,name=log_name,json=logName" json:"log_name,omitempty"`
	// Optional. A default monitored resource object that is assigned to all log
	// entries in `entries` that do not specify a value for `resource`. Example:
	//
	//     { "type": "gce_instance",
	//       "labels": {
	//         "zone": "us-central1-a", "instance_id": "00000000000000000000" }}
	//
	// See [LogEntry][google.logging.v2.LogEntry].
	Resource *google_api3.MonitoredResource `protobuf:"bytes,2,opt,name=resource" json:"resource,omitempty"`
	// Optional. Default labels that are added to the `labels` field of all log
	// entries in `entries`. If a log entry already has a label with the same key
	// as a label in this parameter, then the log entry's label is not changed.
	// See [LogEntry][google.logging.v2.LogEntry].
	Labels map[string]string `protobuf:"bytes,3,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Required. The log entries to write. Values supplied for the fields
	// `log_name`, `resource`, and `labels` in this `entries.write` request are
	// added to those log entries that do not provide their own values for the
	// fields.
	//
	// To improve throughput and to avoid exceeding the
	// [quota limit](/logging/quota-policy) for calls to `entries.write`,
	// you should write multiple log entries at once rather than
	// calling this method for each individual log entry.
	Entries []*LogEntry `protobuf:"bytes,4,rep,name=entries" json:"entries,omitempty"`
	// Optional. Whether valid entries should be written even if some other
	// entries fail due to INVALID_ARGUMENT or PERMISSION_DENIED errors. If any
	// entry is not written, the response status will be the error associated
	// with one of the failed entries and include error details in the form of
	// WriteLogEntriesPartialErrors.
	PartialSuccess bool `protobuf:"varint,5,opt,name=partial_success,json=partialSuccess" json:"partial_success,omitempty"`
}

func (m *WriteLogEntriesRequest) Reset()                    { *m = WriteLogEntriesRequest{} }
func (m *WriteLogEntriesRequest) String() string            { return proto.CompactTextString(m) }
func (*WriteLogEntriesRequest) ProtoMessage()               {}
func (*WriteLogEntriesRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{1} }

func (m *WriteLogEntriesRequest) GetLogName() string {
	if m != nil {
		return m.LogName
	}
	return ""
}

func (m *WriteLogEntriesRequest) GetResource() *google_api3.MonitoredResource {
	if m != nil {
		return m.Resource
	}
	return nil
}

func (m *WriteLogEntriesRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *WriteLogEntriesRequest) GetEntries() []*LogEntry {
	if m != nil {
		return m.Entries
	}
	return nil
}

func (m *WriteLogEntriesRequest) GetPartialSuccess() bool {
	if m != nil {
		return m.PartialSuccess
	}
	return false
}

// Result returned from WriteLogEntries.
// empty
type WriteLogEntriesResponse struct {
}

func (m *WriteLogEntriesResponse) Reset()                    { *m = WriteLogEntriesResponse{} }
func (m *WriteLogEntriesResponse) String() string            { return proto.CompactTextString(m) }
func (*WriteLogEntriesResponse) ProtoMessage()               {}
func (*WriteLogEntriesResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{2} }

// The parameters to `ListLogEntries`.
type ListLogEntriesRequest struct {
	// Deprecated. Use `resource_names` instead.  One or more project identifiers
	// or project numbers from which to retrieve log entries.  Example:
	// `"my-project-1A"`. If present, these project identifiers are converted to
	// resource name format and added to the list of resources in
	// `resource_names`.
	ProjectIds []string `protobuf:"bytes,1,rep,name=project_ids,json=projectIds" json:"project_ids,omitempty"`
	// Required. Names of one or more resources from which to retrieve log
	// entries:
	//
	//     "projects/[PROJECT_ID]"
	//     "organizations/[ORGANIZATION_ID]"
	//
	// Projects listed in the `project_ids` field are added to this list.
	ResourceNames []string `protobuf:"bytes,8,rep,name=resource_names,json=resourceNames" json:"resource_names,omitempty"`
	// Optional. A filter that chooses which log entries to return.  See [Advanced
	// Logs Filters](/logging/docs/view/advanced_filters).  Only log entries that
	// match the filter are returned.  An empty filter matches all log entries in
	// the resources listed in `resource_names`. Referencing a parent resource
	// that is not listed in `resource_names` will cause the filter to return no
	// results.
	// The maximum length of the filter is 20000 characters.
	Filter string `protobuf:"bytes,2,opt,name=filter" json:"filter,omitempty"`
	// Optional. How the results should be sorted.  Presently, the only permitted
	// values are `"timestamp asc"` (default) and `"timestamp desc"`. The first
	// option returns entries in order of increasing values of
	// `LogEntry.timestamp` (oldest first), and the second option returns entries
	// in order of decreasing timestamps (newest first).  Entries with equal
	// timestamps are returned in order of `LogEntry.insertId`.
	OrderBy string `protobuf:"bytes,3,opt,name=order_by,json=orderBy" json:"order_by,omitempty"`
	// Optional. The maximum number of results to return from this request.
	// Non-positive values are ignored.  The presence of `nextPageToken` in the
	// response indicates that more results might be available.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// Optional. If present, then retrieve the next batch of results from the
	// preceding call to this method.  `pageToken` must be the value of
	// `nextPageToken` from the previous response.  The values of other method
	// parameters should be identical to those in the previous call.
	PageToken string `protobuf:"bytes,5,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListLogEntriesRequest) Reset()                    { *m = ListLogEntriesRequest{} }
func (m *ListLogEntriesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListLogEntriesRequest) ProtoMessage()               {}
func (*ListLogEntriesRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{3} }

func (m *ListLogEntriesRequest) GetProjectIds() []string {
	if m != nil {
		return m.ProjectIds
	}
	return nil
}

func (m *ListLogEntriesRequest) GetResourceNames() []string {
	if m != nil {
		return m.ResourceNames
	}
	return nil
}

func (m *ListLogEntriesRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListLogEntriesRequest) GetOrderBy() string {
	if m != nil {
		return m.OrderBy
	}
	return ""
}

func (m *ListLogEntriesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListLogEntriesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Result returned from `ListLogEntries`.
type ListLogEntriesResponse struct {
	// A list of log entries.
	Entries []*LogEntry `protobuf:"bytes,1,rep,name=entries" json:"entries,omitempty"`
	// If there might be more results than those appearing in this response, then
	// `nextPageToken` is included.  To get the next set of results, call this
	// method again using the value of `nextPageToken` as `pageToken`.
	//
	// If a value for `next_page_token` appears and the `entries` field is empty,
	// it means that the search found no log entries so far but it did not have
	// time to search all the possible log entries.  Retry the method with this
	// value for `page_token` to continue the search.  Alternatively, consider
	// speeding up the search by changing your filter to specify a single log name
	// or resource type, or to narrow the time range of the search.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListLogEntriesResponse) Reset()                    { *m = ListLogEntriesResponse{} }
func (m *ListLogEntriesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListLogEntriesResponse) ProtoMessage()               {}
func (*ListLogEntriesResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{4} }

func (m *ListLogEntriesResponse) GetEntries() []*LogEntry {
	if m != nil {
		return m.Entries
	}
	return nil
}

func (m *ListLogEntriesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The parameters to ListMonitoredResourceDescriptors
type ListMonitoredResourceDescriptorsRequest struct {
	// Optional. The maximum number of results to return from this request.
	// Non-positive values are ignored.  The presence of `nextPageToken` in the
	// response indicates that more results might be available.
	PageSize int32 `protobuf:"varint,1,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// Optional. If present, then retrieve the next batch of results from the
	// preceding call to this method.  `pageToken` must be the value of
	// `nextPageToken` from the previous response.  The values of other method
	// parameters should be identical to those in the previous call.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListMonitoredResourceDescriptorsRequest) Reset() {
	*m = ListMonitoredResourceDescriptorsRequest{}
}
func (m *ListMonitoredResourceDescriptorsRequest) String() string { return proto.CompactTextString(m) }
func (*ListMonitoredResourceDescriptorsRequest) ProtoMessage()    {}
func (*ListMonitoredResourceDescriptorsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor1, []int{5}
}

func (m *ListMonitoredResourceDescriptorsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListMonitoredResourceDescriptorsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Result returned from ListMonitoredResourceDescriptors.
type ListMonitoredResourceDescriptorsResponse struct {
	// A list of resource descriptors.
	ResourceDescriptors []*google_api3.MonitoredResourceDescriptor `protobuf:"bytes,1,rep,name=resource_descriptors,json=resourceDescriptors" json:"resource_descriptors,omitempty"`
	// If there might be more results than those appearing in this response, then
	// `nextPageToken` is included.  To get the next set of results, call this
	// method again using the value of `nextPageToken` as `pageToken`.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListMonitoredResourceDescriptorsResponse) Reset() {
	*m = ListMonitoredResourceDescriptorsResponse{}
}
func (m *ListMonitoredResourceDescriptorsResponse) String() string { return proto.CompactTextString(m) }
func (*ListMonitoredResourceDescriptorsResponse) ProtoMessage()    {}
func (*ListMonitoredResourceDescriptorsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor1, []int{6}
}

func (m *ListMonitoredResourceDescriptorsResponse) GetResourceDescriptors() []*google_api3.MonitoredResourceDescriptor {
	if m != nil {
		return m.ResourceDescriptors
	}
	return nil
}

func (m *ListMonitoredResourceDescriptorsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The parameters to ListLogs.
type ListLogsRequest struct {
	// Required. The resource name that owns the logs:
	//
	//     "projects/[PROJECT_ID]"
	//     "organizations/[ORGANIZATION_ID]"
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Optional. The maximum number of results to return from this request.
	// Non-positive values are ignored.  The presence of `nextPageToken` in the
	// response indicates that more results might be available.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// Optional. If present, then retrieve the next batch of results from the
	// preceding call to this method.  `pageToken` must be the value of
	// `nextPageToken` from the previous response.  The values of other method
	// parameters should be identical to those in the previous call.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListLogsRequest) Reset()                    { *m = ListLogsRequest{} }
func (m *ListLogsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListLogsRequest) ProtoMessage()               {}
func (*ListLogsRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{7} }

func (m *ListLogsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListLogsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListLogsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Result returned from ListLogs.
type ListLogsResponse struct {
	// A list of log names. For example,
	// `"projects/my-project/syslog"` or
	// `"organizations/123/cloudresourcemanager.googleapis.com%2Factivity"`.
	LogNames []string `protobuf:"bytes,3,rep,name=log_names,json=logNames" json:"log_names,omitempty"`
	// If there might be more results than those appearing in this response, then
	// `nextPageToken` is included.  To get the next set of results, call this
	// method again using the value of `nextPageToken` as `pageToken`.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListLogsResponse) Reset()                    { *m = ListLogsResponse{} }
func (m *ListLogsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListLogsResponse) ProtoMessage()               {}
func (*ListLogsResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{8} }

func (m *ListLogsResponse) GetLogNames() []string {
	if m != nil {
		return m.LogNames
	}
	return nil
}

func (m *ListLogsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func init() {
	proto.RegisterType((*DeleteLogRequest)(nil), "google.logging.v2.DeleteLogRequest")
	proto.RegisterType((*WriteLogEntriesRequest)(nil), "google.logging.v2.WriteLogEntriesRequest")
	proto.RegisterType((*WriteLogEntriesResponse)(nil), "google.logging.v2.WriteLogEntriesResponse")
	proto.RegisterType((*ListLogEntriesRequest)(nil), "google.logging.v2.ListLogEntriesRequest")
	proto.RegisterType((*ListLogEntriesResponse)(nil), "google.logging.v2.ListLogEntriesResponse")
	proto.RegisterType((*ListMonitoredResourceDescriptorsRequest)(nil), "google.logging.v2.ListMonitoredResourceDescriptorsRequest")
	proto.RegisterType((*ListMonitoredResourceDescriptorsResponse)(nil), "google.logging.v2.ListMonitoredResourceDescriptorsResponse")
	proto.RegisterType((*ListLogsRequest)(nil), "google.logging.v2.ListLogsRequest")
	proto.RegisterType((*ListLogsResponse)(nil), "google.logging.v2.ListLogsResponse")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for LoggingServiceV2 service

type LoggingServiceV2Client interface {
	// Deletes all the log entries in a log.
	// The log reappears if it receives new entries.
	DeleteLog(ctx context.Context, in *DeleteLogRequest, opts ...grpc.CallOption) (*google_protobuf5.Empty, error)
	// Writes log entries to Stackdriver Logging.  All log entries are
	// written by this method.
	WriteLogEntries(ctx context.Context, in *WriteLogEntriesRequest, opts ...grpc.CallOption) (*WriteLogEntriesResponse, error)
	// Lists log entries.  Use this method to retrieve log entries from
	// Stackdriver Logging.  For ways to export log entries, see
	// [Exporting Logs](/logging/docs/export).
	ListLogEntries(ctx context.Context, in *ListLogEntriesRequest, opts ...grpc.CallOption) (*ListLogEntriesResponse, error)
	// Lists the descriptors for monitored resource types used by Stackdriver
	// Logging.
	ListMonitoredResourceDescriptors(ctx context.Context, in *ListMonitoredResourceDescriptorsRequest, opts ...grpc.CallOption) (*ListMonitoredResourceDescriptorsResponse, error)
	// Lists the logs in projects or organizations.
	// Only logs that have entries are listed.
	ListLogs(ctx context.Context, in *ListLogsRequest, opts ...grpc.CallOption) (*ListLogsResponse, error)
}

type loggingServiceV2Client struct {
	cc *grpc.ClientConn
}

func NewLoggingServiceV2Client(cc *grpc.ClientConn) LoggingServiceV2Client {
	return &loggingServiceV2Client{cc}
}

func (c *loggingServiceV2Client) DeleteLog(ctx context.Context, in *DeleteLogRequest, opts ...grpc.CallOption) (*google_protobuf5.Empty, error) {
	out := new(google_protobuf5.Empty)
	err := grpc.Invoke(ctx, "/google.logging.v2.LoggingServiceV2/DeleteLog", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *loggingServiceV2Client) WriteLogEntries(ctx context.Context, in *WriteLogEntriesRequest, opts ...grpc.CallOption) (*WriteLogEntriesResponse, error) {
	out := new(WriteLogEntriesResponse)
	err := grpc.Invoke(ctx, "/google.logging.v2.LoggingServiceV2/WriteLogEntries", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *loggingServiceV2Client) ListLogEntries(ctx context.Context, in *ListLogEntriesRequest, opts ...grpc.CallOption) (*ListLogEntriesResponse, error) {
	out := new(ListLogEntriesResponse)
	err := grpc.Invoke(ctx, "/google.logging.v2.LoggingServiceV2/ListLogEntries", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *loggingServiceV2Client) ListMonitoredResourceDescriptors(ctx context.Context, in *ListMonitoredResourceDescriptorsRequest, opts ...grpc.CallOption) (*ListMonitoredResourceDescriptorsResponse, error) {
	out := new(ListMonitoredResourceDescriptorsResponse)
	err := grpc.Invoke(ctx, "/google.logging.v2.LoggingServiceV2/ListMonitoredResourceDescriptors", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *loggingServiceV2Client) ListLogs(ctx context.Context, in *ListLogsRequest, opts ...grpc.CallOption) (*ListLogsResponse, error) {
	out := new(ListLogsResponse)
	err := grpc.Invoke(ctx, "/google.logging.v2.LoggingServiceV2/ListLogs", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for LoggingServiceV2 service

type LoggingServiceV2Server interface {
	// Deletes all the log entries in a log.
	// The log reappears if it receives new entries.
	DeleteLog(context.Context, *DeleteLogRequest) (*google_protobuf5.Empty, error)
	// Writes log entries to Stackdriver Logging.  All log entries are
	// written by this method.
	WriteLogEntries(context.Context, *WriteLogEntriesRequest) (*WriteLogEntriesResponse, error)
	// Lists log entries.  Use this method to retrieve log entries from
	// Stackdriver Logging.  For ways to export log entries, see
	// [Exporting Logs](/logging/docs/export).
	ListLogEntries(context.Context, *ListLogEntriesRequest) (*ListLogEntriesResponse, error)
	// Lists the descriptors for monitored resource types used by Stackdriver
	// Logging.
	ListMonitoredResourceDescriptors(context.Context, *ListMonitoredResourceDescriptorsRequest) (*ListMonitoredResourceDescriptorsResponse, error)
	// Lists the logs in projects or organizations.
	// Only logs that have entries are listed.
	ListLogs(context.Context, *ListLogsRequest) (*ListLogsResponse, error)
}

func RegisterLoggingServiceV2Server(s *grpc.Server, srv LoggingServiceV2Server) {
	s.RegisterService(&_LoggingServiceV2_serviceDesc, srv)
}

func _LoggingServiceV2_DeleteLog_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteLogRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LoggingServiceV2Server).DeleteLog(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.LoggingServiceV2/DeleteLog",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LoggingServiceV2Server).DeleteLog(ctx, req.(*DeleteLogRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LoggingServiceV2_WriteLogEntries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(WriteLogEntriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LoggingServiceV2Server).WriteLogEntries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.LoggingServiceV2/WriteLogEntries",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LoggingServiceV2Server).WriteLogEntries(ctx, req.(*WriteLogEntriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LoggingServiceV2_ListLogEntries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListLogEntriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LoggingServiceV2Server).ListLogEntries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.LoggingServiceV2/ListLogEntries",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LoggingServiceV2Server).ListLogEntries(ctx, req.(*ListLogEntriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LoggingServiceV2_ListMonitoredResourceDescriptors_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMonitoredResourceDescriptorsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LoggingServiceV2Server).ListMonitoredResourceDescriptors(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.LoggingServiceV2/ListMonitoredResourceDescriptors",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LoggingServiceV2Server).ListMonitoredResourceDescriptors(ctx, req.(*ListMonitoredResourceDescriptorsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LoggingServiceV2_ListLogs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListLogsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LoggingServiceV2Server).ListLogs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.LoggingServiceV2/ListLogs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LoggingServiceV2Server).ListLogs(ctx, req.(*ListLogsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _LoggingServiceV2_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.logging.v2.LoggingServiceV2",
	HandlerType: (*LoggingServiceV2Server)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "DeleteLog",
			Handler:    _LoggingServiceV2_DeleteLog_Handler,
		},
		{
			MethodName: "WriteLogEntries",
			Handler:    _LoggingServiceV2_WriteLogEntries_Handler,
		},
		{
			MethodName: "ListLogEntries",
			Handler:    _LoggingServiceV2_ListLogEntries_Handler,
		},
		{
			MethodName: "ListMonitoredResourceDescriptors",
			Handler:    _LoggingServiceV2_ListMonitoredResourceDescriptors_Handler,
		},
		{
			MethodName: "ListLogs",
			Handler:    _LoggingServiceV2_ListLogs_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/logging/v2/logging.proto",
}

func init() { proto.RegisterFile("google/logging/v2/logging.proto", fileDescriptor1) }

var fileDescriptor1 = []byte{
	// 912 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x56, 0x4f, 0x6f, 0x1b, 0x45,
	0x14, 0xd7, 0xd8, 0x4d, 0x6a, 0xbf, 0xd0, 0xc4, 0x1d, 0x1a, 0xc7, 0xb5, 0xd3, 0xc6, 0x6c, 0x28,
	0xd9, 0x5a, 0xea, 0xae, 0x30, 0xaa, 0xd4, 0xa6, 0xe2, 0x12, 0x5a, 0x21, 0xa4, 0x14, 0x45, 0x1b,
	0xd4, 0x4a, 0xbd, 0x58, 0x6b, 0xfb, 0x75, 0x35, 0x74, 0xbd, 0xb3, 0xcc, 0x8c, 0x1d, 0xdc, 0xaa,
	0x1c, 0x7a, 0xe0, 0x0b, 0xf0, 0x2d, 0x38, 0xf0, 0x2d, 0xb8, 0x72, 0xe1, 0xc2, 0x81, 0x23, 0x1f,
	0x82, 0x23, 0x9a, 0xd9, 0x59, 0xc7, 0xb1, 0x5d, 0xc7, 0xe5, 0xb6, 0xf3, 0xe6, 0x37, 0xef, 0xfd,
	0xde, 0xef, 0xfd, 0xb1, 0x61, 0x2f, 0xe2, 0x3c, 0x8a, 0xd1, 0x8f, 0x79, 0x14, 0xb1, 0x24, 0xf2,
	0x47, 0xed, 0xfc, 0xd3, 0x4b, 0x05, 0x57, 0x9c, 0x5e, 0xcf, 0x00, 0x5e, 0x6e, 0x1d, 0xb5, 0xeb,
	0xbb, 0xf6, 0x4d, 0x98, 0x32, 0x3f, 0x4c, 0x12, 0xae, 0x42, 0xc5, 0x78, 0x22, 0xb3, 0x07, 0xf5,
	0xfd, 0xa9, 0xdb, 0x01, 0x4f, 0x98, 0xe2, 0x02, 0xfb, 0x1d, 0x81, 0x92, 0x0f, 0x45, 0x0f, 0x2d,
	0xe8, 0x93, 0x85, 0x61, 0x3b, 0x98, 0x28, 0x31, 0xb6, 0x90, 0xdb, 0x16, 0x62, 0x4e, 0xdd, 0xe1,
	0x4b, 0xbf, 0x3f, 0x14, 0x26, 0x90, 0xbd, 0x6f, 0xcc, 0xde, 0xe3, 0x20, 0x55, 0xf9, 0xe3, 0xbd,
	0xd9, 0x4b, 0xc5, 0x06, 0x28, 0x55, 0x38, 0x48, 0x2d, 0x60, 0xc7, 0x02, 0x44, 0xda, 0xf3, 0xa5,
	0x0a, 0xd5, 0xd0, 0xd2, 0x77, 0xee, 0x41, 0xe5, 0x31, 0xc6, 0xa8, 0xf0, 0x98, 0x47, 0x01, 0xfe,
	0x30, 0x44, 0xa9, 0xe8, 0x4d, 0x28, 0x69, 0x76, 0x49, 0x38, 0xc0, 0x1a, 0x69, 0x12, 0xb7, 0x1c,
	0x5c, 0x8d, 0x79, 0xf4, 0x6d, 0x38, 0x40, 0xe7, 0xaf, 0x02, 0x54, 0x9f, 0x0b, 0x66, 0xe0, 0x4f,
	0x12, 0x25, 0x18, 0xca, 0xcb, 0x5f, 0xd1, 0x87, 0x50, 0xca, 0x05, 0xa9, 0x15, 0x9a, 0xc4, 0xdd,
	0x68, 0xdf, 0xf2, 0xac, 0xce, 0x61, 0xca, 0xbc, 0xa7, 0xb9, 0x6c, 0x81, 0x05, 0x05, 0x13, 0x38,
	0x7d, 0x0a, 0xeb, 0x71, 0xd8, 0xc5, 0x58, 0xd6, 0x8a, 0xcd, 0xa2, 0xbb, 0xd1, 0xbe, 0xef, 0xcd,
	0x15, 0xc8, 0x5b, 0x4c, 0xc8, 0x3b, 0x36, 0xef, 0xb4, 0x71, 0x1c, 0x58, 0x27, 0xf4, 0x3e, 0x5c,
	0xc5, 0x0c, 0x55, 0xbb, 0x62, 0xfc, 0x35, 0x16, 0xf8, 0xb3, 0xae, 0xc6, 0x41, 0x8e, 0xa5, 0x07,
	0xb0, 0x95, 0x86, 0x42, 0xb1, 0x30, 0xee, 0xc8, 0x61, 0xaf, 0x87, 0x52, 0xd6, 0xd6, 0x9a, 0xc4,
	0x2d, 0x05, 0x9b, 0xd6, 0x7c, 0x9a, 0x59, 0xeb, 0x0f, 0x61, 0x63, 0x2a, 0x2c, 0xad, 0x40, 0xf1,
	0x15, 0x8e, 0xad, 0x1c, 0xfa, 0x93, 0xde, 0x80, 0xb5, 0x51, 0x18, 0x0f, 0x33, 0x1d, 0xca, 0x41,
	0x76, 0x38, 0x2c, 0x3c, 0x20, 0xce, 0x4d, 0xd8, 0x99, 0x4b, 0x44, 0xa6, 0x3c, 0x91, 0xe8, 0xfc,
	0x41, 0x60, 0xfb, 0x98, 0x49, 0x35, 0x2f, 0xfa, 0x1e, 0x6c, 0xa4, 0x82, 0x7f, 0x8f, 0x3d, 0xd5,
	0x61, 0x7d, 0x59, 0x23, 0xcd, 0xa2, 0x5b, 0x0e, 0xc0, 0x9a, 0xbe, 0xe9, 0x4b, 0x7a, 0x07, 0x36,
	0x73, 0x2d, 0x4d, 0x69, 0x64, 0xad, 0x64, 0x30, 0xd7, 0x72, 0xab, 0x2e, 0x90, 0xa4, 0x55, 0x58,
	0x7f, 0xc9, 0x62, 0x85, 0xc2, 0xf2, 0xb2, 0x27, 0x5d, 0x54, 0x2e, 0xfa, 0x28, 0x3a, 0xdd, 0x71,
	0xad, 0x98, 0x15, 0xd5, 0x9c, 0x8f, 0xc6, 0xb4, 0x01, 0xe5, 0x34, 0x8c, 0xb0, 0x23, 0xd9, 0x6b,
	0xac, 0x5d, 0x69, 0x12, 0x77, 0x2d, 0x28, 0x69, 0xc3, 0x29, 0x7b, 0x8d, 0xf4, 0x16, 0x80, 0xb9,
	0x54, 0xfc, 0x15, 0x26, 0x46, 0xab, 0x72, 0x60, 0xe0, 0xdf, 0x69, 0x83, 0x73, 0x06, 0xd5, 0xd9,
	0x7c, 0xb2, 0x54, 0xa7, 0x0b, 0x44, 0x3e, 0xa0, 0x40, 0x9f, 0xc1, 0x56, 0x82, 0x3f, 0xaa, 0xce,
	0x54, 0xd0, 0x2c, 0x91, 0x6b, 0xda, 0x7c, 0x32, 0x09, 0x8c, 0x70, 0xa0, 0x03, 0xcf, 0x75, 0xdc,
	0x63, 0x94, 0x3d, 0xc1, 0x52, 0xc5, 0xc5, 0x44, 0xda, 0x0b, 0xf9, 0x91, 0xa5, 0xf9, 0x15, 0x66,
	0xf3, 0xfb, 0x8d, 0x80, 0x7b, 0x79, 0x1c, 0x9b, 0xf2, 0x0b, 0xb8, 0x31, 0x29, 0x51, 0xff, 0xfc,
	0xde, 0xe6, 0x7f, 0xb0, 0x74, 0x52, 0xce, 0xfd, 0x05, 0x1f, 0x8b, 0xf9, 0x18, 0x1f, 0xa0, 0xcb,
	0x96, 0x2d, 0xc8, 0x24, 0xff, 0x2a, 0xac, 0xa7, 0xa1, 0xc0, 0x44, 0xd9, 0xf6, 0xb5, 0xa7, 0x8b,
	0xba, 0x14, 0x96, 0xea, 0x52, 0x9c, 0xd5, 0xe5, 0x39, 0x54, 0xce, 0xc3, 0xd8, 0xf4, 0x1b, 0x50,
	0xce, 0xf7, 0x46, 0x36, 0xe4, 0xe5, 0xa0, 0x64, 0x17, 0xc7, 0xca, 0xfc, 0xdb, 0x7f, 0xaf, 0x41,
	0xe5, 0x38, 0x6b, 0x90, 0x53, 0x14, 0x23, 0xd6, 0xc3, 0x67, 0x6d, 0x7a, 0x06, 0xe5, 0xc9, 0x6e,
	0xa3, 0xfb, 0x0b, 0xfa, 0x68, 0x76, 0xf3, 0xd5, 0xab, 0x39, 0x28, 0x5f, 0xa4, 0xde, 0x13, 0xbd,
	0x65, 0x9d, 0x7b, 0xef, 0xfe, 0xfc, 0xe7, 0x97, 0xc2, 0x41, 0xeb, 0x8e, 0x3f, 0x6a, 0x77, 0x51,
	0x85, 0x9f, 0xfb, 0x6f, 0x72, 0xce, 0x5f, 0xda, 0x61, 0x93, 0x7e, 0x4b, 0xef, 0x74, 0xe9, 0xb7,
	0xde, 0xd2, 0x9f, 0x09, 0x6c, 0xcd, 0xcc, 0x32, 0xbd, 0xbb, 0xf2, 0xe2, 0xaa, 0xb7, 0x56, 0x81,
	0xda, 0xd5, 0xb0, 0x6b, 0x98, 0x55, 0x9d, 0xeb, 0xfa, 0x37, 0xc5, 0x4e, 0xc3, 0xe1, 0x99, 0x06,
	0x1f, 0x92, 0x16, 0x7d, 0x47, 0x60, 0xf3, 0xe2, 0xa0, 0x51, 0x77, 0xd1, 0x3c, 0x2d, 0xda, 0x2d,
	0xf5, 0xbb, 0x2b, 0x20, 0x2d, 0x8b, 0x86, 0x61, 0xb1, 0xed, 0x54, 0xa6, 0x59, 0xc4, 0x4c, 0x2a,
	0x4d, 0xe2, 0x77, 0x02, 0xcd, 0xcb, 0x86, 0x81, 0x1e, 0xbe, 0x27, 0xd8, 0x0a, 0x93, 0x5a, 0x7f,
	0xf4, 0xbf, 0xde, 0x5a, 0xea, 0xae, 0xa1, 0xee, 0xd0, 0xa6, 0xa6, 0x3e, 0x58, 0x46, 0x71, 0x0c,
	0xa5, 0xbc, 0x79, 0xa9, 0xf3, 0x7e, 0x6d, 0x26, 0xb4, 0xf6, 0x97, 0x62, 0x6c, 0xf8, 0x4f, 0x4d,
	0xf8, 0xdb, 0x74, 0x57, 0x87, 0x7f, 0x93, 0x8d, 0xd8, 0x54, 0x4b, 0xbd, 0x35, 0x3d, 0x75, 0xf4,
	0x13, 0x6c, 0xf7, 0xf8, 0x60, 0xde, 0xdf, 0xd1, 0x47, 0xb6, 0xe9, 0x4f, 0x74, 0xbf, 0x9e, 0x90,
	0x17, 0x0f, 0x2c, 0x24, 0xe2, 0x71, 0x98, 0x44, 0x1e, 0x17, 0x91, 0x1f, 0x61, 0x62, 0xba, 0xd9,
	0xcf, 0xae, 0xc2, 0x94, 0xc9, 0xa9, 0xff, 0x21, 0x8f, 0xec, 0xe7, 0xbf, 0x84, 0xfc, 0x5a, 0xd8,
	0xf9, 0x3a, 0x7b, 0xfd, 0x55, 0xcc, 0x87, 0x7d, 0xcf, 0xba, 0xf6, 0x9e, 0xb5, 0xbb, 0xeb, 0xc6,
	0xc3, 0x17, 0xff, 0x05, 0x00, 0x00, 0xff, 0xff, 0x9a, 0x9f, 0x7c, 0xe8, 0x3f, 0x09, 0x00, 0x00,
}
