<!--[metadata]>
+++
title = "Install"
description = "Lists the installation methods"
keywords = ["Docker install "]
[menu.main]
identifier = "engine_install"
parent="engine_use"
weight="-81"
+++
<![end-metadata]-->

# Install Docker Engine

Docker Engine is supported on Linux, Cloud, Windows, and OS X. Installation instructions are available for the following:

## On Linux
* [Arch Linux](linux/archlinux.md)
* [CentOS](linux/centos.md)
* [CRUX Linux](linux/cruxlinux.md)
* [Debian](linux/debian.md)
* [Fedora](linux/fedora.md)
* [FrugalWare](linux/frugalware.md)
* [Gentoo](linux/gentoolinux.md)
* [Oracle Linux](linux/oracle.md)
* [Red Hat Enterprise Linux](linux/rhel.md)
* [openSUSE and SUSE Linux Enterprise](linux/SUSE.md)
* [Ubuntu](linux/ubuntulinux.md)

If your linux distribution is not listed above, don't give up yet. To try out Docker on a distribution that is not listed above, go here: [Installation from binaries](binaries.md).

## On Cloud
* [Choose how to Install](cloud/overview.md)
* [Example: Manual install on a cloud provider](cloud/cloud-ex-aws.md)
* [Example: Use Docker Machine to provision cloud hosts](cloud/cloud-ex-machine-ocean.md)

## On OSX and Windows
* [Mac OS X](mac.md)
* [Windows](windows.md)

## The Docker Archives
Instructions for installing prior releases of Docker can be found in the following docker archives:
[Docker v1.7](http://docs.docker.com/v1.7/), [Docker v1.6](http://docs.docker.com/v1.6/), [Docker v1.5](http://docs.docker.com/v1.5/), and [Docker v1.4](http://docs.docker.com/v1.4/).

## Where to go after installing
* [About Docker Engine](../index.md)
* [Support](https://www.docker.com/support/)
* [Training](https://training.docker.com//)
