// Code generated by protoc-gen-go.
// source: api.proto
// DO NOT EDIT!

/*
Package types is a generated protocol buffer package.

It is generated from these files:
	api.proto

It has these top-level messages:
	UpdateProcessRequest
	UpdateProcessResponse
	CreateContainerRequest
	CreateContainerResponse
	SignalRequest
	SignalResponse
	AddProcessRequest
	Rlimit
	User
	AddProcessResponse
	CreateCheckpointRequest
	CreateCheckpointResponse
	DeleteCheckpointRequest
	DeleteCheckpointResponse
	ListCheckpointRequest
	Checkpoint
	ListCheckpointResponse
	StateRequest
	ContainerState
	Process
	Container
	Machine
	StateResponse
	UpdateContainerRequest
	UpdateResource
	UpdateContainerResponse
	EventsRequest
	Event
	NetworkStats
	CpuUsage
	ThrottlingData
	CpuStats
	PidsStats
	MemoryData
	MemoryStats
	BlkioStatsEntry
	BlkioStats
	HugetlbStats
	CgroupStats
	StatsResponse
	StatsRequest
*/
package types

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

type UpdateProcessRequest struct {
	Id         string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Pid        string `protobuf:"bytes,2,opt,name=pid" json:"pid,omitempty"`
	CloseStdin bool   `protobuf:"varint,3,opt,name=closeStdin" json:"closeStdin,omitempty"`
	Width      uint32 `protobuf:"varint,4,opt,name=width" json:"width,omitempty"`
	Height     uint32 `protobuf:"varint,5,opt,name=height" json:"height,omitempty"`
}

func (m *UpdateProcessRequest) Reset()                    { *m = UpdateProcessRequest{} }
func (m *UpdateProcessRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateProcessRequest) ProtoMessage()               {}
func (*UpdateProcessRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

type UpdateProcessResponse struct {
}

func (m *UpdateProcessResponse) Reset()                    { *m = UpdateProcessResponse{} }
func (m *UpdateProcessResponse) String() string            { return proto.CompactTextString(m) }
func (*UpdateProcessResponse) ProtoMessage()               {}
func (*UpdateProcessResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

type CreateContainerRequest struct {
	Id          string   `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	BundlePath  string   `protobuf:"bytes,2,opt,name=bundlePath" json:"bundlePath,omitempty"`
	Checkpoint  string   `protobuf:"bytes,3,opt,name=checkpoint" json:"checkpoint,omitempty"`
	Stdin       string   `protobuf:"bytes,4,opt,name=stdin" json:"stdin,omitempty"`
	Stdout      string   `protobuf:"bytes,5,opt,name=stdout" json:"stdout,omitempty"`
	Stderr      string   `protobuf:"bytes,6,opt,name=stderr" json:"stderr,omitempty"`
	Labels      []string `protobuf:"bytes,7,rep,name=labels" json:"labels,omitempty"`
	NoPivotRoot bool     `protobuf:"varint,8,opt,name=noPivotRoot" json:"noPivotRoot,omitempty"`
}

func (m *CreateContainerRequest) Reset()                    { *m = CreateContainerRequest{} }
func (m *CreateContainerRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateContainerRequest) ProtoMessage()               {}
func (*CreateContainerRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

type CreateContainerResponse struct {
	Container *Container `protobuf:"bytes,1,opt,name=container" json:"container,omitempty"`
}

func (m *CreateContainerResponse) Reset()                    { *m = CreateContainerResponse{} }
func (m *CreateContainerResponse) String() string            { return proto.CompactTextString(m) }
func (*CreateContainerResponse) ProtoMessage()               {}
func (*CreateContainerResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *CreateContainerResponse) GetContainer() *Container {
	if m != nil {
		return m.Container
	}
	return nil
}

type SignalRequest struct {
	Id     string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Pid    string `protobuf:"bytes,2,opt,name=pid" json:"pid,omitempty"`
	Signal uint32 `protobuf:"varint,3,opt,name=signal" json:"signal,omitempty"`
}

func (m *SignalRequest) Reset()                    { *m = SignalRequest{} }
func (m *SignalRequest) String() string            { return proto.CompactTextString(m) }
func (*SignalRequest) ProtoMessage()               {}
func (*SignalRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

type SignalResponse struct {
}

func (m *SignalResponse) Reset()                    { *m = SignalResponse{} }
func (m *SignalResponse) String() string            { return proto.CompactTextString(m) }
func (*SignalResponse) ProtoMessage()               {}
func (*SignalResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

type AddProcessRequest struct {
	Id              string    `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Terminal        bool      `protobuf:"varint,2,opt,name=terminal" json:"terminal,omitempty"`
	User            *User     `protobuf:"bytes,3,opt,name=user" json:"user,omitempty"`
	Args            []string  `protobuf:"bytes,4,rep,name=args" json:"args,omitempty"`
	Env             []string  `protobuf:"bytes,5,rep,name=env" json:"env,omitempty"`
	Cwd             string    `protobuf:"bytes,6,opt,name=cwd" json:"cwd,omitempty"`
	Pid             string    `protobuf:"bytes,7,opt,name=pid" json:"pid,omitempty"`
	Stdin           string    `protobuf:"bytes,8,opt,name=stdin" json:"stdin,omitempty"`
	Stdout          string    `protobuf:"bytes,9,opt,name=stdout" json:"stdout,omitempty"`
	Stderr          string    `protobuf:"bytes,10,opt,name=stderr" json:"stderr,omitempty"`
	Capabilities    []string  `protobuf:"bytes,11,rep,name=capabilities" json:"capabilities,omitempty"`
	ApparmorProfile string    `protobuf:"bytes,12,opt,name=apparmorProfile" json:"apparmorProfile,omitempty"`
	SelinuxLabel    string    `protobuf:"bytes,13,opt,name=selinuxLabel" json:"selinuxLabel,omitempty"`
	NoNewPrivileges bool      `protobuf:"varint,14,opt,name=noNewPrivileges" json:"noNewPrivileges,omitempty"`
	Rlimits         []*Rlimit `protobuf:"bytes,15,rep,name=rlimits" json:"rlimits,omitempty"`
}

func (m *AddProcessRequest) Reset()                    { *m = AddProcessRequest{} }
func (m *AddProcessRequest) String() string            { return proto.CompactTextString(m) }
func (*AddProcessRequest) ProtoMessage()               {}
func (*AddProcessRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *AddProcessRequest) GetUser() *User {
	if m != nil {
		return m.User
	}
	return nil
}

func (m *AddProcessRequest) GetRlimits() []*Rlimit {
	if m != nil {
		return m.Rlimits
	}
	return nil
}

type Rlimit struct {
	Type string `protobuf:"bytes,1,opt,name=type" json:"type,omitempty"`
	Soft uint64 `protobuf:"varint,2,opt,name=soft" json:"soft,omitempty"`
	Hard uint64 `protobuf:"varint,3,opt,name=hard" json:"hard,omitempty"`
}

func (m *Rlimit) Reset()                    { *m = Rlimit{} }
func (m *Rlimit) String() string            { return proto.CompactTextString(m) }
func (*Rlimit) ProtoMessage()               {}
func (*Rlimit) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

type User struct {
	Uid            uint32   `protobuf:"varint,1,opt,name=uid" json:"uid,omitempty"`
	Gid            uint32   `protobuf:"varint,2,opt,name=gid" json:"gid,omitempty"`
	AdditionalGids []uint32 `protobuf:"varint,3,rep,name=additionalGids" json:"additionalGids,omitempty"`
}

func (m *User) Reset()                    { *m = User{} }
func (m *User) String() string            { return proto.CompactTextString(m) }
func (*User) ProtoMessage()               {}
func (*User) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

type AddProcessResponse struct {
}

func (m *AddProcessResponse) Reset()                    { *m = AddProcessResponse{} }
func (m *AddProcessResponse) String() string            { return proto.CompactTextString(m) }
func (*AddProcessResponse) ProtoMessage()               {}
func (*AddProcessResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

type CreateCheckpointRequest struct {
	Id         string      `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Checkpoint *Checkpoint `protobuf:"bytes,2,opt,name=checkpoint" json:"checkpoint,omitempty"`
}

func (m *CreateCheckpointRequest) Reset()                    { *m = CreateCheckpointRequest{} }
func (m *CreateCheckpointRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateCheckpointRequest) ProtoMessage()               {}
func (*CreateCheckpointRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *CreateCheckpointRequest) GetCheckpoint() *Checkpoint {
	if m != nil {
		return m.Checkpoint
	}
	return nil
}

type CreateCheckpointResponse struct {
}

func (m *CreateCheckpointResponse) Reset()                    { *m = CreateCheckpointResponse{} }
func (m *CreateCheckpointResponse) String() string            { return proto.CompactTextString(m) }
func (*CreateCheckpointResponse) ProtoMessage()               {}
func (*CreateCheckpointResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

type DeleteCheckpointRequest struct {
	Id   string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Name string `protobuf:"bytes,2,opt,name=name" json:"name,omitempty"`
}

func (m *DeleteCheckpointRequest) Reset()                    { *m = DeleteCheckpointRequest{} }
func (m *DeleteCheckpointRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteCheckpointRequest) ProtoMessage()               {}
func (*DeleteCheckpointRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

type DeleteCheckpointResponse struct {
}

func (m *DeleteCheckpointResponse) Reset()                    { *m = DeleteCheckpointResponse{} }
func (m *DeleteCheckpointResponse) String() string            { return proto.CompactTextString(m) }
func (*DeleteCheckpointResponse) ProtoMessage()               {}
func (*DeleteCheckpointResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

type ListCheckpointRequest struct {
	Id string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
}

func (m *ListCheckpointRequest) Reset()                    { *m = ListCheckpointRequest{} }
func (m *ListCheckpointRequest) String() string            { return proto.CompactTextString(m) }
func (*ListCheckpointRequest) ProtoMessage()               {}
func (*ListCheckpointRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

type Checkpoint struct {
	Name        string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	Exit        bool   `protobuf:"varint,2,opt,name=exit" json:"exit,omitempty"`
	Tcp         bool   `protobuf:"varint,3,opt,name=tcp" json:"tcp,omitempty"`
	UnixSockets bool   `protobuf:"varint,4,opt,name=unixSockets" json:"unixSockets,omitempty"`
	Shell       bool   `protobuf:"varint,5,opt,name=shell" json:"shell,omitempty"`
}

func (m *Checkpoint) Reset()                    { *m = Checkpoint{} }
func (m *Checkpoint) String() string            { return proto.CompactTextString(m) }
func (*Checkpoint) ProtoMessage()               {}
func (*Checkpoint) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

type ListCheckpointResponse struct {
	Checkpoints []*Checkpoint `protobuf:"bytes,1,rep,name=checkpoints" json:"checkpoints,omitempty"`
}

func (m *ListCheckpointResponse) Reset()                    { *m = ListCheckpointResponse{} }
func (m *ListCheckpointResponse) String() string            { return proto.CompactTextString(m) }
func (*ListCheckpointResponse) ProtoMessage()               {}
func (*ListCheckpointResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *ListCheckpointResponse) GetCheckpoints() []*Checkpoint {
	if m != nil {
		return m.Checkpoints
	}
	return nil
}

type StateRequest struct {
	Id string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
}

func (m *StateRequest) Reset()                    { *m = StateRequest{} }
func (m *StateRequest) String() string            { return proto.CompactTextString(m) }
func (*StateRequest) ProtoMessage()               {}
func (*StateRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

type ContainerState struct {
	Status string `protobuf:"bytes,1,opt,name=status" json:"status,omitempty"`
}

func (m *ContainerState) Reset()                    { *m = ContainerState{} }
func (m *ContainerState) String() string            { return proto.CompactTextString(m) }
func (*ContainerState) ProtoMessage()               {}
func (*ContainerState) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

type Process struct {
	Pid             string    `protobuf:"bytes,1,opt,name=pid" json:"pid,omitempty"`
	Terminal        bool      `protobuf:"varint,2,opt,name=terminal" json:"terminal,omitempty"`
	User            *User     `protobuf:"bytes,3,opt,name=user" json:"user,omitempty"`
	Args            []string  `protobuf:"bytes,4,rep,name=args" json:"args,omitempty"`
	Env             []string  `protobuf:"bytes,5,rep,name=env" json:"env,omitempty"`
	Cwd             string    `protobuf:"bytes,6,opt,name=cwd" json:"cwd,omitempty"`
	SystemPid       uint32    `protobuf:"varint,7,opt,name=systemPid" json:"systemPid,omitempty"`
	Stdin           string    `protobuf:"bytes,8,opt,name=stdin" json:"stdin,omitempty"`
	Stdout          string    `protobuf:"bytes,9,opt,name=stdout" json:"stdout,omitempty"`
	Stderr          string    `protobuf:"bytes,10,opt,name=stderr" json:"stderr,omitempty"`
	Capabilities    []string  `protobuf:"bytes,11,rep,name=capabilities" json:"capabilities,omitempty"`
	ApparmorProfile string    `protobuf:"bytes,12,opt,name=apparmorProfile" json:"apparmorProfile,omitempty"`
	SelinuxLabel    string    `protobuf:"bytes,13,opt,name=selinuxLabel" json:"selinuxLabel,omitempty"`
	NoNewPrivileges bool      `protobuf:"varint,14,opt,name=noNewPrivileges" json:"noNewPrivileges,omitempty"`
	Rlimits         []*Rlimit `protobuf:"bytes,15,rep,name=rlimits" json:"rlimits,omitempty"`
}

func (m *Process) Reset()                    { *m = Process{} }
func (m *Process) String() string            { return proto.CompactTextString(m) }
func (*Process) ProtoMessage()               {}
func (*Process) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

func (m *Process) GetUser() *User {
	if m != nil {
		return m.User
	}
	return nil
}

func (m *Process) GetRlimits() []*Rlimit {
	if m != nil {
		return m.Rlimits
	}
	return nil
}

type Container struct {
	Id         string     `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	BundlePath string     `protobuf:"bytes,2,opt,name=bundlePath" json:"bundlePath,omitempty"`
	Processes  []*Process `protobuf:"bytes,3,rep,name=processes" json:"processes,omitempty"`
	Status     string     `protobuf:"bytes,4,opt,name=status" json:"status,omitempty"`
	Labels     []string   `protobuf:"bytes,5,rep,name=labels" json:"labels,omitempty"`
	Pids       []uint32   `protobuf:"varint,6,rep,name=pids" json:"pids,omitempty"`
	Runtime    string     `protobuf:"bytes,7,opt,name=runtime" json:"runtime,omitempty"`
}

func (m *Container) Reset()                    { *m = Container{} }
func (m *Container) String() string            { return proto.CompactTextString(m) }
func (*Container) ProtoMessage()               {}
func (*Container) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

func (m *Container) GetProcesses() []*Process {
	if m != nil {
		return m.Processes
	}
	return nil
}

// Machine is information about machine on which containerd is run
type Machine struct {
	Cpus   uint32 `protobuf:"varint,1,opt,name=cpus" json:"cpus,omitempty"`
	Memory uint64 `protobuf:"varint,2,opt,name=memory" json:"memory,omitempty"`
}

func (m *Machine) Reset()                    { *m = Machine{} }
func (m *Machine) String() string            { return proto.CompactTextString(m) }
func (*Machine) ProtoMessage()               {}
func (*Machine) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{21} }

// StateResponse is information about containerd daemon
type StateResponse struct {
	Containers []*Container `protobuf:"bytes,1,rep,name=containers" json:"containers,omitempty"`
	Machine    *Machine     `protobuf:"bytes,2,opt,name=machine" json:"machine,omitempty"`
}

func (m *StateResponse) Reset()                    { *m = StateResponse{} }
func (m *StateResponse) String() string            { return proto.CompactTextString(m) }
func (*StateResponse) ProtoMessage()               {}
func (*StateResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{22} }

func (m *StateResponse) GetContainers() []*Container {
	if m != nil {
		return m.Containers
	}
	return nil
}

func (m *StateResponse) GetMachine() *Machine {
	if m != nil {
		return m.Machine
	}
	return nil
}

type UpdateContainerRequest struct {
	Id        string          `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Pid       string          `protobuf:"bytes,2,opt,name=pid" json:"pid,omitempty"`
	Status    string          `protobuf:"bytes,3,opt,name=status" json:"status,omitempty"`
	Resources *UpdateResource `protobuf:"bytes,4,opt,name=resources" json:"resources,omitempty"`
}

func (m *UpdateContainerRequest) Reset()                    { *m = UpdateContainerRequest{} }
func (m *UpdateContainerRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateContainerRequest) ProtoMessage()               {}
func (*UpdateContainerRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{23} }

func (m *UpdateContainerRequest) GetResources() *UpdateResource {
	if m != nil {
		return m.Resources
	}
	return nil
}

type UpdateResource struct {
	BlkioWeight       uint32 `protobuf:"varint,1,opt,name=blkioWeight" json:"blkioWeight,omitempty"`
	CpuShares         uint32 `protobuf:"varint,2,opt,name=cpuShares" json:"cpuShares,omitempty"`
	CpuPeriod         uint32 `protobuf:"varint,3,opt,name=cpuPeriod" json:"cpuPeriod,omitempty"`
	CpuQuota          uint32 `protobuf:"varint,4,opt,name=cpuQuota" json:"cpuQuota,omitempty"`
	CpusetCpus        string `protobuf:"bytes,5,opt,name=cpusetCpus" json:"cpusetCpus,omitempty"`
	CpusetMems        string `protobuf:"bytes,6,opt,name=cpusetMems" json:"cpusetMems,omitempty"`
	MemoryLimit       uint32 `protobuf:"varint,7,opt,name=memoryLimit" json:"memoryLimit,omitempty"`
	MemorySwap        uint32 `protobuf:"varint,8,opt,name=memorySwap" json:"memorySwap,omitempty"`
	MemoryReservation uint32 `protobuf:"varint,9,opt,name=memoryReservation" json:"memoryReservation,omitempty"`
	KernelMemoryLimit uint32 `protobuf:"varint,10,opt,name=kernelMemoryLimit" json:"kernelMemoryLimit,omitempty"`
}

func (m *UpdateResource) Reset()                    { *m = UpdateResource{} }
func (m *UpdateResource) String() string            { return proto.CompactTextString(m) }
func (*UpdateResource) ProtoMessage()               {}
func (*UpdateResource) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{24} }

type UpdateContainerResponse struct {
}

func (m *UpdateContainerResponse) Reset()                    { *m = UpdateContainerResponse{} }
func (m *UpdateContainerResponse) String() string            { return proto.CompactTextString(m) }
func (*UpdateContainerResponse) ProtoMessage()               {}
func (*UpdateContainerResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{25} }

type EventsRequest struct {
	Timestamp uint64 `protobuf:"varint,1,opt,name=timestamp" json:"timestamp,omitempty"`
}

func (m *EventsRequest) Reset()                    { *m = EventsRequest{} }
func (m *EventsRequest) String() string            { return proto.CompactTextString(m) }
func (*EventsRequest) ProtoMessage()               {}
func (*EventsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{26} }

type Event struct {
	Type      string `protobuf:"bytes,1,opt,name=type" json:"type,omitempty"`
	Id        string `protobuf:"bytes,2,opt,name=id" json:"id,omitempty"`
	Status    uint32 `protobuf:"varint,3,opt,name=status" json:"status,omitempty"`
	Pid       string `protobuf:"bytes,4,opt,name=pid" json:"pid,omitempty"`
	Timestamp uint64 `protobuf:"varint,5,opt,name=timestamp" json:"timestamp,omitempty"`
}

func (m *Event) Reset()                    { *m = Event{} }
func (m *Event) String() string            { return proto.CompactTextString(m) }
func (*Event) ProtoMessage()               {}
func (*Event) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{27} }

type NetworkStats struct {
	Name       string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	RxBytes    uint64 `protobuf:"varint,2,opt,name=rx_bytes,json=rxBytes" json:"rx_bytes,omitempty"`
	Rx_Packets uint64 `protobuf:"varint,3,opt,name=rx_Packets,json=rxPackets" json:"rx_Packets,omitempty"`
	RxErrors   uint64 `protobuf:"varint,4,opt,name=Rx_errors,json=rxErrors" json:"Rx_errors,omitempty"`
	RxDropped  uint64 `protobuf:"varint,5,opt,name=Rx_dropped,json=rxDropped" json:"Rx_dropped,omitempty"`
	TxBytes    uint64 `protobuf:"varint,6,opt,name=Tx_bytes,json=txBytes" json:"Tx_bytes,omitempty"`
	TxPackets  uint64 `protobuf:"varint,7,opt,name=Tx_packets,json=txPackets" json:"Tx_packets,omitempty"`
	TxErrors   uint64 `protobuf:"varint,8,opt,name=Tx_errors,json=txErrors" json:"Tx_errors,omitempty"`
	TxDropped  uint64 `protobuf:"varint,9,opt,name=Tx_dropped,json=txDropped" json:"Tx_dropped,omitempty"`
}

func (m *NetworkStats) Reset()                    { *m = NetworkStats{} }
func (m *NetworkStats) String() string            { return proto.CompactTextString(m) }
func (*NetworkStats) ProtoMessage()               {}
func (*NetworkStats) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{28} }

type CpuUsage struct {
	TotalUsage        uint64   `protobuf:"varint,1,opt,name=total_usage,json=totalUsage" json:"total_usage,omitempty"`
	PercpuUsage       []uint64 `protobuf:"varint,2,rep,name=percpu_usage,json=percpuUsage" json:"percpu_usage,omitempty"`
	UsageInKernelmode uint64   `protobuf:"varint,3,opt,name=usage_in_kernelmode,json=usageInKernelmode" json:"usage_in_kernelmode,omitempty"`
	UsageInUsermode   uint64   `protobuf:"varint,4,opt,name=usage_in_usermode,json=usageInUsermode" json:"usage_in_usermode,omitempty"`
}

func (m *CpuUsage) Reset()                    { *m = CpuUsage{} }
func (m *CpuUsage) String() string            { return proto.CompactTextString(m) }
func (*CpuUsage) ProtoMessage()               {}
func (*CpuUsage) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{29} }

type ThrottlingData struct {
	Periods          uint64 `protobuf:"varint,1,opt,name=periods" json:"periods,omitempty"`
	ThrottledPeriods uint64 `protobuf:"varint,2,opt,name=throttled_periods,json=throttledPeriods" json:"throttled_periods,omitempty"`
	ThrottledTime    uint64 `protobuf:"varint,3,opt,name=throttled_time,json=throttledTime" json:"throttled_time,omitempty"`
}

func (m *ThrottlingData) Reset()                    { *m = ThrottlingData{} }
func (m *ThrottlingData) String() string            { return proto.CompactTextString(m) }
func (*ThrottlingData) ProtoMessage()               {}
func (*ThrottlingData) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{30} }

type CpuStats struct {
	CpuUsage       *CpuUsage       `protobuf:"bytes,1,opt,name=cpu_usage,json=cpuUsage" json:"cpu_usage,omitempty"`
	ThrottlingData *ThrottlingData `protobuf:"bytes,2,opt,name=throttling_data,json=throttlingData" json:"throttling_data,omitempty"`
	SystemUsage    uint64          `protobuf:"varint,3,opt,name=system_usage,json=systemUsage" json:"system_usage,omitempty"`
}

func (m *CpuStats) Reset()                    { *m = CpuStats{} }
func (m *CpuStats) String() string            { return proto.CompactTextString(m) }
func (*CpuStats) ProtoMessage()               {}
func (*CpuStats) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{31} }

func (m *CpuStats) GetCpuUsage() *CpuUsage {
	if m != nil {
		return m.CpuUsage
	}
	return nil
}

func (m *CpuStats) GetThrottlingData() *ThrottlingData {
	if m != nil {
		return m.ThrottlingData
	}
	return nil
}

type PidsStats struct {
	Current uint64 `protobuf:"varint,1,opt,name=current" json:"current,omitempty"`
	Limit   uint64 `protobuf:"varint,2,opt,name=limit" json:"limit,omitempty"`
}

func (m *PidsStats) Reset()                    { *m = PidsStats{} }
func (m *PidsStats) String() string            { return proto.CompactTextString(m) }
func (*PidsStats) ProtoMessage()               {}
func (*PidsStats) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{32} }

type MemoryData struct {
	Usage    uint64 `protobuf:"varint,1,opt,name=usage" json:"usage,omitempty"`
	MaxUsage uint64 `protobuf:"varint,2,opt,name=max_usage,json=maxUsage" json:"max_usage,omitempty"`
	Failcnt  uint64 `protobuf:"varint,3,opt,name=failcnt" json:"failcnt,omitempty"`
	Limit    uint64 `protobuf:"varint,4,opt,name=limit" json:"limit,omitempty"`
}

func (m *MemoryData) Reset()                    { *m = MemoryData{} }
func (m *MemoryData) String() string            { return proto.CompactTextString(m) }
func (*MemoryData) ProtoMessage()               {}
func (*MemoryData) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{33} }

type MemoryStats struct {
	Cache       uint64            `protobuf:"varint,1,opt,name=cache" json:"cache,omitempty"`
	Usage       *MemoryData       `protobuf:"bytes,2,opt,name=usage" json:"usage,omitempty"`
	SwapUsage   *MemoryData       `protobuf:"bytes,3,opt,name=swap_usage,json=swapUsage" json:"swap_usage,omitempty"`
	KernelUsage *MemoryData       `protobuf:"bytes,4,opt,name=kernel_usage,json=kernelUsage" json:"kernel_usage,omitempty"`
	Stats       map[string]uint64 `protobuf:"bytes,5,rep,name=stats" json:"stats,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"varint,2,opt,name=value"`
}

func (m *MemoryStats) Reset()                    { *m = MemoryStats{} }
func (m *MemoryStats) String() string            { return proto.CompactTextString(m) }
func (*MemoryStats) ProtoMessage()               {}
func (*MemoryStats) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{34} }

func (m *MemoryStats) GetUsage() *MemoryData {
	if m != nil {
		return m.Usage
	}
	return nil
}

func (m *MemoryStats) GetSwapUsage() *MemoryData {
	if m != nil {
		return m.SwapUsage
	}
	return nil
}

func (m *MemoryStats) GetKernelUsage() *MemoryData {
	if m != nil {
		return m.KernelUsage
	}
	return nil
}

func (m *MemoryStats) GetStats() map[string]uint64 {
	if m != nil {
		return m.Stats
	}
	return nil
}

type BlkioStatsEntry struct {
	Major uint64 `protobuf:"varint,1,opt,name=major" json:"major,omitempty"`
	Minor uint64 `protobuf:"varint,2,opt,name=minor" json:"minor,omitempty"`
	Op    string `protobuf:"bytes,3,opt,name=op" json:"op,omitempty"`
	Value uint64 `protobuf:"varint,4,opt,name=value" json:"value,omitempty"`
}

func (m *BlkioStatsEntry) Reset()                    { *m = BlkioStatsEntry{} }
func (m *BlkioStatsEntry) String() string            { return proto.CompactTextString(m) }
func (*BlkioStatsEntry) ProtoMessage()               {}
func (*BlkioStatsEntry) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{35} }

type BlkioStats struct {
	IoServiceBytesRecursive []*BlkioStatsEntry `protobuf:"bytes,1,rep,name=io_service_bytes_recursive,json=ioServiceBytesRecursive" json:"io_service_bytes_recursive,omitempty"`
	IoServicedRecursive     []*BlkioStatsEntry `protobuf:"bytes,2,rep,name=io_serviced_recursive,json=ioServicedRecursive" json:"io_serviced_recursive,omitempty"`
	IoQueuedRecursive       []*BlkioStatsEntry `protobuf:"bytes,3,rep,name=io_queued_recursive,json=ioQueuedRecursive" json:"io_queued_recursive,omitempty"`
	IoServiceTimeRecursive  []*BlkioStatsEntry `protobuf:"bytes,4,rep,name=io_service_time_recursive,json=ioServiceTimeRecursive" json:"io_service_time_recursive,omitempty"`
	IoWaitTimeRecursive     []*BlkioStatsEntry `protobuf:"bytes,5,rep,name=io_wait_time_recursive,json=ioWaitTimeRecursive" json:"io_wait_time_recursive,omitempty"`
	IoMergedRecursive       []*BlkioStatsEntry `protobuf:"bytes,6,rep,name=io_merged_recursive,json=ioMergedRecursive" json:"io_merged_recursive,omitempty"`
	IoTimeRecursive         []*BlkioStatsEntry `protobuf:"bytes,7,rep,name=io_time_recursive,json=ioTimeRecursive" json:"io_time_recursive,omitempty"`
	SectorsRecursive        []*BlkioStatsEntry `protobuf:"bytes,8,rep,name=sectors_recursive,json=sectorsRecursive" json:"sectors_recursive,omitempty"`
}

func (m *BlkioStats) Reset()                    { *m = BlkioStats{} }
func (m *BlkioStats) String() string            { return proto.CompactTextString(m) }
func (*BlkioStats) ProtoMessage()               {}
func (*BlkioStats) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{36} }

func (m *BlkioStats) GetIoServiceBytesRecursive() []*BlkioStatsEntry {
	if m != nil {
		return m.IoServiceBytesRecursive
	}
	return nil
}

func (m *BlkioStats) GetIoServicedRecursive() []*BlkioStatsEntry {
	if m != nil {
		return m.IoServicedRecursive
	}
	return nil
}

func (m *BlkioStats) GetIoQueuedRecursive() []*BlkioStatsEntry {
	if m != nil {
		return m.IoQueuedRecursive
	}
	return nil
}

func (m *BlkioStats) GetIoServiceTimeRecursive() []*BlkioStatsEntry {
	if m != nil {
		return m.IoServiceTimeRecursive
	}
	return nil
}

func (m *BlkioStats) GetIoWaitTimeRecursive() []*BlkioStatsEntry {
	if m != nil {
		return m.IoWaitTimeRecursive
	}
	return nil
}

func (m *BlkioStats) GetIoMergedRecursive() []*BlkioStatsEntry {
	if m != nil {
		return m.IoMergedRecursive
	}
	return nil
}

func (m *BlkioStats) GetIoTimeRecursive() []*BlkioStatsEntry {
	if m != nil {
		return m.IoTimeRecursive
	}
	return nil
}

func (m *BlkioStats) GetSectorsRecursive() []*BlkioStatsEntry {
	if m != nil {
		return m.SectorsRecursive
	}
	return nil
}

type HugetlbStats struct {
	Usage    uint64 `protobuf:"varint,1,opt,name=usage" json:"usage,omitempty"`
	MaxUsage uint64 `protobuf:"varint,2,opt,name=max_usage,json=maxUsage" json:"max_usage,omitempty"`
	Failcnt  uint64 `protobuf:"varint,3,opt,name=failcnt" json:"failcnt,omitempty"`
	Limit    uint64 `protobuf:"varint,4,opt,name=limit" json:"limit,omitempty"`
}

func (m *HugetlbStats) Reset()                    { *m = HugetlbStats{} }
func (m *HugetlbStats) String() string            { return proto.CompactTextString(m) }
func (*HugetlbStats) ProtoMessage()               {}
func (*HugetlbStats) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{37} }

type CgroupStats struct {
	CpuStats     *CpuStats                `protobuf:"bytes,1,opt,name=cpu_stats,json=cpuStats" json:"cpu_stats,omitempty"`
	MemoryStats  *MemoryStats             `protobuf:"bytes,2,opt,name=memory_stats,json=memoryStats" json:"memory_stats,omitempty"`
	BlkioStats   *BlkioStats              `protobuf:"bytes,3,opt,name=blkio_stats,json=blkioStats" json:"blkio_stats,omitempty"`
	HugetlbStats map[string]*HugetlbStats `protobuf:"bytes,4,rep,name=hugetlb_stats,json=hugetlbStats" json:"hugetlb_stats,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	PidsStats    *PidsStats               `protobuf:"bytes,5,opt,name=pids_stats,json=pidsStats" json:"pids_stats,omitempty"`
}

func (m *CgroupStats) Reset()                    { *m = CgroupStats{} }
func (m *CgroupStats) String() string            { return proto.CompactTextString(m) }
func (*CgroupStats) ProtoMessage()               {}
func (*CgroupStats) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{38} }

func (m *CgroupStats) GetCpuStats() *CpuStats {
	if m != nil {
		return m.CpuStats
	}
	return nil
}

func (m *CgroupStats) GetMemoryStats() *MemoryStats {
	if m != nil {
		return m.MemoryStats
	}
	return nil
}

func (m *CgroupStats) GetBlkioStats() *BlkioStats {
	if m != nil {
		return m.BlkioStats
	}
	return nil
}

func (m *CgroupStats) GetHugetlbStats() map[string]*HugetlbStats {
	if m != nil {
		return m.HugetlbStats
	}
	return nil
}

func (m *CgroupStats) GetPidsStats() *PidsStats {
	if m != nil {
		return m.PidsStats
	}
	return nil
}

type StatsResponse struct {
	NetworkStats []*NetworkStats `protobuf:"bytes,1,rep,name=network_stats,json=networkStats" json:"network_stats,omitempty"`
	CgroupStats  *CgroupStats    `protobuf:"bytes,2,opt,name=cgroup_stats,json=cgroupStats" json:"cgroup_stats,omitempty"`
	Timestamp    uint64          `protobuf:"varint,3,opt,name=timestamp" json:"timestamp,omitempty"`
}

func (m *StatsResponse) Reset()                    { *m = StatsResponse{} }
func (m *StatsResponse) String() string            { return proto.CompactTextString(m) }
func (*StatsResponse) ProtoMessage()               {}
func (*StatsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{39} }

func (m *StatsResponse) GetNetworkStats() []*NetworkStats {
	if m != nil {
		return m.NetworkStats
	}
	return nil
}

func (m *StatsResponse) GetCgroupStats() *CgroupStats {
	if m != nil {
		return m.CgroupStats
	}
	return nil
}

type StatsRequest struct {
	Id string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
}

func (m *StatsRequest) Reset()                    { *m = StatsRequest{} }
func (m *StatsRequest) String() string            { return proto.CompactTextString(m) }
func (*StatsRequest) ProtoMessage()               {}
func (*StatsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{40} }

func init() {
	proto.RegisterType((*UpdateProcessRequest)(nil), "types.UpdateProcessRequest")
	proto.RegisterType((*UpdateProcessResponse)(nil), "types.UpdateProcessResponse")
	proto.RegisterType((*CreateContainerRequest)(nil), "types.CreateContainerRequest")
	proto.RegisterType((*CreateContainerResponse)(nil), "types.CreateContainerResponse")
	proto.RegisterType((*SignalRequest)(nil), "types.SignalRequest")
	proto.RegisterType((*SignalResponse)(nil), "types.SignalResponse")
	proto.RegisterType((*AddProcessRequest)(nil), "types.AddProcessRequest")
	proto.RegisterType((*Rlimit)(nil), "types.Rlimit")
	proto.RegisterType((*User)(nil), "types.User")
	proto.RegisterType((*AddProcessResponse)(nil), "types.AddProcessResponse")
	proto.RegisterType((*CreateCheckpointRequest)(nil), "types.CreateCheckpointRequest")
	proto.RegisterType((*CreateCheckpointResponse)(nil), "types.CreateCheckpointResponse")
	proto.RegisterType((*DeleteCheckpointRequest)(nil), "types.DeleteCheckpointRequest")
	proto.RegisterType((*DeleteCheckpointResponse)(nil), "types.DeleteCheckpointResponse")
	proto.RegisterType((*ListCheckpointRequest)(nil), "types.ListCheckpointRequest")
	proto.RegisterType((*Checkpoint)(nil), "types.Checkpoint")
	proto.RegisterType((*ListCheckpointResponse)(nil), "types.ListCheckpointResponse")
	proto.RegisterType((*StateRequest)(nil), "types.StateRequest")
	proto.RegisterType((*ContainerState)(nil), "types.ContainerState")
	proto.RegisterType((*Process)(nil), "types.Process")
	proto.RegisterType((*Container)(nil), "types.Container")
	proto.RegisterType((*Machine)(nil), "types.Machine")
	proto.RegisterType((*StateResponse)(nil), "types.StateResponse")
	proto.RegisterType((*UpdateContainerRequest)(nil), "types.UpdateContainerRequest")
	proto.RegisterType((*UpdateResource)(nil), "types.UpdateResource")
	proto.RegisterType((*UpdateContainerResponse)(nil), "types.UpdateContainerResponse")
	proto.RegisterType((*EventsRequest)(nil), "types.EventsRequest")
	proto.RegisterType((*Event)(nil), "types.Event")
	proto.RegisterType((*NetworkStats)(nil), "types.NetworkStats")
	proto.RegisterType((*CpuUsage)(nil), "types.CpuUsage")
	proto.RegisterType((*ThrottlingData)(nil), "types.ThrottlingData")
	proto.RegisterType((*CpuStats)(nil), "types.CpuStats")
	proto.RegisterType((*PidsStats)(nil), "types.PidsStats")
	proto.RegisterType((*MemoryData)(nil), "types.MemoryData")
	proto.RegisterType((*MemoryStats)(nil), "types.MemoryStats")
	proto.RegisterType((*BlkioStatsEntry)(nil), "types.BlkioStatsEntry")
	proto.RegisterType((*BlkioStats)(nil), "types.BlkioStats")
	proto.RegisterType((*HugetlbStats)(nil), "types.HugetlbStats")
	proto.RegisterType((*CgroupStats)(nil), "types.CgroupStats")
	proto.RegisterType((*StatsResponse)(nil), "types.StatsResponse")
	proto.RegisterType((*StatsRequest)(nil), "types.StatsRequest")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// Client API for API service

type APIClient interface {
	CreateContainer(ctx context.Context, in *CreateContainerRequest, opts ...grpc.CallOption) (*CreateContainerResponse, error)
	UpdateContainer(ctx context.Context, in *UpdateContainerRequest, opts ...grpc.CallOption) (*UpdateContainerResponse, error)
	Signal(ctx context.Context, in *SignalRequest, opts ...grpc.CallOption) (*SignalResponse, error)
	UpdateProcess(ctx context.Context, in *UpdateProcessRequest, opts ...grpc.CallOption) (*UpdateProcessResponse, error)
	AddProcess(ctx context.Context, in *AddProcessRequest, opts ...grpc.CallOption) (*AddProcessResponse, error)
	CreateCheckpoint(ctx context.Context, in *CreateCheckpointRequest, opts ...grpc.CallOption) (*CreateCheckpointResponse, error)
	DeleteCheckpoint(ctx context.Context, in *DeleteCheckpointRequest, opts ...grpc.CallOption) (*DeleteCheckpointResponse, error)
	ListCheckpoint(ctx context.Context, in *ListCheckpointRequest, opts ...grpc.CallOption) (*ListCheckpointResponse, error)
	State(ctx context.Context, in *StateRequest, opts ...grpc.CallOption) (*StateResponse, error)
	Events(ctx context.Context, in *EventsRequest, opts ...grpc.CallOption) (API_EventsClient, error)
	Stats(ctx context.Context, in *StatsRequest, opts ...grpc.CallOption) (*StatsResponse, error)
}

type aPIClient struct {
	cc *grpc.ClientConn
}

func NewAPIClient(cc *grpc.ClientConn) APIClient {
	return &aPIClient{cc}
}

func (c *aPIClient) CreateContainer(ctx context.Context, in *CreateContainerRequest, opts ...grpc.CallOption) (*CreateContainerResponse, error) {
	out := new(CreateContainerResponse)
	err := grpc.Invoke(ctx, "/types.API/CreateContainer", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aPIClient) UpdateContainer(ctx context.Context, in *UpdateContainerRequest, opts ...grpc.CallOption) (*UpdateContainerResponse, error) {
	out := new(UpdateContainerResponse)
	err := grpc.Invoke(ctx, "/types.API/UpdateContainer", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aPIClient) Signal(ctx context.Context, in *SignalRequest, opts ...grpc.CallOption) (*SignalResponse, error) {
	out := new(SignalResponse)
	err := grpc.Invoke(ctx, "/types.API/Signal", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aPIClient) UpdateProcess(ctx context.Context, in *UpdateProcessRequest, opts ...grpc.CallOption) (*UpdateProcessResponse, error) {
	out := new(UpdateProcessResponse)
	err := grpc.Invoke(ctx, "/types.API/UpdateProcess", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aPIClient) AddProcess(ctx context.Context, in *AddProcessRequest, opts ...grpc.CallOption) (*AddProcessResponse, error) {
	out := new(AddProcessResponse)
	err := grpc.Invoke(ctx, "/types.API/AddProcess", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aPIClient) CreateCheckpoint(ctx context.Context, in *CreateCheckpointRequest, opts ...grpc.CallOption) (*CreateCheckpointResponse, error) {
	out := new(CreateCheckpointResponse)
	err := grpc.Invoke(ctx, "/types.API/CreateCheckpoint", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aPIClient) DeleteCheckpoint(ctx context.Context, in *DeleteCheckpointRequest, opts ...grpc.CallOption) (*DeleteCheckpointResponse, error) {
	out := new(DeleteCheckpointResponse)
	err := grpc.Invoke(ctx, "/types.API/DeleteCheckpoint", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aPIClient) ListCheckpoint(ctx context.Context, in *ListCheckpointRequest, opts ...grpc.CallOption) (*ListCheckpointResponse, error) {
	out := new(ListCheckpointResponse)
	err := grpc.Invoke(ctx, "/types.API/ListCheckpoint", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aPIClient) State(ctx context.Context, in *StateRequest, opts ...grpc.CallOption) (*StateResponse, error) {
	out := new(StateResponse)
	err := grpc.Invoke(ctx, "/types.API/State", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aPIClient) Events(ctx context.Context, in *EventsRequest, opts ...grpc.CallOption) (API_EventsClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_API_serviceDesc.Streams[0], c.cc, "/types.API/Events", opts...)
	if err != nil {
		return nil, err
	}
	x := &aPIEventsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type API_EventsClient interface {
	Recv() (*Event, error)
	grpc.ClientStream
}

type aPIEventsClient struct {
	grpc.ClientStream
}

func (x *aPIEventsClient) Recv() (*Event, error) {
	m := new(Event)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *aPIClient) Stats(ctx context.Context, in *StatsRequest, opts ...grpc.CallOption) (*StatsResponse, error) {
	out := new(StatsResponse)
	err := grpc.Invoke(ctx, "/types.API/Stats", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for API service

type APIServer interface {
	CreateContainer(context.Context, *CreateContainerRequest) (*CreateContainerResponse, error)
	UpdateContainer(context.Context, *UpdateContainerRequest) (*UpdateContainerResponse, error)
	Signal(context.Context, *SignalRequest) (*SignalResponse, error)
	UpdateProcess(context.Context, *UpdateProcessRequest) (*UpdateProcessResponse, error)
	AddProcess(context.Context, *AddProcessRequest) (*AddProcessResponse, error)
	CreateCheckpoint(context.Context, *CreateCheckpointRequest) (*CreateCheckpointResponse, error)
	DeleteCheckpoint(context.Context, *DeleteCheckpointRequest) (*DeleteCheckpointResponse, error)
	ListCheckpoint(context.Context, *ListCheckpointRequest) (*ListCheckpointResponse, error)
	State(context.Context, *StateRequest) (*StateResponse, error)
	Events(*EventsRequest, API_EventsServer) error
	Stats(context.Context, *StatsRequest) (*StatsResponse, error)
}

func RegisterAPIServer(s *grpc.Server, srv APIServer) {
	s.RegisterService(&_API_serviceDesc, srv)
}

func _API_CreateContainer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error) (interface{}, error) {
	in := new(CreateContainerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	out, err := srv.(APIServer).CreateContainer(ctx, in)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func _API_UpdateContainer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error) (interface{}, error) {
	in := new(UpdateContainerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	out, err := srv.(APIServer).UpdateContainer(ctx, in)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func _API_Signal_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error) (interface{}, error) {
	in := new(SignalRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	out, err := srv.(APIServer).Signal(ctx, in)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func _API_UpdateProcess_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error) (interface{}, error) {
	in := new(UpdateProcessRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	out, err := srv.(APIServer).UpdateProcess(ctx, in)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func _API_AddProcess_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error) (interface{}, error) {
	in := new(AddProcessRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	out, err := srv.(APIServer).AddProcess(ctx, in)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func _API_CreateCheckpoint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error) (interface{}, error) {
	in := new(CreateCheckpointRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	out, err := srv.(APIServer).CreateCheckpoint(ctx, in)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func _API_DeleteCheckpoint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error) (interface{}, error) {
	in := new(DeleteCheckpointRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	out, err := srv.(APIServer).DeleteCheckpoint(ctx, in)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func _API_ListCheckpoint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error) (interface{}, error) {
	in := new(ListCheckpointRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	out, err := srv.(APIServer).ListCheckpoint(ctx, in)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func _API_State_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error) (interface{}, error) {
	in := new(StateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	out, err := srv.(APIServer).State(ctx, in)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func _API_Events_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(EventsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(APIServer).Events(m, &aPIEventsServer{stream})
}

type API_EventsServer interface {
	Send(*Event) error
	grpc.ServerStream
}

type aPIEventsServer struct {
	grpc.ServerStream
}

func (x *aPIEventsServer) Send(m *Event) error {
	return x.ServerStream.SendMsg(m)
}

func _API_Stats_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error) (interface{}, error) {
	in := new(StatsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	out, err := srv.(APIServer).Stats(ctx, in)
	if err != nil {
		return nil, err
	}
	return out, nil
}

var _API_serviceDesc = grpc.ServiceDesc{
	ServiceName: "types.API",
	HandlerType: (*APIServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateContainer",
			Handler:    _API_CreateContainer_Handler,
		},
		{
			MethodName: "UpdateContainer",
			Handler:    _API_UpdateContainer_Handler,
		},
		{
			MethodName: "Signal",
			Handler:    _API_Signal_Handler,
		},
		{
			MethodName: "UpdateProcess",
			Handler:    _API_UpdateProcess_Handler,
		},
		{
			MethodName: "AddProcess",
			Handler:    _API_AddProcess_Handler,
		},
		{
			MethodName: "CreateCheckpoint",
			Handler:    _API_CreateCheckpoint_Handler,
		},
		{
			MethodName: "DeleteCheckpoint",
			Handler:    _API_DeleteCheckpoint_Handler,
		},
		{
			MethodName: "ListCheckpoint",
			Handler:    _API_ListCheckpoint_Handler,
		},
		{
			MethodName: "State",
			Handler:    _API_State_Handler,
		},
		{
			MethodName: "Stats",
			Handler:    _API_Stats_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Events",
			Handler:       _API_Events_Handler,
			ServerStreams: true,
		},
	},
}

var fileDescriptor0 = []byte{
	// 2212 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xec, 0x39, 0x4b, 0x73, 0x1c, 0x49,
	0xd1, 0x9e, 0xa7, 0x34, 0x39, 0x0f, 0x49, 0x6d, 0x3d, 0xc6, 0xb3, 0x6b, 0xaf, 0xbf, 0x8e, 0x0f,
	0xd6, 0xc0, 0x22, 0x8c, 0xbc, 0x1b, 0x38, 0x20, 0x20, 0x62, 0x2d, 0x1b, 0x30, 0x6b, 0x2d, 0x72,
	0x4b, 0x8a, 0xbd, 0x10, 0x31, 0xd1, 0x9a, 0x2e, 0xcf, 0x34, 0xea, 0xe9, 0xee, 0xed, 0xae, 0xd1,
	0xe3, 0xc2, 0x11, 0x6e, 0x1c, 0xb9, 0x10, 0xc1, 0x85, 0x1b, 0x77, 0x0e, 0xfc, 0x02, 0xfe, 0x09,
	0xb1, 0x3f, 0x81, 0x23, 0x59, 0x95, 0xd5, 0x55, 0xd5, 0xf3, 0x90, 0x96, 0x03, 0xc1, 0x85, 0xcb,
	0x44, 0xe5, 0xa3, 0x32, 0xb3, 0xf2, 0x55, 0xd9, 0x35, 0xd0, 0xf2, 0xd3, 0x70, 0x3f, 0xcd, 0x12,
	0x9e, 0x38, 0x0d, 0x7e, 0x93, 0xb2, 0xdc, 0xfd, 0x6d, 0x05, 0xb6, 0xcf, 0xd2, 0xc0, 0xe7, 0xec,
	0x38, 0x4b, 0x46, 0x2c, 0xcf, 0x3d, 0xf6, 0xe5, 0x8c, 0xe5, 0xdc, 0xe9, 0x41, 0x35, 0x0c, 0xfa,
	0x95, 0xc7, 0x95, 0x27, 0x2d, 0x0f, 0x57, 0xce, 0x26, 0xd4, 0x52, 0x44, 0x54, 0x25, 0x42, 0x2c,
	0x9d, 0x47, 0x00, 0xa3, 0x28, 0xc9, 0xd9, 0x09, 0x0f, 0xc2, 0xb8, 0x5f, 0x43, 0xc2, 0xba, 0x67,
	0x61, 0x9c, 0x6d, 0x68, 0x5c, 0x85, 0x01, 0x9f, 0xf4, 0xeb, 0x48, 0xea, 0x7a, 0x04, 0x38, 0xbb,
	0xd0, 0x9c, 0xb0, 0x70, 0x3c, 0xe1, 0xfd, 0x86, 0x44, 0x2b, 0xc8, 0xdd, 0x83, 0x9d, 0x39, 0x3b,
	0xf2, 0x34, 0x89, 0x73, 0xe6, 0x7e, 0x55, 0x81, 0xdd, 0xc3, 0x8c, 0x21, 0xe5, 0x30, 0x89, 0xb9,
	0x1f, 0xc6, 0x2c, 0x5b, 0x65, 0x23, 0x5a, 0x74, 0x3e, 0x8b, 0x83, 0x88, 0x1d, 0xfb, 0xa8, 0x96,
	0x4c, 0xb5, 0x30, 0xd2, 0xe2, 0x09, 0x1b, 0x5d, 0xa4, 0x49, 0x18, 0x73, 0x69, 0x31, 0xd2, 0x0d,
	0x46, 0x58, 0x9c, 0xcb, 0xc3, 0xd4, 0x25, 0x89, 0x00, 0x61, 0x31, 0x2e, 0x92, 0x19, 0x59, 0xdc,
	0xf2, 0x14, 0xa4, 0xf0, 0x2c, 0xcb, 0xfa, 0x4d, 0x8d, 0x47, 0x48, 0xe0, 0x23, 0xff, 0x9c, 0x45,
	0x79, 0x7f, 0xed, 0x71, 0x4d, 0xe0, 0x09, 0x72, 0x1e, 0x43, 0x3b, 0x4e, 0x8e, 0xc3, 0xcb, 0x84,
	0x7b, 0x49, 0xc2, 0xfb, 0xeb, 0xd2, 0x61, 0x36, 0xca, 0x7d, 0x0d, 0x7b, 0x0b, 0x27, 0x25, 0x2f,
	0x38, 0xfb, 0xd0, 0x1a, 0x15, 0x48, 0x79, 0xe2, 0xf6, 0xc1, 0xe6, 0xbe, 0x0c, 0xe1, 0xbe, 0x61,
	0x36, 0x2c, 0x28, 0xaa, 0x7b, 0x12, 0x8e, 0x63, 0x3f, 0xfa, 0xfa, 0xf1, 0x14, 0xe7, 0x91, 0x5b,
	0xa4, 0x67, 0x30, 0x32, 0x04, 0xb9, 0x9b, 0xd0, 0x2b, 0x44, 0xa9, 0x90, 0xfc, 0xb5, 0x06, 0x5b,
	0x9f, 0x06, 0xc1, 0x1d, 0x19, 0x33, 0x80, 0x75, 0xce, 0xb2, 0x69, 0x28, 0x24, 0x56, 0xe5, 0x61,
	0x35, 0xec, 0x7c, 0x00, 0xf5, 0x59, 0x8e, 0x27, 0xa9, 0xc9, 0x93, 0xb4, 0xd5, 0x49, 0xce, 0x10,
	0xe5, 0x49, 0x82, 0xe3, 0x40, 0xdd, 0xcf, 0xc6, 0x39, 0x46, 0x42, 0xb8, 0x50, 0xae, 0x85, 0xc9,
	0x2c, 0xbe, 0xc4, 0x28, 0x08, 0x94, 0x58, 0x0a, 0xcc, 0xe8, 0x2a, 0x50, 0xfe, 0x17, 0xcb, 0xe2,
	0x58, 0x6b, 0xe6, 0x58, 0x3a, 0xa8, 0xeb, 0xcb, 0x83, 0xda, 0x5a, 0x11, 0x54, 0x28, 0x05, 0xd5,
	0x85, 0xce, 0xc8, 0x4f, 0xfd, 0xf3, 0x30, 0x0a, 0x79, 0xc8, 0xf2, 0x7e, 0x5b, 0x1a, 0x51, 0xc2,
	0x39, 0x4f, 0x60, 0xc3, 0x4f, 0x53, 0x3f, 0x9b, 0x26, 0x19, 0xba, 0xe6, 0x5d, 0x18, 0xb1, 0x7e,
	0x47, 0x0a, 0x99, 0x47, 0x0b, 0x69, 0x39, 0x8b, 0xc2, 0x78, 0x76, 0xfd, 0x46, 0xe4, 0x46, 0xbf,
	0x2b, 0xd9, 0x4a, 0x38, 0x21, 0x2d, 0x4e, 0x3e, 0x67, 0x57, 0xc7, 0x59, 0x78, 0x89, 0x7b, 0xc6,
	0xa8, 0xb4, 0x27, 0xbd, 0x38, 0x8f, 0x76, 0x3e, 0x84, 0xb5, 0x2c, 0x0a, 0xa7, 0x21, 0xcf, 0xfb,
	0x1b, 0x68, 0x56, 0xfb, 0xa0, 0xab, 0xfc, 0xe9, 0x49, 0xac, 0x57, 0x50, 0xdd, 0x97, 0xd0, 0x24,
	0x94, 0x70, 0xaf, 0x60, 0x51, 0xd1, 0x92, 0x6b, 0x81, 0xcb, 0x93, 0x77, 0x5c, 0xc6, 0xaa, 0xee,
	0xc9, 0xb5, 0xc0, 0x4d, 0xfc, 0x2c, 0x90, 0x71, 0x42, 0x9c, 0x58, 0xbb, 0x1e, 0xd4, 0x45, 0xa0,
	0x84, 0xab, 0x67, 0x2a, 0xe0, 0x5d, 0x4f, 0x2c, 0x05, 0x66, 0xac, 0x72, 0x0a, 0x31, 0xb8, 0x74,
	0xbe, 0x09, 0x3d, 0x3f, 0x08, 0xd0, 0x3d, 0x09, 0x46, 0xfd, 0x67, 0x61, 0x90, 0xa3, 0xa4, 0x1a,
	0x12, 0xe7, 0xb0, 0xee, 0x36, 0x38, 0x76, 0x42, 0xa9, 0x3c, 0xfb, 0x95, 0xae, 0x07, 0x5d, 0xa3,
	0xab, 0x92, 0xed, 0xfb, 0xa5, 0xd2, 0xae, 0xca, 0xb4, 0xda, 0x2a, 0x0a, 0xc4, 0xec, 0xb6, 0x98,
	0xdc, 0x01, 0xf4, 0x17, 0xa5, 0x2b, 0xcd, 0x3f, 0x86, 0xbd, 0x97, 0x2c, 0x62, 0x5f, 0x47, 0x33,
	0xba, 0x28, 0xf6, 0xa7, 0x4c, 0x55, 0x92, 0x5c, 0x0b, 0xd1, 0x8b, 0xdb, 0x95, 0xe8, 0x0f, 0x61,
	0xe7, 0x4d, 0x98, 0xf3, 0x3b, 0x05, 0xbb, 0xbf, 0x01, 0x30, 0x4c, 0x5a, 0x4d, 0xc5, 0xa8, 0x11,
	0x38, 0x76, 0x1d, 0x72, 0x55, 0x5d, 0x72, 0x2d, 0x62, 0xc0, 0x47, 0xa9, 0x6a, 0xc7, 0x62, 0x29,
	0xfa, 0xce, 0x2c, 0x0e, 0xaf, 0x4f, 0x92, 0xd1, 0x05, 0xe3, 0xb9, 0xec, 0x6d, 0xd8, 0x77, 0x2c,
	0x94, 0x2c, 0x91, 0x09, 0x8b, 0x22, 0xd9, 0xe0, 0xd6, 0x3d, 0x02, 0xdc, 0x23, 0xd8, 0x9d, 0x37,
	0x54, 0x35, 0xa3, 0x67, 0xd0, 0x36, 0x7e, 0xcc, 0xd1, 0xa4, 0xda, 0x72, 0x6f, 0xdb, 0x5c, 0xee,
	0x23, 0xe8, 0x9c, 0x70, 0xf4, 0xf6, 0xaa, 0xe3, 0x3e, 0x81, 0x9e, 0xee, 0x64, 0x92, 0x91, 0x6a,
	0xd1, 0xe7, 0xb3, 0x5c, 0x71, 0x29, 0xc8, 0xfd, 0x5b, 0x0d, 0xd6, 0x54, 0xaa, 0x14, 0xf5, 0x5e,
	0x31, 0xf5, 0xfe, 0x5f, 0x69, 0x3b, 0xef, 0x43, 0x2b, 0xbf, 0xc9, 0x39, 0x9b, 0x1e, 0xab, 0xe6,
	0xd3, 0xf5, 0x0c, 0xe2, 0x7f, 0x2d, 0xc8, 0xb4, 0xa0, 0xbf, 0x57, 0xa0, 0xa5, 0xc3, 0xfc, 0x6f,
	0x5f, 0xe0, 0x1f, 0x41, 0x2b, 0xa5, 0xc0, 0x33, 0xea, 0x24, 0xed, 0x83, 0x9e, 0x52, 0x54, 0xf4,
	0x0e, 0xc3, 0x60, 0xe5, 0x4f, 0xdd, 0xce, 0x1f, 0xeb, 0x82, 0x6e, 0x94, 0x2e, 0x68, 0x0c, 0x7e,
	0x2a, 0x5a, 0x54, 0x53, 0xb6, 0x28, 0xb9, 0x76, 0xfa, 0x78, 0xb0, 0x59, 0xcc, 0x43, 0xac, 0x3c,
	0xba, 0x53, 0x0a, 0xd0, 0xfd, 0x04, 0xd6, 0x8e, 0xfc, 0xd1, 0x04, 0xcf, 0x21, 0x36, 0x8e, 0x52,
	0x95, 0xa6, 0xb8, 0x51, 0xac, 0x85, 0x92, 0x29, 0x43, 0x7f, 0xdf, 0xa8, 0x7e, 0xaa, 0x20, 0xf7,
	0x02, 0x2f, 0x66, 0x2a, 0x03, 0x55, 0x4c, 0x4f, 0xb1, 0x73, 0x15, 0x0e, 0x29, 0x6a, 0x69, 0xf1,
	0x6a, 0xb7, 0x78, 0x30, 0x2c, 0x6b, 0x53, 0xd2, 0xac, 0x1a, 0x5d, 0xe1, 0x03, 0x65, 0x8f, 0x57,
	0x90, 0xdd, 0xdf, 0xe1, 0xec, 0x44, 0x53, 0xd5, 0x9d, 0xb3, 0xd3, 0xf2, 0x79, 0x80, 0xdc, 0x57,
	0x2b, 0xb9, 0xef, 0x19, 0xb4, 0x32, 0x96, 0x27, 0xb3, 0x0c, 0xdd, 0x2c, 0x3d, 0xdb, 0x3e, 0xd8,
	0x29, 0x2a, 0x49, 0xea, 0xf2, 0x14, 0xd5, 0x33, 0x7c, 0xee, 0x57, 0x55, 0xe8, 0x95, 0xa9, 0xa2,
	0x2f, 0x9d, 0x47, 0x17, 0x61, 0xf2, 0x05, 0x8d, 0x83, 0xe4, 0x3c, 0x1b, 0x25, 0xaa, 0x0a, 0x7d,
	0x79, 0x82, 0xb7, 0x0e, 0x6a, 0xa2, 0x5b, 0xc5, 0x20, 0x14, 0xf5, 0x98, 0x65, 0x61, 0x12, 0xa8,
	0x91, 0xc5, 0x20, 0x44, 0x1b, 0x40, 0xe0, 0xed, 0x2c, 0xe1, 0xbe, 0x1a, 0x40, 0x35, 0x2c, 0xe7,
	0x40, 0x8c, 0x11, 0xe3, 0x87, 0x22, 0x6a, 0x0d, 0x35, 0x07, 0x6a, 0x8c, 0xa1, 0x1f, 0xb1, 0x69,
	0xae, 0xca, 0xdc, 0xc2, 0x08, 0xcb, 0x29, 0x9a, 0x6f, 0x44, 0x52, 0xab, 0x7a, 0xb7, 0x51, 0x42,
	0x02, 0x81, 0x27, 0x57, 0x7e, 0x2a, 0xcb, 0xbe, 0xeb, 0x59, 0x18, 0x4c, 0xe4, 0x2d, 0x82, 0xd0,
	0x1b, 0x2c, 0xbb, 0xf4, 0xc5, 0x55, 0x28, 0xdb, 0x40, 0xd7, 0x5b, 0x24, 0x08, 0xee, 0x0b, 0x96,
	0xc5, 0x2c, 0x3a, 0xb2, 0xb4, 0x02, 0x71, 0x2f, 0x10, 0xdc, 0x07, 0xb0, 0xb7, 0x10, 0x73, 0x75,
	0xf7, 0x7c, 0x17, 0xba, 0xaf, 0x2e, 0x19, 0x76, 0xe3, 0x22, 0x0b, 0xd0, 0x87, 0x22, 0x99, 0x31,
	0xb2, 0xd3, 0x54, 0x46, 0xa0, 0xee, 0x19, 0x84, 0x9b, 0x43, 0x43, 0xb2, 0x2f, 0x1d, 0x17, 0x28,
	0x81, 0xaa, 0x3a, 0x81, 0xca, 0xe9, 0xd2, 0xd5, 0xe9, 0xa2, 0x12, 0xab, 0x6e, 0x12, 0xab, 0xa4,
	0xb4, 0x31, 0xaf, 0xf4, 0xf7, 0x55, 0xe8, 0x7c, 0xce, 0xf8, 0x55, 0x92, 0x5d, 0x88, 0x42, 0xc9,
	0x97, 0xde, 0x7c, 0x0f, 0x60, 0x3d, 0xbb, 0x1e, 0x9e, 0xdf, 0x70, 0x95, 0x18, 0x75, 0xac, 0xcb,
	0xeb, 0x17, 0x02, 0x74, 0x1e, 0x02, 0x20, 0xe9, 0xd8, 0xa7, 0xdb, 0x8e, 0x06, 0x97, 0x56, 0x76,
	0xad, 0x10, 0xce, 0x7b, 0xd0, 0xf2, 0xae, 0x87, 0xd8, 0x4f, 0x93, 0x8c, 0xb2, 0xb7, 0xee, 0xa1,
	0xa8, 0x57, 0x12, 0x16, 0x7b, 0x91, 0x18, 0x64, 0x49, 0x9a, 0xb2, 0xa0, 0x30, 0x2d, 0xbb, 0x7e,
	0x49, 0x08, 0xa1, 0xf5, 0xb4, 0xd0, 0xda, 0x24, 0xad, 0xdc, 0x68, 0x45, 0x52, 0xaa, 0xb4, 0xae,
	0xa9, 0x43, 0xd9, 0x5a, 0x4f, 0xb5, 0xd6, 0x75, 0xd2, 0xca, 0x2d, 0xad, 0xa7, 0x46, 0x6b, 0xab,
	0xd8, 0xab, 0xb4, 0xba, 0x7f, 0xa9, 0xc0, 0x3a, 0xa6, 0xe5, 0x59, 0xee, 0x8f, 0x19, 0xde, 0x60,
	0x6d, 0x8e, 0x29, 0x1c, 0x0d, 0x67, 0x02, 0x54, 0x21, 0x03, 0x89, 0x22, 0x86, 0xff, 0x83, 0x4e,
	0xca, 0x32, 0x4c, 0x56, 0xc5, 0x51, 0xc5, 0x86, 0x52, 0xf7, 0xda, 0x84, 0x23, 0x96, 0x7d, 0xb8,
	0x2f, 0x69, 0xc3, 0x30, 0x1e, 0x52, 0xfa, 0x4c, 0x93, 0x80, 0x29, 0x57, 0x6d, 0x49, 0xd2, 0xeb,
	0xf8, 0x33, 0x4d, 0x70, 0xbe, 0x0d, 0x5b, 0x9a, 0x5f, 0xdc, 0x92, 0x92, 0x9b, 0x5c, 0xb7, 0xa1,
	0xb8, 0xcf, 0x14, 0x1a, 0x87, 0x96, 0xde, 0xe9, 0x04, 0x3f, 0x30, 0x39, 0x5e, 0x23, 0xe3, 0x97,
	0x3e, 0x16, 0x1b, 0x76, 0xd0, 0x54, 0x96, 0x64, 0xae, 0xac, 0x2d, 0x40, 0xe7, 0x3b, 0xb0, 0xc5,
	0x89, 0x97, 0x05, 0xc3, 0x82, 0x87, 0xa2, 0xb9, 0xa9, 0x09, 0xc7, 0x8a, 0xf9, 0x1b, 0xd0, 0x33,
	0xcc, 0xb2, 0x1f, 0x93, 0xbd, 0x5d, 0x8d, 0x3d, 0x15, 0x5d, 0xf9, 0x8f, 0xe4, 0x2c, 0xca, 0x9c,
	0x8f, 0x64, 0x87, 0xb0, 0x5c, 0xd5, 0x3e, 0xd8, 0x28, 0x3a, 0xab, 0x72, 0x86, 0xec, 0x0a, 0xe4,
	0x96, 0x9f, 0xc0, 0x06, 0xd7, 0xa6, 0x0f, 0xb1, 0x80, 0x7c, 0xd5, 0x5e, 0x8b, 0xee, 0x56, 0x3e,
	0x98, 0xd7, 0xe3, 0xe5, 0x83, 0xa2, 0xe7, 0xe9, 0xca, 0x57, 0x0a, 0xc9, 0xbe, 0x36, 0xe1, 0xa4,
	0x0a, 0xf7, 0x47, 0xd0, 0xc2, 0x79, 0x20, 0x27, 0xeb, 0xd0, 0x31, 0xa3, 0x59, 0x96, 0x61, 0x7d,
	0x15, 0x8e, 0x51, 0xa0, 0x98, 0x17, 0xe4, 0x75, 0xa9, 0x9c, 0x41, 0x80, 0x9b, 0x00, 0x50, 0x99,
	0x4b, 0x6d, 0xc8, 0x63, 0xa7, 0x00, 0x01, 0x22, 0xcf, 0xa6, 0xfe, 0xb5, 0x0e, 0xbd, 0xcc, 0x33,
	0x44, 0xd0, 0x01, 0x51, 0xe1, 0x3b, 0x3f, 0x8c, 0x46, 0xea, 0xdb, 0x17, 0x15, 0x2a, 0xd0, 0x28,
	0xac, 0xdb, 0x0a, 0xff, 0x5c, 0x85, 0x36, 0x69, 0x24, 0x83, 0x91, 0x6b, 0x84, 0x17, 0x8b, 0x56,
	0x29, 0x01, 0xbc, 0xfa, 0x1b, 0x46, 0x9d, 0x19, 0x03, 0x8d, 0xa9, 0x85, 0x6d, 0x78, 0xd1, 0xe5,
	0xd8, 0xfb, 0x2c, 0xef, 0x2c, 0xe5, 0x6e, 0x09, 0x26, 0x32, 0xf8, 0x63, 0xe8, 0x50, 0x7e, 0xaa,
	0x3d, 0xf5, 0x55, 0x7b, 0xda, 0xc4, 0x46, 0xbb, 0x9e, 0x89, 0x69, 0x0b, 0xed, 0x95, 0xb7, 0x7b,
	0xfb, 0xe0, 0x61, 0x89, 0x5d, 0x9e, 0x64, 0x5f, 0xfe, 0xbe, 0x8a, 0x39, 0xb6, 0x59, 0xe2, 0x1d,
	0x3c, 0x07, 0x30, 0x48, 0xd1, 0xb3, 0x2e, 0xd8, 0x4d, 0x31, 0x55, 0xe2, 0x52, 0x9c, 0xfd, 0xd2,
	0x8f, 0x66, 0x85, 0x53, 0x09, 0xf8, 0x61, 0xf5, 0x79, 0xc5, 0x1d, 0xc1, 0xc6, 0x0b, 0x71, 0x67,
	0x59, 0xdb, 0x91, 0x79, 0xea, 0xff, 0x3a, 0xc9, 0x0a, 0x47, 0x49, 0x40, 0x62, 0xc3, 0x18, 0xb1,
	0x4a, 0x84, 0x04, 0x44, 0x1b, 0x4d, 0x52, 0x75, 0xc3, 0xe2, 0xca, 0x28, 0xaa, 0x5b, 0x8a, 0xdc,
	0x7f, 0xd4, 0x01, 0x8c, 0x16, 0xe7, 0x04, 0x06, 0x61, 0x32, 0x14, 0x17, 0x44, 0x38, 0x62, 0xd4,
	0x90, 0x86, 0x19, 0xc3, 0xf4, 0xc9, 0xc3, 0x4b, 0xa6, 0x66, 0x88, 0x5d, 0x75, 0xee, 0x39, 0xe3,
	0xbc, 0x3d, 0x84, 0x68, 0xa3, 0xec, 0x5c, 0x5e, 0xb1, 0xcd, 0xf9, 0x05, 0xec, 0x18, 0xa1, 0x81,
	0x25, 0xaf, 0x7a, 0xab, 0xbc, 0xfb, 0x5a, 0x5e, 0x60, 0x64, 0xfd, 0x14, 0x10, 0x3d, 0xc4, 0x3b,
	0x66, 0x56, 0x92, 0x54, 0xbb, 0x55, 0xd2, 0x56, 0x98, 0xbc, 0x95, 0x3b, 0x8c, 0x9c, 0xb7, 0xf0,
	0xc0, 0x3a, 0xa8, 0x28, 0x7b, 0x4b, 0x5a, 0xfd, 0x56, 0x69, 0xbb, 0xda, 0x2e, 0xd1, 0x18, 0x8c,
	0xc8, 0xcf, 0x00, 0x29, 0xc3, 0x2b, 0x3f, 0xe4, 0xf3, 0xf2, 0x1a, 0x77, 0x9d, 0xf3, 0x0b, 0xdc,
	0x54, 0x16, 0x46, 0xe7, 0x9c, 0xb2, 0x6c, 0x5c, 0x3a, 0x67, 0xf3, 0xae, 0x73, 0x1e, 0xc9, 0x1d,
	0x46, 0xce, 0x0b, 0x40, 0xe4, 0xbc, 0x3d, 0x6b, 0xb7, 0x4a, 0xd9, 0x08, 0x93, 0xb2, 0x2d, 0x87,
	0xb0, 0x95, 0xb3, 0x11, 0xc7, 0x1b, 0xc5, 0x92, 0xb1, 0x7e, 0xab, 0x8c, 0x4d, 0xb5, 0x41, 0x0b,
	0x71, 0xbf, 0x84, 0xce, 0xcf, 0x67, 0x63, 0xc6, 0xa3, 0x73, 0x5d, 0xf3, 0xff, 0xe9, 0x36, 0xf3,
	0x4f, 0x6c, 0x33, 0x87, 0xe3, 0x2c, 0x99, 0xa5, 0xa5, 0xae, 0x4d, 0x35, 0xbc, 0xd0, 0xb5, 0x25,
	0x8f, 0xec, 0xda, 0xc4, 0xfd, 0x09, 0x74, 0x68, 0x60, 0x52, 0x1b, 0xa8, 0x0b, 0x39, 0x8b, 0x45,
	0x5f, 0x0c, 0x68, 0xb4, 0xed, 0x40, 0x0d, 0x9f, 0x6a, 0x57, 0xb9, 0x1b, 0x19, 0x37, 0xe1, 0xd7,
	0x87, 0xa9, 0xba, 0xd7, 0xd0, 0x9d, 0x90, 0x6f, 0xd4, 0x2e, 0x4a, 0xc0, 0xff, 0x2f, 0x8c, 0x33,
	0x67, 0xd8, 0xb7, 0x7d, 0x48, 0xae, 0xee, 0x4c, 0x6c, 0xb7, 0x7e, 0x0f, 0x40, 0x7c, 0x5e, 0x0c,
	0x8b, 0x46, 0x65, 0xbf, 0xe7, 0xe9, 0x1b, 0x02, 0xbf, 0x65, 0x8a, 0xe5, 0xe0, 0x14, 0xb6, 0x16,
	0x64, 0x2e, 0x69, 0x53, 0xdf, 0xb2, 0xdb, 0x54, 0xfb, 0xe0, 0xbe, 0x12, 0x69, 0x6f, 0xb5, 0x7b,
	0xd7, 0x9f, 0x2a, 0xf4, 0x35, 0xa2, 0x9f, 0x5c, 0x9c, 0xe7, 0xd0, 0x8d, 0x69, 0xf8, 0xd2, 0x01,
	0xa8, 0x59, 0x82, 0xec, 0xc1, 0xcc, 0xeb, 0xc4, 0xf6, 0x98, 0x86, 0x81, 0x18, 0x49, 0x0f, 0x2c,
	0x0d, 0x84, 0xe5, 0x1c, 0xaf, 0x3d, 0xb2, 0xa2, 0x5d, 0x1a, 0x06, 0x6b, 0xf3, 0xc3, 0xa0, 0x7a,
	0x34, 0x58, 0xf5, 0xc6, 0x78, 0xf0, 0x87, 0x26, 0xd4, 0x3e, 0x3d, 0x7e, 0xed, 0x78, 0xb0, 0x31,
	0xf7, 0x72, 0xea, 0x14, 0x7d, 0x7f, 0xf9, 0xdb, 0xf1, 0xe0, 0xd1, 0x2a, 0xb2, 0x1a, 0x95, 0xef,
	0x09, 0x99, 0x73, 0x73, 0xb4, 0x96, 0xb9, 0xfc, 0x9b, 0x4a, 0xcb, 0x5c, 0x35, 0x7e, 0xdf, 0x73,
	0x7e, 0x00, 0x4d, 0x7a, 0x4b, 0x75, 0xb6, 0x15, 0x6f, 0xe9, 0x95, 0x76, 0xb0, 0x33, 0x87, 0xd5,
	0x1b, 0xdf, 0x40, 0xb7, 0xf4, 0x3c, 0xee, 0xbc, 0x57, 0xd2, 0x55, 0x7e, 0x8a, 0x1d, 0xbc, 0xbf,
	0x9c, 0xa8, 0xa5, 0x1d, 0x02, 0x98, 0xe7, 0x36, 0xa7, 0xaf, 0xb8, 0x17, 0x9e, 0x74, 0x07, 0x0f,
	0x96, 0x50, 0xb4, 0x90, 0x33, 0xd8, 0x9c, 0x7f, 0x3f, 0x73, 0xe6, 0xbc, 0x3a, 0xff, 0xc6, 0x35,
	0xf8, 0x60, 0x25, 0xdd, 0x16, 0x3b, 0xff, 0x76, 0xa6, 0xc5, 0xae, 0x78, 0x93, 0xd3, 0x62, 0x57,
	0x3e, 0xba, 0xdd, 0x73, 0x7e, 0x09, 0xbd, 0xf2, 0x6b, 0x96, 0x53, 0x38, 0x69, 0xe9, 0x6b, 0xdc,
	0xe0, 0xe1, 0x0a, 0xaa, 0x16, 0xf8, 0x31, 0x34, 0xe8, 0x99, 0xaa, 0xa8, 0x0d, 0xfb, 0x75, 0x6b,
	0xb0, 0x5d, 0x46, 0xea, 0x5d, 0x4f, 0xa1, 0x49, 0x5f, 0x60, 0x3a, 0x01, 0x4a, 0x1f, 0x64, 0x83,
	0x8e, 0x8d, 0x75, 0xef, 0x3d, 0xad, 0x14, 0x7a, 0xf2, 0x92, 0x9e, 0x7c, 0x99, 0x1e, 0x2b, 0x38,
	0xe7, 0x4d, 0xf9, 0x2f, 0xcf, 0xb3, 0x7f, 0x05, 0x00, 0x00, 0xff, 0xff, 0x9a, 0x70, 0x70, 0x7d,
	0xf2, 0x19, 0x00, 0x00,
}
