package io.gitlab.arturbosch.detekt.rules.bugs

import io.gitlab.arturbosch.detekt.test.assertThat
import io.gitlab.arturbosch.detekt.test.compileAndLint
import org.junit.jupiter.api.Nested
import org.junit.jupiter.api.Test

internal class MissingPackageDeclarationSpec {

    @Nested
    inner class `MissingPackageDeclaration rule` {

        @Test
        fun `should pass if package declaration is declared`() {
            val code = """
                package foo.bar

                class C
            """
            val findings = MissingPackageDeclaration().compileAndLint(code)

            assertThat(findings).isEmpty()
        }

        @Test
        fun `should report if package declaration is missing`() {
            val code = "class C"

            val findings = MissingPackageDeclaration().compileAndLint(code)

            assertThat(findings).hasSize(1)
        }
    }
}
