/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.store;

import java.io.IOException;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.io.DynamicByteArrayOutputStream;
import org.apache.derby.iapi.services.io.FormatIdOutputStream;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.store.access.RowSource;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.store.raw.StreamContainerHandle;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derbyTesting.unitTests.harness.T_Fail;
import org.apache.derbyTesting.unitTests.harness.T_MultiThreadedIterations;
import org.apache.derbyTesting.unitTests.store.T_RowSource;
import org.apache.derbyTesting.unitTests.store.T_Util;

public class T_StreamFile
extends T_MultiThreadedIterations {
    private static final String testService = "streamFileTest";
    static final String REC_001 = "McLaren";
    static final String REC_002 = "Ferrari";
    static final String REC_003 = "Benetton";
    static final String REC_004 = "Prost";
    static final String REC_005 = "Tyrell";
    static final String REC_006 = "Derby, Natscape, Goatscape, the popular names";
    static final String REC_007 = "abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz";
    static final String SP1 = "savepoint1";
    static final String SP2 = "savepoint2";
    static RawStoreFactory factory;
    static LockFactory lf;
    static long commonContainer;
    static boolean testRollback;
    static final String TEST_ROLLBACK_OFF = "derby.RawStore.RollbackTestOff";
    private static ContextService contextService;
    private T_Util t_util;

    public void boot(boolean create, Properties startParams) throws StandardException {
        super.boot(create, startParams);
        contextService = ContextService.getFactory();
    }

    protected String getModuleToTestProtocolName() {
        return "org.apache.derby.iapi.store.raw.RawStoreFactory";
    }

    protected void setupTest() throws T_Fail {
        String rollbackOff = PropertyUtil.getSystemProperty((String)TEST_ROLLBACK_OFF);
        boolean bl = testRollback = Boolean.valueOf(rollbackOff) == false;
        if (this.startParams == null) {
            this.startParams = new Properties();
        }
        this.startParams.put("derby.database.noAutoBoot", Boolean.TRUE.toString());
        this.startParams.put("derby.__deleteOnCreate", Boolean.TRUE.toString());
        this.startParams = T_Util.setEncryptionParam(this.startParams);
        try {
            factory = (RawStoreFactory)Monitor.createPersistentService((String)this.getModuleToTestProtocolName(), (String)testService, (Properties)this.startParams);
            if (factory == null) {
                throw T_Fail.testFailMsg(this.getModuleToTestProtocolName() + " service not started.");
            }
            lf = factory.getLockFactory();
            if (lf == null) {
                throw T_Fail.testFailMsg("LockFactory.MODULE not found");
            }
        }
        catch (StandardException mse) {
            throw T_Fail.exceptionFail(mse);
        }
        this.t_util = new T_Util(factory, lf, contextService);
        commonContainer = this.commonContainer();
    }

    protected void joinSetupTest() throws T_Fail {
        T_Fail.T_ASSERT(factory != null, "raw store factory not setup ");
        T_Fail.T_ASSERT(contextService != null, "Context service not setup ");
        T_Fail.T_ASSERT(commonContainer != -1L, "common container not setup ");
        this.t_util = new T_Util(factory, lf, contextService);
    }

    protected T_MultiThreadedIterations newTestObject() {
        return new T_StreamFile();
    }

    protected void runTestSet() throws T_Fail {
        ContextManager cm1 = contextService.newContextManager();
        contextService.setCurrentContextManager(cm1);
        try {
            try {
                this.SF001(1, 13, 2, false);
                this.SF001(1, 1, 2, false);
                this.SF001(1000, 1, 2, false);
                this.SF001(1000, 2, 2, false);
                this.SF001(500, 9, 2, false);
                this.SF001(500, 13, 2, false);
                this.SF001(1000, 2, 2, true);
            }
            catch (StandardException se) {
                cm1.cleanupOnError((Throwable)se, false);
                throw T_Fail.exceptionFail(se);
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            contextService.resetCurrentContextManager(cm1);
            throw throwable;
        }
        contextService.resetCurrentContextManager(cm1);
    }

    private long commonContainer() throws T_Fail {
        long cid;
        ContextManager cm1 = contextService.newContextManager();
        contextService.setCurrentContextManager(cm1);
        try {
            try {
                Transaction t = this.t_util.t_startTransaction();
                cid = this.t_util.t_addContainer(t, 0L);
                this.t_util.t_commit(t);
                t.close();
            }
            catch (StandardException se) {
                cm1.cleanupOnError((Throwable)se, false);
                throw T_Fail.exceptionFail(se);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            contextService.resetCurrentContextManager(cm1);
            throw throwable;
        }
        contextService.resetCurrentContextManager(cm1);
        return cid;
    }

    protected void SF001(int rowCount, int columnCount, int columnType, boolean forceAbort) throws StandardException, T_Fail {
        Transaction t = this.t_util.t_startTransaction();
        int segmentId = -1;
        Properties properties = new Properties();
        properties.put("derby.storage.streamFileBufferSize", "16384");
        T_RowSource testRowSource = null;
        testRowSource = forceAbort ? new T_RowSource(rowCount, columnCount, columnType, forceAbort, t) : new T_RowSource(rowCount, columnCount, columnType, forceAbort, null);
        long startms = System.currentTimeMillis();
        long containerId = t.addAndLoadStreamContainer((long)segmentId, properties, (RowSource)testRowSource);
        long endms = System.currentTimeMillis();
        long time = endms - startms;
        this.REPORT("SF001 - write: " + time + "ms");
        StreamContainerHandle scHandle = t.openStreamContainer((long)segmentId, containerId, false);
        DataValueDescriptor[] template = null;
        template = testRowSource.getTemplate();
        DataValueDescriptor[] readRow = null;
        readRow = testRowSource.getTemplate();
        segmentId = -1;
        int fetchCount = 0;
        startms = System.currentTimeMillis();
        while (scHandle.fetchNext(readRow)) {
            ++fetchCount;
            if (readRow.toString().equals(template.toString())) continue;
            throw T_Fail.testFailMsg("Record's value incorrect, expected :" + template.toString() + ": - got :" + readRow.toString());
        }
        endms = System.currentTimeMillis();
        time = endms - startms;
        if (fetchCount != rowCount) {
            throw T_Fail.testFailMsg("incorrect number of row fetched.  Expecting " + rowCount + " rows, got " + fetchCount + ", rows instead.");
        }
        this.REPORT("SF001 - fetch: " + time + "ms");
        scHandle.close();
        this.t_util.t_commit(t);
        t.close();
        this.PASS("SF001, rowCount = " + rowCount + ", columnCount = " + columnCount + ", clumn type: " + columnType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void SF002(int param) throws StandardException, T_Fail {
        T_RowSource rowSource = new T_RowSource(500000, 13, 2, false, null);
        DynamicByteArrayOutputStream out = new DynamicByteArrayOutputStream(16384);
        FormatIdOutputStream logicalDataOut = new FormatIdOutputStream((OutputStream)out);
        long startms = System.currentTimeMillis();
        System.out.println("starting rowSource test, time: " + startms);
        try {
            FormatableBitSet validColumns = rowSource.getValidColumns();
            int numberFields = 0;
            if (validColumns != null) {
                for (int i = validColumns.size() - 1; i >= 0; --i) {
                    if (!validColumns.get(i)) continue;
                    numberFields = i + 1;
                    break;
                }
            }
            DataValueDescriptor[] row = rowSource.getNextRowFromRowSource();
            while (row != null) {
                int arrayPosition = -1;
                for (int i = 0; i < numberFields; ++i) {
                    if (!validColumns.get(i)) continue;
                    DataValueDescriptor column = row[++arrayPosition];
                    if (param != 1) continue;
                    try {
                        DataValueDescriptor sColumn = column;
                        if (sColumn.isNull()) continue;
                        sColumn.writeExternal((ObjectOutput)logicalDataOut);
                        out.reset();
                        continue;
                    }
                    catch (IOException ioe) {
                        throw T_Fail.exceptionFail(ioe);
                    }
                }
                row = rowSource.getNextRowFromRowSource();
            }
            Object var15_17 = null;
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            throw throwable;
        }
        long endms = System.currentTimeMillis();
        long time2 = endms - startms;
        if (param != 1) {
            System.out.println("ended rowSource test, time: " + endms + ", time spent = " + time2);
        } else {
            System.out.println("------ writeExternal called....\n ended rowSource test, time: " + endms + ", time spent = " + time2);
        }
        this.PASS("SF002");
    }

    static {
        commonContainer = -1L;
    }
}

