/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.junit;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UTFDataFormatException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derby.iapi.types.CharStreamHeaderGenerator;
import org.apache.derby.iapi.types.ClobStreamHeaderGenerator;
import org.apache.derby.iapi.types.ReaderToUTF8Stream;
import org.apache.derby.iapi.types.StreamHeaderGenerator;
import org.apache.derby.iapi.util.UTF8Util;
import org.apache.derbyTesting.functionTests.util.streams.CharAlphabet;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.junit.BaseTestCase;

public class UTF8UtilTest
extends BaseTestCase {
    private static final String TYPENAME = "VARCHAR";
    private static final int HEADER_LENGTH = 2;

    public UTF8UtilTest(String name) {
        super(name);
    }

    public void testEqualityOfModifedUTF8AndASCII() throws IOException {
        int length = 12706;
        LoopingAlphabetStream ascii = new LoopingAlphabetStream(12706L);
        ReaderToUTF8Stream modUTF8 = new ReaderToUTF8Stream((Reader)new LoopingAlphabetReader(12706L), 12706, 0, TYPENAME, (StreamHeaderGenerator)new CharStreamHeaderGenerator());
        modUTF8.skip(2L);
        UTF8UtilTest.assertEquals(ascii, (InputStream)modUTF8);
    }

    public void testSkipUntilEOFOnZeroLengthStream() throws IOException {
        UTF8UtilTest.assertEquals((long)0L, (long)UTF8Util.skipUntilEOF((InputStream)new LoopingAlphabetStream(0L)));
    }

    public void testSkipUntilEOFOnShortStreamASCII() throws IOException {
        UTF8UtilTest.assertEquals((long)5L, (long)UTF8Util.skipUntilEOF((InputStream)new LoopingAlphabetStream(5L)));
    }

    public void testSkipUntilEOFOnShortStreamCJK() throws IOException {
        int charLength = 5;
        ReaderToUTF8Stream in = new ReaderToUTF8Stream((Reader)new LoopingAlphabetReader(5L, CharAlphabet.cjkSubset()), 5, 0, TYPENAME, (StreamHeaderGenerator)new CharStreamHeaderGenerator());
        in.skip(2L);
        UTF8UtilTest.assertEquals((long)5L, (long)UTF8Util.skipUntilEOF((InputStream)in));
    }

    public void testSkipUntilEOFOnLongStreamASCII() throws IOException {
        UTF8UtilTest.assertEquals((long)127019L, (long)UTF8Util.skipUntilEOF((InputStream)new LoopingAlphabetStream(127019L)));
    }

    public void testSkipUntilEOFOnLongStreamCJK() throws IOException {
        int charLength = 127019;
        ReaderToUTF8Stream in = new ReaderToUTF8Stream((Reader)new LoopingAlphabetReader(127019L, CharAlphabet.cjkSubset()), 127019, 0, TYPENAME, (StreamHeaderGenerator)new ClobStreamHeaderGenerator(true));
        in.skip(2L);
        UTF8UtilTest.assertEquals((long)127019L, (long)UTF8Util.skipUntilEOF((InputStream)in));
    }

    public void testSkipFullyOnValidLongStreamCJK() throws IOException {
        int charLength = 161019;
        ReaderToUTF8Stream in = new ReaderToUTF8Stream((Reader)new LoopingAlphabetReader(161019L, CharAlphabet.cjkSubset()), 161019, 0, TYPENAME, (StreamHeaderGenerator)new CharStreamHeaderGenerator());
        in.skip(2L);
        UTF8UtilTest.assertEquals((long)483057L, (long)UTF8Util.skipFully((InputStream)in, (long)161019L));
    }

    public void testSkipFullyOnTooShortStreamCJK() throws IOException {
        int charLength = 161019;
        ReaderToUTF8Stream in = new ReaderToUTF8Stream((Reader)new LoopingAlphabetReader(161019L, CharAlphabet.cjkSubset()), 161019, 0, TYPENAME, (StreamHeaderGenerator)new ClobStreamHeaderGenerator(true));
        in.skip(2L);
        try {
            UTF8Util.skipFully((InputStream)in, (long)161119L);
            UTF8UtilTest.fail((String)"Should have failed because of too short stream.");
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    public void testSkipFullyOnInvalidStreamCJK() throws IOException {
        int charLength = 10;
        ReaderToUTF8Stream in = new ReaderToUTF8Stream((Reader)new LoopingAlphabetReader(10L, CharAlphabet.cjkSubset()), 10, 0, TYPENAME, (StreamHeaderGenerator)new CharStreamHeaderGenerator());
        in.skip(2L);
        in.skip(1L);
        try {
            UTF8Util.skipFully((InputStream)in, (long)10L);
            UTF8UtilTest.fail((String)"Should have failed because of UTF error.");
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            // empty catch block
        }
    }

    public void testMixedSkipOnStreamTamil() throws IOException {
        int charLength = 161019;
        ReaderToUTF8Stream in = new ReaderToUTF8Stream((Reader)new LoopingAlphabetReader(161019L, CharAlphabet.tamil()), 161019, 0, TYPENAME, (StreamHeaderGenerator)new CharStreamHeaderGenerator());
        in.skip(2L);
        int firstSkip = 10078;
        UTF8UtilTest.assertEquals((long)(firstSkip * 3), (long)UTF8Util.skipFully((InputStream)in, (long)firstSkip));
        UTF8UtilTest.assertEquals((long)(161019 - firstSkip), (long)UTF8Util.skipUntilEOF((InputStream)in));
        try {
            UTF8Util.skipFully((InputStream)in, (long)1L);
            UTF8UtilTest.fail((String)"Should have failed because the stream has been drained.");
        }
        catch (EOFException eofe) {
            // empty catch block
        }
    }

    public void testMissingSecondByteOfTwo() throws IOException {
        byte[] data = new byte[]{97, -33};
        ByteArrayInputStream is = new ByteArrayInputStream(data);
        try {
            UTF8Util.skipFully((InputStream)is, (long)2L);
            UTF8UtilTest.fail((String)"Reading invalid UTF-8 should fail");
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            // empty catch block
        }
    }

    public void testMissingSecondByteOfThree() throws IOException {
        byte[] data = new byte[]{97, -17};
        ByteArrayInputStream is = new ByteArrayInputStream(data);
        try {
            UTF8Util.skipFully((InputStream)is, (long)2L);
            UTF8UtilTest.fail((String)"Reading invalid UTF-8 should fail");
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            // empty catch block
        }
    }

    public void testMissingThirdByteOfThree() throws IOException {
        byte[] data = new byte[]{97, -17, -72};
        ByteArrayInputStream is = new ByteArrayInputStream(data);
        try {
            UTF8Util.skipFully((InputStream)is, (long)2L);
            UTF8UtilTest.fail((String)"Reading invalid UTF-8 should fail");
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            // empty catch block
        }
    }

    public void testInvalidUTF8Encoding() throws IOException {
        byte[] data = new byte[]{97, 98, 99, -8, 101, 102};
        ByteArrayInputStream is = new ByteArrayInputStream(data);
        try {
            UTF8Util.skipFully((InputStream)is, (long)6L);
            UTF8UtilTest.fail((String)"Reading invalid UTF-8 should fail");
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            // empty catch block
        }
    }

    public void testSkippingInvalidEncodingWorks() throws IOException {
        byte[] data = new byte[]{97, -17, -72, 97, 97};
        byte[] dataWithLength = new byte[]{0, 5, 97, -17, -72, 97, 97};
        ByteArrayInputStream is = new ByteArrayInputStream(data);
        UTF8Util.skipFully((InputStream)is, (long)3L);
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(dataWithLength));
        try {
            dis.readUTF();
            UTF8UtilTest.fail((String)"UTF-8 expected to be invalid, read should fail");
        }
        catch (UTFDataFormatException udfe) {
            // empty catch block
        }
    }

    public static Test suite() {
        return new TestSuite(UTF8UtilTest.class, "UTF8Util tests");
    }
}

