/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.junit;

import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derbyTesting.junit.BaseTestCase;

public class ArrayInputStreamTest
extends BaseTestCase {
    public static Test suite() {
        return new TestSuite(ArrayInputStreamTest.class);
    }

    public ArrayInputStreamTest(String name) {
        super(name);
    }

    public void testSkipLongMaxValue() throws IOException {
        ArrayInputStream ais = new ArrayInputStream(new byte[1000]);
        ArrayInputStreamTest.assertEquals((long)1000L, (long)ais.skip(Long.MAX_VALUE));
        ArrayInputStreamTest.assertEquals((int)1000, (int)ais.getPosition());
        ais.setPosition(1);
        ArrayInputStreamTest.assertEquals((long)999L, (long)ais.skip(Long.MAX_VALUE));
        ArrayInputStreamTest.assertEquals((int)1000, (int)ais.getPosition());
    }

    public void testSkipBytesIntMaxValue() throws IOException {
        ArrayInputStream ais = new ArrayInputStream(new byte[1000]);
        ArrayInputStreamTest.assertEquals((int)1000, (int)ais.skipBytes(Integer.MAX_VALUE));
        ArrayInputStreamTest.assertEquals((int)1000, (int)ais.getPosition());
        ais.setPosition(1);
        ArrayInputStreamTest.assertEquals((int)999, (int)ais.skipBytes(Integer.MAX_VALUE));
        ArrayInputStreamTest.assertEquals((int)1000, (int)ais.getPosition());
    }

    public void testSkipNegative() throws IOException {
        ArrayInputStream ais = new ArrayInputStream(new byte[1000]);
        ArrayInputStreamTest.assertEquals((long)0L, (long)ais.skip(-1L));
    }

    public void testSkipBytesNegative() throws IOException {
        ArrayInputStream ais = new ArrayInputStream(new byte[1000]);
        ArrayInputStreamTest.assertEquals((int)0, (int)ais.skipBytes(-1));
    }
}

