/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.oe.load;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.derbyTesting.system.oe.load.SimpleInsert;

public class ThreadInsert
extends SimpleInsert
implements Runnable {
    private final ThreadInsert master;
    private SQLException loadExceptions;
    private int threadCount;
    private DataSource ds;
    private short nextWarehouse = 1;

    public ThreadInsert(DataSource ds) {
        this.master = this;
        this.ds = ds;
    }

    private ThreadInsert(ThreadInsert master) {
        this.master = master;
    }

    public void setupLoad(Connection conn, short scale) throws SQLException {
        super.setupLoad(conn, scale);
        int cpuCount = Runtime.getRuntime().availableProcessors();
        this.setThreadCount(cpuCount);
    }

    public void setThreadCount(int threadCount) {
        if (this.scale == 1) {
            this.threadCount = 1;
            return;
        }
        if (this.scale < threadCount) {
            this.threadCount = this.scale;
            return;
        }
        this.threadCount = threadCount;
    }

    public void populateAllTables() throws Exception {
        if (this.threadCount == 1) {
            super.populateAllTables();
        } else {
            this.threadPopulate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void threadPopulate() throws SQLException, InterruptedException {
        Thread[] threads = new Thread[this.threadCount - 1];
        for (int t = 1; t < this.threadCount; ++t) {
            Thread loader;
            Connection loaderConn = this.ds.getConnection();
            ThreadInsert ti = new ThreadInsert(this);
            ti.setSeed(this.seed * (long)t / 17L);
            ti.setupConnection(loaderConn, this.scale);
            ti.setRandomGenerator();
            threads[t - 1] = loader = new Thread((Runnable)ti, "OELoader:" + t);
            loader.start();
        }
        this.itemTable(1, 100000);
        this.run();
        for (int j = 0; j < threads.length; ++j) {
            threads[j].join();
        }
        ThreadInsert threadInsert = this;
        synchronized (threadInsert) {
            if (this.loadExceptions != null) {
                throw this.loadExceptions;
            }
        }
    }

    synchronized short getNextWarehouse() {
        short s = this.nextWarehouse;
        this.nextWarehouse = (short)(s + 1);
        short next = s;
        if (next > this.scale) {
            return -1;
        }
        return next;
    }

    synchronized void addException(SQLException sqle) {
        if (this.loadExceptions == null) {
            this.loadExceptions = sqle;
        } else {
            SQLException e;
            SQLException chain = this.loadExceptions;
            while ((e = chain.getNextException()) != null) {
                chain = e;
            }
            chain.setNextException(sqle);
        }
    }

    public void run() {
        short w;
        while ((w = this.master.getNextWarehouse()) != -1) {
            try {
                this.populateForOneWarehouse(w);
            }
            catch (SQLException e) {
                this.master.addException(e);
                break;
            }
        }
    }
}

