/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.nstest.init;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.derbyTesting.system.nstest.NsTest;
import org.apache.derbyTesting.system.nstest.utils.DbUtil;

public class Initializer {
    private String thread_id;
    private DbUtil dbutil;

    public Initializer(String name) {
        this.thread_id = name;
        this.dbutil = new DbUtil(this.thread_id);
    }

    public void startInserts() {
        Connection conn = null;
        int insertsRemaining = NsTest.MAX_INITIAL_ROWS;
        try {
            System.out.println(this.thread_id + " is getting a connection to the database...");
            if (NsTest.embeddedMode) {
                conn = DriverManager.getConnection(NsTest.embedDbURL, NsTest.prop);
            } else if (NsTest.driver_type.equalsIgnoreCase("DerbyClient")) {
                System.out.println("-->Using derby client url");
                conn = DriverManager.getConnection(NsTest.clientDbURL, NsTest.prop);
            }
        }
        catch (Exception e) {
            System.out.println("FAIL: " + this.thread_id + " could not get the database connection");
            this.printException("getting database connection in startInserts()", e);
        }
        NsTest.addStats(NsTest.CONNECTIONS_MADE, 1);
        System.out.println("Connection number: " + NsTest.numConnections);
        if (NsTest.AUTO_COMMIT_OFF) {
            try {
                conn.setAutoCommit(false);
            }
            catch (Exception e) {
                System.out.println("FAIL: " + this.thread_id + "'s setAutoCommit() failed:");
                this.printException("setAutoCommit() in Initializer", e);
            }
        }
        while (insertsRemaining-- >= 0) {
            try {
                int numInserts = this.dbutil.add_one_row(conn, this.thread_id);
            }
            catch (Exception e) {
                System.out.println(" FAIL: " + this.thread_id + " unexpected exception:");
                this.printException("add_one_row() in Initializer", e);
                break;
            }
        }
        if (NsTest.AUTO_COMMIT_OFF) {
            try {
                conn.commit();
            }
            catch (Exception e) {
                System.out.println("FAIL: " + this.thread_id + "'s commit() failed:");
                this.printException("commit in Initializer", e);
            }
        }
    }

    public synchronized void printException(String where, Exception e) {
        if (e instanceof SQLException) {
            SQLException se = (SQLException)e;
            if (se.getSQLState().equals("40001")) {
                System.out.println("deadlocked detected");
            }
            if (se.getSQLState().equals("40XL1")) {
                System.out.println(" lock timeout exception");
            }
            if (se.getSQLState().equals("23500")) {
                System.out.println(" duplicate key violation");
            }
            if (se.getNextException() != null) {
                String m = se.getNextException().getSQLState();
                System.out.println(se.getNextException().getMessage() + " SQLSTATE: " + m);
            }
        }
        if (e.getMessage() == null) {
            e.printStackTrace(System.out);
        }
        System.out.println("During - " + where + ", the exception thrown was : " + e.getMessage());
    }
}

