/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.perf.clients;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derbyTesting.perf.clients.Client;
import org.apache.derbyTesting.perf.clients.Runner;

public class GroupByClient
implements Client {
    private static final int MAX_GROUPING_COLS = 25;
    private Connection conn;
    private PreparedStatement ps;
    private int numGroupingCols;
    private int[] numGroups = new int[26];
    private String[] groupingExpr = new String[26];
    private int totalExpectedGroups;
    private int tableSize = 0;
    private String sql;

    public GroupByClient() {
        this.numGroupingCols = Runner.getLoadOpt("numGroupingCols", -1);
        if (this.numGroupingCols > 0) {
            this.totalExpectedGroups = 1;
            for (int i = 1; i < this.numGroups.length; ++i) {
                this.numGroups[i] = Runner.getLoadOpt("numGroups" + i, 1);
                this.totalExpectedGroups *= this.numGroups[i];
                this.getGroupingExpr(i);
            }
        } else {
            this.numGroupingCols = 1;
            this.numGroups[1] = 10;
            this.totalExpectedGroups = 10;
            this.getGroupingExpr(1);
        }
        this.sql = this.buildStatement();
    }

    public void init(Connection c) throws SQLException {
        this.conn = c;
        this.getTableSize();
        System.out.println("We'll run '" + this.sql + "'");
        if (this.numGroupingCols == 1) {
            System.out.println("... which should produce " + this.totalExpectedGroups + " total groups, each containing " + this.tableSize / this.totalExpectedGroups + " rows.");
        }
        this.ps = c.prepareStatement(this.sql);
        c.setAutoCommit(false);
    }

    private void getGroupingExpr(int i) {
        this.groupingExpr[i] = this.numGroups[i] == 1 ? null : (this.numGroups[i] == 10 ? "TEN" : (this.numGroups[i] == 100 ? "ONEPERCENT" : "MOD(UNIQUE1," + this.numGroups[i] + ")"));
    }

    private String buildStatement() {
        StringBuffer buf = new StringBuffer();
        buf.append("SELECT ");
        this.appendGroups(buf);
        buf.append(", COUNT(*) FROM TENKTUP1 GROUP BY ");
        this.appendGroups(buf);
        return buf.toString();
    }

    private void appendGroups(StringBuffer buf) {
        for (int i = 1; i < this.numGroups.length && this.numGroups[i] > 1; ++i) {
            if (i > 1) {
                buf.append(",");
            }
            buf.append(this.groupingExpr[i]);
        }
    }

    private void dumpTables() throws SQLException {
        ResultSet rs = this.conn.getMetaData().getTables(null, null, "%", null);
        while (rs.next()) {
            System.out.println("Schem=" + rs.getString("TABLE_SCHEM") + " name=" + rs.getString("TABLE_NAME"));
        }
        rs.close();
        this.conn.commit();
    }

    private void getTableSize() throws SQLException {
        Statement s = this.conn.createStatement();
        ResultSet rs = s.executeQuery("select count(*) from tenktup1");
        if (!rs.next()) {
            throw new RuntimeException("Unable to find size of tenktup1");
        }
        this.tableSize = rs.getInt(1);
        rs.close();
        s.close();
        this.conn.commit();
    }

    public void doWork() throws SQLException {
        ResultSet rs = this.ps.executeQuery();
        int expectedCount = this.tableSize / this.totalExpectedGroups;
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
            int groupName = rs.getInt(1);
            int theCount = rs.getInt(2);
            if (this.numGroupingCols != 1 || theCount == expectedCount) continue;
            System.out.println("group=" + groupName + ", count=" + theCount + ",expectedCount=" + expectedCount);
        }
        if (this.numGroupingCols == 1 && numRows != this.totalExpectedGroups) {
            System.out.println("Total rows from GROUP BY was " + numRows + ", expected total rows to be " + this.totalExpectedGroups);
        }
        rs.close();
        this.conn.commit();
    }

    public void printReport(PrintStream out) {
    }
}

